
#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "CAN_Communication_Matrix.h"

uint8_t SoundEnableCode[SND_TOTAL_NUMBER];
SoundSchedulingStruct SoundScheduling;

void Sound_Scheduler_Init(void)
{
    uint8_t i;

    for (i = 0; i < SND_TOTAL_NUMBER; i++)
        SoundEnableCode[i] = 0;

    Sound_Clear();

    SoundScheduling.Current = SND_NONE;
    SoundScheduling.Next = SND_NONE;
    SoundScheduling.ReqCode = 0;
    SoundScheduling.StopReq = 0;
}

//ReqCode：请求码,0 - 表示无效请求,不请求播放声音
//                非0值 - 请求播放声音,该请求码将被记录,对于只播放一次的声音,如果与上一次请求播放该声音的请求码相同
//                        声音就不会再被重复播放
//ContrlorResumeofBuzzerd为诊断添加声音控制

void Sound_Request(uint8_t Sound, uint8_t ReqCode)
{
    uint8_t PriorityRef = 0u;
    uint8_t PriorityNew = 0u;

    if ((Sound < SND_TOTAL_NUMBER) && (ReqCode))
    {
        if ((SoundEnableCode[Sound] != ReqCode) || (SoundList[Sound].Type != SND_TYPE_NORMAL))
        {
            if (SoundScheduling.Next < SND_TOTAL_NUMBER) //如果已有即将要播放的声音
            {
                if (Sound != SoundScheduling.Next)
                {
                    PriorityRef = Sound_Priority_Query(SoundList[SoundScheduling.Next].Src);
                    PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

                    if (PriorityNew < PriorityRef)
                    {
                        SoundScheduling.Next = Sound; //请求的声音具有更高的优先级
                        SoundScheduling.ReqCode = ReqCode;
                    }
                    else if (PriorityNew == PriorityRef)
                    {
                        if (SoundList[Sound].Type == SND_TYPE_RADAR)
                        {
                            SoundScheduling.Next = Sound; //同优先级雷达声可相互打断
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                }
            }
            else //如果没有即将要播放的声音
            {
                if (Sound != SoundScheduling.Current)
                {
                    PriorityRef = Sound_Priority_Query(SND_SRC_CURRENT);
                    PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

                    if (PriorityNew < PriorityRef)
                    {
                        SoundScheduling.Next = Sound; //请求的声音具有更高的优先级
                        SoundScheduling.ReqCode = ReqCode;
                    }
                    else if (PriorityNew == PriorityRef)
                    {
                        if (SoundList[Sound].Type == SND_TYPE_RADAR)
                        {
                            SoundScheduling.Next = Sound; //同优先级雷达声可相互打断
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                }
            }
        }
    }
}

void Sound_Delete(uint8_t Sound)
{
    if (Sound < SND_TOTAL_NUMBER)
    {
        if (SoundEnableCode[Sound]) //是已播放过的声音
        {
            if (Sound == SoundScheduling.Current)
            {
                SoundScheduling.StopReq = 1;
                return;
            }

            if (Sound == SoundScheduling.Next)
                SoundScheduling.Next = SND_NONE;

            SoundEnableCode[Sound] = 0;
        }
    }
}

//50ms
void Sound_Scheduling_Service(void)
{
    //处理声音停止请求
    if (SoundScheduling.StopReq)
    {
        if (SoundScheduling.Current < SND_TOTAL_NUMBER)
        {
            if (Sound_Stop(SoundList[SoundScheduling.Current].Src) == 0)
            {
                SoundEnableCode[SoundScheduling.Current] = 0;
                SoundScheduling.Current = SND_NONE;
				SoundScheduling.StopReq = 0;
            }
        }
    }

    //使用查询优先级方法查看当前声音是否还在播放
    if (SoundScheduling.Current < SND_TOTAL_NUMBER)
    {
        if (Sound_Priority_Query(SND_SRC_CURRENT) == 0xFF)
            SoundScheduling.Current = SND_NONE;
    }
    else
    {
        ;
    }

    //播放请求的声音
    if (SoundScheduling.Next < SND_TOTAL_NUMBER)
    {
        if (SoundScheduling.Current < SND_TOTAL_NUMBER) //如果当前有声音正在播放,则停止播放该声音
            Sound_Stop(SoundList[SoundScheduling.Current].Src);

        if (Sound_Play(SoundList[SoundScheduling.Next].Src) == 0) //如果请求的声音播放成功
        {
            SoundEnableCode[SoundScheduling.Next] = SoundScheduling.ReqCode; //声音已播放
            SoundScheduling.Current = SoundScheduling.Next;
            SoundScheduling.Next = SND_NONE;
        }
    }
}
