#include "EOL_Para.h"

_EOL_Data_Type EOL_Data_Type;

void EOL_InitVal(void)
{
    EOL_Data_Type.Flag = 0x7AA7A55Au;
    EOL_Data_Type.DID_605C = 1u;        /* LDWS(车道偏离)系统开关    0   1*/
    EOL_Data_Type.DID_605D = 1u;        /* AFS 系统开关 0  1*/
    EOL_Data_Type.DID_605E = 1u;        /* HUD 系统开关 0  1*/
    EOL_Data_Type.DID_605F = 1u;        /* ACC 系统开关关 0  1*/
    EOL_Data_Type.DID_6060 = 1u;        /* 称重系统开关 0   1*/
    EOL_Data_Type.DID_6062[0u] = 0x1Fu; /* 车速里程表 K 值 高位*/
    EOL_Data_Type.DID_6062[1u] = 0x40;  /* 车速里程表 K 值 低位*/
    EOL_Data_Type.DID_6063 = 1u;        /* 发动机速比 0未配置 其他数值*/
    EOL_Data_Type.DID_6064 = 1u;        /* 单位 0-未配 1-km/h 2-MPH */
    EOL_Data_Type.DID_6068 = 1u;        /* 语言*/
    EOL_Data_Type.DID_606D = 1u;        /* 轮胎防盗使能开关*/
    EOL_Data_Type.DID_606E = 1u;        /* 换挡提示设置*/
    EOL_Data_Type.DID_606F[0u] = 0x00;  /* 油箱容量设置*/
    EOL_Data_Type.DID_606F[1u] = 0x64;
    EOL_Data_Type.DID_6070 = 1u;        /* HAS 系统开关*/
    EOL_Data_Type.DID_6071 = 1u;        /* ESC 系统开关*/
    EOL_Data_Type.DID_6072 = 1u;        /* 盘式制动磨损报警功能*/
    EOL_Data_Type.DID_6073 = 1u;        /* 挂车设置*/
    EOL_Data_Type.DID_6074 = 1u;        /* 排放配置 */
    EOL_Data_Type.DID_6075 = 0u;        /* 超速报警车型信号*/
    EOL_Data_Type.DID_6076[0u] = 0x00u; /* 油箱容量设置*/
    EOL_Data_Type.DID_6076[1u] = 0x00u;
    EOL_Data_Type.DID_6076[2u] = 0x00u;
    EOL_Data_Type.DID_60C9 = 1u;        /* 尿素箱容积*/
    EOL_Data_Type.DID_60CA[0u] = 0x00u; /* 主油箱容积*/
    EOL_Data_Type.DID_60CA[1u] = 0x64u;
    EOL_Data_Type.DID_60CB[0u] = 0x00u;
    EOL_Data_Type.DID_60CB[1u] = 0x64u; /* 副油箱容积*/
    EOL_Data_Type.DID_60CC = 0x01u;     /* 油箱类型*/
    EOL_Data_Type.DID_60CD[0u] = 0x00u; /* 发动机类型*/
    EOL_Data_Type.DID_60CD[1u] = 0x0Cu;
    EOL_Data_Type.DID_60CE = 0u;        /* TCU 类型*/
    EOL_Data_Type.DID_60CF = 1u;        /* 驱动能源类型*/
    EOL_Data_Type.DID_60D0 = 1u;        /* 驱动形式*/
    EOL_Data_Type.DID_60D1 = 10u;       /* 蓄电池容量*/
    EOL_Data_Type.DID_60D2 = 1u;        /* 电池管理系统*/
}

/*LDWS(车道偏离)系统开关*/
uint8_t Val_EOL_605C_LDWS(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_605C;
    return Res;
}

void Set_Val_EOL_605C_LDWS(uint8_t Val)
{
    EOL_Data_Type.DID_605C = Val;
}

/*AFS 系统开关*/
uint8_t Val_EOL_605D_AFS(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_605D;
    return Res;
}

void Set_Val_EOL_605D_AFS(uint8_t Val)
{
    EOL_Data_Type.DID_605D = Val;
}

/*HUD 系统开关*/
uint8_t Val_EOL_605E_HUD(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_605E;
    return Res;
}

void Set_Val_EOL_605E_HUD(uint8_t Val)
{
    EOL_Data_Type.DID_605E = Val;
}

/* ACC 系统开关关*/
uint8_t Val_EOL_605F_ACC(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_605F;
    return Res;
}

void Set_Val_EOL_605F_ACC(uint8_t Val)
{
    EOL_Data_Type.DID_605F = Val;
}

/* 称重系统开关*/
uint8_t Val_EOL_6060_Weigh(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6060;
    return Res;
}

void Set_Val_EOL_6060_Weigh(uint8_t Val)
{
    EOL_Data_Type.DID_6060 = Val;
}

/* 车速里程表 K 值*/
uint16_t Val_EOL_6062_KValue(void)
{
    uint16_t Res;
    Res = 0u;
    Res = Res | (EOL_Data_Type.DID_6062[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_6062[1u];
    return Res;
}

void Set_Val_EOL_6062_KValue(uint16_t Val)
{
    EOL_Data_Type.DID_6062[0u] = (uint8_t)(Val >> 8u);
    EOL_Data_Type.DID_6062[1u] = (uint8_t)(Val & 0xFFu);
}

/* 发动机速比*/
uint8_t Val_EOL_6063_Engine(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6063;
    return Res;
}

void Set_Val_EOL_6063_Engine(uint8_t Val)
{
    EOL_Data_Type.DID_6063 = Val;
}

/* 单位*/
uint8_t Val_EOL_6064_Unit(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6064;
    return Res;
}

void Set_Val_EOL_6064_Unit(uint8_t Val)
{
    EOL_Data_Type.DID_6064 = Val;
}

/* 语言*/
uint8_t Val_EOL_6068_Language(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6068;
    return Res;
}

void Set_Val_EOL_6068_Language(uint8_t Val)
{
    EOL_Data_Type.DID_6068 = Val;
}

/* 轮胎防盗使能开关*/
uint8_t Val_EOL_606D_TireAntiTheft(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_606D;
    return Res;
}

void Set_Val_EOL_606D_TireAntiTheft(uint8_t Val)
{
    EOL_Data_Type.DID_606D = Val;
}

/* 换挡提示设置*/
uint8_t Val_EOL_606E_Shift(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_606E;
    return Res;
}

void Set_Val_EOL_606E_Shift(uint8_t Val)
{
    EOL_Data_Type.DID_606E = Val;
}

/* 油箱容量设置*/
uint16_t Val_EOL_606F_FuelTank(void)
{
    uint16_t Res;
    Res = 0u;
    Res = Res | (EOL_Data_Type.DID_606F[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_606F[1u];
    return Res;
}

void Set_Val_EOL_606F_FuelTank(uint16_t Val)
{
    EOL_Data_Type.DID_606F[0u] = (uint8_t)(Val >> 8u);
    EOL_Data_Type.DID_606F[1u] = (uint8_t)(Val & 0xFFu);
}

/* HAS 系统开关*/
uint8_t Val_EOL_6070_HAS(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6070;
    return Res;
}

void Set_Val_EOL_6070_HAS(uint8_t Val)
{
    EOL_Data_Type.DID_6070 = Val;
}

/* ESC 系统开关*/
uint8_t Val_EOL_6071_ESC(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6071;
    return Res;
}

void Set_Val_EOL_6071_ESC(uint8_t Val)
{
    EOL_Data_Type.DID_6071 = Val;
}

/* 盘式制动磨损报警功能*/
uint8_t Val_EOL_6072_DiscBrake(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6072;
    return Res;
}

void Set_Val_EOL_6072_DiscBrake(uint8_t Val)
{
    EOL_Data_Type.DID_6072 = Val;
}

/*挂车设置*/
uint8_t Val_EOL_6073_SetRrailer(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6073;
    return Res;
}

void Set_Val_EOL_6073_SetRrailer(uint8_t Val)
{
    EOL_Data_Type.DID_6073 = Val;
}

/*排放配置*/
uint8_t Val_EOL_6074_Emission(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6074;
    return Res;
}

void Set_Val_EOL_6074_Emission(uint8_t Val)
{
    EOL_Data_Type.DID_6074 = Val;
}

/*超速报警车型信号*/
uint8_t Val_EOL_6075_SpeedAlarm(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_6075;
    return Res;
}

void Set_Val_EOL_6075_SpeedAlarm(uint8_t Val)
{
    EOL_Data_Type.DID_6075 = Val;
}
/* 油箱容量设置*/
uint32_t Val_EOL_6076_FuelTank(void)
{
    uint32_t Res;
    Res = 0u;
    Res = Res | (EOL_Data_Type.DID_606F[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_606F[1u];
    Res = ((Res & 0x00FFFFu) << 8) | EOL_Data_Type.DID_606F[2u];
    return Res;
}

void Set_Val_EOL_6076_FuelTank(uint32_t Val)
{
    EOL_Data_Type.DID_606F[0u] = (uint8_t) ((Val >> 16u) & 0xFFu);
    EOL_Data_Type.DID_606F[1u] = (uint8_t) ((Val >> 8u) & 0xFFu);
    EOL_Data_Type.DID_606F[2u] = (uint8_t) (Val & 0xFFu);
}

/*尿素箱容积*/
uint8_t Val_EOL_60C9_Urea(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60C9;
    return Res;
}

void Set_Val_EOL_60C9_Urea(uint8_t Val)
{
    EOL_Data_Type.DID_60C9 = Val;
}

/* 主油箱容积*/
uint16_t Val_EOL_60CA_MainFuelTank(void)
{
    uint16_t Res;
    Res = 0u;
    Res = Res | (EOL_Data_Type.DID_60CA[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CA[1u];
    return Res;
}

void Set_Val_EOL_60CA_MainFuelTank(uint16_t Val)
{
    EOL_Data_Type.DID_60CA[0u] = (uint8_t) (Val >> 8u);
    EOL_Data_Type.DID_60CA[1u] = (uint8_t) (Val & 0xFFu);
}

/* 副油箱容积*/
uint16_t Val_EOL_60CB_AuxiliaryTank(void)
{
    uint16_t Res;
    Res = 0;
    Res = Res | (EOL_Data_Type.DID_60CB[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CB[1u];
    return Res;
}

void Set_Val_EOL_60CB_AuxiliaryTank(uint16_t Val)
{
    EOL_Data_Type.DID_60CB[0u] = (uint8_t) (Val >> 8u) ;
    EOL_Data_Type.DID_60CB[1u] = (uint8_t) (Val & 0xFFu) ;
}

/*油箱类型*/
uint8_t Val_EOL_60CC_FuelTankType(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60CC;
    return Res;
}

void Set_Val_EOL_60CC_FuelTankType(uint8_t Val)
{
    EOL_Data_Type.DID_60CC = Val;
}

/* 发动机类型*/
uint16_t Val_EOL_60CD_EngineType(void)
{
    uint16_t Res;
    Res = 0;
    Res = Res | (EOL_Data_Type.DID_60CD[0u] << 8u);
    Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CD[1u];
    return Res;
}

void Set_Val_EOL_60CD_EngineType(uint16_t Val)
{
    EOL_Data_Type.DID_60CD[0u] = (uint8_t) (Val >> 8u) ;
    EOL_Data_Type.DID_60CD[1u] = (uint8_t) (Val & 0xFFu) ;
}

/*TCU 类型*/
uint8_t Val_EOL_60CE_FuelTankType(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60CE;
    return Res;
}

void Set_Val_EOL_60CE_FuelTankType(uint8_t Val)
{
    EOL_Data_Type.DID_60CE = Val;
}

/*驱动能源类型*/
uint8_t Val_EOL_60CF_DriveEnergy(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60CF;
    return Res;
}

void Set_Val_EOL_60CF_DriveEnergy(uint8_t Val)
{
    EOL_Data_Type.DID_60CF = Val;
}


/*驱动形式*/
uint8_t Val_EOL_60D0_DriveForm(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60D0;
    return Res;
}

void Set_Val_EOL_60D0_DriveForm(uint8_t Val)
{
    EOL_Data_Type.DID_60D0 = Val;
}

/*蓄电池容量*/
uint8_t Val_EOL_60D1_BatteryCapacity(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60D1;
    return Res;
}

void Set_Val_EOL_60D1_BatteryCapacity(uint8_t Val)
{
    EOL_Data_Type.DID_60D1 = Val;
}

/*电池管理系统*/
uint8_t Val_EOL_60D2_BatteryManagement(void)
{
    uint8_t Res;
    Res = EOL_Data_Type.DID_60D2;
    return Res;
}

void Set_Val_EOL_60D2_BatteryManagement(uint8_t Val)
{
    EOL_Data_Type.DID_60D2 = Val;
}