/************************************************************************************************
PROJECT : simple_draw
FILE    : $Id: jcua.c 15225 2017-11-21 12:01:29Z matthias.nippert $
============================================================================ 
DESCRIPTION
============================================================================
                            C O P Y R I G H T
============================================================================
                       Copyright (c) 2013 - 2014
                                  by 
                       Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing, not for mass production

DISCLAIMER

LICENSEE has read, understood and accepted the terms and conditions defined in
the license agreement, especially the usage rights. In any case, it is
LICENSEE's responsibility to make sure that any user of the software complies
with the terms and conditions of the signed license agreement.

SAMPLE CODE is not part of the licensed software, as such it must not be used in
mass-production applications. It can only be used for evaluation and
demonstration purposes at customer's premises listed in the signed license
agreement.
****************************************************************************
*/

/*******************************************************************************
  Section: Includes
*/


#include "r_typedefs.h"        /* Renesas basic types, e.g. uint32_t */
#include "r_jcua_api.h"
#include "r_ddb_api.h"
#include "r_wm_api.h"
#include "r_tick_api.h"
#include "jcua.h"
#include "loc_graphics.h"
#define  JCUA_WM_UNIT (0U)

/***********************************************************
  Section: Local Variables
*/
static uint32_t loc_CallbackReached;
static uint32_t loc_InterruptFactor;
static r_jcua_Error_t JcuaError;
static uint16_t loc_JEPG_H = 0u;
static uint16_t loc_JEPG_Pitch = 0u;
extern r_wm_Window_t loc_WmWindowJcua;
static uint8_t R_WM_Frame_Flag = 0xFFu;

/***********************************************************
  Section: Local Defines
*/
#define LOC_BYTE_PER_PIXEL  (4)

/***********************************************************
  Section: Local Functions
*/
/*******************************************************************************
    Function: SetSFMAConfig

    Fills the flash device config and command structure according to the target
    device.
 */
void loc_JpegCallbackFunction(uint32_t Unit, r_jcua_CallbackReason_t Factor, uint32_t Param)
{
    loc_CallbackReached = 1;
    loc_InterruptFactor |= Factor;
    return;
}

void Init_JcuaRun(uint16_t u16JEPGH, uint16_t u16JEPGPitch)
{
    return;
}

void JCUA_Enable_window(void)
{
    R_WM_WindowEnable(0, &loc_WmWindowJcua);
    R_WM_FrameEndMark(0, 0);
    R_WM_FrameWait(0, 0);
    R_WM_Frame_Flag = 1u;
}

void JCUA_Disable_window(void)
{
    R_WM_WindowDisable(0, &loc_WmWindowJcua);
    R_WM_FrameEndMark(0, 0);
    R_WM_FrameWait(0, 0);
    R_WM_Frame_Flag = 0u;
}

uint8_t Common_Get_window_Sta(void)
{
    return R_WM_Frame_Flag;
}
uint32_t u32adress;
void loc_JcuaRun(uint32_t image)
{

    r_jcua_Error_t         error;
    r_jcua_FrameBuffer_t   frame_buffer;
    r_jcua_DecodeSetting_t option;
    r_wm_Error_t           wmErr;


    /* Initialize JCUA driver. */
    error = R_JCUA_Init(LOC_JCUA_UNIT);
       if (R_JCUA_ERR_OK != error)
       {
	      while (1)
		      {
		      }
       }

    /* Open the decoder. */
    if (R_JCUA_ERR_OK == error)
    {
       error = R_JCUA_DecoderOpen(LOC_JCUA_UNIT, loc_JpegCallbackFunction, 0);
       if (R_JCUA_ERR_OK != error)
       {
	      while (1)
		      {
		      }
       }
       /* Setup frame buffer information. */
       frame_buffer.Address = R_WM_WindowNewDrawBufGet(0U, &loc_WmWindowJcua);
       u32adress = (uint32_t)frame_buffer.Address;
       frame_buffer.Size    = 1280 * 480 * 4;
       frame_buffer.Stride  = 1280 * 4;
       frame_buffer.Format  = R_JCUA_OUTPUT_FORMAT_ARGB8888;
       frame_buffer.Swap    = R_JCUA_SWAP_LONG;
       option.OptionFlag    = R_JCUA_DECODE_OPTION_NONE;
       option.ImgInfo       = R_NULL;

       /* Start JPEG decode.*/
       loc_CallbackReached = 0;
       if (R_JCUA_ERR_OK == error)
       {
           error = R_JCUA_DecoderStart(LOC_JCUA_UNIT, image, &frame_buffer, &option);
           if (R_JCUA_ERR_OK == error)
           {
               /* Wait decode complete. */
               while (loc_CallbackReached == 0)
               {
               };

               wmErr = R_WM_WindowSwap(0, &loc_WmWindowJcua);
               if(R_WM_ERR_OK != wmErr)
               {
                      while (1)
		      {
		      }
               }
               wmErr = R_WM_FrameEndMark(0, 0);
               if(R_WM_ERR_OK != wmErr)
               {
                      while (1)
		      {
		      }
               }
               wmErr = R_WM_FrameWait(0, 0);
               if(R_WM_ERR_OK != wmErr)
               {
                      while (1)
		      {
		      }
               }

              // R_TICK_WaitMS(0, 8000);
           }
           else
           {
               /* Close the decoder. */
               error = R_JCUA_DecoderClose(0);
           }
       }
    //   R_BSP_STDIO_Printf("Closing  JCUA\n");
       /* Close */
       error = R_JCUA_DecoderClose(0);
       
       /* De-initialize Unit 0 of JCUA driver. */
       error = R_JCUA_DeInit(0);
    }
   
}

