#include "TYW_stdint.h"
#include "NVM.h"
#include "Internal_EEPROM.h"
#include <string.h>


#define EEPROM_BASE_ADDR 0
#define EEPROM_PAGE_SIZE 16


void NVM_Usr_Init(void)
{
    uint8_t        readbuff [ 512 ];
    uint8_t        writebuff [ 512 ];
    r_eel_status_t loc_condition;

    //CAFD
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));



    loc_condition = Internal_EEL_Read(INTERNAL_EE_BLOCK_05, readbuff, INTERNAL_EE_BLOCK_05_size);
    if ( (readbuff [ 0 ] != 0x35) || (readbuff [ 1 ] != 0x53) || (readbuff [ 2 ] != 0x7A) || (readbuff [ 3 ] != 0xA7) || (loc_condition == R_EEL_ERR_NO_INSTANCE) )
    {

        writebuff [ 0 ] = 0x35u;
        writebuff [ 1 ] = 0x53u;
        writebuff [ 2 ] = 0x7Au;
        writebuff [ 3 ] = 0xA7u;
        Internal_EEL_Write(INTERNAL_EE_BLOCK_05, writebuff, INTERNAL_EE_BLOCK_05_size);
        Internal_EEL_Read(INTERNAL_EE_BLOCK_05, readbuff, INTERNAL_EE_BLOCK_05_size);

    }


    //CAFD CTRL
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    loc_condition = Internal_EEL_Read(INTERNAL_EE_BLOCK_06, readbuff, INTERNAL_EE_BLOCK_06_size);
    if ( (readbuff [ 0 ] != 0x35) || (readbuff [ 1 ] != 0x53) || (readbuff [ 2 ] != 0x7A) || (readbuff [ 3 ] != 0xA7) || (loc_condition == R_EEL_ERR_NO_INSTANCE) )
    {
        writebuff [ 0 ] = 0x35u;
        writebuff [ 1 ] = 0x53u;
        writebuff [ 2 ] = 0x7Au;
        writebuff [ 3 ] = 0xA7u;
        writebuff [ 4 ] = 0x00u;
        Internal_EEL_Write(INTERNAL_EE_BLOCK_06, writebuff, INTERNAL_EE_BLOCK_06_size);
        Internal_EEL_Read(INTERNAL_EE_BLOCK_06, readbuff, INTERNAL_EE_BLOCK_06_size);

    }


    //USR
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    loc_condition = Internal_EEL_Read(INTERNAL_EE_BLOCK_07, readbuff, INTERNAL_EE_BLOCK_07_size);
    if ( (readbuff [ 0 ] != 0x35) || (readbuff [ 1 ] != 0x53) || (readbuff [ 2 ] != 0x7A) || (readbuff [ 3 ] != 0xA7) || (loc_condition == R_EEL_ERR_NO_INSTANCE) )
    {
        writebuff [ 0 ] = 0x35u;
        writebuff [ 1 ] = 0x53u;
        writebuff [ 2 ] = 0x7Au;
        writebuff [ 3 ] = 0xA7u;


        Internal_EEL_Write(INTERNAL_EE_BLOCK_07, writebuff, INTERNAL_EE_BLOCK_07_size);
        Internal_EEL_Read(INTERNAL_EE_BLOCK_07, readbuff, INTERNAL_EE_BLOCK_07_size);
    }
    //     Internal_EEL_Write(i, write, 64);
}

void CAFD_NVM_Update(void)
{
    uint8_t        readbuff [ 512 ];
    uint8_t        writebuff [ 512 ];
    r_eel_status_t loc_condition;
    //CAFD
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    writebuff [ 0 ] = 0x35u;
    writebuff [ 1 ] = 0x53u;
    writebuff [ 2 ] = 0x7Au;
    writebuff [ 3 ] = 0xA7u;

    Internal_EEL_Write(INTERNAL_EE_BLOCK_05, writebuff, INTERNAL_EE_BLOCK_05_size);
    Internal_EEL_Read(INTERNAL_EE_BLOCK_05, readbuff, INTERNAL_EE_BLOCK_05_size);

}

void CAFD_CTRL_Update(uint8_t status)
{
    uint8_t        readbuff [ 512 ];
    uint8_t        writebuff [ 512 ];
    r_eel_status_t loc_condition;
    //CAFD CTRL
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    writebuff [ 0 ] = 0x35u;
    writebuff [ 1 ] = 0x53u;
    writebuff [ 2 ] = 0x7Au;
    writebuff [ 3 ] = 0xA7u;
    writebuff [ 4 ] = status;
    Internal_EEL_Write(INTERNAL_EE_BLOCK_06, writebuff, INTERNAL_EE_BLOCK_06_size);
    Internal_EEL_Read(INTERNAL_EE_BLOCK_06, readbuff, INTERNAL_EE_BLOCK_06_size);

}
