#ifndef _RTE_CAN_H_
#define _RTE_CAN_H_

#include "TYW_stdint.h"

typedef struct
{
    uint8_t Status;    //当前所处Bus Off 状态
    uint8_t Timer;     // Bus Off计时器
    uint8_t Cnt;       // Bus Off尝试恢复次数
} BusOffMonitorStruct;
typedef enum
{
	CAN_OK,
	CAN_NOT_OK,
	CAN_BUSY,
} Can_ReturnType;

enum
{
    BUS_OFF_STATUS_STABLE = 0,    // 0x00 //非Bus Off状态
    BUS_OFF_STATUS_LV1,           // 0x01 //Bus Off Lv1状态，尝试快速恢复(100ms尝试一次)
    BUS_OFF_STATUS_LV2,           // 0x02 //Bus Off Lv2状态，尝试慢速恢复(1000ms尝试一次)
    BUS_OFF_STATUS_LIMP,          // 0x03 //Bus Off 跛行状态，不再恢复
};

typedef enum
{
	CAN_N_TX = 0u,
	CAN_Y_TX = 1u,
	CAN_N_F_TX = 0x81u,
} Can_SendType;

typedef enum
{
	CAN_N_RX = 0u,
	CAN_Y_RX = 1u,
	CAN_N_F_RX = 0x81u,
} Can_ReceiveType;


typedef struct
{
	uint32_t MsgID;
	uint8_t  MsgStd;
	uint8_t  MsgRTR;
	uint8_t  MsgDLC;
	uint8_t  MsgPro;
	uint8_t  Msg[8];
} _CAN_Msg;

#define Clr_Bit(p, b)           (p) &= (~(1u << (b)))
#define Set_Bit(p, b)           (p) |= (1u << (b))
#define Bit_Is_Set(p, b)        ((p) &(1u << (b)))
#define Bit_Is_Clr(p, b)       (!((p) & (1u << (b))))

extern uint32_t u32Beep;

void BusOff_Init(void);
void BusOff_Service(void);

void Can_Lock_Clr(void);

void Can_Init(void);
void Can_DeInit(void);
uint8_t Can_Write(_CAN_Msg *Msg);
uint8_t Can_Write_FIFO(_CAN_Msg *Msg);

void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[]);
void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus);
void Can_Sleep_Fun(void);
void Can_SleepController_Fun(void);
void Can_Wakeup_Fun(void);
void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus);
Can_ReceiveType Can_ReadRx_St(void);
Can_SendType Can_ReadTx_St(void);
void Can_SetTx_St(Can_SendType Status);
void Can_SetRx_St(Can_ReceiveType Status);
void Can_Abort_All(void);
void Can_Uds_Abort(void);
#endif
