#ifndef _SIMULATED_SPI_MASTER_H_
#define _SIMULATED_SPI_MASTER_H_

#include "RTE_GPIO.h"

/******************************************************************************
模拟SPI主机可配置参数
******************************************************************************/
/*** SPI工作模式 ***/
#define SIM_SPI_MODE_0 0x00
#define SIM_SPI_MODE_1 0x01
#define SIM_SPI_MODE_2 0x02
#define SIM_SPI_MODE_3 0x03

/*** 首先发送的数据位 ***/
#define SIM_SPI_MSB_FIRST 0x00
#define SIM_SPI_LSB_FIRST 0x01

#define SPI_MOSI AUDIO_MOSI
#define SPI_MISO AUDIO_MISO
#define SPI_SCLK AUDIO_SCLK

/******************************************************************************
模拟SPI主机配置结构
******************************************************************************/
typedef struct
{
    uint8_t CPOL;
    uint8_t CPHA;
    uint8_t FirstBit;
} SimSPIConfigStruct;

/******************************************************************************
函数声明
******************************************************************************/
void Sim_SPI_Master_Start(uint8_t Mode, uint8_t FirstBit);

void    Sim_SPI_Master_Byte_Write(uint8_t Data);
uint8_t Sim_SPI_Master_Byte_Read(uint8_t TxData);

void     Sim_SPI_Master_Word_Write(uint16_t Data);
uint16_t Sim_SPI_Master_Word_Read(uint16_t TxData);

#endif
