#ifndef API_CAN_H_
#define API_CAN_H_
#if (CAN_2ND)
#ifdef    GLOBALS_VARIABLE
#define   EXTERN_VAR

#else
#define   EXTERN_VAR     extern

#endif

typedef             char            INT8;
typedef             short  	    INT16;
typedef             unsigned char   INT8U;



typedef struct {
    uint8_t ModuleFCA;
    uint8_t ModuleFCARecvCnt;
    uint8_t ModuleDAW;
    uint8_t ModuleDAWRecvCnt;
    uint8_t ModuleAVN_AV;
    uint8_t ModuleAVN_TBT;
    uint8_t ModuleAVN_Language;
    uint8_t ModuleBCW;
    uint8_t ModuleBCWRecvCnt;
    uint8_t ModuleHBA;
    uint8_t ModuleHBARecvCnt;
    uint8_t ModuleISLW;
    uint8_t ModuleISLWRecvCnt;
    uint8_t ModuleTPMS;
    uint8_t ModuleTPMSRecvCnt;
    uint8_t ModuleDCT;
    uint8_t ModuleDCTRecvCnt;
    uint8_t ModuleSBW;
    uint8_t ModuleSBWRecvCnt;
    uint8_t ModuleSMART;
    uint8_t ModuleSMARTRecvCnt;
    uint8_t ModuleBLE;
    uint8_t ModuleBLERecvCnt;
}SOFTWARE_VARIANT_CODING_STRUCT;
extern SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;  

extern uint8_t UDSSend;
extern uint8_t UDSSend_check;
extern void Send0x553(void);

#pragma pack(1)

//RCS1  ID:0x463    100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            uint32_t CF_RCS_SwTyp  : 1;
            uint32_t      : 3;
            uint32_t CF_RCS_DrvMod : 3;			
            uint32_t      : 1;
            
            uint32_t  CF_RCS_Towmode : 2;			
            uint32_t      : 2;			
            uint32_t CF_RCS_OffRoad : 3;
            uint32_t      : 1;
			
            uint32_t      : 4;	
            uint32_t CF_RCS_BtnSta : 1;
            uint32_t 		: 3;
			
            uint32_t CF_RCS_RotateEnd   : 1;
            uint32_t      : 7;
            
            uint32_t       : 8;
            
            uint32_t      : 8;
			
            uint32_t      : 16;         
        }bits;
    }msg;
    
}RCS1_;
//MCU_MotorSpd  ID:0x410    24
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int   MCU_MotorSpd_L    :   8 ;    
            unsigned int   MCU_MotorSpd_H    :   8 ;  
            unsigned int                     :   8 ;          
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;  
        }bits;
    }msg;
    
}MCU_MotorSpd_;

//AC_ExternalTemperature_C  ID:0x535   100ms 8
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int AC_ExternalTemperature_C :   8 ;
            unsigned int                     :   8 ;    
            unsigned int                     :   8 ;  
            unsigned int                     :   8 ;          
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;  
        }bits;
    }msg;
    
}AC_ExternalTemperature_C_;
//BMS_ChargeStatus  ID:0x177   20ms 45
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;    
            unsigned int                     :   8 ;  
            unsigned int                     :   8 ;          
            unsigned int                     :   5 ;
            unsigned int BMS_ChargeStatus    :   3 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;  
        }bits;
    }msg;
    
}BMS_ChargeStatus_;
//VCU_GearboxPositionDisp id:0x315 100ms ,0

// //VCU_LowSOCWarnLampSts  ID:0x315  10ms, 10

// //VCU_DCDCLVSysFltInd  ID:0x315  100ms, 9

//VCU_ElectricDriveSysFaultDisp  ID:0x315  100ms, 4

// //VCU_SystemFaultDisp_  ID:0x315  100ms, 8

// //VCU_DriveMode_Disp  ID:0x315 100ms, 16

//VCU_PowerBattFaultDisp_  ID:0x315 100ms, 6

//VCU_PowerLimitDisp  ID:0x315  100ms 5
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int VCU_GearboxPositionDisp :   4 ;
            unsigned int VCU_ElectricDriveSysFaultDisp     :   1 ;
            unsigned int VCU_PowerLimitDisp  :   1 ;
            unsigned int VCU_PowerBattFaultDisp  :   1 ;
            unsigned int                     :   1 ;

            unsigned int VCU_SystemFaultDisp :   1 ;
            unsigned int VCU_DCDCLVSysFltInd     :   1 ;
            unsigned int VCU_LowSOCWarnLampSts    :   1 ;
            unsigned int                     :   5 ;

            unsigned int   VCU_DriveMode_Disp   :   3 ;            
            unsigned int                        :   5 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}VCU_4_ICMDisp_;

//AVAS_SwitchFb_  ID:0x449  100ms 0
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int AVAS_SwitchFb       :   1 ;
            unsigned int                     :   7 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}AVAS_SwitchFb_;

//PEPS_SmartSystemWarning_3_1  ID:0x480 100ms, 2
//PEPS_SmartSystemWarning_1_3  ID:0x480  50ms 15
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                       :   2 ;
            unsigned int  PEPS_SmartSystemWarning_3_1   :   1 ;
            unsigned int                       :   5 ;    
            unsigned int                     :   7 ;
            unsigned int PEPS_SmartSystemWarning_1_3      :   1 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}PEPS_1_;

//VCU_PercentgPwrUsage id:0x3A3 100ms ,23
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int  VCU_PercentgPwrUsage_L  :   7 ;
            unsigned int                     :   1 ;
            unsigned int                     :   7 ;
            unsigned int VCU_PercentgPwrUsage_H    :  1 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}VCU_PercentgPwrUsage_;

//BMS_HVBatSOC id:46C 10ms 32
//BMS_BatPckCrnt id:46c 10ms 24
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  BMS_HVBatProcssVol_L  :   5 ;
            unsigned int                        :   3 ;
            unsigned int BMS_HVBatProcssVol_H   :   8 ;

            unsigned int   BMS_BatPckCrnt_L     :   7 ;
            unsigned int                        :   1 ;
            unsigned int   BMS_BatPckCrnt_H     :   8 ;

            unsigned int   BMS_HVBatSOC         :   8 ;
            unsigned int                        :   8 ;
            unsigned int                        :   8 ;
            unsigned int                        :   8 ;
            
        }bits;
    }msg;
    
}BMS_HVBatSOC_;

//BCM_HighBeamSts_  ID:0x391  20ms, 2
//BCM_DRLSts_  ID:0x391  20ms, 4
//BCM_ParkLightSts  ID:0x391  20ms, 27
//BCM_RearFogLightSts  ID:0x391  20ms, 34
//BCM_RHTurnlightSts  ID:0x391  20ms, 0
//BCM_DriverDoorSts  ID:0x391 20ms, 24
//BCM_LHTurnlightSts_  ID:0x391  20ms 1
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int BCM_RHTurnlightSts   :   1 ;
            unsigned int BCM_LHTurnlightSts  :   1 ;
            unsigned int BCM_HighBeamSts     :   1 ;
            unsigned int                     :   1 ;
            unsigned int   BCM_DRLSts        :   1 ;
            unsigned int                    :   3 ;            

            unsigned int                     :   8 ;

            unsigned int                     :   8 ;

            unsigned int BCM_DriverDoorSts     :  1 ;
            unsigned int                     :   2 ;
            unsigned int BCM_ParkLightSts    :   1 ;
            unsigned int                     :   4 ;

            unsigned int                     :   2 ;
            unsigned int BCM_RearFogLightSts :   1 ;
            unsigned int                     :   5 ;

            unsigned int                     :   8 ;

            unsigned int                     :   8 ;

            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}BCM_1_Door_Light_;

//VCU_RegenerationLevelSts  ID:0x3A5  100ms, 34
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   2 ;
            unsigned int VCU_RegenerationLevelSts :   3 ;
            unsigned int                     :   3 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}VCU_RegenerationLevelSts_;

//BMS_ThermalCtrlWarning  ID:0x46D  10ms, 53
//BMS_IsoResisLw  ID:0x46D  10ms, 30
//BMS_HVBatDiscWarn  ID:0x46D 10ms, 5
//BMS_BatTmpHiInd  ID:0x46D  10ms, 25
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                       :   5 ;
            unsigned int  BMS_HVBatDiscWarn    :   1 ;
            unsigned int                       :   2 ;

            unsigned int  BMS_RemainingChargeTime_L :   1 ;
            unsigned int                            :   7 ;   

            unsigned int  BMS_RemainingChargeTime_H :   8 ;

            unsigned int                     :   1 ;
            unsigned int BMS_BatTmpHiInd     :   2 ;
            unsigned int                     :   3 ;
            unsigned int BMS_IsoResisLw    :   2 ;

            unsigned int                     :   8 ;
            unsigned int                     :   8 ;

            unsigned int                     :   5 ;
            unsigned int BMS_ThermalCtrlWarning     :   1 ;
            unsigned int                     :   2 ;

            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}BMS_6_;

//MCU_MotorTempWarning  ID:0x51D  500ms, 15
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int                     :   7 ;
            unsigned int MCU_MotorTempWarning     :   1 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}MCU_MotorTempWarning_;

//TPMS_TirePressureSystemFailSts  ID:0x51B  500ms, 7
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   7 ;
            unsigned int TPMS_TirePressureSystemFailSts     :   1 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}TPMS_TirePressureSystemFailSts_;

//EPS_EPSFailSts  ID:0x505  100ms, 0
//EPS_SteeringAngleCalibrationSts  ID:0x505  100ms, 4
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  EPS_EPSFailSts     :   1 ;
            unsigned int                     :   3 ;
            unsigned int EPS_SteeringAngleCalibrationSts     :   1 ;
            unsigned int                     :   3 ;            
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}EPS_SteeringAngleCalibrationSts_;

//IMMO_AuthFailWarn  ID:0x412  100ms, 32
// //IMMO_AuthCodeWarn  ID:0x412  100ms, 34
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;            
            unsigned int                     :   8 ;
            unsigned int IMMO_AuthFailWarn      :   2 ;
            unsigned int IMMO_AuthCodeWarn   :   1 ;
            unsigned int                     :   5 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}IMMO_AuthFailWarn_;

// //VCU_VacuumPresWarn  ID:0x151 10ms, 29
//VCU_ReadySts  ID:0x151  10ms, 21
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                        :   8 ;
            unsigned int                        :   8 ;
            unsigned int                        :   5 ;            
            unsigned int    VCU_ReadySts        :   1 ;
            unsigned int                     :   2 ;
            unsigned int                        :  5 ;
            unsigned int   VCU_VacuumPresWarn  :   3 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}VCU_3_GearBrakePostion_;

//ABM_AirBagFailSts  ID:0x31C 500ms, 6
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                       :   6 ;
            unsigned int  ABM_AirBagFailSts    :   2 ;
            unsigned int                       :   8 ;            
            unsigned int                        :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}ABM_AirBagFailSts_;

//ESP_ABS_FailSts  ID:0x2e9 10ms, 5
// //ESP_VehicleSpeedVSOSig  ID:0x2E9    32
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                       :   5 ;
            unsigned int  ESP_ABS_FailSts    :   1 ;
            unsigned int                       :   2 ;            
            unsigned int                        :   8 ;
            unsigned int                     :   8 ;
            unsigned int  ESP_VehicleSpeedVSOSig_L     :   5 ;  
            unsigned int                               :   3 ;
            unsigned int  ESP_VehicleSpeedVSOSig_H     :   8 ;  
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}ESP_ABS_FailSts_;

//OBC_CC_ConnectSts  ID:0x176 20ms, 29
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                       :   8 ;
            unsigned int                        :   8 ;
            unsigned int                       :   8 ;            
            unsigned int                        :  5 ;
            unsigned int   OBC_CC_ConnectSts  :   2 ;
            unsigned int                      :   1 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            unsigned int                     :   8 ;
            
        }bits;
    }msg;
    
}OBC_CC_ConnectSts_;

//ICM_DisplayVehicleSpeed  ID:0x430 20ms, 8
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int   ICM_DisplayVehicleSpeed_L    :   5 ;
            unsigned int   ICM_HandBrakeSystemSts       :   3 ;
            unsigned int   ICM_DisplayVehicleSpeed_H    :   8 ;            
            unsigned int   ICM_BatteryVoltage           :   8 ;
            unsigned int   ICM_Low_Brake_Fluid          :   1 ;
            unsigned int   ICM_DriverSeatBeltSwitch     :   1 ;
            unsigned int                                :   2 ;
            unsigned int    MessageCounter              :   4 ;
            unsigned int                                :   8 ;
            unsigned int   TotalOdometer_km_L           :   4 ;
            unsigned int                                :   4 ;
            unsigned int   TotalOdometer_km_L2          :   8 ;
            unsigned int   TotalOdometer_km_L3          :   8 ;
            
        }bits;
    }msg;
    
}ICM_DisplayVehicleSpeed_;
//ICM_AirBagLampFailSts_Reserved  ID:0x452
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                :   8 ;
            unsigned int   ICM_AirBagLampFailSts_Reserved      :   2 ;
            unsigned int                                :   6 ;            

            unsigned int                                :   8 ;
            unsigned int                                :   8 ;
            unsigned int                                :   8 ;
            unsigned int                                :   8 ;
            unsigned int                                :   8 ;
            unsigned int                                :   8 ;
            
        }bits;
    }msg;
    
}ICM_AirBagLampFailSts_Reserved_;

//以前的///////////////////////////////////////////
//////////////////////////////////////////////////
//////////////////////////////////////////////////
//SMKmsg20  ID:0x113  200ms
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   3 ;
            unsigned int C_HfreeTrunkTgRValue:   3 ;
            unsigned int                     :   8 ;
            unsigned int C_WALRValue         :   2 ;
            
        }bits;
    }msg;
    
}SMKmsg20_;


//SMKmsg19  ID:0x112  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int    C_AccINDforCLU                          : 1 ;
            unsigned int                                            : 2 ;
            unsigned int    C_DrvToggleButton                       : 1 ;
            unsigned int    C_BrakeSW                               : 1 ;
            unsigned int                                            : 1 ;
            unsigned int    C_AccSMK                                : 1 ;
            unsigned int    C_AccRelayStatus                        : 1 ;
            
            
            
            unsigned int                                            : 2 ;
            unsigned int    C_EsclLowBat                            : 2 ;
            unsigned int    C_EsclEnableStatus                      : 1 ;
            unsigned int    C_EsclBoltStatus                        : 3 ;
            
            
            
            
            unsigned int    C_LFSearchingOn                         : 1 ;
            unsigned int    C_EsclUnitStatus                        : 3 ;
            unsigned int    C_EsclManagerState                      : 4 ;
            
            unsigned int    C_PpositionClutch                       : 1 ;
            unsigned int    C_Ign2SMK                               : 1 ;
            unsigned int    C_Ign2RelayState                        : 1 ;
            unsigned int    C_Ign1SMK                               : 1 ;
            unsigned int    C_Ign1RelayState                        : 1 ;
            unsigned int    C_EsclPowerSupplystatus                 : 1 ;
            unsigned int    C_EsclUnlock                            : 2 ;
            
            
            
            unsigned int                                            : 1 ;
            unsigned int    C_TerminalControlState                  : 4 ;
            unsigned int    C_StartFeedback                         : 1 ;
            unsigned int    C_SSBSW2                                : 1 ;
            unsigned int    C_SSBSW1                                : 1 ;
            
            
            unsigned int                                            : 3 ;
            unsigned int    C_TerminalsManagerState                 : 5 ;
            unsigned int                                            : 16 ;
        }bits;
    }msg;
    
}SMKmsg19_;

//SMKmsg18  ID:0x111  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                              : 1 ;
            unsigned int  C_StarterRlyState           : 1 ;
            unsigned int  C_SMKTeleEngineRunning      : 1 ;
            unsigned int  C_SMKTeleCrankingState      : 1 ;
            unsigned int  C_SMKDiagState              : 1 ;
            unsigned int                              : 1 ;
            unsigned int  C_AuthState                 : 2 ;
            
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            
        }bits;
    }msg;
    
}SMKmsg18_;

//SMKmsg17  ID:0x110  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int C_KeyBATDischargeWarn :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_ImmoLp            :   1 ;
            unsigned int C_IDoutWarn         :   1 ;
            unsigned int C_ESCLNotUnlockWarn :   1 ;
            unsigned int C_ESCLNotLockedWarn :   1 ;
            unsigned int C_ESCLFailWarn      :   1 ;
            unsigned int C_DeactivationWarn  :   1 ;
            
            unsigned int C_SMKExtBuzWarn     :   3 ;
            unsigned int                     :   4 ;
            unsigned int C_KeyoutLp          :   1 ;
            
            unsigned int                     :  2 ;
            unsigned int C_VehicleNotPWarn   :   1 ;
            unsigned int C_SSBWarn           :   1 ;
            unsigned int C_SMKDispWarn       :   4 ;
            
            unsigned int                     :  16 ;
            unsigned int                     :  16 ;
            unsigned int                     :  6 ;
            unsigned int C_HazardFromSMK     :  2 ;//???????
            
        }bits;
    }msg;
    
}SMKmsg17_;

//SMKmsg01  ID:0x10  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int  C_PassiveAccessLock         : 2 ;
            unsigned int                              : 1 ; 
            unsigned int  C_PassiveAccessUnlock       : 2 ;
            unsigned int                              : 1 ;
            unsigned int  C_PassiveFrtDrv             : 1 ;
            unsigned int  C_PassiveFrtAst             : 1 ;
            
            
            
            unsigned int                              : 2 ;
            unsigned int  C_PassiveTrunkTg            : 1 ;
            unsigned int                              : 1 ;
            unsigned int  C_SMKFobID                  : 3 ;
            unsigned int                              : 1 ;
            
            
            
            
            unsigned int   C_SMKRKECmd                : 4 ;
            unsigned int                              : 4 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            
        }bits;
    }msg;
    
}SMKmsg01_;

//BCMmsgDvp1  ID:0x602  
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int  BCMmsgDvp1DataByte0                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte1                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte2                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte3                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte4                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte5                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte6                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte7                            : 8 ;
            
        }bits;
    }msg;
    
}BCMmsgDvp1_;        


//BCMmsg24  ID:0x107  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            unsigned int                             : 5 ;
            unsigned int  C_AutolightValue           : 1 ;
            unsigned int                             : 2 ;
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            
            unsigned int                             : 2 ;
            unsigned int C_WiperMistSw               : 1 ;
            unsigned int C_WiperLowSw                : 1 ;
            unsigned int C_WiperHighSw               : 1 ;
            unsigned int C_WiperAutoSw               : 1 ;
            unsigned int C_LightSwState              : 2 ;
            
            
            unsigned int                             : 4 ;
            unsigned int C_RrWiperSwState            : 2 ;
            unsigned int C_WiperSwState              : 2 ;
            
            unsigned int                             : 8 ;
            
        }bits;
    }msg;
    
}BCMmsg24_; 


//BCMmsg22  ID:0x105     200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            unsigned int                             : 2 ;
            unsigned int C_HBAControlMode            : 1 ;
            unsigned int                             : 5 ;
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
        }bits;
    }msg;
    
}BCMmsg22_; 

//WPCmsg03  ID: 0x19B  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                     :   5 ;
	    unsigned int C_WPCWarning        :   3 ;
	    unsigned int                     :   6 ;
	    unsigned int C_WPCRValue         :   2 ;
            
        }bits;
    }msg;
    
}WPCmsg03_; 

//BCMmsg21  ID:0x104   200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   2 ;
            unsigned int C_ADrURValue        :   3 ;
            unsigned int C_ADrLRValue        :   3 ;
            unsigned int C_RearWiperRValue   :   2 ;
            unsigned int                     :   3 ;
            unsigned int C_EscortHLRValue    :   3 ;
            unsigned int                     :   3 ;
            unsigned int C_OTTurnRValue      :   3 ;
            
            
        }bits;
    }msg;
    
}BCMmsg21_; 

//BCMmsg20  ID:0x103  200
typedef struct
{   
    
    union                                          //SMKmsgDvp1  ID:0x608
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                     :   2 ;
            unsigned int C_HfreeTrunkTgRValue     :   3 ;
            unsigned int C_AstUnlockStat          :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_AstDrSw           :   1 ;
            unsigned int                     :   8 ;
            
            unsigned int                     :   3 ;
            unsigned int C_DrvUnlockState    :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_DrvKeyUnlockSw    :   1 ;
            unsigned int C_DrvKeyLockSw      :   1 ;
            unsigned int C_DrvDrSw           :   1 ;
            
            unsigned int                     :   1 ;
            unsigned int C_HLpLowAct         :   1 ;
            unsigned int C_HLpHighAct        :   1 ;
            unsigned int C_HazardSw          :   1 ;
            unsigned int C_FrtFogAct         :   1 ;
            unsigned int C_ExtTailAct        :   1 ;
            unsigned int                     :   2 ;
            
            unsigned int                     :   4 ;
            unsigned int C_RearFogAct        :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_IntTailAct        :   1 ;
            unsigned int                     :   1 ;
            
            unsigned int                     :   2 ;
            
            unsigned int C_RRUnlockState     :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_RRDrSw            :   1 ;
            unsigned int C_RLUnlockState     :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_RLDrSw            :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_TSigRhSw          :   1 ;
            unsigned int C_TSigLhSw          :   1 ;
            unsigned int C_TrunkTgSw         :   1 ;
            unsigned int C_TrunkTgOtrReleaseSW         :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_StaticBendRhAct   :   1 ;
            unsigned int C_StaticBendLhAct   :   1 ;
            unsigned int                     :   4 ;
            unsigned int C_SunRoofOpenState  :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_TSigRhAct         :   1 ;
            unsigned int C_TSigLhAct          :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg20_; 


//BCMmsg19  ID:0x102   200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                     :  8 ;
            unsigned int                     :  4 ;
            unsigned int C_FrtFogOn          :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_ExtTailOn         :   1 ;
            unsigned int                     :   2 ;
            unsigned int C_IntTailOn         :   1 ;
            unsigned int C_HLpLowOn          :   1 ;
            unsigned int C_HLpHighOn         :   1 ;
            unsigned int                     :   5 ;
            unsigned int C_StaticBendRhOn    :   1 ;
            unsigned int C_StaticBendLhOn    :   1 ; 
            unsigned int                     :   2 ;
            unsigned int C_RearFogOn         :   1 ;
            unsigned int                     :   4 ;
            unsigned int C_DedicatedDRLOn    :   1 ;
            unsigned int C_PassingLpOn       :   1 ;
            unsigned int                     :   2 ;
            unsigned int C_TSigRHOn          :   1 ;
            unsigned int C_TSigLHOn          :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg19_;


//BCMmsg18  ID:0x101  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                     :   3 ;
            unsigned int C_BCMDiagState      :   1 ;
            unsigned int C_AvTail            :   1 ;
            unsigned int C_AutoLightSwOn     :   1 ;
            unsigned int                     :   2 ;
            
            
            unsigned int C_PASOption         :   2 ;
            unsigned int                     :   3 ;
            unsigned int C_PASCheckSound     :   3 ;
            
            unsigned int                     :   8 ;
            unsigned int                      :   2 ;        
            unsigned int C_PASDisplayRLH     :   3 ;
            unsigned int C_PASDisplayRCTR    :   3 ;
            
            unsigned int                     :   5 ;
            unsigned int C_PASDisplayRRH     :   3 ;
            
            unsigned int                     :   2 ;
            unsigned int C_PASSystemOn       :   3 ;
            unsigned int C_PASRsound         :   3 ;
            
            unsigned int                     :   8 ;
            
            unsigned int C_PASDistance       :   1 ;
            unsigned int C_WngBuz            :   3 ;
            unsigned int C_WiperIntT         :   3 ;
            unsigned int C_WiperIntSw        :   1 ;
            
        }bits;
    }msg;
    
}BCMmsg18_;





//BCMmsg17  ID:0x100    200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                     :   2 ;
	    unsigned int C_BAlarmState       :   4 ;
	    unsigned int                     :   1 ;
	    unsigned int C_Acc               :   1 ;
            unsigned int                     :   6 ;
            unsigned int C_BodyTypeOption    :   2 ;
            unsigned int                     :  11 ;
            unsigned int C_IGNSw             :   3 ;
            unsigned int C_Ign2              :   1 ;
            unsigned int C_Ign1              :   1 ;
            unsigned int C_AutoLightOption   :   1 ;
            unsigned int                     :  10 ;
            unsigned int C_ParkBrakeSw       :   1 ;
            unsigned int                     :   7 ;
            unsigned int C_PanicState        :   1 ;
            unsigned int                     :   3 ;
            unsigned int C_SMKOption         :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg17_;


//BCMmsg01  ID:0x0   200
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int                     :   3 ;
	    unsigned int C_RKECmd            :   3 ;
            
            
        }bits;
    }msg;
    
}BCMmsg01_;

//BCMGst  ID:0x720  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int BCMGstByte0Tpci     :   8 ;
	    unsigned int BCMGstByte1Data     :   8 ;
	    unsigned int BCMGstByte2Data     :   8 ;
	    unsigned int BCMGstByte3Data     :   8 ;
	    unsigned int BCMGstByte4Data     :   8 ;
	    unsigned int BCMGstByte5Data     :   8 ;
	    unsigned int BCMGstByte6Data     :   8 ;
            unsigned int BCMGstByte7Data     :   8 ;
            
            
        }bits;
    }msg;
    
}BCMGst_;

//FCA12  ID:0x483   200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t FCA_USM          :  3 ;
            uint32_t FCA_DrvSetState  :  3 ;
            uint32_t                  :  2 ;
            uint32_t FCA_WarningTargetDisplay : 5 ;
            uint32_t                  :  3 ;
            uint32_t                  : 2 ;//18
            uint32_t  FCA_Regulation  : 2 ;
            uint32_t  FCA_FrOnOffEquipSta      : 2 ;
            uint32_t                  : 30 ;
        }bits;
    }msg;
    
}FCA12_;


//TPMS11  ID:0x593  200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  TPMS_W_LAMP                        : 2 ;
            unsigned int  TREAD_W_LAMP                      : 2 ;
            unsigned int  POS_FL_W_LAMP                     : 1 ;
            unsigned int  POS_FR_W_LAMP                     : 1 ;
            unsigned int  POS_RL_W_LAMP                     : 1 ;  
            unsigned int  POS_RR_W_LAMP                     : 1 ;  //8
            
            unsigned int  STATUS_TPMS                             : 3 ; //11
            unsigned int  UNIT                                                : 2 ;//13
            unsigned int                                                            : 3 ;//16  
            
            unsigned int   PRESSURE_FL                             : 8 ; //24
            unsigned int   PRESSURE_FR                             : 8 ; //32
            unsigned int   PRESSURE_RL                             : 8 ;//40 
            unsigned int   PRESSURE_RR                             : 8 ;//48
            
            unsigned int                                                            : 8 ;
            unsigned int                                                            : 8 ; 
        }bits;
    }msg;
    
}TPMS11_;

//TCU14  ID:0x502   100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int                                  : 5 ;
            unsigned int  CF_Tcu_GSel_BlinkReq            : 1 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCU14_;

//0x410
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                                  : 4 ;
            unsigned int      CF_Gway_EscortHLRValue      : 2 ;//6
            unsigned int                                  : 2 ;//8
            
            
            unsigned int CF_Gway_ADrLRValue               : 3 ;//11
            unsigned int    CF_Gway_ADrURValue            : 3 ; //14
            unsigned int                                  : 2 ; //16
            
            
            unsigned int                                  : 5 ; //21
            unsigned int    CF_Gway_OTTurnRValue          : 3 ;  //24
            
            unsigned int                                  : 3 ; //27
            unsigned int   CF_Gway_HAnBRValue             : 3 ; //30
            unsigned int                                  : 2 ; //32
            
            
            unsigned int                                  : 3 ; //35
            unsigned int     CF_Gway_MoodLpRValue         : 3 ; //38
            unsigned int     CF_Gway_RearWiperRValue      : 2 ;  //40
            
            
            unsigned int       CF_Gway_PasSpkrLvRValue    : 3 ;     //43
            unsigned int                                  : 5 ;    //48
            
            
            unsigned int                                  : 8 ;      //56
            
            unsigned int                                  : 4 ;    //60
            unsigned int         CF_Gway_WPCRValue        : 2 ;     //62
            unsigned int                                   : 2 ;     //  64
            
            
        }bits;
    }msg;
    
}TCUA3_;

//TCU13  ID:0x113   10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int                                  : 8 ;
            unsigned int SLOPE_TCU                        : 6 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 4 ;
            unsigned int CF_Tcu_TarGr                     : 4 ;
            unsigned int CF_Tcu_ShfPatt                   : 4 ;
            unsigned int                                  : 4 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCU13_;

//TCU11  ID:0x111   10
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 8 ;
            unsigned int G_SEL_DISP                       : 4 ;
            unsigned int                                  : 2 ;
            unsigned int TCU_TYPE                         : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int TEMP_AT                          : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int SWI_CC                           : 8 ;
        }bits;
    }msg;
}TCU11_;


//SAS11  ID:0x2b0   10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int  SAS_Angle                       : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}SAS11_;


//MDPS11  ID:0x381   20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int  CF_Mdps_WLmp                    : 2 ;
            unsigned int                                  : 6 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}MDPS11_;

//LKA12  ID:0x53e   100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 4 ;
            unsigned int  CF_ISLW_Status                  : 2 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            unsigned int  DAW_LVDA_PUDis                  : 8 ;//32
            
            unsigned int  CF_LeadVehDptAlert_Display      : 2 ; //34
            unsigned int  CF_LeadVehDptAlert_USM          : 2 ; //36
            unsigned int  CF_DAW_TimeReset                 : 1 ;
            unsigned int                                   : 3 ;    //40
            
            unsigned int CF_DAW_Status                    : 4 ;
            unsigned int CF_DAW_Warn                      : 2 ;
            unsigned int CF_DAW_Opt_USM_NEW               : 2 ;   //48
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}LKA12_;

//LKA13 ID:0x4EC
typedef struct
{
  union
  {
      unsigned       data[8];
      struct
      {
      uint32_t                   :8;
      uint32_t                   :8;
      uint32_t                   :8;
      uint32_t                   :8;
      uint32_t                   :8;
      uint32_t  ISLA_OptUsmSta           :3;
      uint32_t                   :5;
      uint32_t                   :8;
      uint32_t                   :8;
      }bits;
  }msg;
}LKA13_;
  

typedef struct
{      
    union
    {   
        uint8_t    data[8];
        struct
        {   
            uint8_t  CF_Gway_PDWDisplayFLH                     : 3 ;
            uint8_t  CF_Gway_PDWDisplayFRH                     : 3 ;
            uint8_t   CF_Gway_PDWRsound                        : 2 ;
            
            uint8_t  CF_Gway_PDWDisplayFCTR                    : 3 ;
            uint8_t  CF_Gway_PDWDisplayRCTR                    : 3 ;
            uint8_t  CF_Gway_PDWFsound                         : 2 ; 
            
            uint8_t   CF_Gway_PDWDisplayRLH                    : 3 ;
            uint8_t  CF_Gway_PDWDisplayRRH                     : 3 ;
            uint8_t  CF_Gway_PDWCheckSound                     : 2 ;
            
            uint8_t  CF_Gway_PDWSystemOn                       : 2 ;
            uint8_t  CF_Gway_PDWOption                         : 2 ;
            uint8_t                                            : 4 ;
            
            uint8_t                                  : 8 ;
            uint8_t                                  : 8 ;
            uint8_t                                  : 8 ;
            uint8_t                                  : 8 ;
            
        }bits;
    }msg;
    
}PDW11_;
















//LKA11  ID:0x340    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t CF_LKA_LaneRecogState :  2 ;
            uint32_t                       :  4 ;
            uint32_t CF_LKA_SysWarning     :  4 ;
            uint32_t CF_LKA_LHWarning      :  2 ;
            uint32_t CF_LKA_RHWarning      :  2 ;
            uint32_t CF_HBA_Lamp           :  1 ;
            uint32_t CF_LKA_HandsOff_Snd   :  1 ;
            uint32_t                       : 13 ;
            uint32_t CF_HBA_SysState       :  3 ;
            uint32_t CF_HBA_Opt_USM        :  2 ;
            uint32_t CF_HBA_Opt            :  1 ;
            uint32_t                       :  5 ;
            uint32_t CF_LKA_USM_Mode       :  2 ;
            uint32_t                       : 14 ;
            uint32_t CF_LKA_SymbolState    :  3 ;
            uint32_t CF_LKA_Opt_USM        :  3 ;
            uint32_t CF_HBA_Lamp_New       :  2 ;
        }bits;
    }msg;
    
}LKA11_;


//FCA11  ID:0x38d    20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            uint32_t CF_VSM_Prefill : 1;
            uint32_t CF_VSM_HBACmd : 2;
            uint32_t CF_VSM_Warn : 2;
            uint32_t CF_VSM_BeltCmd : 3;
            uint32_t CR_VSM_DecCmd : 8;
            uint32_t FCA_Sensor_Type : 1;
            uint32_t   : 1;
            uint32_t FCA_Status : 2;
            uint32_t FCA_CmdAct : 1;
            uint32_t FCA_StopReq : 1;
            uint32_t FCA_DrvSetStatus : 3;
            uint32_t   : 4;
            uint32_t FCA_WrngSndSta : 2;
            uint32_t CF_VSM_DecCmdAct : 1;
            uint32_t FCA_Failinfo : 3;
            uint32_t CR_FCA_Alive : 4;
            uint32_t FCA_RelativeVelocity : 9;
            uint32_t FCA_TimetoCollision : 8;
            uint32_t FCA_CRC : 8;
            
        }bits;
    }msg;
    
}FCA11_;

typedef struct
{      
    union
    {   
        uint8_t    data[8];
        struct
        {   
            uint8_t                                  : 3 ;
            uint8_t  CF_VSM_Warn                     : 2 ;//5
            uint8_t                                  : 3 ;
            
            uint8_t                                  : 8 ;
            
            uint8_t                                  : 2 ;//18
            uint8_t  FCA_Status                      : 2 ; 
            uint8_t                                  : 1 ;//21
            uint8_t  FCA_StopReq                     : 1 ;
            uint8_t                                  : 2 ;
            
            uint8_t                                  : 5 ;//29
            uint8_t  FCA_WrngSndSta                  : 2 ;
            uint8_t                                  : 1 ;
            
            uint8_t  FCA_Failinfo                    : 3 ;
            uint8_t                                  : 5 ;
            uint8_t                                  : 8 ;
            uint8_t                                  : 8 ;
            uint8_t                                  : 8 ;
            
        }bits;
    }msg;
    
}FCA11_FS_;






//TCS15  ID:0x507    100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int  ABS_W_LAMP     : 1 ;
            unsigned int  TCS_OFF_LAMP   : 2 ;
            unsigned int  TCS_LAMP       : 2 ;
            unsigned int  DBC_W_LAMP     : 1 ;
            unsigned int  DBC_F_LAMP     : 2 ;
            unsigned int  ESC_Off_Step   : 2 ;
            unsigned int                 : 6 ; 
            
            unsigned int  AVH_CLU        : 8 ;
            
            unsigned int                 : 2 ;//26
            unsigned int  EBD_W_LAMP     : 1 ;//27
            unsigned int  AVH_ALARM      : 2 ;//29
            unsigned int  AVH_LAMP       : 3 ; //32
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            
            
        }bits;
    }msg;
    
}TCS15_;

//TCS11  ID:0x153        10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 3 ;
            unsigned int HAC_CTL                          : 1 ;
            unsigned int                                  : 2 ;
            
            unsigned int ESS_STAT                         : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCS11_;

//ESP12  ID:0x220    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int CYL_PRES_FLAG                    : 1 ;
            unsigned int                                  : 7 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 6 ;
            unsigned int CYL_PRES_STAT                    : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}ESP12_;


//EMS_H11  ID:0x1bf  10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                                  : 4 ;
            unsigned int  RR_DEF_CUTOFF                   : 1 ;
            unsigned int                                  : 3 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}EMS_H11_;

//EMS_H12  ID:0x18f    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 3 ;
            unsigned int CF_Ems_IsgStat                   : 3 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            
            unsigned int CF_Ems_UpTarGr                   : 1 ;
            unsigned int CF_Ems_DownTarGr                 : 1 ;
            unsigned int CF_Ems_DesCurGr                  : 4 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 1 ;
            unsigned int CF_Ems_IsgBuz                    : 1 ;
            unsigned int                                  : 4 ;
            unsigned int CF_Ems_IsgStat2                  : 2 ;
            
        }bits;
    }msg;
    
}EMS_H12_;

//EMS20  ID:0x200    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int FCO                              : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}EMS20_;

//EMS19  ID:0x492    50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;//32
            
            unsigned int  CR_Ems_EngOilTemp         : 8 ;//40
            
            unsigned int DPF_LAMP_STAT                : 2 ; //42
            unsigned int BAT_LAMP_STAT                : 1 ; //43
            unsigned int                                                   : 5 ;//48 
            
            unsigned int                                                   : 8 ;//56
            
            unsigned int CF_Ems_OPSFail                   : 1 ;//57
            unsigned int                                                   : 7 ;//64        
            
        }bits;
    }msg;
    
}EMS19_;
//CGW_PC2  ID:0x568
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {         
            uint32_t                  : 10 ;
            uint32_t L_MIL            :  1 ;
            uint32_t                  :  2 ;
            uint32_t CF_TCU_WarnMsg   :  3 ;
            uint32_t CF_TCU_WarnImg   :  1 ;
            uint32_t CF_TCU_WarnSnd   :  1 ;
            uint32_t                  :  1 ;
            uint32_t CF_Tcu_DriWarn1  :  3 ;
            uint32_t CF_Tcu_DriWarn2  :  2 ;
            uint32_t                  : 13 ;
            uint32_t CF_Tcu_GSel_BlinkReq :  1 ;
            uint32_t                  :  1 ;
            uint32_t CF_Tcu_SmartShift_Inf :  1 ;
            uint32_t  CF_Tcu_SiCluster :  5 ;
            uint32_t CF_Tcu_DrivingModeDisp : 3;
            
            uint32_t BAT_SOC : 8;
            
            uint32_t CF_Tcu_DrivingModeReq : 3;
            uint32_t CF_Tcu_DriWarn3  :  2 ;
            uint32_t Bat_dischrg      :  1 ;
            uint32_t                    : 1 ;
            uint32_t CF_EMS_SAFETY_FUNCTION  :  1 ;
        }bits;
    }msg;
    
}CGW_PC2_;















//CGW4  ID:0x559
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {           
            uint32_t CF_Gway_MemoryP1Cmd     : 1 ;
            uint32_t CF_Gway_MemoryP2Cmd     : 1 ;
            uint32_t CF_Gway_PBackP1Cmd     : 1 ;
            uint32_t CF_Gway_PBackP2Cmd     : 1 ;
            uint32_t CF_Gway_StrgWhlHeatedState     : 1 ;
            uint32_t CF_Gway_PBackStopCmd     : 1 ;
            uint32_t                        : 1 ;
            uint32_t                        : 1 ;
            //uint32_t                        : 8 ;
            uint32_t CF_Gway_DrvWdwStat     : 1 ;
            uint32_t CF_Gway_RLWdwState     : 1 ;
            uint32_t CF_Gway_RRWdwState     : 1 ;
            uint32_t CF_Gway_AstWdwStat     : 1 ;
            uint32_t CF_Gway_MemoryEnable   : 1 ;
            uint32_t CF_Gway_StrgWhlAutoOffState   : 1 ;
            uint32_t                        : 1 ;
            uint32_t CF_Gway_IMSBuzzer      : 1 ;
            uint32_t                        : 2 ;
            uint32_t CF_Gway_WiperSwState   :  2 ;
            uint32_t                        : 4 ;
            uint32_t                        : 8 ;
            uint32_t                        : 4 ;
            uint32_t CF_Gway_DrvSeatBeltIND :  2 ;
            uint32_t                        :  2 ;
            uint32_t CF_Gway_RLSeatBeltIND  :  2 ;
            uint32_t CF_Gway_RRSeatBeltIND  :  2 ;
            uint32_t CF_Gway_RCSeatBeltIND  :  2 ;
            uint32_t CF_Gway_RrWiperSwState :  2 ;
            uint32_t                        :  8 ;
            uint32_t CF_Gway_WPCWarning     :  3 ;
            uint32_t                        :  5 ;
        }bits;
    }msg;
    
}CGW4_;





//EMS16  ID:0x492    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int GLOW_STAT                        : 1 ;
            unsigned int CRUISE_LAMP_M                                 : 1 ;
            unsigned int CRUISE_LAMP_S                                 : 1 ;
            unsigned int                                  : 1 ;
            unsigned int ENG_STAT                         : 3 ;
            unsigned int                                  : 1 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;            
            
        }bits;
    }msg;
    
}EMS16_;

//EMS14  ID:0x545    100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                                  : 1 ;
            unsigned int L_MIL                            : 1 ;
            unsigned int                                  : 1 ;
            unsigned int AMP_CAN                          : 5 ;
            
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int  VB                              : 8 ; 
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;           
            
        }bits;
    }msg;
    
}EMS14_;

//EMS12  ID:0x329    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 8 ;
            unsigned int  TEMP_ENG                        : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 6 ; 
            unsigned int ACC_ACT                          : 2 ;
            
            unsigned int BRAKE_ACT                        : 2 ;
            unsigned int                                  : 6 ;
            unsigned int TPS                              : 8 ;
            unsigned int PV_AV_CAN                        : 8 ;
            unsigned int                                  : 8 ;           
            
        }bits;
    }msg;
    
}EMS12_;

//EMS_CNG11  ID:0x445    10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CNG_EOM                         : 3 ;
            unsigned int  CNG_SYS_Flag                    : 8 ;
            
            unsigned int  CNG_FTL                         : 8 ;
            unsigned int                                  : 5 ; 
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;           
            
        }bits;
    }msg;
    
}EMS_CNG11_;


//EMS11  ID:0x316   10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 1 ;
            
            unsigned int  F_N_ENG                         : 1 ;
            unsigned int                                  : 6 ;
            unsigned int                                  : 8 ;
            unsigned int  N                               : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int  VS                              : 8 ;           
            
        }bits;
    }msg;
    
}EMS11_;

//DATC13  ID:0x43   1000
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CF_Datc_TempDispUnit            : 2 ;
            unsigned int                                  : 6 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
            
        }bits;
    }msg;
    
}DATC13_;


//DATC11  ID:0x44   1000   
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int CR_Datc_OutTempC                 : 8 ;
            unsigned int CR_Datc_OutTempF                 : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}DATC11_;

//ACU14  ID:0x500   100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int CF_SWL_Ind       :  2 ;
            unsigned int      :  6 ;
            unsigned int      :  8 ;
            unsigned int      :  8 ;
            unsigned int      :  8 ;
            unsigned int      :  32 ;
        }bits;
    }msg;
    
}ACU14_;

//BCW11 ID:0x58B   50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int      CF_BCW_Stat               :  4  ;
            unsigned int      CF_RCCW_Stat              :  4  ;
            
            
            unsigned int      CF_BCW_IndLeft            :  2  ;
            unsigned int                                :  6  ;
            
            unsigned int        CF_BCW_IndRight        :  2  ;
            unsigned int                                :  2 ;
            unsigned int      CF_FR_SndWan              :  1  ;
            unsigned int      CF_FL_SndWan              :  1  ;
            unsigned int      CF_RR_SndWan              :  1  ;
            unsigned int      CF_RL_SndWan              :  1  ;
            
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            
            
            
            unsigned int      CF_RCCW_IndLeft           :  2  ;
            unsigned int      CF_RCCW_IndRight          :  2  ;
            unsigned int                               :  4  ;
            
            
            
        }bits;
    }msg;
    
}BCW11_;

//RR_C_RDR_01_1_50ms  ID:0x443    50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            uint32_t      : 12;         
            
            uint32_t RR_C_RDR_AlvCnt01_1Val  : 4;
			
            uint32_t RCCW_Sta : 4;
            uint32_t RCCW_OnOffEquipSt : 2;			
            uint32_t RCCW_LftIndSta   : 2;
			
            uint32_t RCCW_RtIndSta  : 2;			
            uint32_t RCCW_LftSndWrngSta : 1;
            uint32_t RCCW_RtSndWrngSta   : 1;			
            uint32_t      : 4;
			
            uint32_t  		 : 8;
            
            uint32_t       : 4;
            uint32_t RR_C_RDR_ADAS_TrlrOffDispSta   : 2;
            uint32_t       : 2;
            
            uint32_t       : 8;            
            uint32_t       : 8;
			
        }bits;
    }msg;
    
}RR_C_RDR_01_1_50ms_;

//RR_C_RDR_01_2_50ms  ID:0x444    50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            uint32_t      : 12;         
            
            uint32_t RR_C_RDR_AlvCnt01_2Val  : 4;
			
            uint32_t   		   : 5;
            uint32_t RCCA_OnOffEquipSt : 2;			
            uint32_t 		   : 1;
			
            uint32_t RCCW_RtIndSta  : 2;			
            uint32_t RCCW_LftSndWrngSta : 1;
            uint32_t RCCW_RtSndWrngSta   : 1;			
            uint32_t      : 4;
			
            uint32_t  		 : 8;
            
            uint32_t       : 8;
			
            uint32_t       : 1;  
            uint32_t RCCA_LftWrngSta : 2;            
            uint32_t RCCA_RtWrngSta : 2;            
            uint32_t  				 : 2;
			uint32_t SEA_OnOffEquipSta_New : 2;
			
            uint32_t       : 7;      

			
        }bits;
    }msg;
    
}RR_C_RDR_01_2_50ms_;
//ADAS_CMD_10_1_20ms  ID:0x38D    20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            uint32_t      : 19;         
            
            uint32_t FCA_WrngLvlSta  : 2;
            uint32_t      : 11;         
			
            uint32_t FCA_SysFlrSta : 3;			

            uint32_t FCA_VehStpReq : 1;
			
            uint32_t  			 : 19;			
			
            uint32_t FCA_WrngTrgtDis  : 5;			
            
            uint32_t       : 4;      

			
        }bits;
    }msg;
    
}ADAS_CMD_10_1_20ms_;

//ADAS_CMD_10_2_200ms  ID:0x447    20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            uint32_t      : 16;
            
            uint32_t FCA_OnOffEquipSta : 3;
            uint32_t FCA_SnstvtyModRetVal : 3;
            uint32_t      : 2;
            uint32_t FCA_Jnctn_OnOffEquipSta: 2;
            uint32_t FCA_Regulation     : 2;
            uint32_t  	     : 4;
			
            uint32_t      : 16;
            uint32_t      : 16;         
        }bits;
    }msg;
    
}ADAS_CMD_10_2_200ms_;
//ADAS_CMD_30_1_10ms_  ID:0x363    200
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t      : 32;         
            uint32_t      LKA_SysIndReq: 3;         
            uint32_t       : 29;                
        }bits;
    }msg;    
}  ADAS_CMD_30_1_10ms_;
//ADAS_CMD_30_2_20ms_  ID:0x363    200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            uint32_t      : 32;         
            
            uint32_t      : 26;         
					
            uint32_t CF_Gway_IAUOption      : 3;              
            uint32_t CF_Gway_PwrAutoOffTimeRValue      : 3;      

			
        }bits;
    }msg;
    
}ADAS_CMD_30_2_20ms_;
//ADAS_CMD_31_1_50ms_  ID:0x485
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t      : 16;
            uint32_t      HDA_OptUsmSta: 3;
            uint32_t      : 6;
            uint32_t      HDA_LFA_SymSta: 2;
        }bits;
    }msg;
    
}ADAS_CMD_31_1_50ms_;

//RR_C_RDR_02_2_50ms  ID:0x48A    50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            uint32_t      : 12;         
            
            uint32_t RR_C_RDR_AlvCnt02_2Val  : 4;
            uint32_t BCA_Sta 			: 4;         
			
            uint32_t BCA_OnOffEquipSta : 3;			
            uint32_t      : 18;         

            uint32_t BCA_R_Brake_Warning : 3;
			
            uint32_t  			 : 16;			
			
            uint32_t BCA_Plus_LftWrngSta  : 2;			
            uint32_t BCA_Plus_RtWrngSta: 2;      

			
        }bits;
    }msg;
    
}RR_C_RDR_02_2_50ms_;
//FR_CMR_01_1_20ms  ID:0x364   10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t                       :  16 ;
			
            uint32_t HBA_IndLmpReq         :  1 ;
            uint32_t HBA_SysSta            :  3 ;
            uint32_t HBA_OptUsmSta         :  2 ;
            uint32_t                       :  8 ;       
            uint32_t DAW_LVDA_PUDis        :  2 ;
            
            uint32_t DAW_OptUsmSta         :  3 ;
            uint32_t DAW_SysSta            : 4 ;
            uint32_t DAW_WrnMsgSta         :  2 ;
            uint32_t DAW_TimeRstReq        :  1 ;
            uint32_t DAW_LVDA_OptUsmSta    :  2 ;
            uint32_t                       :  3 ;
            uint32_t HBA_SysOptSta       :  1 ;  
			
            uint32_t                       : 14 ;          
            uint32_t HBA_IndLmpReq_New       :  2 ;

        }bits;
    }msg;
    
}FR_CMR_01_1_20ms_;
// 0x53E
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t                       :  8 ;
            uint32_t                       :  8 ;
            
            uint32_t                       :  2 ;
			uint32_t   ISLW_SysSta         :  2 ;
            uint32_t                       :  4 ;
            
            uint32_t                       :  8;
            uint32_t                       :  8;
            
            uint32_t  ISLA_OptUsmSta       :  3;
            uint32_t                       :  5;
            
            uint32_t                       :  8 ;
            uint32_t                       :  8 ;
        }bits;
    }msg;
    
}FR_CMR_02_1_100ms_;

    
typedef union 
{
    unsigned char      m_aucData[8];
    struct {
        unsigned int                        :  6 ;
        unsigned int CF_RCCA_WarnLh         :  2 ;
        unsigned int CF_BCA_R_Plus_WarnLh   :  2 ;
        unsigned int CF_BCA_R_Plus_WarnRh   :  2 ;
        unsigned int                        :  2 ;
        unsigned int CF_RCCA_WarnRh         :  2 ;
        unsigned int CF_BCA_State           :  3 ;
        unsigned int                        :  5 ;
        unsigned int                        :  6 ;
        unsigned int BCW_IndSta             :  2 ;
        unsigned int CF_SEA_Stat            :  2 ;
        unsigned int CF_RCCA_FuncState      :  1 ;
        unsigned int CF_BCA_RH_SndWan       :  1 ;
        unsigned int CF_BCA_LH_SndWan       :  1 ;
        unsigned int                        :  3 ;
        unsigned int CF_RCCA_SW_Stat        :  3 ;
        unsigned int                        :  2 ;
        unsigned int CF_BCA_R_Warning       :  3 ;
        unsigned int BCA_Plus_Deccel_Req    :  4 ;
        unsigned int BCA_Plus_BrkCmdSta     :  1 ;
        unsigned int CF_BCA_R_Plus_State    :  3 ;
        unsigned int                        :  8 ;
    };
}BCA11_;

//CGW_PC12  ID:0x4C9   20  
typedef union 
{
    unsigned char      m_aucData[8];
    struct {
        unsigned int CF_TCU_AvgCltTemp : 4;
        unsigned int   : 3;
        unsigned int CF_Bms_MILReq : 1;
        unsigned int CF_Ems_SysWarnLamp : 1;
        unsigned int   : 1;
        unsigned int CF_EMS_NCC_STAT : 2;
        unsigned int   : 27;
        unsigned int Gear_Warn : 1;
        unsigned int CF_Tcu_ATTempWarn : 1;
        unsigned int CF_Ems_ISG_Equipped : 1;
        unsigned int CF_Ems_ISGDisp_Detail : 5;
        unsigned int CF_Ems_OilLife_Ena : 1;
        unsigned int CF_Ems_OilLife_Warn : 2;
        unsigned int CF_Ems_OilLife_Ratio : 7;
        unsigned int BrkClthPrs_Warn : 1;
        unsigned int   : 6;                     
	};
}CGW_PC12_;

//typedef struct
//{   
//    INT8U       msg[8];
//    INT8U       dlc;
//    INT8U       prio;         
//    
//}CGW_PC12_;
//CGW_PC14  ID:0x44E   20  
//typedef struct
//{   
//    INT8U       msg[8];
//    INT8U       dlc;
//    INT8U       prio;         
//    
//}CGW_PC14_;
typedef struct
{   
    INT8U       msg[8];
    INT8U       dlc;
    INT8U       prio;         
    
}can002_;     
//typedef struct
//{   
//  
//  union
//  {   
//    unsigned        data[8];
//    struct {
//      unsigned int CF_Gway_AutoShutOffTimeMin_EMS : 8;
//      unsigned int CF_Gway_AutoShutOffTimeSec_EMS : 6;
//      unsigned int CF_Gway_PwrAutoOffInfo_EMS : 2;   //8
//      unsigned int   : 1;
//      unsigned int CF_EMS_SelfRgnRValueSet : 2;
//      unsigned int CF_EMS_SelfRgnWarn : 2;
//      unsigned int CF_EMS_SelfRgnNoCond : 2;   
//      unsigned int CF_EMS_SelfRgnStat : 2;   //8 1
//      unsigned int CF_EMS_SelfRgnPrgLvl : 8;  
//      unsigned int CF_Ems_Stall : 2;
//      unsigned int ECGPOvrd : 1;
//      unsigned int ENG_SldDrvAlertDisp : 2;
//      unsigned int ENG_AccDrvAlertDisp : 2;
//      unsigned int   : 2;   //8 1
//      unsigned int CF_Ems_IsgWarning : 4;
//      unsigned int   : 18;
//    }bits;
//  }msg;
//  
//}CGW_PC14_;

typedef struct
{   
  
  union
  {   
    unsigned        data[8];
    struct {
      unsigned int                         : 33;
      unsigned int CF_Ems_Stall : 2;
      unsigned int                          : 7;
      unsigned int CF_Ems_IsgWarning : 4;
      unsigned int   : 18;
    }bits;
  }msg;
  
}CGW_PC14_;


/*typedef struct
{   

union
{   
unsigned        data[8];
struct {
unsigned int CF_Gway_AutoShutOffTimeMin_EMS : 8;
unsigned int CF_Gway_AutoShutOffTimeSec_EMS : 6;
unsigned int CF_Gway_PwrAutoOffInfo_EMS : 2;
unsigned int   : 1;
unsigned int CF_EMS_SelfRgnRValueSet : 2;
unsigned int CF_EMS_SelfRgnWarn : 2;
unsigned int CF_EMS_SelfRgnNoCond : 2;
unsigned int CF_EMS_SelfRgnStat : 2;
unsigned int CF_EMS_SelfRgnPrgLvl : 8;
unsigned int CF_Ems_Stall : 2;
unsigned int CF_Ems_IsgWarning : 4;
unsigned int   : 2;
unsigned int  : 4;
unsigned int   : 18;
        }bits;
    }msg;

}CGW_PC14_;*/
//WHL_SPD11  ID:0x386   20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int WHL_SPD_FL                       : 16 ;
            //unsigned int                                  : 2 ;
            unsigned int WHL_SPD_FR                       : 16 ;
            //unsigned int                                  : 2 ;
            unsigned int WHL_SPD_RL                       : 16 ;
            // unsigned int                                  : 2 ;
            unsigned int WHL_SPD_RR                       : 16 ;
            //unsigned int                                  : 2 ;
            
            
        }bits;
    }msg;
    
}WHL_SPD11_;

//ABS11  ID:0x38a   20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                                  : 3 ;
            unsigned int  ABS_W_LAMP                      : 1 ;
            unsigned int  EBD_W_LAMP                      : 1 ;
            unsigned int                                  : 1 ;
            unsigned int  ESS_STAT                        : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
            
        }bits;
    }msg;
    
}ABS11_;

//SCC11  ID:0x420 
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  MainMode_SCC                      : 1 ;
            unsigned int  SCCInfoDisplay                       : 3 ;
            unsigned int  AliveCounterSCC                    : 4 ; 
            
            unsigned int  VSetDis                                     : 8 ; //16
            
            unsigned int   ObjValid                                   : 1 ; //17
            unsigned int   DriverAlertDisplay                 : 2 ; // 19
            unsigned int   TauGapSet                                : 3 ; // 22
            unsigned int                                                     : 2 ; // 24  
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
        }bits;
    }msg;
}SCC11_;

//SCC12  ID:0x421 
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                  : 11 ;
            unsigned int SCCFailInfo      :  2 ;
            unsigned int                  : 22 ;
            unsigned int TakeOverReq      :  1 ;
            unsigned int                  : 28 ;
        }bits;
    }msg;
}SCC12_;

//SCC14  ID:0x389
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                  : 32 ;
            unsigned int SCCMode2         :  3 ;
            unsigned int NSCC_AutoSetSpdUpdtSta :  2 ;
            unsigned int NSCC_AutoSetSpdSta :  2 ;
            unsigned int                  :  3 ;
            unsigned int                  :  3 ;
            unsigned int                  : 11 ;
            unsigned int ObjGap           :  8 ;
        }bits;
    }msg;
}SCC14_;


//HDA11  ID:0x485
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t   : 7;
            uint32_t CF_HDA_AutoSetSpdUpdate : 1;
            uint32_t   : 8;
            uint32_t CF_HDA_InfoDisplay : 3;
            uint32_t   : 4;
            uint32_t CF_HDA_LFA_Wrn_Snd : 1;
            uint32_t CF_HDA_LFA_SymbolState : 2;
            uint32_t   : 3;
            uint32_t CF_HDA_InfoDisplay2 : 3;
            uint32_t   : 32;
        }bits;
    }msg;
}HDA11_;


//CLU19  ID:0x4a6   0   10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            
            unsigned int  CF_AVN_FCANValueSet             : 3 ;
            unsigned int  CF_AVN_CluUSMReset              : 1 ;
            unsigned int                                  : 4 ;
            unsigned int                                  : 3 ;
            unsigned int  CF_AVN_DAWModeNValueSet         : 3 ;
            unsigned int                                  : 2 ;
            
            
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 4 ;
            unsigned int  CF_AVN_WarningTimingNValueSet   : 3 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_AVN_SccFrVehDptNValueSet     : 2 ;
            unsigned int                                  : 6 ;
            
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 1 ;
            unsigned int CF_AVN_LkaModeNValueSet          : 3 ;
            unsigned int                                  : 2 ;
            unsigned int CF_AVN_HBANValueSet              : 2 ;
            unsigned int                                  : 8 ;
            
            
            
        }bits;
    }msg;
    
}CLU19_;

//CLU16  ID:0x51b   0
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int CF_Clu_TirePressUnitNValueSet :  3 ;
            unsigned int                  :  5 ;
            unsigned int                  :  8 ;
            
            unsigned int                  :  1 ;
            unsigned int CF_Clu_FCAModeNValueSet :  3 ;
            unsigned int                  : 3 ;
            unsigned int                  : 1 ;
            
            unsigned int                  :  7 ;
            unsigned int                  : 1 ;
            
            unsigned int                  :  7 ;
            unsigned int CF_Clu_USMReset  :  1 ;
            unsigned int                  : 8 ;
            unsigned int                  : 7 ;
            unsigned int CF_Clu_ICUDeliveryModeOffReq  :  1 ;
            unsigned int                  : 8 ;
        }bits;
    }msg;
    
}CLU16_;
//CGW_PC4  ID:0x366
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                 :  8 ;
            unsigned int N               : 16 ; 
            unsigned int                 : 8  ;
            
            
            
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            
            unsigned int                 : 1 ;
            unsigned int F_N_ENG          :  1 ;
            unsigned int                 :  2 ;
            unsigned int SCU_WarnMsg      :  4 ;
            
            unsigned int                 :  8 ;                      
        }bits;
    }msg;
}CGW_PC4_;


//EPB11  ID:0x490 
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int   EPB_I_LAMP                           : 4 ;
            unsigned int   EPB_F_LAMP                          : 2 ; 
            unsigned int   EPB_ALARM                           : 2 ; //8
            
            unsigned int   EPB_CLU                                 : 8  ;//16   
            
            unsigned int                                                      : 8 ;
            unsigned int                                                      : 8 ;
            unsigned int                                                      : 8 ;
            unsigned int                                                      : 8 ;
            unsigned int                                                      : 8 ;    
            unsigned int                                                      : 8 ;
        }bits;
    }msg;
}EPB11_;



//CGW_PC5  ID:0x367
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {                                                                    
            unsigned int  SLD_VS                                    : 8 ;
            
            unsigned int   CF_Ems_IsgStat                     : 3 ;//11
            unsigned int   CF_Ems_OilChg                    : 1 ;//12
            unsigned int                                                    : 1 ;//13   
            unsigned int   CF_Ems_UpTarGr                 : 1 ;//14 
            unsigned int   CF_Ems_DownTarGr            : 1 ;//15  
            unsigned int   CF_Ems_SldAct                                : 1 ;//16    
            
            unsigned int   CF_Ems_DesCurGr               : 4 ; //20    
            unsigned int                                                    : 1 ;  //21
            unsigned int  CF_Ems_IsgBuz                      : 1 ;  //22
            unsigned int                                                    : 2 ;  //24  
            
            unsigned int                                                    : 1 ;  //25   
            unsigned int  CF_Ems_IsgStat2                   : 2 ;  //27 
            unsigned int  TCU_GearSlctDis                   : 5 ;  //32   
            
            unsigned int   G_SEL_DISP                          : 4 ;//36 
            unsigned int   GEAR_TYPE                          : 4 ;//40                          : 4 ; 
            
            unsigned int                                                    : 8 ;
            unsigned int                                                    : 8 ;
            unsigned int                                                    : 8 ; 
        }bits;
    }msg;
}CGW_PC5_; 

//CGW_PC6  ID:0x368
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                             : 8 ; 
            unsigned int                                                             : 8 ;  //16
            unsigned int                                                             : 8 ;  //24  
            unsigned int                                                             : 8 ; //32
            
            unsigned int  CF_Tcu_TarGr                                 : 4 ; 
            unsigned int                                                             : 4 ; //40
            
            unsigned int                                                             : 8 ; //48
            unsigned int                                                             : 8 ;//56 
            
            unsigned int                                                             : 5 ; //61     
            unsigned int TCU_TYPE                                        : 2 ; //63
            unsigned int                                                             : 1 ; //64                                      
        }bits;
    }msg;
}CGW_PC6_;

//CGW_PC8  ID:0x356  10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                : 8 ; 
            unsigned int                                                : 8 ; 
            unsigned int                                                : 8 ; 
            unsigned int                                                : 4 ; 
            unsigned int         CF_Lvr_Wrn                             : 3 ; 
            unsigned int                                                : 1 ; 
            unsigned int         FCO                                    : 16 ; 
            unsigned int                                                : 8 ; 
            
        }bits;
        
    }msg;
}CGW_PC8_;












//CGW5  ID:0x7F
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
	    unsigned int C_StopLampLhOpenSts :  1 ;
	    unsigned int C_StopLampRhOpenSts :  1 ;
	    unsigned int                     : 1 ;
            unsigned int C_HLampLowLhOpenSts     : 1 ;
            unsigned int C_HLampLowRhOpenSts     : 1 ;
            unsigned int                     : 4 ;
	    unsigned int C_RearFOGLhOpenSts  : 1 ;
	    unsigned int                     : 7 ;
	    unsigned int C_RearTSIGLhOpenSts :  1 ;
	    unsigned int C_RearTSIGRhOpenSts :  1 ;
	    unsigned int C_FrontTSIGLhOpenSts :  1 ;
	    unsigned int C_FrontTSIGRhOpenSts :  1 ;
            unsigned int C_SBendingLhOpenSts     :  1 ;
	    unsigned int C_SBendingRhOpenSts     :  1 ;
	    unsigned int                  :  2 ;
	    //unsigned int C_HLampBifuncLhOpenSts :  1 ;
	    //unsigned int C_HLampBifuncRhOpenSts :  1 ;
            unsigned int                  :  2 ;
            unsigned int                  :  3 ;
	    unsigned int CF_Afs_LedHLStat :  2 ;
            //unsigned int                  :  2 ;
            unsigned int                  :  4 ;
            unsigned int CF_Gway_RrSeatRemindInfo : 2 ;
            unsigned int                  :  2 ;
            unsigned int                  :  3 ;
            unsigned int                  :  2 ;
            unsigned int                  :  2 ;
            unsigned int IGN_AutoOff_WarnSta_CLU  :  2 ;
            unsigned int                  :  15 ;
        }bits;
    }msg;
    
}CGW5_;


typedef union 
{
    uint8_t      m_aucData[8];
    struct {
        uint32_t CF_Evp_Stat            :  1 ;
        uint32_t                        :  31 ;
        uint32_t                        :  32 ;
    };
}EVP11_;

//CGW7  ID:0x7F
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t CF_Gway_SeatBeltWngBuz : 2;
            uint32_t CF_Gway_DrvSeatBeltInd : 2;
            uint32_t CF_Gway_AstSeatBeltInd : 2;
            uint32_t CF_Gway_RCSeatBeltInd : 2;
            uint32_t CF_Gway_RLSeatBeltInd : 2;
            uint32_t CF_Gway_RRSeatBeltInd : 2;
            uint32_t   : 12;
            uint32_t CF_Gway_WiperIntT_MFSW : 3;
            uint32_t CF_Gway_WiperSwState_MFSW : 2;
            uint32_t CF_Gway_MFSW_Info : 1;
            uint32_t CF_Gway_RrWiperSwState_MFSW : 2;
            uint32_t CF_Gway_LightSwState_MFSW : 2;
            uint32_t   : 30;
        }bits;
    }msg;
    
}CGW7_;






//PAS11  ID:0x436
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int CF_Gway_PASDisplayFLH  :  3 ;
            unsigned int CF_Gway_PASDisplayFRH  :  3 ;
            unsigned int CF_Gway_PASRsound      :  2 ;
            unsigned int CF_Gway_PASDisplayFCTR :  3 ;
            unsigned int CF_Gway_PASDisplayRCTR :  3 ;
            unsigned int CF_Gway_PASFsound      :  2 ;
            unsigned int CF_Gway_PASDisplayRLH  :  3 ;
            unsigned int CF_Gway_PASDisplayRRH  :  3 ;
            unsigned int CF_Gway_PASCheckSound  :  2 ;
            unsigned int CF_Gway_PASSystemOn    :  2 ;
            unsigned int CF_Gway_PASOption      :  2 ;
            unsigned int                        :  4 ;
        }bits;
    }msg;
    
}PAS11_;





//CLU15  ID:0x52a   200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_Clu_LanguageInfo             : 5 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 6 ;
            unsigned int  CF_Gway_RVMSw                   : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}CLU15_;



//CLU12  ID:0x5b0   1000
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned long   CF_Clu_Odometer               : 24 ;
            unsigned int    CR_Clu_OutTempSns             : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}CLU12_;

//CLU11  ID:0x4f1   20
typedef union 
{
    uint8_t      m_aucData[8];
    struct {
        uint32_t CF_Clu_CruiseSwState :  3 ;
        uint32_t CF_Clu_CruiseSwMain :  1 ;
        uint32_t CF_Clu_SldMainSW :  1 ;
        uint32_t CF_Clu_ParityBit1 :  1 ;
        uint32_t CF_Clu_VanzDecimal :  2 ;
        uint32_t CF_Clu_Vanz      :  9 ;
        uint32_t CF_Clu_SPEED_UNIT :  1 ;
        uint32_t                  :  1 ;
        uint32_t CF_Clu_RheostatLevel :  5 ;
        uint32_t                  :  1 ;
        uint32_t                  :  3 ;
        uint32_t CF_Clu_AliveCnt1 :  4 ;
    };
}CLU11_;

//CLU21  ID:0x391   20
typedef union 
{
    uint8_t      m_aucData[8];
    struct {
        uint32_t CF_Clu_PaddUpSwState :  1 ;
        uint32_t CF_Clu_PaddDownSwState :  1 ;
         uint32_t                  :  2 ;       
        uint32_t CF_Clu_LFASwState :  1 ;
          uint32_t                  :  2 ;          
        uint32_t CF_Clu_OKSwState :  1 ;
        
        uint32_t                  :  16 ; 
        uint32_t                  :  8 ;
        uint32_t CF_Clu_AutoBrightLevel :  8 ;     
        
        uint32_t       :  6 ;
        uint32_t CF_Clu_PwrAutoOffResetReq_EMS :  2 ;
        
        uint32_t CLU_AlvCnt21Val :  4 ;
        uint32_t                         :  4 ;     
        
        uint32_t CLU_Crc21Val    :8;
    };
}CLU21_;




//CLU_HU_PE_05  ID:0x1D4  20
typedef union 
{
    uint8_t      m_aucData[8];
    struct
    {
        uint32_t Clu_Usm_VoiceVolume :  3 ;
        uint32_t Clu_Usm_AutoinitFuelEconomy :  3 ;
        uint32_t Clu_Usm_WelcomeSound :  2 ;
        uint32_t CLU_Usm_Roadinfoguide :  2 ;
        uint32_t CLU_Usm_WiperLight :  2 ;
        uint32_t Clu_Usm_TransmissionDisp :  2 ;
        uint32_t Clu_Usm_FuelEconUnit_km :  2 ;
        uint32_t                  :  1 ;
        uint32_t Clu_Usm_AdasVolume :  3 ;
        uint32_t Clu_Usm_SubspeedometerDisp :  2 ;
        uint32_t Clu_Usm_FuelEconUnit_mi :  2 ;
        uint32_t                  :  2 ;
        uint32_t Warn_Sound_AdasVolumeFeedback :  3 ;
        uint32_t                  : 32 ;
        uint32_t                  :  3 ;
        
    } ;
}CLU_HU_PE_05_;


//CGW6  ID:0x50e     200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CF_Gway_BCMWarning              : 3 ;
            unsigned int  CF_Gway_ClutchIgnLockSW         : 1 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 7 ;
            unsigned int  CF_Gway_RrDefoggerInd           : 1 ; 
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 4 ;
            unsigned int                                  : 2 ;
            unsigned int    CF_ICU_SeaWarn_Lh             : 2 ;
            unsigned int   CF_ICU_SeaWarn_Rh              : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}CGW6_;

//CGW2  ID:0x553         200`   
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                                : 8 ;//0-7
            
            unsigned int  CF_Gway_ExtTailAct                          :2 ;   //8-9
            unsigned int                                                                 : 6 ; //10 11 12 13 14 15
            //unsigned int  Lamp_AutoLtSnsrNightSta                  : 1 ; //16
            unsigned int  CF_Gway_AutoLightValue                  : 1 ; //16
            unsigned int  CF_Gway_BrakeFluidSw                     : 1 ;  //17
            unsigned int  CF_Gway_ICUPowerAutoCutMode     : 2 ; //18
            unsigned int  CF_Gway_AvTail                                  : 1 ; //20
            unsigned int  CF_Gway_RearFogAct                         : 1 ; //22
            unsigned int                                                                  : 1 ; //23 
            unsigned int  CF_Gway_RRDrSw                              : 1 ; //24
            
            unsigned int  CF_Gway_RLDrSw                              : 1 ; //25
            unsigned int  CF_Gway_IntTailAct                            : 1 ; //26
            unsigned int                                                                  : 6 ; //32
            
            unsigned int                                                                  : 3 ; //35 
            unsigned int  CF_Gway_ESCLFailWarn                   : 1 ; //36
            unsigned int  CF_Gway_ESCLNotLockedWarn      : 1 ; //37    
            unsigned int  CF_Gway_ESCLNotUnlockWarn      : 1 ; //38    
            unsigned int  CF_Gway_IDoutWarn                         : 1 ; //39  
            unsigned int                                                                 : 1 ; //40 
            
            unsigned int  CF_Gway_ImmoLp                               : 1 ; //41
            unsigned int                                                                   : 3 ; //44  
            unsigned int  CF_Gway_VehicleNotPWarn               : 1 ; //45  
            unsigned int  CF_Gway_DeactivationWarn               : 1 ; //46 
            unsigned int  CF_Gway_KeyBATDischargeWarn    : 1 ; //47
            unsigned int  CF_Gway_SSBWarn                             : 1 ; //48  
            
            unsigned int                                                                   : 3 ; //51
            unsigned int  CF_Gway_SMKRKECmd                     : 3 ;//54
            unsigned int                                                                   : 1 ; //55  
            unsigned int  CF_Gway_SJBDeliveryMode               : 1 ; //56 
            
            unsigned int  CF_Gway_KeyoutLp                              : 1 ; //57
            unsigned int  CF_Gway_SMKDispWarn                     : 4 ; //61
            unsigned int  CF_Gway_WngBuz                                 : 3 ; //64
        }bits;
    }msg;
    
}CGW2_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int CF_Ahb_SLmp      : 2 ;
            unsigned int                  : 5 ;    
            unsigned int CF_Ahb_WLmp      : 1 ;
        }bits;
    }msg;
}AHB1_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;    
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 5 ;
            unsigned int GPF_LAMP_STAT             : 2 ;
            unsigned int CF_Ems_OPSFail            : 1 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 5 ;
            unsigned int CF_Hcu_HevRdyClu_new      : 2 ;
        }bits;
    }msg;
}HEV_PC11_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 1 ;
            unsigned int CF_Bms_ServiceLamp        : 1 ;
            unsigned int                           : 1 ;
            unsigned int CF_Ldc_AuxBatWrnLamp      : 1 ;
            unsigned int                           : 1 ;
            unsigned int CF_Ldc_Srvlamp_Rqst       : 1 ;
            unsigned int                           : 1 ;
            unsigned int CF_Tcu_ServiceLamp        : 1 ;
            unsigned int                           : 3 ;
            unsigned int                           : 8 ;
            unsigned int CF_Ems_MilReq             : 1 ;
        }bits;
    }msg;
}HEV_PC2_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 8 ;
            unsigned int CR_Fatc_OutTempSns_C      : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int CF_Ems_EHRSTemp           : 2 ;
            unsigned int                           : 8 ;
            unsigned int                           : 2 ;
            unsigned int CR_Hcu_HevMod             : 4 ;
            unsigned int  CF_Hcu_SerLamp           : 1 ;
        }bits;
    }msg;
}HEV_PC1_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 8 ;
            unsigned int CF_Brk_RBSWLamp           : 1 ;
            unsigned int                           : 1 ;
            unsigned int CF_Hcu_HevRdy             : 1 ;
            unsigned int                           : 5 ;
            unsigned int CR_Ems_EngSpd_rpm        : 16 ;
        }bits;
    }msg;
}HEV_PC4_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
         //   unsigned int                           : 1 ;
            unsigned int CR_Bms_DisplaySoc         : 8 ;
            unsigned int CF_Hcu_GreenZoneLamp      : 1 ; 
        }bits;
    }msg;
}HEV_PC9_;

typedef struct 
{
    
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int CF_Tcu_GarSelDisp         : 4 ; 
        }bits;
    }msg;
}HEV_PC5_;

//CGW1  ID:0x541    100
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CF_Gway_IGNSw                   : 3 ;
            unsigned int  CF_Gway_RKECmd                  : 3 ;
            unsigned int  CF_Gway_DrvKeyLockSw            : 1 ;
            unsigned int  CF_Gway_DrvKeyUnlockSw          : 1 ;
            
            
            unsigned int  CF_Gway_DrvDrSw                 : 2 ;
            unsigned int  CF_Gway_DrvSeatBeltSw           : 2 ;
            unsigned int  CF_Gway_TrunkTgSw               : 2 ;
            unsigned int  CF_Gway_AstSeatBeltSw           : 2 ;
            
            
            
            unsigned int  CF_Gway_SMKOption               : 1 ;
            unsigned int  CF_Gway_HoodSw                  : 2 ;
            unsigned int  CF_Gway_TurnSigLh               : 2 ;
            unsigned int  CF_Gway_WiperIntT               : 3 ;
            
            unsigned int  CF_Gway_WiperIntSw              : 1 ;
            unsigned int  CF_Gway_WiperLowSw              : 1 ;
            unsigned int  CF_Gway_WiperHighSw             : 1 ;
            unsigned int  CF_Gway_WiperAutoSw             : 1 ;
            unsigned int  CF_Gway_RainSnsState            : 3 ;
            unsigned int  CF_Gway_HeadLampLow             : 1 ;
            
            unsigned int  CF_Gway_HeadLampHigh            : 1 ;
            unsigned int  CF_Gway_HazardSw                : 2 ;
            unsigned int  CF_Gway_AstDrSw                 : 1 ;
            unsigned int  CF_Gway_DefoggerRly             : 1 ;
            unsigned int  CF_Gway_ALightStat              : 1 ;
            unsigned int  CF_Gway_LightSwState            : 2 ;
            
            unsigned int  CF_Gway_Frt_Fog_Act             : 1 ;
            unsigned int  CF_Gway_TSigRHSw                : 1 ;
            unsigned int  CF_Gway_TSigLHSw                : 1 ;
            unsigned int  CF_Gway_DriveTypeOption         : 1 ;
            unsigned int  CF_Gway_StarterRlyState         : 1 ;
            unsigned int  CF_Gway_PassiveAccessLock       : 2 ;
            unsigned int                                  : 1 ;
            
            unsigned int  CF_Gway_PassiveAccessUnlock     : 2 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_Gway_PassingSW               : 1 ;
            unsigned int  CF_Gway_HBAControlMode          : 1 ;
            unsigned int  CF_Gway_HLpHighSw               : 1 ;
            unsigned int  CF_Gway_InhibitRMT              : 2 ;
            
            
            unsigned int  CF_Gway_RainSnsOption           : 1 ;
            unsigned int  C_SunRoofOpenState              : 1 ;
            unsigned int                                  : 2 ;
            unsigned int  CF_Gway_ParkBrakeSw             : 2 ;
            unsigned int  CF_Gway_TurnSigRh               : 2 ;
            
            
            
        }bits;
    }msg;
    
}CGW1_;  

typedef struct
{   
  
  union
  {   
    unsigned        data[8];
    struct
    {   
      unsigned int SCR_LEVEL_WARN_LAMP         : 1 ;
      unsigned int                             : 7 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;
      unsigned int                             : 8 ;

    }bits;
  }msg;
  
}EMS21_; 





//0x424
typedef union 
{
    unsigned char      m_aucData[8];
    
    struct {
        unsigned int                        :   6   ;
        unsigned int  C_BLEOption           :    2   ;
        
        
        
        unsigned int                        :   8   ;
        unsigned int                        :    6  ;
        
        
        unsigned int C_BLEIDOut             :    2   ;
        unsigned int                        :   7  ;
        
        
        
        
        unsigned int        C_BLEKeyreminder        :   3   ;
        unsigned int                        :    6  ;
        unsigned int                        :   16   ;
        unsigned int                        :    8  ;
        
    };
}HU_BLE_PE_00_;

//EV_PC9  ID 50B
typedef struct 
{
    
    union 
    {
        unsigned char      data[8];
        struct 
        {
            unsigned int                                                         : 8; 
            unsigned int                                                         : 8;   
            unsigned int CR_Bms_DisplaySoc                   : 8 ;
            unsigned int CF_Vcu_ResvAirCtrInfo              : 1 ;
            unsigned int CF_Datc_ServiceLamp                 : 1 ;
            unsigned int CF_Bms_PShiftForCharging        : 1 ;
            unsigned int                                                          : 1 ;          
            unsigned int CF_OBC_AC_CONNECT_FLAG          : 1 ;
            unsigned int                                 : 2 ;
            unsigned int CF_OBC_SERVICE_LAMP_Req         : 1 ;//
            unsigned int                                                          : 8;
            unsigned int                                                          : 8;
            unsigned int                                                          : 5;   
            unsigned int CF_Vuc_ProgCharWaitForCharInd   : 1 ;
            unsigned int DATC_TempUnit                            : 2 ;
            unsigned int CF_Bms_FstEvseFltAlram            : 1 ;
            unsigned int CF_Vcu_ResvInfo                          : 1 ;
            unsigned int                                                          : 2 ; 
            unsigned int CF_Vcu_WarnMsg                        : 4 ;
        }bits;
    }msg;
}EV_PC9_;

typedef struct
{   
    union
    {  
        uint8_t data[8];
        struct
        {   
            
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits;
    }msg;
}Send_7DF;  

typedef struct
{ 
    union
    {  
        uint8_t data[1];
        struct
        {   
            
            unsigned int   Byte0Data        : 8 ;
        }bits;
    }msg;
}Send_7DF_ectype;  

typedef struct
{   
    union
    {  
        uint8_t data[8];
        struct
        {   
            
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;       
            unsigned int                  : 8 ;
            unsigned int     LVR12_STS    : 2 ;
            unsigned int                  : 6 ;
        }bits;
    }msg;
}P_STS_;  

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_7C6; 


typedef struct
{       uint32_t ID; 
uint8_t DataLen;
uint8_t data[8];
struct
{   
    unsigned int   Byte0Data        : 8 ;
    unsigned int   Byte1Data        : 8 ;
    unsigned int   Byte2Data        : 8 ;
    unsigned int   Byte3Data        : 8 ;
    unsigned int   Byte4Data        : 8 ;
    unsigned int   Byte5Data        : 8 ;       
    unsigned int   Byte6Data        : 8 ;
    unsigned int   Byte7Data        : 8 ;
}; 
}Receive_7CE; 

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_null;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_111_;




typedef union 
{
    unsigned char      mdata[8];
    struct {
        unsigned int Byte0Data     :   8 ;
        unsigned int Byte1Data     :   8 ;
        unsigned int Byte2Data     :   8 ;
        unsigned int Byte3Data     :   8 ;
        unsigned int Byte4Data     :   8 ;
        unsigned int Byte5Data     :   8 ;
        unsigned int Byte6Data     :   8 ;
        unsigned int Byte7Data     :   8 ;
    };
}Send_Data;

typedef union 
{
    uint8_t      m_aucData[8];
    struct {
    uint32_t                       : 9 ;
    uint32_t CF_IMT_EOL_state      : 1 ;
    uint32_t CF_IMT_DispCMD        : 2 ;
    uint32_t G_SEL_DISP_eClutch              : 4 ;
    uint32_t SCU_N_MODE     : 2 ;
    uint32_t                : 2 ;
    uint32_t SCU_POS_ACT   : 4 ;
    uint32_t                : 8 ;
    uint32_t                : 3 ;  //35
    uint32_t                : 7 ;
    uint32_t TCU_TYPE_eCLUTCH               : 2 ; //42
    uint32_t                  : 8 ;   //TCU_TYPE_eCLUTCH
    uint32_t                  : 8 ; 
    uint32_t                  : 6 ; 
    };
}CGW_PC11_;



typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t   : 16;
            uint32_t CR_Fatc_OutTempSns : 8;
            uint32_t   : 4;
            uint32_t ENG_SldSwSta : 2;
            uint32_t   : 2;
            uint32_t   : 32;
        }bits;
    }msg;
}CGW_PC1_;

//CGW_PC3  0X572 200MS
typedef union 
{
    uint8_t      m_aucData[8];
    struct {
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint8_t                       : 8;
        uint32_t  HILL_HOLD_WARNING    : 1 ;
        uint32_t  Clutch_Burst_Warning : 1 ;
        uint32_t  Vehicle_Stop_Time    : 5 ;
        uint32_t                : 1 ;
        
    };
}CGW_PC3_;

typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int BS2_SOC                              : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}CGW_IBS2_;


//HU_GW_PE_01  0x173 200ms
//typedef union 
//{
//    uint8_t      m_aucData[8];
//    struct {
//        uint8_t     HU_AliveStatus       : 2;
//    uint8_t                       : 4;
//    uint8_t    HU_DistanceUnit    : 2;
//    
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    
//    uint8_t                      : 4 ;
//    uint8_t  CF_AVN_ProfileIDRValue : 4 ;
//    uint8_t                      : 8 ;
//    uint8_t                      : 8 ;
//    };
//}HU_GW_PE_01_;


// 4WD11  ID:0x428   20
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t      : 8;
            
            uint32_t _4WD_ERR : 8;
            
            uint32_t     : 16;
            uint32_t      : 8;
            uint32_t      : 4;
            uint32_t LOCK_ACT: 1;
            uint32_t TIRE_SIZE_DIFF: 3;

            uint32_t      : 16;         
        }bits;
    }msg;
}_4WD11_;

typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t ECU_Engine_Speed_L : 8;
            uint32_t ECU_Engine_Speed_H : 8;
            uint32_t ECU_Vehicle_Speed  : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t ECU_Engine_Temperature                   : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;           
        }bits;
    }msg;
}_ECU_101;


typedef union 
{
    union 
    {
	unsigned           date[8];
  
	struct {
           uint32_t ECU_Engine_Speed_H : 8;   
           uint32_t ECU_Engine_Speed_L : 8;      
           uint32_t ECU_Vehicle_Speed : 8;   
           uint32_t  : 1;
           uint32_t  : 1;
           uint32_t  : 6;
           uint32_t ECU_Engine_Temperature_H : 8; 
           uint32_t ECU_Engine_Temperature_L : 8;     
           uint32_t  : 8;
           uint32_t  : 8;
           }bits;
         
	  //  unsigned int      :    6   ;
	  //  unsigned int      :    2   ;
	  //  unsigned int      :    8   ;
	  //  unsigned int         :   16   ;
	}msg;
}_ABS1;

typedef union 
{
    union 
    {
	unsigned           date[8];
  
	struct {
           uint32_t  : 8;  
           uint32_t  : 8;       
           uint32_t  : 8;   
           uint32_t  : 2;
           uint32_t  TCS_Warning: 1;
           uint32_t  : 5;
           uint32_t  : 8;      
           uint32_t  : 8;
           uint32_t  : 8;
           uint32_t  : 8;
           }bits;
         
	  //  unsigned int      :    6   ;
	  //  unsigned int      :    2   ;
	  //  unsigned int      :    8   ;
	  //  unsigned int         :   16   ;
	}msg;
}_TCS_37B;

typedef union 
{
    union 
    {
	unsigned           date[8];
  
	struct {
           uint32_t  : 8;  
           uint32_t  : 8;       
           uint32_t  : 8;   
           uint32_t  : 8;
           uint32_t  : 1;
           uint32_t ISG_Ready : 1;
           uint32_t ISG_Power : 1;
           uint32_t  : 1;
           uint32_t ISG_Power_Enable : 2;      
           uint32_t  : 2;
           uint32_t  : 8;
           uint32_t  : 8;
           uint32_t  : 8;
           }bits;
         
	  //  unsigned int      :    6   ;
	  //  unsigned int      :    2   ;
	  //  unsigned int      :    8   ;
	  //  unsigned int         :   16   ;
	}msg;
}_ISG_111;

typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 7;           
            uint32_t  ECU_Warning_Lamp  : 1;
        }bits;
    }msg;
}_ECU_402;

typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t ECU_Battery_Voltage: 1;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;
            uint32_t                    : 8;           
        }bits;
    }msg;
}_ECU_401;
EXTERN_VAR     volatile _ECU_101                           ECU_101;
EXTERN_VAR     volatile _ECU_402                           ECU_402;
EXTERN_VAR     volatile _ECU_401                           ECU_401;
EXTERN_VAR     volatile _ABS1                              ABS1;
EXTERN_VAR     volatile _TCS_37B                           TCS_37B;
EXTERN_VAR     volatile _ISG_111                           ISG_111;

EXTERN_VAR     volatile _4WD11_                           CAN_4WD11_;
EXTERN_VAR     volatile RCS1_                             RCS1;
EXTERN_VAR     volatile VCU_4_ICMDisp_                    VCU_4_ICMDisp;
EXTERN_VAR     volatile AVAS_SwitchFb_                    AVAS_SwitchFb;            
EXTERN_VAR     volatile BCM_1_Door_Light_                 BCM_1_Door_Light;
EXTERN_VAR     volatile VCU_RegenerationLevelSts_         VCU_RegenerationLevelSts;
EXTERN_VAR     volatile BMS_6_                            BMS_6;
EXTERN_VAR     volatile MCU_MotorTempWarning_             MCU_MotorTempWarning;
EXTERN_VAR     volatile TPMS_TirePressureSystemFailSts_   TPMS_TirePressureSystemFailSts;
// EXTERN_VAR     volatile EPS_EPSFailSts_                   EPS_EPSFailSts;
EXTERN_VAR     volatile EPS_SteeringAngleCalibrationSts_  EPS_SteeringAngleCalibrationSts;
EXTERN_VAR     volatile IMMO_AuthFailWarn_                IMMO_AuthFailWarn;
EXTERN_VAR     volatile VCU_3_GearBrakePostion_           VCU_3_GearBrakePostion;
EXTERN_VAR     volatile ABM_AirBagFailSts_                ABM_AirBagFailSts;
EXTERN_VAR     volatile ESP_ABS_FailSts_                  ESP_ABS_FailSts;
EXTERN_VAR     volatile OBC_CC_ConnectSts_                OBC_CC_ConnectSts;
EXTERN_VAR     volatile PEPS_1_    PEPS_1;
EXTERN_VAR     volatile VCU_PercentgPwrUsage_             VCU_PercentgPwrUsage;
EXTERN_VAR     volatile BMS_HVBatSOC_   BMS_HVBatSOC;
EXTERN_VAR     volatile BMS_ChargeStatus_  BMS_ChargeStatus;
EXTERN_VAR     volatile AC_ExternalTemperature_C_         AC_ExternalTemperature_C;
EXTERN_VAR     volatile ICM_DisplayVehicleSpeed_         ICM_DisplayVehicleSpeed;
EXTERN_VAR     volatile ICM_AirBagLampFailSts_Reserved_         ICM_AirBagLampFailSts_Reserved;

EXTERN_VAR     volatile CGW_PC1_             CGW_PC1;
EXTERN_VAR     volatile CGW_PC11_            CGW_PC11;
EXTERN_VAR     volatile SMKmsg20_            SMKmsg20;
EXTERN_VAR     volatile SMKmsg19_            SMKmsg19;
EXTERN_VAR     volatile SMKmsg18_            SMKmsg18;
EXTERN_VAR     volatile SMKmsg17_            SMKmsg17;
EXTERN_VAR     volatile SMKmsg01_            SMKmsg01;
EXTERN_VAR     volatile BCMmsgDvp1_          BCMmsgDvp1;
EXTERN_VAR     volatile BCMmsg24_            BCMmsg24;
EXTERN_VAR     volatile BCMmsg22_            BCMmsg22;
EXTERN_VAR     volatile BCMmsg21_            BCMmsg21;
EXTERN_VAR     volatile BCMmsg20_            BCMmsg20;
EXTERN_VAR     volatile BCMmsg19_            BCMmsg19;
EXTERN_VAR     volatile BCMmsg18_            BCMmsg18;
EXTERN_VAR     volatile BCMmsg17_            BCMmsg17;
EXTERN_VAR     volatile BCMmsg01_            BCMmsg01;
EXTERN_VAR     volatile BCMGst_              BCMGst;
EXTERN_VAR     volatile FCA12_               FCA12;
EXTERN_VAR     volatile TPMS11_              TPMS11;
EXTERN_VAR     volatile TCU14_               TCU14;
EXTERN_VAR     volatile TCU13_               TCU13;
EXTERN_VAR     volatile TCU11_               TCU11;
EXTERN_VAR     volatile SAS11_               SAS11;
EXTERN_VAR     volatile MDPS11_              MDPS11;
EXTERN_VAR     volatile LKA13_               LKA13;
EXTERN_VAR     volatile LKA12_               LKA12;
EXTERN_VAR     volatile LKA11_               LKA11;
EXTERN_VAR     volatile FCA11_               FCA11;
EXTERN_VAR     volatile FCA11_FS_            FCA11_FS;
EXTERN_VAR     volatile TCS15_               TCS15;
EXTERN_VAR     volatile TCS11_               TCS11;
EXTERN_VAR     volatile ESP12_               ESP12;
EXTERN_VAR     volatile EMS_H12_             EMS_H12;
EXTERN_VAR     volatile EMS20_               EMS20;
EXTERN_VAR     volatile EMS19_               EMS19;
EXTERN_VAR     volatile CGW_PC2_             CGW_PC2;             
EXTERN_VAR     volatile CGW4_                CGW4;        
EXTERN_VAR     volatile EMS16_               EMS16;
EXTERN_VAR     volatile EMS14_               EMS14;
EXTERN_VAR     volatile EMS_CNG11_           EMS_CNG11;
EXTERN_VAR     volatile EMS12_               EMS12;
EXTERN_VAR     volatile EMS11_               EMS11;
EXTERN_VAR     volatile DATC13_              DATC13;
EXTERN_VAR     volatile DATC11_              DATC11;
EXTERN_VAR     volatile ACU14_               ACU14;
EXTERN_VAR     volatile CGW_PC12_            CGW_PC12;
EXTERN_VAR     volatile CGW_PC14_            CGW_PC14;
EXTERN_VAR     volatile can002_              can002;
EXTERN_VAR     volatile WHL_SPD11_           WHL_SPD11;
EXTERN_VAR     volatile ABS11_               ABS11;
EXTERN_VAR     volatile SCC11_               SCC11;
EXTERN_VAR     volatile SCC12_               SCC12;
EXTERN_VAR     volatile SCC14_               SCC14;
EXTERN_VAR     volatile HDA11_               HDA11;
EXTERN_VAR     volatile CLU19_               CLU19;
EXTERN_VAR     volatile CLU16_               CLU16;
EXTERN_VAR     volatile CGW_PC4_             CGW_PC4;           
EXTERN_VAR     volatile EPB11_               EPB11;                
EXTERN_VAR     volatile TCUA3_               CGW_USM1;
EXTERN_VAR     volatile CLU15_               CLU15;
EXTERN_VAR     volatile CLU12_               CLU12;
EXTERN_VAR     volatile CLU11_               CLU11;
EXTERN_VAR     volatile CLU21_               CLU21;
EXTERN_VAR     volatile CGW6_                CGW6;
EXTERN_VAR     volatile CGW2_                CGW2;
EXTERN_VAR     volatile HEV_PC11_            HEV_PC11;
EXTERN_VAR     volatile HEV_PC1_            HEV_PC1;
EXTERN_VAR     volatile HEV_PC2_             HEV_PC2;
EXTERN_VAR     volatile HEV_PC4_             HEV_PC4;
EXTERN_VAR     volatile HEV_PC9_             HEV_PC9;
EXTERN_VAR     volatile HEV_PC5_             HEV_PC5;
EXTERN_VAR     volatile CGW1_                CGW1; 
EXTERN_VAR     volatile CGW_PC5_             CGW_PC5;           
EXTERN_VAR     volatile CGW_PC6_             CGW_PC6;  
EXTERN_VAR     volatile PAS11_               PAS11;  
EXTERN_VAR     volatile CGW5_                CGW5; 
EXTERN_VAR     volatile CGW7_                CGW7; 
EXTERN_VAR     volatile EVP11_               EVP11; 
EXTERN_VAR     volatile PDW11_               PDW11;
EXTERN_VAR     volatile EMS21_               EMS21;
EXTERN_VAR     volatile MCU_MotorSpd_         MCU_MotorSpd;



EXTERN_VAR     volatile HU_BLE_PE_00_        HU_BLE_PE_00;
EXTERN_VAR     volatile EMS_H11_             EMS_H11;
EXTERN_VAR     volatile AHB1_                AHB1;
EXTERN_VAR     volatile HU_CLU_PE_05_        HU_CLU_PE_05;

EXTERN_VAR     volatile HU_MON_PE_01_        HU_MON_PE_01;
EXTERN_VAR     volatile HU_USM_E_05_         HU_USM_E_05;
EXTERN_VAR     volatile HU_USM_E_10_         HU_USM_E_10;
EXTERN_VAR     volatile HU_USM_E_04_	     HU_USM_E_04;
EXTERN_VAR     volatile HU_CLU_PE_06_        HU_CLU_PE_06;
EXTERN_VAR     volatile ECALL_CLU_PE_01_     ECALL_CLU_PE_01;
EXTERN_VAR     volatile HU_USM_E_01_         HU_USM_E_01;
EXTERN_VAR     volatile BCW11_                   BCW11;
EXTERN_VAR     volatile RR_C_RDR_01_1_50ms_    RR_C_RDR_01_1_50ms;
EXTERN_VAR     volatile RR_C_RDR_01_2_50ms_    RR_C_RDR_01_2_50ms;
EXTERN_VAR     volatile RR_C_RDR_02_2_50ms_    RR_C_RDR_02_2_50ms;

EXTERN_VAR     volatile ADAS_CMD_10_1_20ms_    ADAS_CMD_10_1_20ms;
EXTERN_VAR     volatile ADAS_CMD_10_2_200ms_   ADAS_CMD_10_2_200ms;
EXTERN_VAR     volatile ADAS_CMD_30_1_10ms_    ADAS_CMD_30_1_10ms;
EXTERN_VAR     volatile ADAS_CMD_30_2_20ms_    ADAS_CMD_30_2_20ms;
EXTERN_VAR     volatile ADAS_CMD_31_1_50ms_    ADAS_CMD_31_1_50ms;
EXTERN_VAR     volatile FR_CMR_01_1_20ms_    FR_CMR_01_1_20ms;
EXTERN_VAR     volatile FR_CMR_02_1_100ms_   FR_CMR_02_1_100ms;

EXTERN_VAR     volatile CGW_PC8_                 CGW_PC8;
EXTERN_VAR     volatile CGW_PC3_                 CGW_PC3;
EXTERN_VAR     volatile  HU_GW_PE_01_          HU_GW_PE_01;
EXTERN_VAR     volatile  BCA11_                BCA11;
EXTERN_VAR     volatile  P_STS_                P_STS;
EXTERN_VAR     volatile CGW_IBS2_            CGW_IBS2;
EXTERN_VAR     volatile CLU_01_20ms_         CLU_01_20ms;




EXTERN_VAR     volatile Send_7DF             Send_7DF_Data ;//LHY  
EXTERN_VAR     volatile Send_7DF_ectype      Send_7DF_ectype_Data ;//LHY  
EXTERN_VAR     volatile Send_7C6             Send_7C6_Data ;//LHY 
EXTERN_VAR     volatile Receive_7CE          Receive_7CE_Data ;//LHY

EXTERN_VAR     volatile Send_null             Send_420 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_490 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_381 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_507 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_593 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_340 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_500 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_1A5 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_586 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_368 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_38A ;//LHY 
EXTERN_VAR     volatile Send_null             Send_428 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_12A ;//LHY  
EXTERN_VAR     volatile Send_111_             Send_111 ;//LHY 

EXTERN_VAR     volatile WPCmsg03_            WPCmsg03;
EXTERN_VAR     volatile Send_Data            Send_7CE_Data;
EXTERN_VAR     volatile CLU_HU_PE_01_		CLU_HU_PE_01;
EXTERN_VAR     volatile CLU_HU_PE_05_		CLU_HU_PE_05;
EXTERN_VAR     volatile HU_CLU_PE_02_		HU_CLU_PE_02;
 
EXTERN_VAR  void SendCan0Message_EOL(void);


EXTERN_VAR  void Can_Clear(uint8_t *data, uint8_t DataLen);

#pragma pack()
#endif

#endif /* API_CAN_H_ */
