/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file start.h
 **
 ** \brief Device dependent, tool-chain independent C header for device initialization
 **
 ** This file allows to configure device settings and declares functions that
 ** are called from the startup script. All items marked by "<<<" can be
 ** configured to influence the device initialization.
 **
 ** \note Function Start_PreInit() will be called prior to global variable
 ** initialization.
 **
 ** History:
 **   - 2015-09-01  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __START_H__
#define __START_H__

// File version YYXX = vYY.XX
#define START_H_VERSION          0x0001

#ifndef __FILE_VERSION_CHECK__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"

/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/
/** System RAM start address */
#define SYSRAM_START_ADDRESS        MCU_SYSRAM_BASE_ADDRESS
/** System RAM size in byte */
#define SYSRAM_SIZE_BYTE            MCU_SYSRAM_SIZE_BYTE

/** Retention RAM start address */
#define BURAM_START_ADDRESS         MCU_BURAM_BASE_ADDRESS
/** Retention RAM size in byte */
#define BURAM_SIZE_BYTE             MCU_BURAM_SIZE_BYTE

/** Video RAM start address */
#define VRAM_START_ADDRESS          MCU_VRAM_BASE_ADDRESS
/** Retention RAM size in byte */
#define VRAM_SIZE_BYTE              MCU_VRAM_SIZE_BYTE

/** TCMRAM start address (TCMRAM AXI slave interface - no DMA access via TCM port)
 ** The start stack (located at the beginning of TCM RAM) must be excluded. It is
 ** defined and ECC initialized in the start assembly file. */
#define TCMRAM_AXI_START_ADDRESS    MCU_TCMRAM_ADDRESS_TCM2AXI(0)
/** TCMRAM size in byte */
#define TCMRAM_SIZE_BYTE            MCU_TCMRAM_SIZE_BYTE


/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/
typedef struct stc_clear_ecc_memories
{
    uint32_t    u32TcmRamStartAddress;  ///< TCMRAM memory to ECC clean : Begin
    uint32_t    u32TcmRamSizeByte;      ///< TCMRAM memory to ECC clean : Size in bytes
    uint32_t    u32SysRamStartAddress;  ///< SYSRAM memory to ECC clean : Begin
    uint32_t    u32SysRamSizeByte;      ///< SYSRAM memory to ECC clean : Size in bytes
    uint32_t    u32BuRamStartAddress;   ///< BURAM  memory to ECC clean : Begin
    uint32_t    u32BuRamSizeByte;       ///< BURAM  memory to ECC clean : Size in bytes
    uint32_t    u32EthRamStartAddress;  ///< ETHRAM memory to ECC clean : Begin
    uint32_t    u32EthRamSizeByte;      ///< ETHRAM memory to ECC clean : Size in bytes
}   stc_clear_ecc_memories_t;

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/
extern const stc_clear_ecc_memories_t    Start_stcClearEccMemories;

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/

extern void Start_PreInit(void);
extern void Start_Init(void);
extern uint32_t TestBackupRam;

#endif /* __FILE_VERSION_CHECK__ */
#endif /* __START_H__ */

