

#ifndef _NM_PROTOCOL_H_
    #define _NM_PROTOCOL_H_

    #define NM_LOCK                     0
    #define NM_UNLOCK                   1

    #define ALIVE_MSG                   0x01

    #define RING_MSG                    0x02

    #define LIMP_HOME_MSG               0x04


    #define NMBusSleep                  253
    #define NMAwake                     254

    #define BusInit                     1
    #define BusSleep                    0

    #define NM_YES                      1
    #define NM_NO                       0

    #define NM_Stabilize                1
    #define NM_Unstabitily              0
      
    #define NM_IGN_ON                   1
    #define NM_IGN_OFF                  0

    #define NM_Passive                  0
    #define NM_Active                   1

    #define NM_NODE_SKIP                1
    #define NM_NODE_NOT_SKIP            0

    #define NM_LocalWakeup              1
    #define NM_RemoteWakeup             2
    #define NM_WaitWakeup               0

    #define SilentNM()     NetWorkStatus.NMactive = NM_Passive
    #define TalkNM()       NetWorkStatus.NMactive = NM_Active

    #define SilentAPP()    NetWorkStatus.APPactive = NM_Passive
    #define TalkAPP()      NetWorkStatus.APPactive = NM_Active

    extern  volatile    uint8_t         NM_IGN_State;
    extern  volatile    uint8_t         NM_TX_STATE;
    extern  volatile    uint8_t         NM_ER_STATE;
    extern  volatile    uint16_t        NM_CAN_CHL_ID; //NM_CAN_ID_BASE + OWN_NODE_CHL0              
    extern  volatile    uint16_t        NM_LAST_ID;
    extern  volatile    uint8_t         NM_LimpHomeTxCnt;
    extern  volatile    uint16_t        NM_tSleepRequestMin;
    
    extern  volatile    uint8_t         NM_Task_Lock;
    extern  volatile    _NM_TimeInfo    NM_Time;
    
    extern  volatile    uint8_t           NM_LastSend_PDU_Type; //Last PDU Type
    extern  volatile    uint8_t           NM_Destination;
    extern  volatile    uint16_t          NM_ID_BUF;
    
    extern  volatile    _NMPDU            NM_SPDU;              //send PDU buf
    extern  volatile    _NMPDU            NM_PDU_BUF;
    extern  volatile    _NetWorkStatus    NetWorkStatus;

	//function
    extern   void        OsekNM_Manage_Main(uint16_t BatVolt);
    
    extern   void        StartNM(void);
    
    extern   void        NMLimpHome_main(void);
    extern   void        NMBusSleep_main(void);

    extern   void        (* NM_Main_Program)(void);
    extern   void        NM_State_Transformation(void (* pProgram)(void));
    
    extern   void        CancelAlarm(uint16_t timetype); //Cansel Ttyp /Tmax /Terror count
    extern   void        NM_SetTSendTimer(uint16_t Second,_NM_TimeInfo *T);
    extern   uint8_t     NM_TSendTimerOver(_NM_TimeInfo *T);
    
#endif
