
#ifndef RTC_H__
#define RTC_H__
/*-----------------use for RH850_F1KM_S1 --------------------*/
#include "r_typedefs.h"
//#include "dr7f701684.dvf.h"

#define RTC_MODE_MAIN 0U
#define RTC_MODE_SUB 1U

#define RTC_MODE_SELECT RTC_MODE_MAIN

/* RTC default time setting */
#ifndef RTC_DEFAULT_TIME
#define RTC_DEFAULT_TIME 1U
#define RTC_DEFAULT_YEAR 20U
#define RTC_DEFAULT_MONTH 1U
#define RTC_DEFAULT_DATE 1U
#define RTC_DEFAULT_WEEK 3U /*must be right*/
#define RTC_DEFAULT_HOUR 0U
#define RTC_DEFAULT_MINUTE 0U
#define RTC_DEFAULT_SECOND 0U
#endif
/*only use for alarm */
typedef enum
{
	RTC_ALARM_SUN = 0X01U,	/*Sunday*/
	RTC_ALARM_SAT = 0X02U,	/*Saturday*/
	RTC_ALARM_FRI = 0X04U,	/*Friday*/
	RTC_ALARM_THUR = 0X08U, /*Thursday*/
	RTC_ALARM_WED = 0X10U,	/*Wednesday*/
	RTC_ALARM_TUE = 0X20U,	/*Tuesday*/
	RTC_ALARM_MON = 0X40U,	/*Monday*/
	RTC_ALARM_DAYS = 0X7FU, /*everyday*/

} RTC_Alarm_Days_en_t;

typedef struct
{
	uint8_t u8RTCYear;		 /*00~~99 in Dec*/
	uint8_t u8RTCMonth;		 /*01~~12 in Dec*/
	uint8_t u8RTCDayOfMonth; /*01~~31 in Dec*/
	uint8_t u8RTCDayOfWeek;	 /*0~~6 in Dec*/
	uint8_t u8RTCHour;		 /*fix 24Hour Format 00~~23 in  Dec*/
	uint8_t u8RTCMinute;	 /*0~~59 in Dec*/
	uint8_t u8RTCSecond;	 /*0~~59 in Dec*/
} RTC_Information_st_t;

extern volatile uint8_t g_RTCLeapYear; /*1:LeapYear , 0:Not a leap year*/
extern volatile RTC_Information_st_t g_stRTCInformation;

/* RTC exported time register */
#define RTC_YEAR g_stRTCInformation.u8RTCYear
#define RTC_MONTH g_stRTCInformation.u8RTCMonth
#define RTC_DATE g_stRTCInformation.u8RTCDayOfMonth
#define RTC_WEEK g_stRTCInformation.u8RTCDayOfWeek
#define RTC_HOUR g_stRTCInformation.u8RTCHour
#define RTC_MINUTE g_stRTCInformation.u8RTCMinute
#define RTC_SECOND g_stRTCInformation.u8RTCSecond
#define RTC_LEAP_YEAR g_RTCLeapYear

extern void RTC_Pre_Init(void);
extern void RTC_Init(void);
extern void RTC_Set_Time(RTC_Information_st_t *pstRTCTime);
extern void RTC_Timing_Service(void);
extern void RTC_Alarm_Set(RTC_Alarm_Days_en_t enAlarmDays, uint8_t u8RTCHour, uint8_t u8RTCMinute);

#endif
