
#include "dr7f701684.dvf.h"

/*-----------------use for RH850_F1KM_S1 --------------------*/
#include "rh850_macros.h"
#include "TimerB.h"

/*---------------PWM Start--------------------------------------------*/
#define TIMERB_CHANNEL_INTERVAL 1U
#define TIMERB_CHANNEL_BIT_MUL 3U
#define TIMERB_BASE_ADDRESSES 0xFFE30000U
#define TIMERB_TIMEROUT_MAX 50U

/*----target clock----------*/
#define TIMERB_0_CK0 5000000UL
#define TIMERB_0_CK1 5000000UL
#define TIMERB_0_CK2 5000000UL
#define TIMERB_0_CK3 5000000UL

/*-----default clock---------*/
#define TIMERB_PPLLCLK2 40000000UL
#define TIMERB_CKSCLK_IPERI2 TIMERB_PPLLCLK2

/*-----------------------------------------------------*/
#define TIMERB_0_CK0_DIV (TIMERB_CKSCLK_IPERI2 / TIMERB_0_CK0)
#define TIMERB_0_CK1_DIV (TIMERB_CKSCLK_IPERI2 / TIMERB_0_CK1)
#define TIMERB_0_CK2_DIV (TIMERB_CKSCLK_IPERI2 / TIMERB_0_CK2)
#define TIMERB_0_CK3_DIV (TIMERB_CKSCLK_IPERI2 / TIMERB_0_CK3)

/*-------------------------------------------*/

#if (TIMERB_0_CK0_DIV == 1U)
#define TIMERB_0_CK0_DIV_COE 0U
#elif (TIMERB_0_CK0_DIV == 2U)
#define TIMERB_0_CK0_DIV_COE 1U
#elif (TIMERB_0_CK0_DIV == 4U)
#define TIMERB_0_CK0_DIV_COE 2U
#elif (TIMERB_0_CK0_DIV == 8U)
#define TIMERB_0_CK0_DIV_COE 3U
#elif (TIMERB_0_CK0_DIV == 16U)
#define TIMERB_0_CK0_DIV_COE 4U
#elif (TIMERB_0_CK0_DIV == 32U)
#define TIMERB_0_CK0_DIV_COE 5U
#elif (TIMERB_0_CK0_DIV == 64U)
#define TIMERB_0_CK0_DIV_COE 6U
#elif (TIMERB_0_CK0_DIV == 128U)
#define TIMERB_0_CK0_DIV_COE 7U
#elif (TIMERB_0_CK0_DIV == 256U)
#define TIMERB_0_CK0_DIV_COE 8U
#elif (TIMERB_0_CK0_DIV == 512U)
#define TIMERB_0_CK0_DIV_COE 9U
#elif (TIMERB_0_CK0_DIV == 1024U)
#define TIMERB_0_CK0_DIV_COE 10U
#elif (TIMERB_0_CK0_DIV == 2048U)
#define TIMERB_0_CK0_DIV_COE 11U
#elif (TIMERB_0_CK0_DIV == 4096U)
#define TIMERB_0_CK0_DIV_COE 12U
#elif (TIMERB_0_CK0_DIV == 8192U)
#define TIMERB_0_CK0_DIV_COE 13U
#elif (TIMERB_0_CK0_DIV == 16384U)
#define TIMERB_0_CK0_DIV_COE 14U
#elif (TIMERB_0_CK0_DIV == 32768U)
#define TIMERB_0_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK1_DIV == 1U)
#define TIMERB_0_CK1_DIV_COE 0U
#elif (TIMERB_0_CK1_DIV == 2U)
#define TIMERB_0_CK1_DIV_COE 1U
#elif (TIMERB_0_CK1_DIV == 4U)
#define TIMERB_0_CK1_DIV_COE 2U
#elif (TIMERB_0_CK1_DIV == 8U)
#define TIMERB_0_CK1_DIV_COE 3U
#elif (TIMERB_0_CK1_DIV == 16U)
#define TIMERB_0_CK1_DIV_COE 4U
#elif (TIMERB_0_CK1_DIV == 32U)
#define TIMERB_0_CK1_DIV_COE 5U
#elif (TIMERB_0_CK1_DIV == 64U)
#define TIMERB_0_CK1_DIV_COE 6U
#elif (TIMERB_0_CK1_DIV == 128U)
#define TIMERB_0_CK1_DIV_COE 7U
#elif (TIMERB_0_CK1_DIV == 256U)
#define TIMERB_0_CK1_DIV_COE 8U
#elif (TIMERB_0_CK1_DIV == 512U)
#define TIMERB_0_CK1_DIV_COE 9U
#elif (TIMERB_0_CK1_DIV == 1024U)
#define TIMERB_0_CK1_DIV_COE 10U
#elif (TIMERB_0_CK1_DIV == 2048U)
#define TIMERB_0_CK1_DIV_COE 11U
#elif (TIMERB_0_CK1_DIV == 4096U)
#define TIMERB_0_CK1_DIV_COE 12U
#elif (TIMERB_0_CK1_DIV == 8192U)
#define TIMERB_0_CK1_DIV_COE 13U
#elif (TIMERB_0_CK1_DIV == 16384U)
#define TIMERB_0_CK1_DIV_COE 14U
#elif (TIMERB_0_CK1_DIV == 32768U)
#define TIMERB_0_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK2_DIV == 1U)
#define TIMERB_0_CK2_DIV_COE 0U
#elif (TIMERB_0_CK2_DIV == 2U)
#define TIMERB_0_CK2_DIV_COE 1U
#elif (TIMERB_0_CK2_DIV == 4U)
#define TIMERB_0_CK2_DIV_COE 2U
#elif (TIMERB_0_CK2_DIV == 8U)
#define TIMERB_0_CK2_DIV_COE 3U
#elif (TIMERB_0_CK2_DIV == 16U)
#define TIMERB_0_CK2_DIV_COE 4U
#elif (TIMERB_0_CK2_DIV == 32U)
#define TIMERB_0_CK2_DIV_COE 5U
#elif (TIMERB_0_CK2_DIV == 64U)
#define TIMERB_0_CK2_DIV_COE 6U
#elif (TIMERB_0_CK2_DIV == 128U)
#define TIMERB_0_CK2_DIV_COE 7U
#elif (TIMERB_0_CK2_DIV == 256U)
#define TIMERB_0_CK2_DIV_COE 8U
#elif (TIMERB_0_CK2_DIV == 512U)
#define TIMERB_0_CK2_DIV_COE 9U
#elif (TIMERB_0_CK2_DIV == 1024U)
#define TIMERB_0_CK2_DIV_COE 10U
#elif (TIMERB_0_CK2_DIV == 2048U)
#define TIMERB_0_CK2_DIV_COE 11U
#elif (TIMERB_0_CK2_DIV == 4096U)
#define TIMERB_0_CK2_DIV_COE 12U
#elif (TIMERB_0_CK2_DIV == 8192U)
#define TIMERB_0_CK2_DIV_COE 13U
#elif (TIMERB_0_CK2_DIV == 16384U)
#define TIMERB_0_CK2_DIV_COE 14U
#elif (TIMERB_0_CK2_DIV == 32768U)
#define TIMERB_0_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_0_CK3_DIV == 1U)
#define TIMERB_0_CK3_DIV_COE 0U
#elif (TIMERB_0_CK3_DIV == 2U)
#define TIMERB_0_CK3_DIV_COE 1U
#elif (TIMERB_0_CK3_DIV == 4U)
#define TIMERB_0_CK3_DIV_COE 2U
#elif (TIMERB_0_CK3_DIV == 8U)
#define TIMERB_0_CK3_DIV_COE 3U
#elif (TIMERB_0_CK3_DIV == 16U)
#define TIMERB_0_CK3_DIV_COE 4U
#elif (TIMERB_0_CK3_DIV == 32U)
#define TIMERB_0_CK3_DIV_COE 5U
#elif (TIMERB_0_CK3_DIV == 64U)
#define TIMERB_0_CK3_DIV_COE 6U
#elif (TIMERB_0_CK3_DIV == 128U)
#define TIMERB_0_CK3_DIV_COE 7U
#elif (TIMERB_0_CK3_DIV == 256U)
#define TIMERB_0_CK3_DIV_COE 8U
#elif (TIMERB_0_CK3_DIV == 512U)
#define TIMERB_0_CK3_DIV_COE 9U
#elif (TIMERB_0_CK3_DIV == 1024U)
#define TIMERB_0_CK3_DIV_COE 10U
#elif (TIMERB_0_CK3_DIV == 2048U)
#define TIMERB_0_CK3_DIV_COE 11U
#elif (TIMERB_0_CK3_DIV == 4096U)
#define TIMERB_0_CK3_DIV_COE 12U
#elif (TIMERB_0_CK3_DIV == 8192U)
#define TIMERB_0_CK3_DIV_COE 13U
#elif (TIMERB_0_CK3_DIV == 16384U)
#define TIMERB_0_CK3_DIV_COE 14U
#elif (TIMERB_0_CK3_DIV == 32768U)
#define TIMERB_0_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

static const uint32_t u32TimerBClockArray[12U] =
	{
		TIMERB_0_CK0,
		TIMERB_0_CK1,
		TIMERB_0_CK2,
		TIMERB_0_CK3,

};
/*-------------------------------------------------------*/

/*-----------------------------------------*/
void TimerB_PWM_Init(void);
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock);
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty);
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty);
void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
static void TimerB_Input_Demo_Init(void);

/*----------------------------------------------*/
void TimerB_PWM_Init(void)
{
	uint16_t u16TimeCount = 0U;
	do
	{
		/*stop all clk*/
		TAUB0TT = 0xFFFFU;
		u16TimeCount++;
	} while (((TAUB0TE)) && (u16TimeCount < TIMERB_TIMEROUT_MAX));
	if (u16TimeCount < TIMERB_TIMEROUT_MAX)
	{
		/*CLK0 =PCLK */
		TAUB0TPS = ((TIMERB_0_CK3_DIV_COE << 12U) | (TIMERB_0_CK2_DIV_COE << 8U) | (TIMERB_0_CK1_DIV_COE << 4U) | (TIMERB_0_CK0_DIV_COE));
	}
}
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16ClockSelectRe = (0x801U | (enTimerBClock << 14U));
	uint16_t u16TimerBbit = (1U << u8TimerBChannel);

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = 0U;

	/*control*/
	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
	*((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
	/*TAUB0CMOR2 = u16ClockSelectRe;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
	*((uint8_t *)u32TimerBRegAddrChannel) = 0U;
	/*TAUB0CMUR2 = 0U;*/

	/*output mode*/

	/*Simultaneous rewrite */
	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
	/*TAUB0RDE |= u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDS &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDM &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDC &= (~u16TimerBbit);*/
}
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16ClockSelectRe = (0x409U | (enTimerBClock << 14U));
	uint16_t u16TimerBbit = (1U << u8TimerBChannel);

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = 0U;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
	*((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
	/*TAUB0CMOR3 = u16ClockSelectRe;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
	*((uint8_t *)u32TimerBRegAddrChannel) = 0U;
	/*TAUB0CMUR3 = 0U;*/

	/*output mode*/
	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
	*((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
	/*TAUB0TOE |= u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X248U;
	*((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
	/*TAUB0TOM |= u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X24CU;
	*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	/*TAUB0TOC &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
	if (enTimerBPolarity == TIMERB_HIGH)
	{
		/*TAUB0TOL &= (~u16TimerBbit);*/
		*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	}
	else
	{
		/*TAUB0TOL |= u16TimerBbit;*/
		*((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
	}

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X250U;
	*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	/*TAUB0TDE &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X54U;
	*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	/*TAUB0TDL &= (~u16TimerBbit);*/

	/*Simultaneous rewrite */
	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
	/*TAUB0RDE |= u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDS &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDM &= (~u16TimerBbit);*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
	(*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
	/*TAUB0RDC &= (~u16TimerBbit);*/
}

/* 返回初始化状态。1：成功。0：失败
	输出要设置的通道，通道选择的时钟源，通道有效时输出的极性*/
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{

	uint8_t u8TimerBResult = 0U;

	if ((enTimerBChannel % 2U))
	{
		u8TimerBResult = 1U;
		TimerB_PWM_Master_Channel_Init(enTimerBChannel - 1U, enTimerBClock);
		TimerB_PWM_Slave_Channel_Init(enTimerBChannel, enTimerBClock, enTimerBPolarity);
	}

	return u8TimerBResult;
}

/* 返回实际设置成功的频率，如果返回0表示错误。
频率单位：HZ
占空比精度千分之一*/
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty)
{

	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);

	uint8_t u8TimerBClockSel = (uint8_t)(((*((uint16_t *)u32TimerBRegAddrChannel))) >> 14U);
	uint8_t u8TimerBClockIndex = u8TimerBIndex * 4U + u8TimerBClockSel;
	uint32_t u32TimerBClockFre = u32TimerBClockArray[u8TimerBClockIndex];
	uint32_t u32CalBuf = (u32TimerBClockFre / u16Fre);
	uint32_t u32CalFre = 0U;
	uint32_t u32Duty = u16Duty;
	if (enTimerBChannel % 2U)
	{
		u32CalFre = (u32TimerBClockFre / u32CalBuf);

		u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel));

		(*((uint16_t *)(u32TimerBRegAddrChannel - 4U * TIMERB_CHANNEL_INTERVAL))) = u32CalBuf - 1U;
		/*TAUB0CDR2 = u32CalBuf - 1U;  // fre*/

		(*((uint16_t *)u32TimerBRegAddrChannel)) = (u32Duty * u32CalBuf / 1000U);
		/*TAUB0CDR3 = (u32Duty * u32CalBuf / 100000U); //  duty*/

		u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
		(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
		/*TAUB0RDT = (u16TimerBbit);*/
	}
	return u32CalFre;
}
/*占空比精度千分之一*/
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL));

	uint32_t u32CalBuf = (*((uint16_t *)u32TimerBRegAddrChannel)) + 1U;
	/*	uint32_t u32CalBuf = TAUB0CDR2 + 1U;*/
	uint32_t u32Duty = u16Duty;

	if (enTimerBChannel % 2U)
	{
		(*((uint16_t *)(u32TimerBRegAddrChannel + 4U * TIMERB_CHANNEL_INTERVAL))) = (u32CalBuf * u32Duty / 1000U);
		/*TAUB0CDR3 = (u32CalBuf * u32Duty / 100U); */ /*duty*/

		u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
		(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
		/*TAUB0RDT = (u16TimerBbit);*/
	}
}

void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C4U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*	TAUB0TS = (u16TimerBbit);*/
}
/*调用该函数后，仅重新调用开始函数功能即可正常使用*/
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL));

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*TAUB0TT = (u16TimerBbit);*/
}
/*仅休眠时可调用，调用该函数后需要重新初始化相关通道才可以正常使用。*/
void TimerB_PWM_Channel_Sleep(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;
	uint16_t u16TimerBRegTOL = 0U;
	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*TAUB0TT = (u16TimerBbit);*/

	u16TimerBbit = u16TimerBbit * (TIMERB_CHANNEL_BIT_MUL - 1U) / TIMERB_CHANNEL_BIT_MUL;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
	u16TimerBRegTOL = (*((uint16_t *)u32TimerBRegAddrChannel));
	/*u16TimerBRegTOL=TAUB0TOL*/
	u16TimerBRegTOL &= u16TimerBbit;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
	*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	/*TAUB0TOE &= ~u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X58U;

	if (u16TimerBRegTOL)
	{
		*((uint16_t *)u32TimerBRegAddrChannel) |= (u16TimerBbit);
		/*TAUB0TO |= u16TimerBbit;*/
	}
	else
	{
		*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
		/*TAUB0TO &= ~u16TimerBbit;*/
	}
}

/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/

void TimerB_Cal_Fre(TIMERB_Channel_en_t enTimerBChannel, uint32_t u32TimerBClockFre, uint16_t u16TimerBCount);

static void TimerB_Input_Capture_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16ClockSelectRe = (0x156U | (enTimerBClock << 14U));
	uint16_t u16TimerBbit = (1U << u8TimerBChannel);

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = 0U;

	/*control*/
	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
	*((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
	/*TAUB0CMOR10 = u16ClockSelectRe;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
	*((uint8_t *)u32TimerBRegAddrChannel) = (uint8_t)enTimerBEdge;
	/*TAUB0CMUR10 = enTimerBEdge;*/

	/*output mode*/
	/*Simultaneous rewrite */
}
/**/
static void TimerB_Interval_Timer_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16ClockSelectRe = (0x00U | (enTimerBClock << 14U));
	uint16_t u16TimerBbit = (1U << u8TimerBChannel);

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = 0U;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
	*((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
	/*TAUB0CMOR3 = u16ClockSelectRe;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
	*((uint8_t *)u32TimerBRegAddrChannel) = 0U;
	/*TAUB0CMUR3 = 0U;*/

	/*output mode*/
	/*Simultaneous rewrite */

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * u8TimerBChannel);
	*((uint16_t *)u32TimerBRegAddrChannel) = 0xFFFFU;
	/*TAUB0CDR9 = 0xFFFFU;*/
}

void TimerB_Input_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge)
{
	TimerB_Input_Capture_Channel_Init(enTimerBChannel, enTimerBClock, enTimerBEdge);
	TimerB_Interval_Timer_Channel_Init(enTimerBChannel - 1, enTimerBClock);

	peripheral_IRQ_enable((enTimerBChannel * 2UL) + INTTAUB0I0);
	peripheral_IRQ_enable(((enTimerBChannel - 1U) * 2UL) + INTTAUB0I0);
}

void TimerB_Input_Channel_Start(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C4U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*	TAUB0TS = (u16TimerBbit);*/
}
void TimerB_Input_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*TAUB0TT = (u16TimerBbit);*/
}

/*捕获中断*/
void TimerB_Input_Isr(TIMERB_Channel_en_t enTimerBChannel)
{
	/*----------------------------------------------------------------------------*/
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);

	uint8_t u8TimerBClockSel = (uint8_t)(((*((uint16_t *)u32TimerBRegAddrChannel))) >> 14U);
	uint8_t u8TimerBClockIndex = u8TimerBIndex * 4U + u8TimerBClockSel;

	uint32_t u32TimerBChannelClock = 0UL;
	uint32_t u32TimerBChannelData = 0UL;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel));

	/*通道使用的时钟频率*/
	u32TimerBChannelClock = u32TimerBClockArray[u8TimerBClockIndex];
	/*通道返回的计数值，滚动计数，不清除*/
	u32TimerBChannelData = (*((uint16_t *)u32TimerBRegAddrChannel)) + 1UL;

	/*----------------------------------------------------------------------------*/

	TimerB_Cal_Fre(enTimerBChannel, u32TimerBChannelClock, u32TimerBChannelData);
}
/*溢出中断*/
void TimerB_Overflow_Isr(void)
{
}
uint32_t u32TimerBInputDataLast = 0;
uint32_t u32TimerBInputData = 0;
uint32_t u32TimerBInputDataDif = 0;
uint32_t u32TimerBInputFre = 0;

/*
形参分别表示，通道号，通道时钟频率，通道计数器的数值。
*/
void TimerB_Cal_Fre(TIMERB_Channel_en_t enTimerBChannel, uint32_t u32TimerBClockFre, uint16_t u16TimerBCount)
{

	u32TimerBInputData = u16TimerBCount;
	if (u32TimerBInputDataLast < u32TimerBInputData)
	{
		u32TimerBInputDataDif = u32TimerBInputData - u32TimerBInputDataLast;
	}
	else
	{
		u32TimerBInputDataDif = 0xFFFF - u32TimerBInputDataLast + u32TimerBInputData + 1;
	}

	u32TimerBInputDataLast = u32TimerBInputData;

	u32TimerBInputFre = u32TimerBClockFre / u32TimerBInputDataDif;
}