#include  "CAN_CH0_CAN_Communication_Matrix.h"
/* 2023/12/02 19:20:48 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1B1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xB3ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xB2ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_1B1_Sig_MKBD_SWVerMinor(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_PE_01_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1B1_Sig_MKBD_SWVerMajor(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_PE_01_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_VolUpSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_VolDownSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_SetupSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_CustomSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_MediaSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_RadioSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_NavSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_MapSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_03_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B2_Sig_MKBD_ResetCommand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_02_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0B2_Sig_MKBD_VolKonbEnter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MKBD_HU_E_02_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_MKBD_HU_PE_01_Msg:
        u8Result = CAN_CH0_ID_MKBD_HU_PE_01_Msg_Count;
        break;
    case CAN_CH0_ID_MKBD_HU_E_03_Msg:
        u8Result = CAN_CH0_ID_MKBD_HU_E_03_Msg_Count;
        break;
    case CAN_CH0_ID_MKBD_HU_E_02_Msg:
        u8Result = CAN_CH0_ID_MKBD_HU_E_02_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

