#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_MKBD_HU_PE_01_Msg_Count,
    CAN_CH0_ID_MKBD_HU_E_03_Msg_Count,
    CAN_CH0_ID_MKBD_HU_E_02_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{

    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_MKBD_HU_PE_01_Msg    0x1B1ul
#define  CAN_CH0_ID_MKBD_HU_E_03_Msg     0x0B3ul
#define  CAN_CH0_ID_MKBD_HU_E_02_Msg     0x0B2ul

extern uint8_t  Get_CAN_CH0_ID_1B1_Sig_MKBD_SWVerMinor(void);
extern uint8_t  Get_CAN_CH0_ID_1B1_Sig_MKBD_SWVerMajor(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_VolUpSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_VolDownSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_SetupSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_CustomSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_MediaSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_RadioSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_NavSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B3_Sig_MKBD_MapSw(void);
extern uint8_t  Get_CAN_CH0_ID_0B2_Sig_MKBD_ResetCommand(void);
extern uint8_t  Get_CAN_CH0_ID_0B2_Sig_MKBD_VolKonbEnter(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
