------------------------代码里的路径是直接写出来的 可以直接处理---------------------------------------------------------------
import re
import os

def check_image_path(filename):
    with open(filename, "r") as f:
        content = f.read()

    # 使用正则表达式来匹配图片路径
    image_paths = re.findall(r"(.*?\.(jpg|jpeg|png|gif))", content)

    # 检查图片是否存在
    for image_path in image_paths:
        if not os.path.exists(image_path):
            print(f"图片 {image_path} 不存在")

if __name__ == "__main__":
    filename = "test.c"
    check_image_path(filename)

--------------------------------代码里的路径是用sprintf 拼的路径要做如下处理------------------------------------------------

import re
import os

def check_image_path(filename):
    with open(filename, "r") as f:
        content = f.read()

    # 使用正则表达式来匹配图片路径
    image_paths = re.findall(r"(.*?\.(jpg|jpeg|png|gif))", content)

    # 检查图片是否存在
    for image_path in image_paths:
        # 使用正则表达式来匹配 %d
        number = re.findall(r"\%d", image_path)[0]

        # 使用 number 来格式化路径
        image_path = image_path.replace("%d", str(number))

        image_path = os.path.join(os.path.dirname(filename), image_path)
        if not os.path.exists(image_path):
            print(f"图片 {image_path} 不存在")

if __name__ == "__main__":
    filename = "set_number_white_20.c"
    check_image_path(filename)


---------------------------------一行里有2个路径的 要做分割处理-------------------------------------------
import re
import os

def check_image_path(filename):
    with open(filename, "r") as f:
        content = f.read()

    # 使用正则表达式来匹配两个文件路径
    image_paths = re.findall(r"(.*?\.(jpg|jpeg|png|gif))\s+(.*?\.(jpg|jpeg|png|gif))", content)

    # 检查图片是否存在
    for image_path in image_paths:
        image_path = os.path.join(os.path.dirname(filename), image_path)
        if not os.path.exists(image_path):
            print(f"图片 {image_path} 不存在")

if __name__ == "__main__":
    filename = "set_number_white_20.c"
    check_image_path(filename)
