from PyQt5.QtWidgets import QApplication, QWidget, QVBoxLayout, QSpinBox
from PyQt5.QtGui import QValidator
from PyQt5.QtCore import Qt

class EvenSpinBox(QSpinBox):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setMaximum(65534)
        self.setMinimum(2)
        self.setSingleStep(2)  # 设置步长为2

    def validate(self, text, pos):
        try:
            if len(self.suffix()):
                value = int(text[len(self.prefix()):-len(self.suffix())])
            else:
                value = int(text[len(self.prefix()):])
            if value % 2 == 0:
                return QValidator.Acceptable, text, pos
            else:
                return QValidator.Intermediate, text, pos
        except ValueError:
            return QValidator.Invalid, text, pos

    def fixup(self, text):
        try:
            if len(self.suffix()):
                value = int(text[len(self.prefix()):-len(self.suffix())])
            else:
                value = int(text[len(self.prefix()):])
            # 如果值是奇数，增加1使其成为偶数
            if value % 2 != 0:
                self.setValue(value + 1)
        except ValueError:
            pass


class _Demo(QWidget):
    def __init__(self):
        super().__init__()

        self.spinBox = EvenSpinBox()
        layout = QVBoxLayout()
        layout.addWidget(self.spinBox)
        self.setLayout(layout)

if __name__ == '__main__':
    app = QApplication([])
    demo = _Demo()
    demo.show()
    app.exec_()
