from typing import Dict, List, Tuple

from psd_tools.api.layers import PixelLayer, TypeLayer


class rect:
    def __init__(self) -> None:
        self.x = 0
        self.y = 0
        self.w = 1
        self.h = 1
    def set_value(self, x_, y_, w_, h_)->None:
        self.x = x_
        self.y = y_
        self.w = w_
        self.h = h_
    def __str__(self) -> str:
        return "rect(({self.x},{self.y}),({self.w},{self.h}))"

# 标志位类
class flag_data:
    psd_name = ''           # psd名字
    english = False         # 是否需要英文
    cobit = False           # 是否需要共位
    show = False            # 是否显示
    equal_size = True       # 是否等大
    Auto_cut_1 = False      # 智能切图
    self_set_cut = False    # 自定义切图

    range_group:List[rect] = []        # 自定义切图数组

    def __str__(self) -> str:
        return "psd名:{}, english:{}, cobit:{}, show:{}, equal_size:{}".format(self.psd_name, self.english, self.cobit, self.show, self.equal_size)


class lay_item:
    layer:Tuple[PixelLayer, TypeLayer]
    layer_name:str
    # psd_name:str
    x = y = w = h = 0
    english = False
    show = False

    def __str__(self) -> str:
        return"<图层名:{} ,x:{} ,y:{} ,w:{} ,h:{} >".format(self.layer_name, self.x, self.y, self.w, self.h)

    def new_str(self)->str:
        return"<layer_name:{}, x:{} ,y:{} ,w:{} ,h:{}, english:{}, show:{}|\n layer:{}>".format(self.layer_name, self.x, self.y, self.w, self.h, self.english, self.show, self.layer)



# if __name__ == '__main__':
#     a = lay_item()
#     a.layer = ''
#     a.layer_name = "123"
#     a.x = 32
#     a.y = 64
#     a.w = 128
#     a.h = 256

#     print(a)

#     b = "aaa{}".format(True)
#     print(b)
