import json
import os
import re
import urllib.parse
import urllib.request
from random import uniform
from time import sleep

import numpy as np
import openpyxl
import psd_tools
from PIL import ImageChops,Image
from psd_tools import PSDImage
from PyQt5.QtGui import QBrush, QColor
from PyQt5.QtWidgets import QListWidgetItem, QMessageBox
from skimage.metrics import structural_similarity as ssim

from comm_class import flag_data, lay_item

auto_cut_info = {}

class exc(object):
    excel_file_name = 'image coordinate size.xlsx'  # EXCEL名称
    image_name_colum    = 'A'
    x_coord_column      = 'B'
    y_coord_column      = 'C'
    width_column        = 'D'
    height_column       = 'E'
    translation_column  = 'F'
    Original_column     = 'G'

    # 起始行
    start_line_number = 2
    if not os.path.exists(excel_file_name):
        openpyxl.Workbook().save(excel_file_name)

    wb = openpyxl.load_workbook(excel_file_name)  # 创建excel对象
    sheet = wb.sheetnames  # 获取工作表名称
    sheet1 = wb[sheet[0]]  # 获取sheet1工作表对象


    def exc_clear(self):
        excel_file_name = 'image coordinate size.xlsx'  # EXCEL名称
        while(True):
            x_coord_index = self.x_coord_column + str(self.start_line_number)
            y_coord_index = self.y_coord_column + str(self.start_line_number)
            width_index = self.width_column + str(self.start_line_number)
            height_index = self.height_column + str(self.start_line_number)
            image_name_index  = self.image_name_colum + str(self.start_line_number)
            translation_index  = self.translation_column + str(self.start_line_number)
            Original_index  = self.Original_column + str(self.start_line_number)

            if self.sheet1[image_name_index].value != None:
                self.sheet1[x_coord_index] = None
                self.sheet1[y_coord_index] = None
                self.sheet1[width_index] = None
                self.sheet1[height_index] = None
                self.sheet1[image_name_index] = None
                self.sheet1[translation_index] = None
                self.sheet1[Original_index] = None
                self.start_line_number += 1

            else:
                msgbox_flag = 1
                while True:
                    try:
                        self.wb.save('image coordinate size.xlsx')
                        break
                    except PermissionError:

                        if msgbox_flag:
                            print("please close the Excel file")

                            msgbox_flag = 0
                            # app = QtWidgets.QApplication(sys.argv)
                            msg_box = QMessageBox(QMessageBox.Warning, 'Warning', 'please close the Excel file')
                            msg_box.exec_()
                            sleep(3)
                break

        self.image_name_colum    = 'A'
        self.x_coord_column      = 'B'
        self.y_coord_column      = 'C'
        self.width_column        = 'D'
        self.height_column       = 'E'
        self.translation_column  = 'F'
        self.Original_column     = 'G'

        # 起始行
        self.start_line_number = 2

    def exc_write(self, x_coord, y_coord, max_w, max_h, image_name, translation, Original):
        # 处理单元格索引
        x_coord_index = self.x_coord_column + str(self.start_line_number)
        y_coord_index = self.y_coord_column + str(self.start_line_number)
        width_index = self.width_column + str(self.start_line_number)
        height_index = self.height_column + str(self.start_line_number)
        image_name_index  = self.image_name_colum + str(self.start_line_number)
        translation_index  = self.translation_column + str(self.start_line_number)
        Original_index  = self.Original_column + str(self.start_line_number)
        self.sheet1[x_coord_index] = x_coord
        self.sheet1[y_coord_index] = y_coord
        self.sheet1[width_index] = max_w
        self.sheet1[height_index] = max_h
        self.sheet1[image_name_index] = image_name
        self.sheet1[translation_index] = translation
        self.sheet1[Original_index] = Original
        self.start_line_number += 1

        msgbox_flag = 1
        while True:
            try:
                self.wb.save('image coordinate size.xlsx')
                break
            except PermissionError:
                if msgbox_flag:
                    print("please close the Excel file")

                    msgbox_flag = 0
                    # app = QtWidgets.QApplication(sys.argv)
                    msg_box = QMessageBox(QMessageBox.Warning, 'Warning', 'please close the Excel file')
                    msg_box.exec_()
                    sleep(3)

exc_c = exc()
exc_c.exc_clear()

def crawler_translation(content):
    url='http://fanyi.youdao.com/translate?smartresult=dict&smartresult=rule'
    head={}
    #隐藏爬虫信息
    head['User-Agent']='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0'

	#编辑表单
    data={}
    data['i']=content
    data['from']='AUTO'
    data['to']='AUTO'
    data['smartresult']='dict'
    data['client']='fanyideskweb'
    data['salt']='15590456742344'
    data['sign']='238073a9cc158731f9feea2f63589c3f'
    data['ts']='1559045674234'
    data['bv']='e2a78ed30c66e16a857c5b6486a1d326'
    data['doctype']='json'
    data['version']='2.1'
    data['keyfrom']='fanyi.web'
    data['action']='FY_BY_CLICKBUTTION'

	#确认新表单
    data=urllib.parse.urlencode(data).encode('utf-8')

	#传入url和data
    req=urllib.request.Request(url,data,head)

	#获得响应
    response=urllib.request.urlopen(url,data)
    html=response.read().decode('utf-8')
    '''
    print(html)

    target=json.loads(html)
    print(target)

    print(target['translateResult'])

    print(target['translateResult'][0][0])

    print(target['translateResult'][0][0]['tgt'])
    '''
    target=json.loads(html)

	#获取结果
    # print('翻译结果:%s'%(target['translateResult'][0][0]['tgt']))
    return target['translateResult'][0][0]['tgt']

def check_path(path):
    if os.path.isabs(path):
        return 1
    elif os.path.isabs(os.path.join(os.getcwd(), path)):
        return 2
    else:
        return 0

def get_middle_position(x, y, w, h):
    return x + w//2, y + h//2

def is_in_pos_list(x, y, w, h, pos_list:dict):
    for pos in pos_list.keys():
        # 误差设置
        if abs(x - pos[0]) <= 2 and abs(y - pos[1]) <= 2:
            if any([w == i.width and h == i.height for i in pos_list[pos]]):
                return x, y
            else:
                return pos[0], pos[1]

    return x, y

def extractLayerImge(lay_info:lay_item, psd_name:str, lwdtI:QListWidgetItem):
    global exc_c
    psd = PSDImage.open(psd_name)
    for layer in psd.descendants():
        if layer.is_group():
            # print(layer)
            continue
        if (    (layer.is_visible()) and \
                (lay_info.layer.name == layer.name) and (lay_info.layer.kind == layer.kind) and \
                (lay_info.layer.size == layer.size) and (lay_info.layer.offset == layer.offset)
                ):
            layer.visible = True
        else:
            layer.visible = False

    lay_info.layer.visible = True
    temp_layer_name = ''
    if bool(re.search('[a-z, A-Z,.,-,_]', lay_info.layer.name)):
        temp_layer_name = layer_name = lay_info.layer.name
    else:
        sleep(uniform(0.5, 3.6))
        if lay_info.english:
            layer_name = temp_layer_name = crawler_translation(lay_info.layer.name)
        else:
            temp_layer_name = layer_name = lay_info.layer.name

    temp_layer_name = layer_name
    if layer_name == '.':
        layer_name = 'dot'
    elif layer_name == '-' or layer_name == '_':
        layer_name = 'line'

    layer_name = layer_name.replace("/", "_")
    layer_name = layer_name.replace("\\", "_")
    layer_name = layer_name.replace(".", "_")
    layer_name = layer_name.replace(":", "_")
    layer_name = layer_name.replace("?", "!")
    layer_name = layer_name.replace("*", "#")
    layer_name = layer_name.replace('"', "'")
    layer_name = layer_name.replace('<', "_")
    layer_name = layer_name.replace('>', "_")
    layer_name = layer_name.replace('|', "&")

    pos_type = check_path(psd_name)

    # 空格替换为下划线
    layer_name = layer_name.replace(' ', '_')
    layer_name = layer_name.replace('*', 'x')
    layer_name = layer_name.replace('#', 'x')
    # layer_name = layer_name.replace('x', 'x')
    if pos_type == 2:
        layer_name = ".\\" + psd_name[:-4] + '/' + layer_name + '.png'
    if pos_type == 1:
        layer_name = psd_name[:-4] + '/' + layer_name + '.png'

    x1 = lay_info.x
    y1 = lay_info.y
    x2 = lay_info.x + lay_info.w
    y2 = lay_info.y + lay_info.h

    pos = (x1, y1, x2, y2)
    xywh = (lay_info.x , lay_info.y, lay_info.w, lay_info.h)
    color = QColor(51, 204, 51)

    try:
        if lay_info.w != 0 or lay_info.h != 0:
        # if lay_info.Auto_cut_1:
        #     for info in auto_cut_info.keys():
        #         break_flag = False
        #         for data_i in auto_cut_info[info]:
        #             if data_i == lay_info:
        #                 x1 = info[0] - info[2]//2
        #                 y1 = info[1] - info[3]//2
        #                 x2 = x1 + info[2]
        #                 y2 = y1 + info[3]
        #                 pos = (x1, y1, x2, y2)
        #         if break_flag :
        #             break

        # else:
            layer_image = psd.composite(viewport = pos, force=True)

            # layer_image.show(layer_name)
                # print("[# layer_image #]:", layer_image, "xywh:", xywh)
            # temp_psd_show = psd.compose(True)
            # temp_psd_show.show()
            if lay_info.show:
                layer_image.show()
            folder = os.path.exists(psd_name[:-4])
            if not folder:                   #判断是否存在文件夹如果不存在则创建为文件夹
                os.makedirs(psd_name[:-4])
            layer_image.save(layer_name)
            lay_info.layer.visible = False
            # {}[0]
    except KeyError:
        color = QColor(220, 220, 41)
    except:
        color = QColor(204, 0, 0)

    brush = QBrush(color)
    lwdtI.setForeground(brush)
    sleep(0.01)

        # print('翻译结果：', temp_layer_name)
    exc_c.exc_write(x1, y1, lay_info.w, lay_info.h, layer_name, temp_layer_name, lay_info.layer.name)
    return x1, y1, layer_name, temp_layer_name, lay_info.layer.name


def find_common_area(rect1, rect2):
    x1, y1, w1, h1 = rect1
    x2, y2, w2, h2 = rect2

    # 计算矩形的右上角坐标
    r1 = x1 + w1
    t1 = y1 + h1
    r2 = x2 + w2
    t2 = y2 + h2

    # 判断矩形是否重叠
    if x1 < r2 and r1 > x2 and y1 < t2 and t1 > y2:
        # 计算公共矩形的坐标和大小
        x = max(x1, x2)
        y = max(y1, y2)
        w = min(r1, r2) - x
        h = min(t1, t2) - y
        return (x, y, w, h)
    else:
        # 没有重叠的公共面积
        return None

    # for x_ in range(x, w+1):
    #     for y_ in range(y, h+1):
    #         # pixel = psd_layer.as_PIL().getpixel((x_, y_))
    #         pixel = psd_layer.getpixel((x_, y_))
    #         if pixel[3] != 0:
    #             return True
    # return False
def have_pixel(psd_layer, x, y, w, h, l_x, l_y, l_w, l_h):
    # 指定你关心的范围 (left, top, right, bottom)
    bounds = find_common_area((x, y, w, h), (l_x, l_y, l_w, l_h)) # 返回xywh坐标格式
    if bounds == None:
        return False
    # xywh转成ltrb坐标格式
    bounds = (bounds[0]- l_x, bounds[1]-l_y, bounds[0] + bounds[2]- l_x, bounds[1] + bounds[3]-l_y)
    # 从图层中提取像素数据并转换为RGBA模式
    image = psd_layer.topil().convert("RGBA")
    # image.show()
    cropped_image = image.crop(bounds)
    a_ = 0
    # cropped_image.show()
    # 遍历所有像素
    for x_ in range(bounds[2] - bounds[0]):
        for y_ in range(bounds[3] - bounds[1]):
            r, g, b, a = cropped_image.getpixel((x_, y_))
            # 检查每个像素的alpha值，如果alpha值大于0， 则至少有一个不透明像素
            if a > 0:
                # return True
                a_ += a
    return a_
    # # 创建一个与裁剪区域相同大小的完全透明的图片
    # empty_image = Image.new('RGBA', (w, h), (0, 0, 0, 0))

    # # 使用ImageChops的difference方法比较两张图片
    # diff = ImageChops.difference(cropped_image, empty_image)

    # # 获取像素值的和，如果和为0，说明两张图片完全相同，裁剪区域完全透明
    # pixel_sum = sum(diff.getdata(), (0, 0, 0, 0))

    # # 如果四个通道的像素和都为0，说明该区域完全透明，否则有像素点
    # return any(value != 0 for value in pixel_sum)

def get_lay_info(psd_info:flag_data):
    psd = PSDImage.open(psd_info.psd_name)
    max_w = max_h = 0
    max_x = max_y= -1
    layer_list = []
    auto_cut_info = {}

    for layer in psd.descendants():
        if layer.is_group():
            # print(layer)
            continue
        if layer.is_visible() == True:
            layer_list.append(layer)
            # 关闭所有图层并寻找最大宽高
            if max_w < layer.width:
                max_w = layer.width
            if max_h < layer.height:
                max_h = layer.height
            if max_x > layer.left or max_x == -1:
                max_x = layer.left
            if max_y > layer.top or max_y == -1:
                max_y = layer.top

            # 计算中间点
            middle_pos = get_middle_position(layer.left, layer.top, layer.width, layer.height)
            # 判断是否存在
            middle_pos = is_in_pos_list(middle_pos[0], middle_pos[1], layer.width, layer.height, auto_cut_info)
            if middle_pos in auto_cut_info:
                auto_cut_info[middle_pos].append(layer)
            else:
                auto_cut_info[middle_pos] = [layer]

            layer.visible = False
            # temp_psd_show = psd.compose(True)
            # temp_psd_show.show()
    # print(auto_cut_infor)

    max_info_w = max_info_h = 0
    # 获取不同的中心点下坐标的宽高
    for info_i in list(auto_cut_info.keys()):
        for data_i in auto_cut_info[info_i]:
            if max_info_w < data_i.width:
                max_info_w = data_i.width
            if max_info_h < data_i.height:
                max_info_h = data_i.height
        auto_cut_info[(info_i[0], info_i[1], max_info_w+1 if max_info_w%2 else max_info_w, max_info_h+1 if max_info_h%2 else max_info_h)]= auto_cut_info[info_i]
        del auto_cut_info[info_i]
        max_info_w = max_info_h = 0

    # for info_i in auto_cut_info.keys():
    #     print(info_i)
    #     for data_i in auto_cut_info[info_i]:
    #         print("\t", data_i)

    layer_info_list:list[lay_item] = []
    for layer in layer_list:
        is_join_flag = True
        layer_info_item = lay_item()
        if psd_info.Auto_cut_1:
            max_w = max_h = 0
            max_x = max_y= -1
            for info in auto_cut_info.keys():
                break_flag = False
                for data_i in auto_cut_info[info]:
                    if data_i == layer:
                        layer_info_item.x = info[0] - info[2]//2
                        layer_info_item.y = info[1] - info[3]//2
                        layer_info_item.w = info[2]
                        layer_info_item.h = info[3]
                        break_flag = True
                        break
                if break_flag :
                    break
        elif psd_info.self_set_cut:
            max_w = max_h = 0
            max_x = max_y= -1
            print(psd_info.range_group)
            is_join_flag = False
            for rect_item in psd_info.range_group:
                if have_pixel(layer, rect_item.x, rect_item.y, rect_item.w, rect_item.h,
                        layer.left, layer.top, layer.width, layer.height): # 判断图像中是否存在像素点

                    layer_info_item.x = rect_item.x
                    layer_info_item.y = rect_item.y
                    layer_info_item.w = rect_item.w
                    layer_info_item.h = rect_item.h
                    is_join_flag = True
                    break
            # 坐标内没有
        else:
            if psd_info.cobit:
                layer_info_item.x = max_x
                layer_info_item.y = max_y

                layer_info_item.w = max_w + 1 if max_w % 2 else max_w
                layer_info_item.h = max_h + 1 if max_h % 2 else max_h
            else:
                if psd_info.equal_size:
                    layer_info_item.w = max_w + 1 if max_w % 2 else max_w
                    layer_info_item.h = max_h + 1 if max_h % 2 else max_h
                else:
                    layer_info_item.w = layer.width + 1 if layer.width % 2 else layer.width
                    layer_info_item.h = layer.height + 1 if layer.height % 2 else layer.height

                layer_info_item.x = layer.left
                layer_info_item.y = layer.top
        if is_join_flag:
            layer_info_item.layer_name = layer.name
            layer_info_item.layer = layer
            print(layer_info_item)
            layer_info_list.append(layer_info_item)

    return layer_info_list


if __name__ == '__main__':
    psd_data :flag_data = flag_data()

    psd_data.psd_name = "NB35_W_0.psd"
    psd_data.equal_size = False
    from comm_class import rect
    psd_data.range_group = [rect()]
    psd_data.range_group[0].y = 10
    psd_data.range_group[0].w = 12
    psd_data.range_group[0].h = 10
    psd_data.self_set_cut = 1

    get_lay_info(psd_data)
