import json
import os
import re
import urllib.parse
import urllib.request
from random import uniform
from time import sleep

import openpyxl
import psd_tools
from psd_tools import PSDImage

excel_file_name = 'image coordinate size.xlsx'  # EXCEL名称
image_name_colum    = 'A'
x_coord_column      = 'B'
y_coord_column      = 'C'
width_column        = 'D'
height_column       = 'E'
translation_column  = 'F'
Original_column     = 'G'

need_en = ''
need_cobit = ''

# 起始行
start_line_number = 2

def crawler_translation(content):
    url='http://fanyi.youdao.com/translate?smartresult=dict&smartresult=rule'
    head={}
    #隐藏爬虫信息
    head['User-Agent']='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0'

	#编辑表单
    data={}
    data['i']=content
    data['from']='AUTO'
    data['to']='AUTO'
    data['smartresult']='dict'
    data['client']='fanyideskweb'
    data['salt']='15590456742344'
    data['sign']='238073a9cc158731f9feea2f63589c3f'
    data['ts']='1559045674234'
    data['bv']='e2a78ed30c66e16a857c5b6486a1d326'
    data['doctype']='json'
    data['version']='2.1'
    data['keyfrom']='fanyi.web'
    data['action']='FY_BY_CLICKBUTTION'

	#确认新表单
    data=urllib.parse.urlencode(data).encode('utf-8')

	#传入url和data
    req=urllib.request.Request(url,data,head)

	#获得响应
    response=urllib.request.urlopen(url,data)
    html=response.read().decode('utf-8')
    '''
    print(html)

    target=json.loads(html)
    print(target)

    print(target['translateResult'])

    print(target['translateResult'][0][0])

    print(target['translateResult'][0][0]['tgt'])
    '''
    target=json.loads(html)

	#获取结果
    # print('翻译结果:%s'%(target['translateResult'][0][0]['tgt']))
    return target['translateResult'][0][0]['tgt']


def extractLayerImge(layer:psd_tools.api.layers.TypeLayer):
    # layer.is_group()
    # layer_image = psd.compose(False)
    layer.visible = True
    # layer_image = layer.composite()
    temp_layer_name = ''
    if bool(re.search('[a-z, A-Z,.,-,_]', layer.name)):
        temp_layer_name = layer_name = layer.name
    else:
        sleep(uniform(0.5, 3.6))
        if (need_en == 'Y' or need_en == 'y'):
            layer_name = temp_layer_name = crawler_translation(layer.name)
        else:
            temp_layer_name = layer_name = layer.name

    if layer_name == '.':
        layer_name = 'dot'
    elif layer_name == '-' or layer_name == '_':
        layer_name = 'line'

    layer_name = layer_name.replace("/", "_")
    layer_name = layer_name.replace("\\", "_")
    layer_name = layer_name.replace(".", "_")
    layer_name = layer_name.replace(":", "_")
    layer_name = layer_name.replace("?", "!")
    layer_name = layer_name.replace("*", "#")
    layer_name = layer_name.replace('"', "'")
    layer_name = layer_name.replace('<', "_")
    layer_name = layer_name.replace('>', "_")
    layer_name = layer_name.replace('|', "&")

    layer_name = psd_name[:-4] + '/' + psd_name[:-4] + '_' + layer_name + '.png'

    # 空格替换为下划线
    layer_name = layer_name.replace(' ', '_')
    # layer_name = psd_name[:-4] + '_' + layer_name + '.png'
    # layer_image = psd.composite(viewport=(5,5,10,10),force=True)
    # layer_image = psd.composite(force=True)
    x1 = x2 = y1 = y2 = 0
    if need_cobit == 'Y' or need_cobit == 'y':
        x1 = max_x
        y1 = max_y
        x2 = max_x + max_w
        y2 = max_y + max_h

    else:
        difference_x = (max_w - layer.width)//2
        difference_y = (max_h - layer.height)//2
        x1 = layer.left-difference_x
        y1 = layer.top-difference_y
        x2 = x1 + max_w
        y2 = y1 + max_h

    pos = (x1, y1, x2, y2)
    xywh = (x1, y1, x2-x1, y2-y1)
    layer_image = psd.composite(viewport = pos, force=True)
    # layer_image.show(layer_name)
    print("[# layer_image #]:", layer_image, "xywh:", xywh)
    # print('\n\n\nlayer_name' + layer_name + '\n\n\n')
    layer_image.save(layer_name, quality=95, subsampling=0)
    layer.visible = False
    # print('翻译结果：', temp_layer_name)
    return x1, y1, layer_name, temp_layer_name, layer.name
    # layer.is_group()

if __name__ == '__main__':
    wb = openpyxl.load_workbook(excel_file_name)  # 创建excel对象
    sheet = wb.sheetnames  # 获取工作表名称
    sheet1 = wb[sheet[0]]  # 获取sheet1工作表对象
    while(True):
        x_coord_index = x_coord_column + str(start_line_number)
        y_coord_index = y_coord_column + str(start_line_number)
        width_index = width_column + str(start_line_number)
        height_index = height_column + str(start_line_number)
        image_name_index  = image_name_colum + str(start_line_number)
        translation_index  = translation_column + str(start_line_number)
        Original_index  = Original_column + str(start_line_number)

        if sheet1[image_name_index].value != None:
            sheet1[x_coord_index] = None
            sheet1[y_coord_index] = None
            sheet1[width_index] = None
            sheet1[height_index] = None
            sheet1[image_name_index] = None
            sheet1[translation_index] = None
            sheet1[Original_index] = None
            start_line_number += 1

        else:
            while True:
                try:
                    wb.save(excel_file_name)
                    break
                except PermissionError:
                    print("please close the Excel file")
                    sleep(3)
            break

    start_line_number = 2

    while(True):
        psd_name = input('please input psd name(input \\q out):\n')
        if psd_name == '\\q':
            break
        if psd_name[-4:] != '.psd':
            psd_name = psd_name + '.psd'
        while(True):
            need_en = input('need english?(Y/N)')
            if need_en == 'y' or need_en == 'n' or need_en == 'Y' or need_en == 'N':
                break
            else:
                print('please Reenter')

        while(True):
            need_cobit = input('need cobit?(Y/N)')
            if need_cobit == 'y' or need_cobit == 'n' or need_cobit == 'Y' or need_cobit == 'N':
                break
            else:
                print('please Reenter')

        try:
            psd = PSDImage.open(psd_name)
        except FileNotFoundError:
            print('file "%s" does not exist Please re-enter' % (psd_name[:-4]))
            continue
        max_w = max_h = 0
        max_x = max_y= -1
        layer_list = []
        for layer in psd.descendants():
            if layer.is_group():
                # print(layer)
                continue
            if layer.is_visible() == True:
                layer_list.append(layer)
                # 关闭所有图层并寻找最大宽高
                if max_w < layer.width:
                    max_w = layer.width
                if max_h < layer.height:
                    max_h = layer.height
                if max_x > layer.left or max_x == -1:
                    max_x = layer.left
                if max_y > layer.top or max_y == -1:
                    max_y = layer.top

                # layer.visible = False
        print("*"*20)
        for layer in layer_list:
            print(layer)
        print("H"*20)
        print("max_w: %d, max_h: %d" % (max_w, max_h))
        print("*"*20)
        while(True):
            confirm_data = input('Please confirm(Y/N)')
            if confirm_data == 'y' or confirm_data == 'Y' or confirm_data == 'n' or confirm_data == 'N':
                break
            else:
                print('please Reenter')
        if confirm_data == 'n' or confirm_data == 'N':
            continue
        # 偶数处理
        if max_w % 2:
            max_w += 1

        if max_h % 2:
            max_h += 1

        folder = os.path.exists(psd_name[:-4])
        if not folder:                   #判断是否存在文件夹如果不存在则创建为文件夹
            os.makedirs(psd_name[:-4])

        for layer in layer_list:
            print('descendants ', layer)
            x_coord, y_coord, image_name, translation, Original = extractLayerImge(layer)
            # 处理单元格索引
            x_coord_index = x_coord_column + str(start_line_number)
            y_coord_index = y_coord_column + str(start_line_number)
            width_index = width_column + str(start_line_number)
            height_index = height_column + str(start_line_number)
            image_name_index  = image_name_colum + str(start_line_number)
            translation_index  = translation_column + str(start_line_number)
            Original_index  = Original_column + str(start_line_number)

            sheet1[x_coord_index] = x_coord
            sheet1[y_coord_index] = y_coord
            sheet1[width_index] = max_w
            sheet1[height_index] = max_h
            sheet1[image_name_index] = image_name
            sheet1[translation_index] = translation
            sheet1[Original_index] = Original
            start_line_number += 1
    wb.save(excel_file_name)
    wb.close()

    # 将本地的表格复制过去

