# import resource
import os
import shutil
import sys
import time
from ctypes import *
from threading import Thread

import numpy as np
import ctypes
# import numpy.ctypeslib as npct
# import serial
# import serial.tools.list_ports
from PyQt5 import QtWidgets,QtCore
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import QSize, QTimer, pyqtSignal
from PyQt5.QtWidgets import (QApplication, QListWidgetItem, QMessageBox,
                             QStatusBar, QStyleFactory, QFileDialog,
                             QApplication)

from comm_class import flag_data, lay_item, rect
from cut_pic import extractLayerImge, get_lay_info
from outputUI import Ui_MainWindow as Ui_Form
import EvenSpinBox
EvenSpinBox = EvenSpinBox.EvenSpinBox

fozu = r"""
##################################################################
#                          _ooOoo_                               #
#                         o8888888o                              #
#                         88" . "88                              #
#                         (| -|- |)                              #
#                         O\  =  /O                              #
#                      ____/`---'\____                           #
#                    .'  \\|     |#  `.                          #
#                   /  \\|||  :  |||#  \                         #
#                  /  _||||| -:- |||||-  \                       #
#                  |   | \\\  -  #/ |   |                        #
#                  | \_|  ''\---/''  |   |                       #
#                  \  .-\__  `-`  ___/-. /                       #
#                ___`. .'  /--.--\  `. . ___                     #
#              ."" '<  `.___\_<|>_/___.'  >'"".                  #
#            | | :  `- \`.;`\ _ /`;.`/ - ` : | |                 #
#            \  \ `-.   \_ __\ /__ _/   .-` /  /                 #
#      ========`-.____`-.___\_____/___.-`____.-'========         #
#                           `=---='                              #
#      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^        #
#            佛祖保佑       永无BUG     永不修改                 #
##################################################################
"""

print(fozu)
class Pyqt5_Cut_psd(QtWidgets.QMainWindow, Ui_Form):
    # 定义信号
    cut_info_signal = pyqtSignal(int, str)
    cut_info_ok = pyqtSignal()
    cut_info_error = pyqtSignal()

    flag_stop_cut_pic_t = False

    def __init__(self, parent = None) -> None:
        super(Pyqt5_Cut_psd, self).__init__()
        self.setupUi(self)
        # self.lay_info_s:(list[lay_item])
        self.lay_info_s = {}
        icon = QIcon("./pic/cut_pic.ico")
        # app = QApplication([])
        # app.setWindowIcon(icon)
        self.setWindowIcon(icon)
        ctypes.windll.shell32.SetCurrentProcessExplicitAppUserModelID("myappid")
        # MainWindow.setWindowIcon(icon)
        # self.MainWindow.setWindowIcon(icon)
        # self.statusbar.showMessage("初始化中")
        self.lay_lwdtI = {}
        self.cut_range_group_list:list[rect] = [rect()]
        self.cut_pic_t = Thread(target=self.cut_pic_thread)
        # ui初始化状态
        self.__init()
        # 设置链接
        self.connects()

    def __init(self):
        self.stackedWidget.setCurrentIndex(0)
        self.let_psd_name.clear()
        # 设置选择框界面的界面值
        self.stk_set_cut_type.setCurrentIndex(0)

        # # 设置输入框w，h仅能输入偶数
        # esb_w = EvenSpinBox(self)
        # # 获取布局
        # layout = self.win_range_cut_w.layout()
        # self.sbx_w.deleteLater()
        # layout.replaceWidget(self.sbx_w,esb_w)
        # self.sbx_w = esb_w

    def __add_item(self, layer_data:lay_item):
        temp_item = QListWidgetItem()
        temp_item.setSizeHint(QSize(self.lwg_confirmed.widght(), 16))
        temp_item.setText(str(layer_data))
        self.lwg_confirmed.addItem(temp_item)

    def __set_range_cut_xywh(self, x, y, w, h):
        self.sbx_x.setValue( x )
        self.sbx_x.setValue( y )
        self.sbx_w.setValue( w )
        self.sbx_h.setValue( h )

    # 点击按钮后添加一个选择框的范围
    def __add_range_cut_item(self):
        self.cbb_range_group.addItem("范围%d"%((self.cbb_range_group.count() + 1)))
        self.cut_range_group_list.append(rect())

    def __del_range_cut_item(self):
        if (self.cbb_range_group.count() > 1):
            del self.cut_range_group_list[self.cbb_range_group.currentIndex()]
            self.cbb_range_group.removeItem( self.cbb_range_group.count()-1 )
            self.__switchOut_range_cut_item(self.cbb_range_group.currentIndex())

    def __switchOut_range_cut_item(self, index):
        self.sbx_x.setValue( self.cut_range_group_list[self.cbb_range_group.currentIndex()].x )
        self.sbx_y.setValue( self.cut_range_group_list[self.cbb_range_group.currentIndex()].y )
        self.sbx_w.setValue( self.cut_range_group_list[self.cbb_range_group.currentIndex()].w )
        self.sbx_h.setValue( self.cut_range_group_list[self.cbb_range_group.currentIndex()].h )

    def __set_range_group_x(self, value):
        self.cut_range_group_list[self.cbb_range_group.currentIndex()].x = value


    def __set_range_group_y(self, value):
        self.cut_range_group_list[self.cbb_range_group.currentIndex()].y = value


    def __set_range_group_w(self, value):
        self.cut_range_group_list[self.cbb_range_group.currentIndex()].w = value


    def __set_range_group_h(self, value):
        self.cut_range_group_list[self.cbb_range_group.currentIndex()].h = value

    # 读取文件地址
    def __read_file_path(self):
        file_path,_ = QFileDialog.getOpenFileNames(self, "选择PSD文件", os.getcwd(), 'PSD文件(*.psd)')
        if (file_path != ''):
            self.let_psd_name.setText(str(file_path)[1:-1])
        print(str(file_path)[1:-1])

    def __analysis_psd(self):
        self.lwg_confirmed.clear()
        self.lay_lwdtI.clear()
        for psd_name_i in self.let_psd_name.text().split(","):
            psd_name = psd_name_i.replace("'", '').strip()
            if psd_name[-4:] != '.psd':
                psd_name += '.psd'
            if os.path.exists(psd_name):
                self.stackedWidget.setCurrentIndex(1)

                psd_data = flag_data()
                psd_data.psd_name = psd_name
                psd_data.english = self.cbx_english.isChecked()
                psd_data.cobit = self.cbx_equal_position.isChecked()
                psd_data.show = self.cbx_show.isChecked()
                psd_data.equal_size = self.cbx_equal_size.isChecked()
                psd_data.Auto_cut_1 = self.cbx_auto_1.isChecked()
                psd_data.self_set_cut = self.stk_set_cut_type.currentIndex == 1

                self.lib_info_data.clear()
                info_prompt = "<" + psd_name + "|"
                if psd_data.self_set_cut:
                    info_prompt = "<  | 自 定 义 切 割 |  >"
                elif psd_data.Auto_cut_1:
                    info_prompt = "<  | 智 能 切 割 |  >"
                else:
                    if psd_data.equal_size:
                        info_prompt += "需要等大|"
                    else:
                        info_prompt += "无需等大|"
                    if psd_data.english:
                        info_prompt += "需要转化成英语|"
                    else:
                        info_prompt += "不要转化成英语|"
                    if psd_data.cobit:
                        info_prompt += "需要共位|"
                    else:
                        info_prompt += "无需共位|"
                    if psd_data.show:
                        info_prompt += "需要显示>"
                    else:
                        info_prompt += "无需显示>"

                self.lib_info_data.setText(info_prompt)
                psd_data.range_group = self.cut_range_group_list
                psd_data.self_set_cut = self.stk_set_cut_type.currentIndex()
                self.lay_info_s[psd_name] = get_lay_info(psd_data)
                self.lwg_confirmed.addItem(str(psd_name))
                # a = b = None
                for lay_info in self.lay_info_s[psd_name]:
                    self.lwg_confirmed.addItem(str(lay_info))
                    # a = self.lwg_confirmed.item(self.lwg_confirmed.count() - 1)
                    # if b != None:
                    #     print(a == b)
                    # b = a
                    self.lay_lwdtI[lay_info] = self.lwg_confirmed.item(self.lwg_confirmed.count() - 1)
                    # print(self.lwg_confirmed.item(self.lwg_confirmed.count() - 1), type(self.lwg_confirmed.item(self.lwg_confirmed.count()-1)))


                # if psd_name_i != self.let_psd_name.text().split(",")[-1]:
            else :
                QMessageBox.critical(self, "错误", '未知的psd文件名\n请检查psd文件名字是否正确\n|%s|'%(psd_name), QMessageBox.Yes, QMessageBox.Yes)
                print(psd_name, os.path.exists(psd_name))

    def __btnb_confirmed(self, btn):
        if btn.text() == "Reset":
            self.__analysis_psd()
            self.flag_stop_cut_pic_t = True
        elif btn.text() == "OK":
            self.cut_pic_t.start()
            del self.cut_pic_t
            self.cut_pic_t = Thread(target=self.cut_pic_thread)

            pass
        elif btn.text() == "Cancel":
            self.statusbar.clearMessage()
            self.stackedWidget.setCurrentIndex(0)
            self.flag_stop_cut_pic_t = True

            pass

    def cut_pic_ok(self):
        # 复制一份excel到每个psd的路径下方
        paths = set()
        for psd_name_i in self.let_psd_name.text().split(","):
            psd_name = psd_name_i.replace("'","").strip()
            # paths.add(os.path.split(psd_name)[0])
            paths.add(os.path.splitext(psd_name)[0])
        print(paths)
        excel_file_name = 'image coordinate size.xlsx'
        for psd_path in paths:
            # 判断psd_path是否等于当前路径
            if os.path.samefile(psd_path, os.getcwd()):
                continue
            # 判断是否存在excel文件
            if os.path.exists(os.path.join(psd_path, excel_file_name)):
                os.remove(os.path.join(psd_path, excel_file_name))
            shutil.copy(excel_file_name, psd_path)

        QMessageBox.information(self, "成功", '图片已经切成功放入对应文件夹中，\n坐标位于《image coordinate size.xlsx》文件中。', QMessageBox.Yes, QMessageBox.Yes)
        self.statusbar.clearMessage()

    def cut_pic_error(self):
        QMessageBox.critical(self, "错误", '未知的错误，已暂停', QMessageBox.Yes, QMessageBox.Yes)
        self.statusbar.clearMessage()

    def cut_pic_thread(self):
        for psd_name_i in self.let_psd_name.text().split(","):
            psd_name = psd_name_i.replace("'","").strip()
            if psd_name[-4:] != '.psd':
                psd_name += '.psd'
            for lay_info in self.lay_info_s[psd_name]:
                if self.flag_stop_cut_pic_t:
                    self.flag_stop_cut_pic_t = False
                    return
                self.statusbar.showMessage(str(psd_name) + "|" +str(lay_info) + "切图中……")
                extractLayerImge(lay_info, psd_name, self.lay_lwdtI[lay_info])
        self.cut_info_ok.emit()

    def to_selfset_page(self):
        self.stk_set_cut_type.setCurrentIndex(1)


    def return_selfset_page(self):
        self.stk_set_cut_type.setCurrentIndex(0)


    def connects(self):
        self.btn_analysis.clicked.connect(self.__analysis_psd)
        self.btnb_confirmed.clicked.connect(self.__btnb_confirmed)
        self.cut_info_ok.connect(self.cut_pic_ok)
        self.cut_info_error.connect(self.cut_pic_error)
        self.btn_select_file.clicked.connect(self.__read_file_path)
        self.btn_selfset.clicked.connect(self.to_selfset_page)
        self.btn_selfset_return.clicked.connect(self.return_selfset_page)
        self.sbx_x.valueChanged.connect(self.__set_range_group_x)
        self.sbx_y.valueChanged.connect(self.__set_range_group_y)
        self.sbx_w.valueChanged.connect(self.__set_range_group_w)
        self.sbx_h.valueChanged.connect(self.__set_range_group_h)
        self.btn_new_range_group.clicked.connect(self.__add_range_cut_item)
        self.btn_del_range_group.clicked.connect(self.__del_range_cut_item)
        self.cbb_range_group.activated[int].connect(self.__switchOut_range_cut_item)


if __name__ == '__main__':
    # 启用高DPI缩放
    QtWidgets.QApplication.setAttribute(QtCore.Qt.AA_EnableHighDpiScaling, True)

    app = QtWidgets.QApplication(sys.argv)
    myshow = Pyqt5_Cut_psd()
    myshow.show()
    sys.exit(app.exec_())
