#ifndef _KWP2000_INTERFACE_H
#define _KWP2000_INTERFACE_H

/*
*********************************************************************
* defines
*********************************************************************
*/
/* Defined for ComStatus */
#define KWP2000_DEFAULT_BAUDRATE_KLINE_DU 10400ul
#define KWP2000_MID_BAUDRATE_KLINE_DU 57600ul
#define KWP2000_HIGH_BAUDRATE_KLINE_DU 249600ul

#define KWP2000_ADDR_IC 0x60u
#define KWP2000_ADDR_OBD 0x33u
#define KWP2000_ADDR_SERVER 0xF1u

#define KWP2000_P2_MIN 0
#define KWP2000_P3_MAX 5000

/*
*********************************************************************
* variable
*********************************************************************
*/
extern unsigned char kwp2000_PhysicalAddress;
extern unsigned char kwp2000_FunctionalAddress;
extern unsigned char kwp2000_ServerAddress;
extern unsigned int kwp2000_P3_MAX_LIMIT;

/*
*********************************************************************
* function
*********************************************************************
*/
extern void Kwp2000_AscInit(void);
extern void Kwp2000_AscSwitchBaudrate(unsigned long xBaudrate_u32);

extern unsigned short Uart_GetData(void);
extern unsigned char Uart_GetRxLevel(void);

extern void Uart_SetData(unsigned char xBuffer_pu8);

extern void Uart_DisableReceiveIsrReq(void);
extern void Uart_EnableReceiveIsrReq(void);

extern void Uart_ClearAllErrorFlag(void);
extern void Uart_EnableRx(void);
extern void Uart_DisableRx(void);
extern void Uart_EnableTx(void);
extern void Uart_SetRxGpio(void);
extern void Uart_SetTxGpio(void);
extern void Uart_SetBaudrate(unsigned long xBaudrate_u32);
extern void Uart_ClearRxFullFlag(void);
extern void Uart_DisableTxInterrupt(void);
extern void Uart_ConfigOperationMode(void);
extern void TJA1021_Enable(unsigned char state);
extern void Kwp2000_SetTiming(void);
extern void Kwp2000_SetAddress(void);
extern void Kwp2000_AscTx(unsigned char *xBuffer_pu8);
extern void Kwp2000_AscEnableRx(void);

#endif
