#include "UDS_2EService_Main.h"

/**
  *2E服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_2E_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC11();                                            /*2E服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC7F();                                            /*2E服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC13_MinLengthCheck();                             /*2E服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC31();                                            /*2E服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC13_TotalLengthCheck();                           /*2E服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC33();                                            /*2E服务解锁等级验证*/
    }
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC22();                                            
    }车厂要求再做
	  if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_Sub_NRC31();                                      
    }车厂要求再做（内部参数）*/
    if(NRC == positiveResponse)
    {
        UDS_2EService_DID();                                                    /*2E服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *2E服务子功能
  */
void UDS_2EService_DID(void)
{
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*2E服务DID判断*/
    {
    case 0xF183u:
        UDS_2EService_DID_F183();                                               /*引导软件数字指纹(预留) */
        break;
    case 0xF184u:
        UDS_2EService_DID_F184();                                               /*应用软件数字指纹*/
        break;
    case 0xF185u:
        UDS_2EService_DID_F185();                                               /*应用数据数字指纹(预留) */
        break;
    case 0xF190u:
        UDS_2EService_DID_F190();                                               /*车辆标识号 VIN*/
        break;
    case 0xF1F0u:
        UDS_2EService_DID_F1F0();                                               /*IC 资源程序软件版本号 */
        break;
    case 0xF1F1u:
        UDS_2EService_DID_F1F1();                                               /*IC 总版本号*/
        break;
    case 0x605Cu:
        UDS_2EService_DID_605C();                                               /*LDWS(车道偏离)系统开关*/
        break;
    case 0x605Du:
        UDS_2EService_DID_605D();                                               /*AFS 系统开关*/
        break;
    case 0x605Eu:
        UDS_2EService_DID_605E();                                               /*HUD 系统开关*/
        break;
    case 0x605Fu:
        UDS_2EService_DID_605F();                                               /*ACC 系统开关 */
        break;
    case 0x6060u:
        UDS_2EService_DID_6060();                                               /*称重系统开关 */
        break;
    case 0x6062u:
        UDS_2EService_DID_6062();                                               /*车速里程表 K 值*/
        break;
    case 0x6063u:
        UDS_2EService_DID_6063();                                               /*发动机速比*/
        break;
    case 0x6064u:
        UDS_2EService_DID_6064();                                               /* 单位*/
        break;
    case 0x6068u:
        UDS_2EService_DID_6068();                                               /*语言*/
        break;
    case 0x606Du:
        UDS_2EService_DID_606D();                                               /*轮胎防盗使能开关*/
        break;
    case 0x606Eu:
        UDS_2EService_DID_606E();                                               /*换挡提示设置*/
        break;
    case 0x606Fu:
        UDS_2EService_DID_606F();                                               /*油箱容量设置*/
        break;
    case 0x6070u:
        UDS_2EService_DID_6070();                                               /*HAS 系统开关*/
        break;
    case 0x6071u:
        UDS_2EService_DID_6071();                                               /*ESC 系统开关 */
        break;
    case 0x6072u:
        UDS_2EService_DID_6072();                                               /* 盘式制动磨损报警功能*/
        break;
    case 0x6073u:
        UDS_2EService_DID_6073();                                               /*挂车设置*/
        break;
    case 0x6074u:
        UDS_2EService_DID_6074();                                               /*排放配置*/
        break;
    case 0x6075u:
        UDS_2EService_DID_6075();                                               /*超速报警车型信号 */
        break;
    case 0x6076u:
        UDS_2EService_DID_6076();                                               /*总里程（注：当总里程被写成任何值时，短里程都应该为 0）*/
        break;
    case 0x60C9u:
        UDS_2EService_DID_60C9();                                               /*尿素箱容积*/
        break;
    case 0x60CAu:
        UDS_2EService_DID_60CA();                                               /*主油箱容积*/
        break;
    case 0x60CBu:
        UDS_2EService_DID_60CB();                                               /*副油箱容积*/
        break;
    case 0x60CCu:
        UDS_2EService_DID_60CC();                                               /*油箱类型*/
        break;
    case 0x60CDu:
        UDS_2EService_DID_60CD();                                               /*油箱类型*/
        break;
    case 0x60CEu:
        UDS_2EService_DID_60CE();                                               /*TCU 类型 */
        break;
    case 0x60CFu:
        UDS_2EService_DID_60CF();                                               /*驱动能源类型*/
        break;
    case 0x60D0u:
        UDS_2EService_DID_60D0();                                               /*驱动形式*/
        break;
    case 0x60D1u:
        UDS_2EService_DID_60D1();                                               /*蓄电池容量*/
        break;
    case 0x60D2u:
        UDS_2EService_DID_60D2();                                               /*电池管理系统 */
        break;
    default:
        break;
    }
}

/**
  *2E服务DIDF183
  *引导软件数字指纹(预留) 
  */
void UDS_2EService_DID_F183(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F183,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F183));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DIDF184
  *应用软件数字指纹
  */
void UDS_2EService_DID_F184(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F184,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F184));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DIDF185
  *应用数据数字指纹(预留)
  */
void UDS_2EService_DID_F185(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F185,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F184));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DIDF190
  *车辆标识号 VIN
  */
void UDS_2EService_DID_F190(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F190,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F190));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DIDF1F0
  *IC 资源程序软件版本号
  */
void UDS_2EService_DID_F1F0(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F1F0,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F1F0));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DIDF1F1
  *IC 总版本号
  */
void UDS_2EService_DID_F1F1(void)
{
  memcpy(Ser2EToDFlashInfo.DID_F1F1,DiagMSG.msgData.DidDetail.Data,sizeof(Ser2EToDFlashInfo.DID_F1F1));
  write2EData(Write2EData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID605C
  *LDWS(车道偏离)系统开关
  */
void UDS_2EService_DID_605C(void)
{
  uint8_t i;
  memcpy(&EOL_Data_Type.DID_605C,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID605D
  *AFS 系统开关
  */
void UDS_2EService_DID_605D(void)
{
  memcpy(&EOL_Data_Type.DID_605D,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID605E
  *HUD 系统开关
  */
void UDS_2EService_DID_605E(void)
{
  memcpy(&EOL_Data_Type.DID_605E,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID605F
  *ACC 系统开关
  */
void UDS_2EService_DID_605F(void)
{
  memcpy(&EOL_Data_Type.DID_605F,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6060
  *称重系统开关
  */
void UDS_2EService_DID_6060(void)
{
  memcpy(&EOL_Data_Type.DID_6060,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6062
  *车速里程表 K 值
  */
void UDS_2EService_DID_6062(void)
{
  memcpy(EOL_Data_Type.DID_6062,DiagMSG.msgData.DidDetail.Data,sizeof(EOL_Data_Type.DID_6062));
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6063
  * 发动机速比
  */
void UDS_2EService_DID_6063(void)
{
  memcpy(&EOL_Data_Type.DID_6063,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);

}

/**
  *2E服务DID6064
  * 单位 
  */
void UDS_2EService_DID_6064(void)
{
  memcpy(&EOL_Data_Type.DID_6064,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);

}

/**
  *2E服务DID6068
  * 语言 
  */
void UDS_2EService_DID_6068(void)
{
  memcpy(&EOL_Data_Type.DID_6068,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);

}

/**
  *2E服务DID606D
  *  轮胎防盗使能开关  
  */
void UDS_2EService_DID_606D(void)
{
  memcpy(&EOL_Data_Type.DID_606D,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);

}

/**
  *2E服务DID606E
  *  换挡提示设置  
  */
void UDS_2EService_DID_606E(void)
{
  memcpy(&EOL_Data_Type.DID_606E,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID606F
  * 油箱容量设置
  */
void UDS_2EService_DID_606F(void)
{
  memcpy(EOL_Data_Type.DID_606F,DiagMSG.msgData.DidDetail.Data,sizeof(EOL_Data_Type.DID_606F));
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6070
  * HAS 系统开关
  */
void UDS_2EService_DID_6070(void)
{
  memcpy(&EOL_Data_Type.DID_6070,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6071
  *  ESC 系统开关
  */
void UDS_2EService_DID_6071(void)
{
  memcpy(&EOL_Data_Type.DID_6071,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6072
  *   盘式制动磨损报警功能
  */
void UDS_2EService_DID_6072(void)
{
  memcpy(&EOL_Data_Type.DID_6072,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6073
  * 挂车设置
  */
void UDS_2EService_DID_6073(void)
{
  memcpy(&EOL_Data_Type.DID_6073,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6074
  *  排放配置
  */
void UDS_2EService_DID_6074(void)
{
  memcpy(&EOL_Data_Type.DID_6074,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6075 
  *  超速报警车型信号 
  */
void UDS_2EService_DID_6075(void)
{
  memcpy(&EOL_Data_Type.DID_6075,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID6076
  *  总里程（注：当总里程被写成任何值时，短里程都应该为 0）
  */
void UDS_2EService_DID_6076(void)
{
  uint32_t temp;
  temp = toUint32_t(0x00u, DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1], DiagMSG.msgData.DidDetail.Data[2]);
  Data_Mileage_Clear();
  Data_ODO_Modify(temp * 10u);
  
  /*具体策略？？？？*/
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60C9
  *尿素箱容积
  */
void UDS_2EService_DID_60C9(void)
{
  memcpy(&EOL_Data_Type.DID_60C9,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CA 
  *主油箱容积
  */
void UDS_2EService_DID_60CA (void)
{
  memcpy(EOL_Data_Type.DID_60CA,DiagMSG.msgData.DidDetail.Data,sizeof(EOL_Data_Type.DID_60CA));
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CB  
  *副油箱容积
  */
void UDS_2EService_DID_60CB(void)
{
  memcpy(EOL_Data_Type.DID_60CB,DiagMSG.msgData.DidDetail.Data,sizeof(EOL_Data_Type.DID_60CB));
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CC  
  *油箱类型
  */
void UDS_2EService_DID_60CC(void)
{
  memcpy(&EOL_Data_Type.DID_60CC,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CD  
  *发动机类型
  */
void UDS_2EService_DID_60CD(void)
{
  memcpy(EOL_Data_Type.DID_60CD,DiagMSG.msgData.DidDetail.Data,sizeof(EOL_Data_Type.DID_60CD));
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CE  
  *TCU 类型
  */
void UDS_2EService_DID_60CE(void)
{
  memcpy(&EOL_Data_Type.DID_60CE,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60CF  
  *驱动能源类型
  */
void UDS_2EService_DID_60CF(void)
{
  memcpy(&EOL_Data_Type.DID_60CF,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60D0  
  *驱动形式 
  */
void UDS_2EService_DID_60D0(void)
{
  memcpy(&EOL_Data_Type.DID_60D0,DiagMSG.msgData.DidDetail.Data,1);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60D1  
  *蓄电池容量 
  */
void UDS_2EService_DID_60D1(void)
{
  memcpy(&EOL_Data_Type.DID_60D1,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}

/**
  *2E服务DID60D2  
  *电池管理系统 
  */
void UDS_2EService_DID_60D2(void)
{
  memcpy(&EOL_Data_Type.DID_60D2,DiagMSG.msgData.DidDetail.Data,1u);
  write2EData(WriteEOLData);
  UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
}
