/**************************************************************************//**
  * \file     Init.c
  * \brief    Initializations during work state switching
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Jan-2019
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "debugger.h"
#include "r_typedefs.h"
#include "Init.h"
#include "r_dev_clk_types.h"
#include "r_ddb_api.h"

#include "Analog_Signals.h"
#include "Clock.h"
#include "Emulated_EEPROM.h"
#include "GPIO.h"
#include "Internal_Flash.h"
#include "RTC.h"
#include "BU98R10.h"
#include "Watchdog.h"


#include "r_dev_api.h"
#include "r_wm_api.h"
#include "r_tick_api.h"


#include "rh850_macros.h"
#include "cpu.h"
#include "Graphic.h"
#include "Sys_Tick.h"
#include "RSCAN.h"
#include "SDRAM.h"
#include "sflash.h"

#include "sys_scheduler.h"

#include "RTE_ADC.h"
#include "COM_CAN.h"
#include "UDS_Common.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**************************************************************************//**
  * \brief      Initializations during work state switching
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Pre_Init(void)
{
    /* Release all Modules (except SDRAM controller) */
    Sys_Peripheral_Reset(SYS_PERI_RESETTABLE & (~SYS_PERI_SDRB0));

    /* Prepare device (clear all internal config, prepare interrupts) */
    R_DEV_Prepare();
    Clock_Pre_Init();
    RTC_Pre_Init();
    GPIO_Init(0);



    Mem_SDRAM_Init(MEM_SDRAM_2x_W9812G6KH_120MHz, Mem_SDRAM_DRV_25Ohm);
    //Mem_SDRAM_Init(MEM_SDRAM_2x_IS45S16800F_120MHz, Mem_SDRAM_DRV_25Ohm);

    Sys_Enable_Preload_Buffer();
}

/**************************************************************************//**
  * \brief      Initializations during system power up
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Init(void)
{
    Clock_Init();
    /* Enable interrupts globally */
    enable_interrupt();

    WDT_Init();

    /* init graphic tick driver */
    R_TICK_Init(0);

    Gfx_Init(GFX_VO_SINGLE_RGB888 | GFX_VI_ITU656);

    CPU_Init();

    RTC_Init();
    Sys_Tick_Timer_Start();
    /*COM_CAN_Init(); Ô­CAN³õÊ¼»¯Î»ÖÃ*/


    RTE_ADC_Init();


    Int_Flash_Init();
    EEPROM_Init();

    BU98R10_Init();

    /*EOL诊断 配置数据读取 DFLASH*/
    ReadAllDFlashData();

    /*读取K-LINE*/
    ReadDTCEOLValue_Meter_K_LINE();

    d_printf("Init complete!\n");

    InitSeriFlashExternReadMode();
    /*30电数据初始化*/
    APP_Startup_Init(Clock_Get_Startup_Mode());
    /*外发要用到EEP数据，位置移动*/
    COM_CAN_Init();
    Gfx_Sys_Start();
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system sleep
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Sleep_Init(void)
{
    Sys_Tick_Timer_Stop();
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system run
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Wakeup_Init(void)
{

}

