/**************************************************************************//**
  * \file     Sound_Track_Playback.h
  * \brief    Sound track play driver header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     11-Oct-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#ifndef _SOUND_TRACK_PLAYBACK_H_
#define _SOUND_TRACK_PLAYBACK_H_

/* Includes ------------------------------------------------------------------*/
//#include "include.h"
        //  #include "Sound_System.h"
          
     #include "TYW_stdint.h"   
                 
     
 #ifndef   SND_SYS_PCM_CHANNEL_ENABLE
#define   SND_SYS_PCM_CHANNEL_ENABLE        1
#endif



/////////////////////////
#if SND_SYS_PCM_CHANNEL_ENABLE
#include "PCM_Sound_Tracks.h"
#endif




/* C binding of definitions if building with C++ compiler */
/*#ifdef __cplusplus
extern  {
#endif
*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

extern void Sound_Track_Playback_Init ( void );

extern void Snd_PCM_Track_Play ( uint8_t TrackID, uint8_t Channel );
extern void Snd_PCM_Track_Repeat_Play ( uint8_t TrackID, uint8_t Channel );
extern void Snd_PCM_Track_Stop_Play ( uint8_t Channel );

extern void Snd_Gen_Track_Play ( uint8_t TrackID, uint8_t Channel );
extern void Snd_Gen_Track_Repeat_Play ( uint8_t TrackID, uint8_t Channel );
extern void Snd_Gen_Track_Stop_Play ( uint8_t Channel );

extern void Sound_Track_Playback_Service ( void );
/*
#ifdef __cplusplus
}
#endif
*/
#endif /* _SOUND_TRACK_PLAYBACK_H_ */