
#include "kwp2000_interface.h"
#include "UART.h"

#define BOARD_TMBCLK_HZ 32000000

/* physical and functional addresses for the ECU */
unsigned char kwp2000_PhysicalAddress;
unsigned char kwp2000_FunctionalAddress;
unsigned char kwp2000_ServerAddress;
unsigned int kwp2000_P3_MAX_LIMIT;

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_SetAddress
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_SetAddress(void)
{
    kwp2000_PhysicalAddress = KWP2000_ADDR_IC;
    kwp2000_FunctionalAddress = KWP2000_ADDR_OBD;
    kwp2000_ServerAddress = KWP2000_ADDR_SERVER;
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_SetTiming
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_SetTiming(void)
{
    kwp2000_P3_MAX_LIMIT = KWP2000_P3_MAX;
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscDisableRx
* Description    : 禁止收 使能发
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscDisableRx(void)
{
    Uart_DisableRx();
    Uart_EnableTx();
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscEnableRx
* Description    : 使能接收功能
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscEnableRx(void)
{
    /* enable receiver, clear all error flags */
    Uart_ClearAllErrorFlag();
    Uart_EnableRx();
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscTx
* Description    : 发送数据字节
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscTx(unsigned char *xBuffer_pu8)
{
    Uart_SetData(*xBuffer_pu8);
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscStart
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscStart(void)
{
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscStop
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscStop(void)
{
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscInit
* Description    : 串口模块初始化
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscInit(void)
{
    Kwp2000_AscStop(); // disable ASC_A mode

    /* disable interrupt service request, clear service request flags */
    /*预留设置*/

    /* enable receiver and transmitter function*/
    Uart_EnableRx();
    Uart_EnableTx();
    TJA1021_Enable(1);

    /* disable transmitter interrupt */
    //Uart_DisableTxInterrupt();  /*----20220309----*/

    ///  -----------------------------------------------------------------------
    ///  Configuration of the ASC0 Operation Mode:
    ///  -----------------------------------------------------------------------
    Uart_ConfigOperationMode();

    ///  -----------------------------------------------------------------------
    ///  Configuration of the used ASC0 Port Pins:
    ///  -----------------------------------------------------------------------
    Uart_SetTxGpio(); // TX
    Uart_SetRxGpio(); // RX

    ///  -----------------------------------------------------------------------
    ///  Configuration of priority of SCI_A interrupt:
    ///  -----------------------------------------------------------------------
    /*预留优先级设置*/

    /* Configuration of Baudrate , as 10400bps */
    Kwp2000_AscSwitchBaudrate(KWP2000_DEFAULT_BAUDRATE_KLINE_DU);

    Kwp2000_AscStart();

    /* clear service request flags */
    Uart_ClearRxFullFlag();
}

/*-------------------------------------------------------------------------
* Function Name  : Kwp2000_AscSwitchBaudrate
* Description    : 设置波特率
* Input          : xBaudrate_u32 波特率数值
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Kwp2000_AscSwitchBaudrate(unsigned long xBaudrate_u32)
{
    /* if configuration is valid, ... */
    if (xBaudrate_u32 != 0ul)
    {
        Kwp2000_AscStop();

        Uart_SetBaudrate(xBaudrate_u32);

        /* start ASC */
        Kwp2000_AscStart();
    }
}