#ifndef MEMU_H__
#define MEMU_H__

#include "TYW_stdint.h"

#ifdef GLOBALS_MEU_PROCESS
#define EXTERN_MEU_PROCESS
#else
#define EXTERN_MEU_PROCESS extern
#endif

#define K_Line_User_RYLQQ       100
#define K_Line_User_KQGZJ       100

#define _MN_IDX_NULL 0xff
#define _MN_IDX_NULL0 0x00
#define _MN_OPR_NULL (void *)0

typedef enum
{
    /*主界面*/
    _MN_DSP_LEVEL1MENU_1 = 0, /* 00 平均车速，平均油耗*/
    _MN_DSP_LEVEL1MENU_2,     /* 01 电池电量*/
    _MN_DSP_LEVEL1MENU_3,     /* 02 DPD*/
    _MN_DSP_LEVEL1MENU_4,     /* 03 油温-转速时间*/
    _MN_DSP_LEVEL1MENU_5,     /* 04 日历*/
    _MN_DSP_LEVEL1MENU_6,     /* 05 空白*/
    _MN_DSP_LEVEPOPUP,        /* 06 报警界面显示*/

    /*一级菜单*/
    _MN_DSP_LEVEL2MENU_1, /* 07 故障码*/
    _MN_DSP_LEVEL2MENU_2, /* 08 保养通知*/
    _MN_DSP_LEVEL2MENU_3, /* 09 保养通知设定*/
    _MN_DSP_LEVEL2MENU_4, /* 10 用户设定*/
    _MN_DSP_LEVEL2MENU_5, /* 11 系统演示模式*/
    _MN_DSP_LEVEL2MENU_6, /* 12 轮胎状态显示*/

    /*二级菜单*/
    _MN_DSP_LEVEL2_1_MENU_1, /* 13 故障码*/

    _MN_DSP_LEVEL2_2_MENU_1, /* 14 发动机机油&滤清器*/
    _MN_DSP_LEVEL2_2_MENU_2, /* 15 燃油滤清器*/
    _MN_DSP_LEVEL2_2_MENU_3, /* 16 变速箱油*/
    _MN_DSP_LEVEL2_2_MENU_4, /* 17 差速器油*/
    _MN_DSP_LEVEL2_2_MENU_7, /* 18 动力转向液*/
    _MN_DSP_LEVEL2_2_MENU_8, /* 19 轮胎*/

    _MN_DSP_LEVEL2_3_MENU_1, /* 20 更换机油＆机油滤清器*/
    _MN_DSP_LEVEL2_3_MENU_2, /* 21 更换燃油滤清器*/
    _MN_DSP_LEVEL2_3_MENU_3, /* 22 更换变速箱油*/
    _MN_DSP_LEVEL2_3_MENU_4, /* 23 更换差速器油*/
    _MN_DSP_LEVEL2_3_MENU_6, /* 24 更换动力转向液*/
    _MN_DSP_LEVEL2_3_MENU_7, /* 25 轮胎换位・更换*/

    _MN_DSP_LEVEL2_4_MENU_1, /* 26 设定日期*/
    _MN_DSP_LEVEL2_4_MENU_2, /* 27 设定时间*/
    _MN_DSP_LEVEL2_4_MENU_7, /*    亮度调节*/
    _MN_DSP_LEVEL2_4_MENU_3, /* 28 语言设定*/
    _MN_DSP_LEVEL2_4_MENU_4, /* 29 设定节油驾驶建议*/
    _MN_DSP_LEVEL2_4_MENU_5, /* 30 TPMS轮胎设定*/
    _MN_DSP_LEVEL2_4_MENU_6, /* 31 显示设定*/

    _MN_DSP_LEVEL2_5_MENU_1, /* 32 LDWS 警报演示*/
    _MN_DSP_LEVEL2_5_MENU_2, /* 33 AEBS第1警报演示*/
    _MN_DSP_LEVEL2_5_MENU_3, /* 34 AEBS第2警报演示*/
    _MN_DSP_LEVEL2_5_MENU_4, /* 35 AEBS全力制动警报演示*/

    _MN_DSP_LEVEL2_6_MENU_1, /* 36 轮胎气压*/
    _MN_DSP_LEVEL2_6_MENU_2, /* 37 轮胎温度*/

    /*三级菜单*/
    _MN_DSP_LEVEL3_2_MENU_1, /* 38 发动机机油＆滤清器*/
    _MN_DSP_LEVEL3_2_MENU_2, /* 39 燃油滤清器*/
    _MN_DSP_LEVEL3_2_MENU_3, /* 40 变速箱油*/
    _MN_DSP_LEVEL3_2_MENU_4, /* 41 差速器油*/
    _MN_DSP_LEVEL3_2_MENU_7, /* 42 动力转向液*/
    _MN_DSP_LEVEL3_2_MENU_8, /* 43 轮胎*/

    _MN_DSP_LEVEL3_3_MENU_1, /* 44 更换机油＆机油滤清器*/
    _MN_DSP_LEVEL3_3_MENU_2, /* 45 更换燃油滤清器*/
    _MN_DSP_LEVEL3_3_MENU_3, /* 46 更换变速箱油*/
    _MN_DSP_LEVEL3_3_MENU_4, /* 47 更换差速器油*/
    _MN_DSP_LEVEL3_3_MENU_6, /* 48 更换动力转向液*/
    _MN_DSP_LEVEL3_3_MENU_7, /* 49 轮胎换位・更换*/

    _MN_DSP_LEVEL3_4_MENU_11, /* 50 设定日期-年*/
    _MN_DSP_LEVEL3_4_MENU_12, /* 51 设定日期-月*/
    _MN_DSP_LEVEL3_4_MENU_13, /* 52 设定日期-日*/
    _MN_DSP_LEVEL3_4_MENU_21, /* 53 设定时间-时*/
    _MN_DSP_LEVEL3_4_MENU_22, /* 54 设定时间-分*/
    _MN_DSP_LEVEL3_4_MENU_3,  /* 55 设定语言*/
    _MN_DSP_LEVEL3_4_MENU_41, /* 56 速度设定－高速路*/
    _MN_DSP_LEVEL3_4_MENU_42, /* 57 速度设定－一般路*/
    _MN_DSP_LEVEL3_4_MENU_43, /* 58 发动机转速设定*/
    _MN_DSP_LEVEL3_4_MENU_44, /* 59 急加速设定*/
    _MN_DSP_LEVEL3_4_MENU_45, /* 60 急减速设定*/
    _MN_DSP_LEVEL3_4_MENU_46, /* 61 长时间怠速设定*/
    _MN_DSP_LEVEL3_4_MENU_47, /* 62 辅助驻车解除设定*/
    _MN_DSP_LEVEL3_4_MENU_5,  /* 63 轮胎匹配画面*/
    _MN_DSP_LEVEL3_7_MENU_1,  /*    亮度调节*/

    /*四级菜单*/
    _MN_DSP_LEVEL4_4_MENU_1, /* 64 速度设定-高速路*/
    _MN_DSP_LEVEL4_4_MENU_2, /* 65 速度设定-一般路*/
    _MN_DSP_LEVEL4_4_MENU_3, /* 66 发动机转速设定*/
    _MN_DSP_LEVEL4_4_MENU_4, /* 67 急加速设定*/
    _MN_DSP_LEVEL4_4_MENU_5, /* 68 急减速设定*/
    _MN_DSP_LEVEL4_4_MENU_6, /* 69 长时间怠速设定*/
    _MN_DSP_LEVEL4_4_MENU_7, /* 70 辅助驻车解除设定*/

    /*特殊界面*/
    _MN_DSP_ENTER_MENU,  /* 71 确认*/
    _MN_DSP_RETURN_MENU, /* 72 返回*/

    _MN_DSP_LEVEL3_5_MENU_1, /* 73 LDWS 警报演示*/
    _MN_DSP_LEVEL3_5_MENU_2, /* 74 AEBS第1警报演示*/
    _MN_DSP_LEVEL3_5_MENU_3, /* 75 AEBS第2警报演示*/
    _MN_DSP_LEVEL3_5_MENU_4, /* 76 AEBS全力制动警报演示*/

} _MenuCode;

typedef uint8_t _MENU_IDX;
typedef struct
{
    _MENU_IDX VK_IDX_ENTER;
    _MENU_IDX VK_IDX_UP;
    _MENU_IDX VK_IDX_DOWN;
    _MENU_IDX VK_IDX_EXIT;

    void (*Enter)(void);
    void (*Do)(void);
    void (*Exit)(void);
} _MenuOptTab;

typedef struct
{
    uint8_t Menu_Flag;            /*主界面标记*/
    uint8_t Menu_Time_Flag;       /*从Enter界面确认退出计时*/
    uint8_t Menu_Enter_Return;    /*进入Enter之前界面*/
    uint8_t Menu_Return;          /*Enter Return界面切换标记*/
    uint8_t Menu_Key_Time;        /*按键长按时间记录*/
    uint16_t Key_Menu_Popup_time; /*上述状态持续时间*/
    uint8_t Key_Menu_Popup_Flag;  /*报警界面menu按键长按 */
    uint8_t Menu_Light_Time;
    uint8_t Menu_Light_Time_Flag;
} _MenuFlag;

EXTERN_MEU_PROCESS _MenuFlag MenuFlag;

EXTERN_MEU_PROCESS uint8_t bMenuSwFlag;
EXTERN_MEU_PROCESS uint8_t g_ClearWin1;
EXTERN_MEU_PROCESS uint8_t bNextMenuIDX; // the next index of menu .
EXTERN_MEU_PROCESS uint8_t bCurMenuIDX;  // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bMainMenuIDX; // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bOldMenuIDX;  // the Old index of menu.

EXTERN_MEU_PROCESS const _MenuOptTab MenuOptTab[]; // add
EXTERN_MEU_PROCESS void NextMenu(_MENU_IDX idx);
EXTERN_MEU_PROCESS void MenuInit(void);
EXTERN_MEU_PROCESS void MenuManage(void);

EXTERN_MEU_PROCESS void Level1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelPopup_Enter(void);
EXTERN_MEU_PROCESS void LevelPopup_Do(void);
EXTERN_MEU_PROCESS void LevelPopup_Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_5Do(void);
EXTERN_MEU_PROCESS void Level2Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_8Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_8Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_8Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_6Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_6Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_6Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_6Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_6Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_6Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_6Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_7Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_8Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_8Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_8Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_4Exit(void);

//EXTERN_MEU_PROCESS void Level3_3Menu_5Enter(void);
//EXTERN_MEU_PROCESS void Level3_3Menu_5Do(void);
//EXTERN_MEU_PROCESS void Level3_3Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_6Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_7Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_3(void);

EXTERN_MEU_PROCESS void Level3_4Menu_2Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_2Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_3(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_4(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_4(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_4(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_5(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_5(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_5(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_6(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_6(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_6(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_7(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_7(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_7(void);

EXTERN_MEU_PROCESS void Level3_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level3_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level3_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Do(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_1Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_2Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_4Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_6Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_7Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level_Enter_Menu_Enter(void);
EXTERN_MEU_PROCESS void Level_Enter_Menu_Do(void);
EXTERN_MEU_PROCESS void Level_Enter_Menu_Exit(void);

EXTERN_MEU_PROCESS void Level_Return_Menu_Enter(void);
EXTERN_MEU_PROCESS void Level_Return_Menu_Do(void);
EXTERN_MEU_PROCESS void Level_Return_Menu_Exit(void);

#endif
