

#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "TYW_stdint.h"
//#include "PCM_Sound_Tracks.h"
//#include "Sound_Tracks.h"
#include "Buzzer.h"
/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
typedef enum
{
    SND_SRC_Key_Notremoved = 0x00  , /*00 忘拔钥匙        */
    SND_SRC_Braking         ,        /*01 制动           */
    SND_SRC_Air_Brake       ,        /*02 制动气压        */
    SND_SRC_BRAKE_LOCK      ,        /*03 BRAKE LOCK     */
    SND_SRC_Parking_Brake   ,        /*04 停车制动忘记复位  */
    SND_SRC_Car_Dump_SPEED  ,        /*05 车厢报警自卸蜂鸣器*/
    SND_SRC_Temp_High       ,        /*06 水温过热         */
    SND_SRC_Coolant_Low     ,        /*07 冷却水量         */
    SND_SRC_Oil_pressure_Low,        /*08 -(预留：油压)     */
    SND_SRC_ACC_AIR         ,        /*09 ACC AIR         */
    SND_SRC_BackUP_SPEED    ,        /*10 倒车警报         */
    SND_SRC_DS_SPEED        ,        /*11 DS 警报          */
    SND_SRC_ROWS_SPEED      ,        /*12 ROWS 警报        */
    SND_SRC_Roll_SPEED      ,        /*13 Roll 警报        */
    SND_SRC_EVSC_SPEED      ,        /*14 EVSC             */
    SND_SRC_DPD_SPEED1      ,        /*15 DPD 手动再生      */
    SND_SRC_DPD_SPEED2      ,        /*15 DPD 手动再生      */
    SND_SRC_DPD_SPEED4      ,        /*15 DPD 手动再生      */
    SND_SRC_NEES            ,        /*16 NEES             */
    SND_SRC_ECO_STOP        ,        /*17 eco stop         */
    SND_SRC_Cyclone_High4HZ ,        /*18 气悬车高调整       */
    SND_SRC_Cyclone_High0_5 ,        /*18 气悬车高调整       */
    SND_SRC_SEATBELT_SPEED  ,        /*19 安全带            */
    SND_SRC_Fuel_Saving     ,        /*20 省油耗建议         */
    SND_SRC_TICK            ,        /*21 转向              */
    SND_SRC_TOCK            ,        /*22 转向              */

    SND_SRC_INDEX_MAX,
} SND_SRC_Index_en_t;

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define   SND_SRC_NONE                      0xFF    //没有声音
#define   SND_SRC_CURRENT                   0xFE    //当前播放的声音

/******************************************************************************
音源循环次数
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFF    //不停播放

/******************************************************************************
音源播放模式
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00    //使用ISD_Play_Vp方法播放
#define   SND_MODE_LOOP                     0x01    //使用ISD_Play_Vp_Loop方法播放

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    BUZZER_Track_Index_en_t  Index;
    uint8_t   Priority;
    uint8_t   Cycle;
    uint8_t   Mode;
    uint16_t  Period;
} SndAttributeStruct;

/******************************************************************************
音源属性表
******************************************************************************/
static const SndAttributeStruct SndAttributeTable[SND_SRC_INDEX_MAX] =
{
    /*================================================================================================
                  音源名称                      | 音源序号      | 优先级 |     循环次数     |    播放模式    | 周期(ms)
    ------------------------------------------------------------------------------------------------*/
    {/*00 SND_SRC_Key_Notremoved  */  BUZZER_Track_Index_Tic,   1,   1,  SND_MODE_SINGLE,   1000U,   },/*00 1HZ 忘拔钥匙    */
    {/*01 SND_SRC_Braking         */  BUZZER_Track_Index_Tic,   2,   1,  SND_MODE_SINGLE,    100U,   },/*01 连续 制动       */
    {/*02 SND_SRC_Air_Brake       */  BUZZER_Track_Index_Tic,   3,   1,  SND_MODE_SINGLE,    100U,   },/*02 连续 制动气压    */
    {/*03 SND_SRC_BRAKE_LOCK      */  BUZZER_Track_Index_Tic,   4,   1,  SND_MODE_SINGLE,    100U,   },/*03      BRAKE LOCK */
    {/*04 SND_SRC_Parking_Brake   */  BUZZER_Track_Index_Tic,   5,   1,  SND_MODE_SINGLE,    100U,   },/*04      停车制动忘记复位*/
    {/*05 SND_SRC_Car_Dump_SPEED  */  BUZZER_Track_Index_Tic,   6,   1,  SND_MODE_SINGLE,    100U,   },/*05      车厢报警自卸蜂鸣器*/
    {/*06 SND_SRC_Temp_High       */  BUZZER_Track_Index_Tic,   7,   1,  SND_MODE_SINGLE,    100U,   },/*06 连续 水温过热 */
    {/*07 SND_SRC_Coolant_Low     */  BUZZER_Track_Index_Tic,   8,   1,  SND_MODE_SINGLE,    100U,   },/*07 连续 冷却水量 */
    {/*08 SND_SRC_Oil_pressure_Low*/  BUZZER_Track_Index_Tic,   9,   1,  SND_MODE_SINGLE,    100U,   },/*08      -(预留：油压)*/
    {/*09 SND_SRC_ACC_AIR         */  BUZZER_Track_Index_Tic,  10,   1,  SND_MODE_SINGLE,    100U,   },/*09 连续 ACC AIR */
    {/*10 SND_SRC_BackUP_SPEED    */  BUZZER_Track_Index_Tic,  11,   1,  SND_MODE_SINGLE,   1000U,   },/*10 1HZ 倒车警报  */
    {/*11 SND_SRC_DS_SPEED        */  BUZZER_Track_Index_Tic,  12,   1,  SND_MODE_SINGLE,    100U,   },/*11     DS 警报   */
    {/*12 SND_SRC_ROWS_SPEED      */  BUZZER_Track_Index_Tic,  13,   1,  SND_MODE_SINGLE,    100U,   },/*12     ROWS 警报 */
    {/*13 SND_SRC_Roll_SPEED      */  BUZZER_Track_Index_Tic,  14,   1,  SND_MODE_SINGLE,    100U,   },/*13     Roll 警报 */
    {/*14 SND_SRC_EVSC_SPEED      */  BUZZER_Track_Index_Tic,  15,   1,  SND_MODE_SINGLE,    100U,   },/*14 4HZ EVSC */
    {/*15 SND_SRC_DPD_SPEED       */  BUZZER_Track_Index_Tic,  16,   1,  SND_MODE_SINGLE,    100U,   },/*15 1HZ 3 DPD 手动再生 */
    {/*15 SND_SRC_DPD_SPEED       */  BUZZER_Track_Index_Tic,  16,   1,  SND_MODE_SINGLE,    100U,   },/*15 2HZ 3 DPD 手动再生 */
    {/*15 SND_SRC_DPD_SPEED       */  BUZZER_Track_Index_Tic,  16,   1,  SND_MODE_SINGLE,    100U,   },/*15 4HZ 3 DPD 手动再生 */
    {/*16 SND_SRC_NEES            */  BUZZER_Track_Index_Tic,  17,   1,  SND_MODE_SINGLE,    100U,   },/*16     NEES */
    {/*17 SND_SRC_ECO_STOP        */  BUZZER_Track_Index_Tic,  18,   1,  SND_MODE_SINGLE,    100U,   },/*17     eco stop */
    {/*18 SND_SRC_Cyclone_High    */  BUZZER_Track_Index_Tic,  19,   1,  SND_MODE_SINGLE,    100U,   },/*18 4HZ   气悬车高调整 */
    {/*18 SND_SRC_Cyclone_High    */  BUZZER_Track_Index_Tic,  19,   1,  SND_MODE_SINGLE,    100U,   },/*18 0.5HZ 气悬车高调整 */
    {/*19 SND_SRC_SEATBELT_SPEED  */  BUZZER_Track_Index_Tic,  20,   1,  SND_MODE_SINGLE,    100U,   },/*19 2HZ 安全带 */
    {/*20 SND_SRC_Fuel_Saving     */  BUZZER_Track_Index_Tic,  21,   1,  SND_MODE_SINGLE,    100U,   },/*20 1HZ省油耗建议 */
    {/*21 SND_SRC_TICK            */  0000u,  22,   1,  SND_MODE_SINGLE,    100U,   },
    {/*22 SND_SRC_TOCK            */  0001u,  23,   1,  SND_MODE_SINGLE,    100U,   },

    /*==============================================================================================*/
};



#define   SND_TOTAL_NUM              SND_SRC_INDEX_MAX//       (sizeof(SndAttributeTable) / sizeof(SndAttributeStruct))

#endif
