/**********************************************************************************************************
* @file    loc_graphics_data.h
* @author  HZS
* @version V1.0.0
* @date    2021.04.09
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_DEF_H_
#define LOC_GRAPHICS_DEF_H_

#include "r_typedefs.h"
#include "r_ddb_api.h"
#include "r_cdi_api.h"
#include "r_wm_api.h"
#include "r_drw2d_os.h"
#include "r_drw2d_api.h"
#include "loc_graphics.h"

typedef struct
{
    uint32_t Count;
    void *Buffer[4];
    r_wm_Sprite_t Sprite;
    uint32_t VoIndex;
    uint32_t DrawIndex;
    r_drw2d_Framebuffer_t DrawFb;
} MultiBufferSprite_t;

typedef struct
{
    uint16_t u16PosX;
    uint16_t u16PosY;
    uint16_t u16Width;
    uint16_t u16Height;
    uint16_t u16Layer;
} SpriteAttr_t;

typedef struct
{
    SpriteName_t           stSpriteID;
    SpriteAttr_t           stAttr;
    SpriteTarge_t          taget_mem;
    MultiBufferSprite_t   *pSpriteBuf;
    uint8_t               *pIndex;
    LogicLayerAttr_t      *pLogicLayerAttr;
    uint8_t                MaxLogicLayer;
    uint8_t               *pUpdate;
    uint8_t               *pEn;
    void (*GUI_N_Display)(void);
} SpritesHandler_t;

#endif
