/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Kernel debug mode support functions
 *  Platform: Altera NIOSII 
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 5998 $
 *  $Date: 2015-09-18 14:23:26 +0200 (Fr, 18. Sep 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

/*******************************************************************************
  Section: Includes
*/

#include "davehd_kernel_os.h"
#include "davehd_kernel_driver.h"
#include "davehd_kernel_debug.h"
#include "davehd_os_hw.h"

#ifdef DHD_KERNEL_DEBUG

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

/*******************************************************************************
  Section: Global Functions
*/



/*----------------------------------------------------------------------------------------------------------*/
/* Process a formatted debug message. The platform has to process the printf syntax, guard against other*/
/* threads (take some lock) and call dhd_gpu_debug_nextnote */
/**/
/* Parameters:*/
/*  a_device - kernel device structure.*/
/*  a_format - printf style format string.*/
/**/

/***********************************************************
  Function: dhd_gpu_debug_note
*/
void dhd_gpu_debug_note(dhd_gpu_device_data_t *a_device, dhd_char_t *a_format, ... ) {  
  va_list args;  
  dhd_int32_t len;
  dhd_gpu_debug_message_t *message;
  dhd_gpu_debug_data_t *data = a_device->m_debug_data;

  if (data == 0) {
    /* debug not enabled for this device*/
    return;
  }

  /* add message to log*/
  dhd_enter_lock(data->m_message_lock);
  message = (dhd_gpu_debug_message_t *) DHD_INC_PTR( data->m_message_buffer, data->m_writepos );  

  va_start(args, a_format);
  len = vsnprintf(message->m_message, DHD_MAX_DEBUG_MESSAGE_SIZE, a_format, args );
  va_end(args);
  
  /* advance writepos (must be still inside message_lock)  */
  dhd_gpu_debug_nextnote( a_device, len );
  dhd_exit_lock(data->m_message_lock);
}



/***********************************************************
  Function: dhd_gpu_debug_internal_output
*/

/* note: must not take message_lock */
void dhd_gpu_debug_internal_output(dhd_gpu_device_data_t *a_device, dhd_gpu_debug_message_t *a_message) {

  printf("%s\n", a_message->m_message);

}


#endif /* DHD_KERNEL_DEBUG */

