#ifndef CPU_H__
#define CPU_H__
#include <v800_ghs.h>

#define _INLINE_ inline
#ifndef u32_T
#define u32_T unsigned long
#endif
#define PSW          5, 0        /* Program status word Note 1 */
#define EBASE        3, 1        /* Exception handler vector address SV */
/* Basic control registers type definitions */
typedef union {
    u32_T     psw;               /* PSW, 32-bit access */
    struct {
        u32_T   Z:1,             /* Bit 0, zero */
                S:1,             /* Bit 1, sign */
                OV:1,            /* Bit 2, overflow */
                CY:1,            /* Bit 3, carry */
                SAT:1,           /* Bit 4, saturated */
                ID:1,            /* Bit 5, interrupt enable (0:enabled) */
                EP:1,            /* Bit 6, exception in process (0:interupt is processed */
                NP:1,            /* Bit 7, FE exception enable (0:enabled) */
                rsvd1:1,         /* Bit 8, reserved */
                DBG:3,           /* Bit 9-11, debug */
                rsvd2:3,         /* Bit 12-14, reserved */
                EBV:1,           /* Bit 15, 0:RBASE or 1:EBASE is used as exception processing base */
                CU0:1,           /* Bit 16, FPU */
                CU1:1,           /* Bit 17, reserved */
                CU2:1,           /* Bit 18, reserved */
                rsvd3:11,        /* Bit 19-29, reserved */
                UM:1,            /* Bit 30, User mode (0:supervisor, 1:user mode) */
                rsvd4:1;         /* Bit 31, reserved */
    };
} PSW_T;



_INLINE_ void SET_PSW_EBV( void)
{ 
    PSW_T p;
    __DI() ;
    p.psw= __STSR( PSW); 
    p.EBV= 1;
    __LDSR( PSW, p.psw);
}


_INLINE_ void SET_EBASE( u32_T v)
{ 
    u32_T __t=__DIR(); 
    __LDSR( EBASE, v);
    __RIR( __t);
}




extern void CPU_Init(void);

#endif
