#include "CAN_FUNC.h"
#include "CAN_Communication_Matrix.h"
/*增加外发计算部分引用文件*/
#include "Common_Interface.h"
#include "Gauges.h"
#include "GaugesInterface.h"

#include "Telltales.h"

#include "GUI.h"
#include "Data_CoolantTemperature.h"
#include "Data_Voltmeter.h"
#include "Data_AirPressure.h"
#include "Individual_ECU_Comm.h"
#include "RTE_TIME.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "Data_Fuel_User.h"

#include "Line_in.h"

/*---------------------------------------------------------------------------
使用しない Byte、bit に関しては全て 1(B)をセットして出力すること
对于不使用的Byte、bit，全部设置1(B)并输出
----------------------------------------------------------------------------*/
USER_ECU User_ECU;
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEAE17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        //0～FA:0～2000 [kPa] FB～FF:Not used // Factor:8
        uint8_t Main_Air_Pressure               : 8 ;//WET 预留

        uint8_t Not_used0                       : 2 ;
        uint8_t Not_used1                       : 2 ;
        uint8_t Not_used2                       : 2 ;
        uint8_t Not_used3                       : 2 ;
        //0～FA:0～2000 [kPa] FB～FF:Not used // Factor:8
        uint8_t Service_Brake_Circuit1_AirPressure          : 8 ;
        //0～FA:0～2000 [kPa] FB～FF:Not used // Factor:8
        uint8_t Service_Brake_Circuit2_AirPressure          : 8 ;

        uint8_t Not_used4                       : 8 ;
        //0～2D0:0～36 [V] 2D1～FFFF:Not used // Factor:0.05
        uint8_t Power_Supply_Voltage_L          : 8 ;
        uint8_t Power_Supply_Voltage_H          : 8 ;

        uint8_t SW_ECONO                        : 2 ;
        uint8_t Rader_Stain_Information         : 2 ;
        uint8_t Not_used5                       : 2 ;
        uint8_t Parking_Brake_Switch            : 2 ;
    } bit;
} _Msg18FEAE17Map;

void Can_Set_Buff_18FEAE17(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FEAE17Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }
    MsgMap.bit.Service_Brake_Circuit1_AirPressure = (uint8_t)(AirPressure_Get_kPa(0) >> 3) ;
    MsgMap.bit.Service_Brake_Circuit2_AirPressure = (uint8_t)(AirPressure_Get_kPa(1) >> 3) ;

    if (RTE_Read_KL30_Valid())
    {

        MsgMap.bit.Power_Supply_Voltage_L = (uint8_t)(RTE_Read_KL30_Voltage() / 50);
        MsgMap.bit.Power_Supply_Voltage_H = (uint8_t)((RTE_Read_KL30_Voltage() / 50) >> 8);

    }
    else
    {
        MsgMap.bit.Power_Supply_Voltage_L = 0;
        MsgMap.bit.Power_Supply_Voltage_H = 0;
    }

    if (Line_In_Get_Status(LINE_IN_PARK_BRAKE))
    {
        MsgMap.bit.Parking_Brake_Switch = 1 ;
    }
    else
    {
        MsgMap.bit.Parking_Brake_Switch = 0 ;
    }

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF3E17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {

        uint16_t Pulse_Correction_Facor         : 16 ;

        uint8_t Not_used0                       : 1 ;
        uint8_t HID_Auto_Leveling               : 1 ;
        uint8_t Not_used1                       : 1 ;
        uint8_t Not_used2                       : 1 ;
        uint8_t AEBS_ON_OFF_Info                : 2 ;
        uint8_t Not_used3                       : 1 ;
        uint8_t SW_PTO                          : 1 ;

        uint8_t Not_used4                       : 7 ;
        uint8_t MIL_Lamp_Status                 : 1 ;

        uint8_t Fuel_Gauges_AD_Value            : 8 ;

        uint8_t Not_used5                       : 8 ;

        uint8_t Not_used6                       : 8 ;

        uint8_t DstWarnVolume_Set               : 3 ;
        uint8_t Not_used7                       : 1 ;
        uint8_t Not_used8                       : 1 ;
        uint8_t TURN_L_Lamp_Status              : 1 ;
        uint8_t Not_used9                       : 1 ;
        uint8_t Not_used10                       : 1 ;
    } bit;
} _Msg18FF3E17Map;
void Can_Set_Buff_18FF3E17(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FF3E17Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }



    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FED917
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t Not_used0                       : 4 ;
        uint8_t BlendingSwitchPosition          : 2 ;
        uint8_t Not_used1                       : 2 ;

        uint8_t Not_used2                       : 2 ;
        uint8_t TralierABSFullyOperational      : 2 ;
        uint8_t TralierABSDitected              : 2 ;
        uint8_t TralierConnected                : 2 ;

        uint8_t Not_used3                       : 8 ;
        uint8_t Not_used4                       : 8 ;
        uint8_t Not_used5                       : 8 ;
        uint8_t Not_used6                       : 8 ;
        uint8_t Not_used7                       : 8 ;
        uint8_t Not_used8                       : 8 ;

    } bit;
} _Msg18FED917Map;
void Can_Set_Buff_18FED917(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FED917Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }



    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE617
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t Seconds                         : 8 ;//Factor 0.25
        uint8_t Minutes                         : 8 ;
        uint8_t Hours                           : 8 ;
        uint8_t Month                           : 8 ;
        uint8_t Day                             : 8 ;//Factor 0.25
        uint8_t Year                            : 8 ;//Offset 1985
        uint8_t Not_used                        : 8 ;
        uint8_t Not_used1                       : 8 ;
    } bit;
} _Msg18FEE617Map;
void Can_Set_Buff_18FEE617(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FEE617Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }

    MsgMap.bit.Seconds = Get_RTC_SECOND() << 2;
    MsgMap.bit.Minutes = Get_RTC_MINUTE();
    MsgMap.bit.Hours   = Get_RTC_HOUR();
    MsgMap.bit.Day     = Get_RTC_DATE() << 2 ;
    MsgMap.bit.Month   = Get_RTC_MONTH();
    MsgMap.bit.Year    = Get_RTC_YEAR() + 15;

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF1817
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/

const uint8_t IDAE17_TYTE_DATA[ID18FEAE17_TYPE_MAX] = {0x50, 0x51, 0x52, 0x53, 0x54, 0x60, 0x61, 0x62, 0x63, 0x64, 0x20, 0x22, 0x30};

static const uint8_t  IDAE17_SendOrder[ID18FEAE17_TYPE_MAX][2U] =
{
    //        A                                   B
    {ID_AlarmThreshold                 , ID_TripA_AvrFuelCost              },
    {ID_TripA_AvrFuelCost              , ID_TripA_AvrSpeed                 },
    {ID_TripA_AvrSpeed                 , ID_TripA_ConsDyeingFee            },
    {ID_TripA_ConsDyeingFee            , ID_TripA_IdleSpeedTime            },
    {ID_TripA_IdleSpeedTime            , ID_TripA_RunTime                  },
    {ID_TripA_RunTime                  , ID_TripB_AvrFuelCost              },
    {ID_TripB_AvrFuelCost              , ID_TripB_AvrSpeed                 },
    {ID_TripB_AvrSpeed                 , ID_TripB_ConsDyeingFee            },
    {ID_TripB_ConsDyeingFee            , ID_TripB_IdleSpeedTime            },
    {ID_TripB_IdleSpeedTime            , ID_TripB_RunTime                  },
    {ID_TripB_RunTime                  , ID_ResidualDistance               },
    {ID_ResidualDistance               , ID_HowMany                        },
    {ID_HowMany                        , ID_AlarmThreshold                 },
};
//Byte：6为最高级别Byte，Byte：3为最低级别Byte
void Can_Set_Buff_18EF1817(uint8_t CopyData [])
{
    static uint8_t  Count = 0 ;
    uint8_t Type ;
    uint8_t i = 0 ;
    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = 0xff ;
    }

    Meter_RequestCode_Update();
    CopyData[ 0 ] = Get_Meter_RequestCode();
    if (Get_Meter_RequestID() == METER_CODE_DATA_T_REQ)
    {
        //A
        Type = IDAE17_SendOrder[Count][0];
        //B
        //Type = IDAE17_SendOrder[Count][1];

        CopyData[ 1 ] = IDAE17_TYTE_DATA[Type] ;

        if (Get_ECU_RespSure())
        {
            CopyData[ 2 ] = (uint8_t)Get_ECU_Data(Type);
            CopyData[ 3 ] = (uint8_t)(Get_ECU_Data(Type) >> 8);
            CopyData[ 4 ] = (uint8_t)(Get_ECU_Data(Type) >> 16);
            CopyData[ 5 ] = (uint8_t)(Get_ECU_Data(Type) >> 24);
        }
        else
        {
            CopyData[ 2 ] = 0xff ;
            CopyData[ 3 ] = 0xff ;
            CopyData[ 4 ] = 0xff ;
            CopyData[ 5 ] = 0xff ;

        }

        Count ++ ;
        if (Count >= ID18FEAE17_TYPE_MAX)
        {
            Count = 0 ;
        }
    }
    else
    {
        CopyData[ 1 ] = IDAE17_TYTE_DATA[Get_Meter_RequestType()] ;
        if (Get_ECU_RespSure())
        {
            Set_Meter_RequestCode(METER_CODE_DATA_T_REQ, ID_TripA_AvrFuelCost, 0);
        }
        else
        {

            CopyData[ 2 ] = (uint8_t)Get_Meter_RequestData(Type);
            CopyData[ 3 ] = (uint8_t)(Get_Meter_RequestData(Type) >> 8);
            CopyData[ 4 ] = (uint8_t)(Get_Meter_RequestData(Type) >> 16);
            CopyData[ 5 ] = (uint8_t)(Get_Meter_RequestData(Type) >> 24);
        }
    }
    //0xFF固定送信
    CopyData[ 6 ] = 0xff ;
    CopyData[ 7 ] = 0xff ;

}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE017
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        //uint32_t Not_used                        : 32 ;
        //uint32_t Total_Vehicle_Distance          : 32 ; //Factor 0.125
        uint8_t Not_used                        : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
        uint8_t                         : 8 ;
    } bit;
} _Msg18FEE017Map;
void Can_Set_Buff_18FEE017(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FEE017Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }

    //MsgMap.bit.Total_Vehicle_Distance = (Data_ODO_Read()/10) << 3 ;

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEFC17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t WasherFluidLevel                         : 8 ;//Factor 0.4
        uint8_t FuelLevel_1                              : 8 ;//Factor 0.4
        uint8_t EngFuelFilterDiffPressure                : 8 ;//Factor 2
        uint8_t EngOilFilterDiffPressure                 : 8 ;//Factor 0.5
        uint16_t CargoAmbientTemperature                  : 16;//Factor 0.03125  Offset -273
        uint8_t FuelLevel_2                              : 8 ;//Factor 0.4
        uint8_t EngOilFilterDiffPressure_ExtRange        : 8 ;//Factor 5
    } bit;
} _Msg18FEFC17Map;
void Can_Set_Buff_18FEFC17(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FEFC17Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }



    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2517
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t Year                                  : 8 ;//0～63: 0～99 [Year]
        uint8_t Month                                 : 8 ;//1～C: 1～12 [Month]
        uint8_t Day                                   : 8 ;//1～1F: 1～31 [Day]
        uint8_t Hour                                  : 8 ;//0～18:0～24 [Hour]
        uint8_t Minute                                : 8 ;//0～3B: 0～59 [Minute]
        uint8_t ODOMeter_L                            : 8 ;
        uint8_t ODOMeter_M                            : 8 ;
        uint8_t ODOMeter_H                            : 8 ;
    } bit;
} _Msg18FF2517Map;
void Can_Set_Buff_18FF2517(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FF2517Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }

    MsgMap.bit.Year = Get_RTC_YEAR() ;
    MsgMap.bit.Month = Get_RTC_MONTH() ;
    MsgMap.bit.Hour = Get_RTC_HOUR() ;
    MsgMap.bit.Day = Get_RTC_DATE() ;
    MsgMap.bit.Year = Get_RTC_YEAR() ;
    MsgMap.bit.Minute = Get_RTC_MINUTE() ;
    MsgMap.bit.ODOMeter_L = (uint8_t)(Data_ODO_Read() / 10) ;
    MsgMap.bit.ODOMeter_M = (uint8_t)((Data_ODO_Read() / 10) >> 8)  ;
    MsgMap.bit.ODOMeter_H = (uint8_t)((Data_ODO_Read() / 10) >> 16) ;

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2A17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t Meter_Malfunction               : 2 ;
        uint8_t Over_Heat_Warning_Status        : 1 ;
        uint8_t Battery_Maintenance_Warning     : 2 ;
        uint8_t Remining_Fuel_Warning           : 1 ;
        uint8_t Water_Temp_Level                : 2 ;

        uint8_t SW_Air_Low_Pressure             : 1 ;
        uint8_t SW_Clutch                       : 1 ;
        uint8_t SW_Water_Separator              : 1 ;
        uint8_t SW_Coolant_Level                : 1 ;
        uint8_t SW_Oil_Pressure                 : 1 ;
        uint8_t SW_Sheetbelt                    : 1 ;
        uint8_t SW_Rear_Body_Warning            : 1 ;
        uint8_t SRS_Input                       : 1 ;

        uint8_t EDS_Smoother_WL_Status          : 1 ;
        uint8_t SW_Dr_Door                      : 1 ;
        uint8_t Reserve                         : 1 ;
        uint8_t ACG_L_Terminal                  : 1 ;
        uint8_t SW_DefLock                      : 1 ;
        uint8_t SW_KickDrive                    : 1 ;
        uint8_t SW_MT_Spriter                   : 1 ;
        uint8_t SW_MT_Range                     : 1 ;

        uint8_t Mult_Indication                 : 2 ;
        uint8_t ROWS_Warning                    : 1 ;
        uint8_t Roll_Warning                    : 1 ;
        uint8_t Air_Sus_Warning                 : 1 ;
        uint8_t ESC_Operating                   : 1 ;
        uint8_t EBS_Warning_Yellow              : 1 ;
        uint8_t EBS_Warning_Red                 : 1 ;

        uint8_t SW_Accessory_Air                : 1 ;
        uint8_t SW_SpotLamp                     : 1 ;
        uint8_t Not_used                        : 1 ;
        uint8_t SW_Illmi                        : 1 ;
        uint8_t Not_used0                       : 1 ;
        uint8_t TURN_R_Lamp_Status              : 1 ;
        uint8_t SW_Hi_Beam                      : 1 ;
        uint8_t SW_KeyRemind                    : 1 ;

        uint8_t SW_Parking                      : 2 ;
        uint8_t Not_used1                       : 1 ;
        uint8_t SW_Coupler_Lock                 : 1 ;
        uint8_t Input_Trailer_ABS               : 1 ;
        uint8_t Input_Trailer_Info              : 1 ;
        uint8_t SW_Trailer_Brake                : 2 ;

        uint8_t IGN_Voltage                     : 8 ;

        uint8_t Not_used2                       : 1 ;
        uint8_t Not_used3                       : 1 ;
        uint8_t Not_used4                       : 1 ;
        uint8_t Not_used5                       : 1 ;
        uint8_t Not_used6                       : 1 ;
        uint8_t IRIS_Warning_Lamp_Status        : 1 ;
        uint8_t Range_Air_Cut_Warning           : 1 ;
        uint8_t MJX_MEB9_Manual_TM_Range_Low    : 1 ;
    } bit;
} _Msg18FF2A17Map;

void Can_Set_Buff_18FF2A17(uint8_t CopyData [])
{
    uint32_t Ign_Time ;
    uint8_t i = 0 ;
    uint16_t Voltage = 0 ;
    Ign_Time = Common_GetIgnOnTime();
    _Msg18FF2A17Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ]  = 0xff ;
    }

    //Byte:0
    if (Coolant_Get_Valid())
    {
        if (Ign_Time < 3000)
        {
            MsgMap.bit.Water_Temp_Level = 0 ;
            MsgMap.bit.Over_Heat_Warning_Status = 0 ;
        }
        else
        {
            if (Coolant_Get_CurSeg() <= 10)
            {
                MsgMap.bit.Water_Temp_Level = 0 ;
                MsgMap.bit.Over_Heat_Warning_Status = 0 ;
            }
            else if (Coolant_Get_CurSeg() == 11 || Coolant_Get_CurSeg() == 12)
            {
                MsgMap.bit.Water_Temp_Level = 1 ;
                MsgMap.bit.Over_Heat_Warning_Status = 1 ;
            }


        }
    }
    else
    {
        MsgMap.bit.Water_Temp_Level = 2 ;
        MsgMap.bit.Over_Heat_Warning_Status = 0 ;
    }

    //Get_Voltmeter_Valid();
    if (Get_Voltmeter_AvrVoltage())
    {
        //0x00～0xFA : 9～34 [V]
        Voltage = Get_Voltmeter_AvrVoltage();
        Voltage += 50 ;
        Voltage /= 100 ;
        if (Voltage >= 90)
        {
            Voltage -= 90 ;
        }
        else
        {
            Voltage = 0 ;
        }
    }
    MsgMap.bit.IGN_Voltage  = Voltage ;

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ] ;
    }

}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF9D17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t Fuel_Level                              : 8 ;//0～64:0～100[%] FE:failure
        uint8_t NotUsed                                 : 8 ;
        uint8_t NotUsed1                                : 8 ;
        uint8_t NotUsed2                                : 8 ;
        uint8_t NotUsed3                                : 8 ;
        uint8_t NotUsed4                                : 8 ;
        uint8_t NotUsed5                                : 8 ;
        uint8_t NotUsed6                                : 8 ;
    } bit;
} _Msg18FF9D17Map;
void Can_Set_Buff_18FF9D17(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FF9D17Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }

    MsgMap.bit.Fuel_Level = Fuel_Get_Percent() ;

    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FFE517
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : Event triggered
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t DTC_Clear_Request                          : 8 ;
        uint8_t Req_0Point                                 : 8 ;
        uint8_t System_Demonstration_Request               : 7 ;
        uint8_t Ferry_Mode_Cancel                          : 1 ;
        uint8_t Not_used                                   : 8 ;
        uint8_t Not_used1                                  : 8 ;
        uint8_t Not_used2                                  : 8 ;
        uint8_t Not_used3                                  : 8 ;
        uint8_t Not_used4                                  : 8 ;
    } bit;
} _Msg18FFE517Map;
void Can_Set_Buff_18FFE517(uint8_t CopyData [])
{
    uint8_t i ;
    _Msg18FFE517Map MsgMap ;
    for (i = 0 ; i < 8 ; i ++)
    {
        MsgMap.Data[ i ] = 0xff ;
    }


    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = MsgMap.Data[ i ]  ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF2D17
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EF2D17(uint8_t CopyData [])
{
    uint8_t i ;
    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = 0xff ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18033317
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t PairCmd                                    : 8 ;
        uint8_t TireNumber                                 : 8 ;

        uint8_t Not_used                                   : 8 ;
        uint8_t Not_used1                                  : 8 ;
        uint8_t Not_used2                                  : 8 ;
        uint8_t Not_used3                                  : 8 ;
        uint8_t Not_used4                                  : 8 ;
        uint8_t Not_used5                                  : 8 ;
    } bit;
} _Msg18033317Map;
void Can_Set_Buff_18033317(uint8_t CopyData [])
{
    uint8_t i ;
    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = 0xff ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_180433A2
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
typedef union
{
    uint8_t Data[8] ;
    struct
    {
        uint8_t SetupCmd                                   : 8 ;

        uint8_t Not_used                                   : 8 ;
        uint8_t Not_used1                                  : 8 ;
        uint8_t Not_used2                                  : 8 ;
        uint8_t Not_used3                                  : 8 ;
        uint8_t Not_used4                                  : 8 ;
        uint8_t Not_used5                                  : 8 ;
        uint8_t Not_used6                                  : 8 ;
    } bit;
} _Msg180433A2Map;
void Can_Set_Buff_180433A2(uint8_t CopyData [])
{
    uint8_t i ;
    for (i = 0 ; i < 8 ; i ++)
    {
        CopyData[ i ] = 0xff ;
    }
}

/*CAN接收处理*/
void Drive_Info_IC1_STATUS_Rx(void)
{
    uint32_t Temp = 0u;
    uint8_t Data_Sig = 0u;
    uint8_t Data_Type = 0u;

    Data_Sig = Get_ID_18EF1718_Sig_Response_Code();
    Data_Type = Get_ID_18EF1718_Sig_Data_Type();
    Temp = Get_ID_18EF1718_Sig_Date();

    switch (Data_Sig)
    {
    case 0x81:
        switch (Data_Type)
        {
        case 0x50 :
            User_ECU.TripA_Fuel          = Temp ;
            break;
        case 0x51 :
            User_ECU.TripA_Average_Speed = Temp ;
            break;
        case 0x52 :
            User_ECU.TripA_Fuel_Consume  = Temp ;
            break;
        case 0x53 :
            User_ECU.TripA_Idling        = Temp ;
            break;
        case 0x54 :
            User_ECU.TripA_Runing        = Temp ;
            break;
        case 0x60 :
            User_ECU.TripB_Fuel          = Temp ;
            break;
        case 0x61 :
            User_ECU.TripB_Average_Speed = Temp ;
            break;
        case 0x62 :
            User_ECU.TripB_Fuel_Consume  = Temp ;
            break;
        case 0x63 :
            User_ECU.TripB_Idling        = Temp ;
            break;
        case 0x64 :
            User_ECU.TripB_Runing        = Temp ;
            break;
        case 0x22 :
            User_ECU.Engine_Surplus      = Temp ;
            break;
        default:
            break;
        }
        break;
    case 0x40:
        switch (Data_Type)
        {
        case 0x50 :
            User_ECU.TripA_Fuel          = Temp ;
            break;
        case 0x51 :
            User_ECU.TripA_Average_Speed = Temp ;
            break;
        case 0x52 :
            User_ECU.TripA_Fuel_Consume  = Temp ;
            break;
        case 0x53 :
            User_ECU.TripA_Idling        = Temp ;
            break;
        case 0x54 :
            User_ECU.TripA_Runing        = Temp ;
            break;
        case 0x60 :
            User_ECU.TripB_Fuel          = Temp ;
            break;
        case 0x61 :
            User_ECU.TripB_Average_Speed = Temp ;
            break;
        case 0x62 :
            User_ECU.TripB_Fuel_Consume  = Temp ;
            break;
        case 0x63 :
            User_ECU.TripB_Idling        = Temp ;
            break;
        case 0x64 :
            User_ECU.TripB_Runing        = Temp ;
            break;
        case 0x22 :
            User_ECU.Engine_Surplus      = Temp ;
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }

    //if (State_Flag.FState_COilTimeOut < FState_COilTimeOutNum)
    //{
    //    State_Flag.FState_COilTimeOut++;
    //}
    //if (Data_Sig == 0x40u)
    //{
    //    State_Flag.FState_ClearOilRx == 1;
    //}
}

uint32_t Common_Data_Get_TripA_Fuel(void)
{
    return User_ECU.TripA_Fuel ;
}
uint32_t Common_Data_Get_TripA_Average_Speed(void)
{
    return User_ECU.TripA_Average_Speed ;
}
uint32_t Common_Data_Get_TripB_Fuel(void)
{
    return User_ECU.TripB_Fuel ;
}
uint32_t Common_Data_Get_TripB_Average_Speed(void)
{
    return User_ECU.TripB_Average_Speed ;
}

