﻿
#ifndef GUI_H_
#define GUI_H_

#include "loc_graphics.h"
#include "images.h"
#include "TYW_stdint.h"
typedef struct
{
    uint8_t FState_GZM;    /*故障码*/
    uint8_t FState_WXTZ;   /*维修提醒*/
    uint8_t FState_WXSD;   /*维修设定*/
    uint8_t FState_YHSD;   /*用户设定*/
    uint8_t FState_ECO;    /*ECO*/
    uint8_t FState_TPMS;   /*胎压显示*/
    uint8_t FState_SYSYS;  /*系统演示*/
    uint8_t WXTZ_FDJY;     /*发动机油*/
    uint8_t WXTZ_RYLQY;    /*燃油滤清油*/
    uint8_t WXTZ_BSXY;     /*变速箱油*/
    uint8_t WXTZ_CSQY;     /*差速器油*/
    uint8_t WXTZ_LHQY;     /*离合器油*/
    uint8_t WXTZ_KQGZJ;    /*空气干燥剂*/
    uint8_t WXTZ_DLZXY;    /*动力转向油*/
    uint8_t WXTZ_LT;       /*轮胎*/
    uint8_t WXTZ_QDJ;      /*起动机*/
    uint8_t WXSD_FDJY;     /*发动机*/
    uint8_t WXSD_RYLQY;    /*燃油滤清油*/
    uint8_t WXSD_BSXY;     /*变速箱油*/
    uint8_t WXSD_CSQY;     /*差速器油*/
    uint8_t WXSD_LHQY;     /*离合器油*/
    uint8_t WXSD_KQGZJ;    /*空气转向*/
    uint8_t WXSD_DLZXY;    /*动力转向*/
    uint8_t WXSD_LT;       /*轮胎*/
    uint8_t WXSD_QDJ;      /*起动机*/
    uint8_t USER_DATE;     /*日期设定*/
    uint8_t USER_TIME;     /*时间设定*/
    uint8_t USER_DISPLAY;  /*显示设定*/
    uint8_t USER_PROPOSAL; /*省油设定*/
    uint8_t USER_HSA;      /*HAS*/
    uint8_t USER_VOLUEM;   /*音量设定*/
    uint8_t USER_LANGUAGE; /*语言设定*/
    uint8_t USER_COMPANY;  /*单位设定*/
    uint8_t USER_LIGHT;    /*亮度设定*/
    uint8_t USER_SETIC;    /*仪表设定*/
    uint8_t DEMO_LDWS;
    uint8_t DEMO_AEBS1;
    uint8_t DEMO_AEBS2;
    uint8_t DEMO_AEBS3;

    uint8_t FState_TPMSSET; /*胎压设置*/

    uint8_t ENTER_RETURN ;

} _Display_State_Flag;

extern volatile _Display_State_Flag State_Flag;


static const uint32_t GUIWedk[7u] = {CN_xingqiyi, CN_xingqier, CN_xingqisan, CN_xingqisi, CN_xingqiwu, CN_xingqiliu, CN_xingqiri};
static const uint32_t GUIGear[12u] = {CN_dangwei_01, CN_dangwei_02, CN_dangwei_03, CN_dangwei_04, CN_dangwei_05, CN_dangwei_06,
                                      CN_dangwei_07, CN_dangwei_08, CN_dangwei_09, CN_dangwei_10, CN_dangwei_11, CN_dangwei_12
                                     };
static const uint32_t GUIMenuWedk[7u] = {CN_Mon, CN_Tue, CN_Wed, CN_Thu, CN_Fri, CN_Sat, CN_ri};

static const uint16_t GUI_DISP_AC_TEMP[2] = {229u, 216u}; /*室外温度数字显示*/
static const uint16_t GUI_DISP_Hours[2] = {370u, 349u};
static const uint16_t GUI_DISP_Minutes[2] = {428u, 406u};
static const uint16_t GUI_DISP_Year[4] = {568u, 552u, 538u, 522u};
static const uint16_t GUI_DISP_Month[2] = {617u, 604u};
static const uint16_t GUI_DISP_Date[2] = {669u, 653u};
static const uint16_t GUI_DISP_TRIPA[5] = {676u, 648u, 629u, 610u, 591u};               /*TRIP*/
static const uint16_t GUI_DISP_ODO[7] = {676u, 657u, 638u, 619u, 600u, 581u, 562u};     /*ODO*/
static const uint16_t GUI_DISP_DrivingSupport[3] = {481u, 459u, 436u};                  /*定速巡航*/
static const uint16_t GUI_DISP_OILTEMP[7] = {729u, 697u, 676u, 655u, 634u, 613u, 592u}; /*油温时间*/
static const uint16_t GUI_DISP_MENUHours[2] = {578u, 560u};
static const uint16_t GUI_DISP_MENUMinutes[2] = {623u, 605u};
static const uint16_t GUI_DISP_MENUYear[4] = {495u, 477u, 459u, 441u}; /*年月日*/
static const uint16_t GUI_DISP_MENUMonth[2] = {572u, 554u};
static const uint16_t GUI_DISP_MENUDate[2] = {648u, 630u};
static const uint16_t GUI_DISP_MENUYear1[4] = {568u, 552u, 538u, 522u}; /*月日年*/
static const uint16_t GUI_DISP_MENUMonth1[2] = {617u, 604u};
static const uint16_t GUI_DISP_MENUDate1[2] = {669u, 653u};
static const uint16_t GUI_DISP_MENU_Y[4] = {150u, 198u, 246u, 294u}; /*菜单选项纵坐标*/
static const uint16_t GUI_TPMS_PIC_X[4] = {298u, 373u, 478u, 543u};
static const uint16_t GUI_TPMS_PIC_Y[4] = {115u, 140u, 214u, 238u};
static const uint16_t GUI_TPMS_NUM1_X[3] = {344u, 329u, 314u};
static const uint16_t GUI_TPMS_NUM2_X[3] = {419u, 404u, 389u};
static const uint16_t GUI_TPMS_NUM3_X[3] = {525u, 510u, 495u};
static const uint16_t GUI_TPMS_NUM4_X[3] = {589u, 574u, 559u};
static const uint16_t GUI_TPMS_NUM_Y[4] = {109u, 173u, 210u, 274u};
static const uint16_t GUI_TPMS_MIC3_X[4] = {314u, 389u, 495u, 559u};
static const uint16_t GUI_TPMS_MIC2_X[4] = {329u, 404u, 510u, 574u};

static const uint16_t GUI_REP1_X[6] = {582u, 565u, 547u, 521u, 503u, 485u};
static const uint16_t GUI_REP_X[4] = {582u, 565u, 547u, 521u};

extern void GUI_Display_KL15_ON_Init(void);
extern void GUI_Display_KL15_OFF_Init(void);
extern void GUI_Display_Value_Init(void); /*显示数据初始化*/
extern void GUI_Display_background(void); /*刷底图*/
extern void GUI_OftenShow_Display(void);  /*常显界面*/
extern void GUI_Dynamic_DIsplay(void);

void GUI_AC_Temp_Dispaly(uint8_t Mode);                               /*室外温度显示*/
void GUI_Time_Dispaly(uint8_t Mode);                                  /*时间显示*/
void GUI_Data_Dispaly(uint8_t Mode);                                  /*日历显示*/
void GUI_TFTTelltales_Display(uint8_t Mode);                          /*TFT指示灯*/
void GUI_WetGas_Dispaly(uint8_t Mode);                                /*wet气压*/
void GUI_AdBlue_Dispaly(uint8_t Mode);                                /**/
void Gui_TRIPA_Display(uint8_t Mode);                                 /*TRIPA*/
void Gui_TRIPB_Display(uint8_t Mode);                                 /*TRIPB*/
void Gui_ODO_Display(uint8_t Mode);                                   /*ODO*/
void Gui_ADAS_Display(uint8_t Mode);                                  /*ADAS*/
void Gui_DrivingSupport_Display(uint8_t Mode);                        /*定速巡航*/
void Gui_Gear_Display(uint8_t Mode);                                  /*挡位*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode);                         /*平均车速，平均油耗*/
void GUI_Drive_Info_Avg_Speed_Display(uint8_t Valid, uint16_t Speed); /*平均车速*/
void GUI_Drive_Info_Avg_Fuel_Display(uint8_t Valid, uint16_t Fuel);   /*平均油耗*/
void GUI_Battery_Display_Display(uint8_t Mode);                       /*电池电量*/
void GUI_DPD_Display_Display(uint8_t Mode);                           /*DPD*/
void GUI_Time_OilTemp_Display(uint8_t Mode);                          /*转速时间-油温*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode);                      /*OFF 转速时间-油温*/
void GUI_Year_Month_Data_Display(uint8_t Mode);                       /*年月日*/
void GUI_block_NULL_Display(uint8_t Mode);                            /*……*/
void GUI_BG_Menu_Display(uint8_t Mode);                               /*一级菜单项*/
void GUI_BG_Menu1_Display(uint8_t Mode);                              /**/
void GUI_BG_Menu2_Display(uint8_t Mode);                              /**/
void GUI_BG_Menu3_Display(uint8_t Mode);                              /**/
void GUI_BG_Menu4_Display(uint8_t Mode);                              /**/
void GUI_BG_Menu5_Display(uint8_t Mode);                              /**/
void GUI_BG_Menu6_Display(uint8_t Mode);                              /**/
void GUI_BG_Errot_Display(uint8_t Mode);                              /*二级菜单--故障码显示*/
void GUI_BG_Rep_Menu_Display(uint8_t Mode);                           /*二级菜单--保养通知*/
void GUI_BG_RepMenu1_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu2_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu3_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu4_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu5_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu6_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu7_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu8_Display(uint8_t Mode);                           /**/
void GUI_BG_RepMenu9_Display(uint8_t Mode);                           /**/
void GUI_BG_RepSet_Menu_Display(uint8_t Mode);                        /*二级菜单--保养通知设定*/
void GUI_BG_RepSetMenu1_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu2_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu3_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu4_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu5_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu6_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu7_Display(uint8_t Mode);                        /**/
void GUI_BG_RepSetMenu8_Display(uint8_t Mode);                        /**/
void GUI_BG_UserSet_Menu_Display(uint8_t Mode);                       /*二级菜单--用户设定*/
void GUI_BG_UserSetMenu1_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu2_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu3_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu4_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu5_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu6_Display(uint8_t Mode);                       /**/
void GUI_BG_UserSetMenu7_Display(uint8_t Mode);                       /**/
void GUI_BG_Demo_Menu_Display(uint8_t Mode);                          /*二级菜单--系统演示模式*/
void GUI_BG_DemoMenu1_Display(uint8_t Mode);
void GUI_BG_DemoMenu2_Display(uint8_t Mode);
void GUI_BG_DemoMenu3_Display(uint8_t Mode);
void GUI_BG_DemoMenu4_Display(uint8_t Mode);
void GUI_BG_TPMS_GasPIC_Display(uint8_t Mode);                        /*二级菜单--TPMS*/
void GUI_BG_TPMS_GasNUM_Display(uint8_t Mode);
void GUI_BG_TPMS_TempPIC_Display(uint8_t Mode);
void GUI_BG_TPMS_TempNUM_Display(uint8_t Mode);
void GUI_BG_RepMenu_Display(uint8_t Mode);                         /*三级菜单--保养通知*/
void GUI_BG_RepMenu_3_1_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_2_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_3_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_4_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_6_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_7_Display(uint8_t Mode);
void GUI_BG_RepMenu_3_8_Display(uint8_t Mode);
void GUI_BG_RepMenuSet_Menu_Display(uint8_t Mode); /**/
void GUI_BG_RepSetMenu_3_1_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_2_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_3_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_4_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_5_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_6_Display(uint8_t Mode);
void GUI_BG_RepSetMenu_3_7_Display(uint8_t Mode);




void GUI_BG_Enter_Return_Display(uint8_t Mode);

#endif