#include "Popups.h"
#include "Common_Interface.h"
#include "GUI.h"
#include "Sound_Scheduler.h"

#include "Gauges.h"
#include "GaugesInterface.h"

#include "CAN_Communication_Matrix.h"
#include "Popup_List.h"
#include "Popup_Message_List.h"
#include "Sound_List.h"
#include "Telltales.h"

#include "Data_Gear.h"
#include "Line_in.h"

#include "Data_CoolantTemperature.h"
#include "Data_Voltmeter.h"
#include "Data_Fuel_User.h"

void Popups_Management_Service(void)
{
    Popups_Polling( );
}

void Popups_Polling(void)
{
    uint16_t   i              = 0x00u;
    uint32_t  u32IG_OFF_Timer = 0x00u;
    uint32_t  u32IG_ON_Timer  = 0x00u;

    COMMON_PowerStatus_t u8IG_st;
    uint8_t Can_BusOFF = 0x00u;

    uint8_t variable_1 = 0x00u;
    uint8_t variable_2 = 0x00u;
    uint8_t variable_3 = 0x00u;

    u32IG_ON_Timer  = Common_GetIgnOnTime( );
    u32IG_OFF_Timer = Common_GetIgnOffTime( );

    u8IG_st = Common_Get_IG_Sts( );


    /*CAN 通讯异常*/
    for ( i = 0u; i < ID_TOTAL_MAX; i++ )
    {
        if ( CAN_MSG_Status(i) == CAN_SIG_LOST )
        {
            Can_BusOFF++;
        }
    }

    if (( u32IG_ON_Timer <= PopupStart ) && (u32IG_ON_Timer >= 2u ))
    {

    }
    else
    {
        if ( u8IG_st == COMMON_POWER_ON )
        {
            /*----第一组---------------------------------------------------------------------*/
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                /*0.紧急警报-刹车*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x07u) || (variable_2 == 0x07u))
                {
                    Popup_Request(POPUP1_BRAKE_BLACK);
                    Popup_Clear(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return ;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BLACK);
                }

                /*1.紧急警报-紧急制动*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x07u)
                {
                    Popup_Request(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return ;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BRAKE);
                }

                /*2.车间距警报-刹车(红字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x06u) || (variable_2 == 0x06u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return ;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_R);
                }

                /*3.车间距警报-碰撞报警*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x06u)
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return ;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_COLLISION);
                }

                /*4.车间距警报-刹车(黄字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x05u) || (variable_2 == 0x05u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return ;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_Y);
                }
            }
            else
            {
                Popup_Clear(POPUP1_BRAKE_BLACK);
                Popup_Clear(POPUP1_BRAKE_BRAKE);
                Popup_Clear(POPUP1_BRAKE_SPACING_R);
                Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                Popup_Clear(POPUP1_BRAKE_SPACING_Y);
            }

            /*5.ASR工作*/
            variable_1 = Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUT1_ASR_OPERATE);
            }
            else
            {
                Popup_Delete(POPUT1_ASR_OPERATE);
            }

            /*----第二组---------------------------------------------------------------------*/
            /*6.PTO紧急警报-刹车*/
            variable_1 = Get_ID_18FED900_Sig_PTO_SW();
            variable_2 = Line_In_Get_Status(LINE_IN_PTO);//B01

            if ((variable_1 == 0x01u) || (variable_2 == LINE_IN_LOGIC_VALID))
            {
                Popup_Request(POPUT2_PTO);
            }
            else
            {
                Popup_Delete(POPUT2_PTO);
            }

            /*7.忘记松手刹车    LINE_IN_Get_PARK_BRAKE 驻车制动*/
            variable_1 = Line_In_Get_Status(LINE_IN_PARK_BRAKE);

            if (variable_1 == LINE_IN_LOGIC_VALID) //6.67Km
            {
                Popup_Request(POPUP2_PARKING_BRAKE);
            }
            else
            {
                Popup_Delete(POPUP2_PARKING_BRAKE);
            }

            /*8.遥控调整车辆高度(有车速)*/
            variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);

            if (variable_1 == LINE_IN_LOGIC_VALID) //0.5Km
            {
                Popup_Request(POPUP2_AIRMATIC_HIGHT);
            }
            else
            {
                Popup_Delete(POPUP2_AIRMATIC_HIGHT);
            }

            /*----第三组---------------------------------------------------------------------*/
            /*9.自动巡航模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_Time();

            if ((variable_1 == 0x01u) && (variable_2 < 30u)) //5s内不显示
            {
                Popup_Request(POPUP3_CRUISE);
            }
            else
            {
                Popup_Delete(POPUP3_CRUISE);
            }

            /*10.可变SLD 模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_SLD_Time();

            if ((variable_1 == 0x03u) && (variable_2 < 30u)) //5s内不显示
            {
                Popup_Request(POPUP3_VARIABLE_SLD);
            }
            else
            {
                Popup_Delete(POPUP3_VARIABLE_SLD);
            }
        }
        else /*ig off*/
        {
            Popup_Clear(POPUP1_BRAKE_BLACK);/*00.紧急警报-刹车*/
            Popup_Clear(POPUP1_BRAKE_BRAKE);/*01.紧急警报-紧急制动*/
            Popup_Clear(POPUP1_BRAKE_SPACING_R);/*02.车间距警报-刹车(红字)*/
            Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);/*03.车间距警报-碰撞报警*/
            Popup_Clear(POPUP1_BRAKE_SPACING_Y);/*04.车间距警报-刹车(黄字)*/
            Popup_Clear(POPUT1_ASR_OPERATE);/*05.ASR工作*/
            Popup_Clear(POPUT2_PTO);/*06.PTO紧急警报-刹车*/
            Popup_Clear(POPUP2_PARKING_BRAKE);/*07.忘记松手刹车*/
            Popup_Clear(POPUP2_AIRMATIC_HIGHT);/*08.遥控调整车辆高度(有车速)*/
            Popup_Clear(POPUP3_CRUISE);/*09.自动巡航模式*/
            Popup_Clear(POPUP3_VARIABLE_SLD);/*10.可变SLD 模式*/
            /*11.充电异常（系统检测）*/
            /*12.油压（系统检测）*/
            /*13.AMT初始化异常*/
            /*14.尿素品质异常（系统检测）*/
            /*15.尿素喷射异常（系统检测）*/
            /*16.尿素水补给（系统检测）*/
            /*17.AMT初始化结束*/
            /*18.DPD自动再生*/
            /*19.过热（过热，请在安全的场所停车）*/
            /*20.过热（冷却液温度过高）*/
            /*21.冷却水（冷却液不足）*/
            /*22.冷却水（冷却水不足）*/
            /*23.油压(机油)请在安全场所停车*/
            /*24.油压异常*/
            /*25.仪表故障-请在安全场所停车*/
            /*26.仪表故障-请与五十铃公司联系*/
            /*27.通信系统-请在安全场所停车*/
            /*28.通信系统-请与五十铃公司联系*/
            /*29.车速限制-图1*/
            /*30.车速限制-图2*/
            /*31.扭矩限制-图1*/
            /*32.扭矩限制-图2*/
            /*33.扭矩限制、车速限制 交互 显示-->扭矩限制*/
            /*34.尿素品质异常-图1*/
            /*35.尿素品质异常-图2*/
            /*36.临界排放故障-图1*/
            /*37.临界排放故障-图2*/
            /*38.AMT异常-图1*/
            /*39.AMT异常-请重启发动机*/
            /*40.AMT异常(气压低下)-图1*/
            /*41.AMT异常(气压低下)-图2*/
            /*42.低圧警報-轮胎漏气警告*/
            /*43.同——44*/
            /*44.尿素补给-补充尿素溶液-图1*/
            /*45.尿素补给-补充尿素溶液-图2*/
            /*46.尿素余量少-有车速-图1*/
            /*47.尿素余量少-无车速-图2*/
            /*48.低圧警報（低下）*/
            /*49.同——50*/
            /*50.摄像头有污染-图1*/
            /*51.摄像头有污染-请与五十铃公司联系*/
            /*52.尿素喷射异常（停止）-图1*/
            /*53.尿素喷射异常（停止）-图2*/
            /*54.尿素喷射异常（消耗量）-图1*/
            /*55.尿素喷射异常（消耗量）-图2*/
            /*56.高圧警報-轮胎高压警告*/
            /*57.高温警報-轮胎高温警告*/
            /*58.尿素喷射异常(停止、消耗量)交互显示*/
            /*59.DPD手动再生要求1-DPD需要再生*/
            /*60.DPD手动再生要求1-请按下DPD开关*/
            /*61.DPD手动再生要求2-DPD需要再生*/
            /*62.DPD手动再生要求2-请按下DPD开关*/
            /*63.TPMS故障-轮胎监控失败*/
            /*64.TPMS電池低下-轮胎监控传感器电压下降*/
            /*65.DPD手动再生中*/
            /*66.遥控车辆高度调整中(无车速)*/
            /*67.PTO(停车中)*/
            /*68.充电异常-请在安全的场所停车*/
            /*69.充电异常-请与五十铃公司联系*/
            /*70.AMT異常-AMT异常*/
            /*71.AMT異常-请联系经销商*/
            /*72.补充燃料-油箱单位*/
            /*73.过热-离合器过载*/
            /*74.过热-选择合适的档位*/
            /*75.AMT磨耗-离合器磨损*/
            /*76.低电压报警*/
            /*77.过电压报警*/
            /*78.DPD自动再生-DPD自动再生中*/
            /*79.DPD自动再生-再生将自动完成，不需要操作开关*/
            /*80.气压过低-气压过低请注意*/
            /*81.气压过低-请冲入空气*/
            /*82.EBS故障（红）-请在安全的场所停车*/
            /*83.EBS故障（红）-请与五十铃公司联系*/
            /*84.省油耗建议-急加速*/
            /*85.省油耗建议-急减速*/
            /*86.省油耗建议-请降低发动机转速*/
            /*87.省油耗建议-请降低速度*/
            /*88.发动机机油＆滤清器*/
            /*89.燃油滤清器*/
            /*90.变速箱油*/
            /*91.差速器油*/
            /*92.顺畅系统离合器油*/
            /*93.动力转向液*/
            /*94.更换轮胎・轮胎位置*/
        }
    }

#if 0

    //11.充电异常（系统检测）
    variable_1 = Line_In_Get_Status(LINE_IN_CHARGE);
    if (EOL == 0X00)
    {
        //检出A34信号（10ms周期监测）时（Lo 或 电压值＜21V连续500回以上），且EOL：LID$2B＝0ｘ00
        if ((E_Speed < 350) && (variable_1 == LINE_IN_LOGIC_VALID)) //转速350R/min
        {
            if (variable_1)
            {
                Popup_Request(POPUT4_ABNORMAL_CHARGE);
            }
            else
            {
                Popup_Delete(POPUT4_ABNORMAL_CHARGE);
            }
        }
    }
    else
    {
        Popup_Delete(POPUT4_ABNORMAL_CHARGE);
    }


    //12.油压（系统检测）
    variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);
    if (EOL == 0X00)
    {
        if ((E_Speed < 350) && (variable_1 == LINE_IN_LOGIC_VALID)) //转速350R/min
        {
            if (variable_1)
            {
                Popup_Request(POPUP4_OIL_PRESSURE);
            }
            else
            {
                Popup_Delete(POPUP4_OIL_PRESSURE);
            }
        }
    }
    else
    {
        Popup_Delete(POPUP4_OIL_PRESSURE);
    }


    //13.AMT初始化异常           DM1 SPN4220 Key On時
    if (EOL == 0x13)
    {
        if (PowerSts == COMMON_POWER_ON)
        {
            Popup_Request(POPUP4_AMT_INIT_EXCE);
        }
        else
        {
            Popup_Delete(POPUP4_AMT_INIT_EXCE);
        }
    }
    else
    {
        Popup_Delete(POPUP4_AMT_INIT_EXCE);
    }


    //14.尿素品质异常（系统检测）
    //variable_1 = Get_ID_18FF2300_Sig_Amber3();
    //if(variable_1 == 1 )
    if (PowerSts == COMMON_POWER_ON)
    {
        Popup_Request(POPUP4_ADBLUE_QUALITY);
    }
    else
    {
        Popup_Delete(POPUP4_ADBLUE_QUALITY);
    }

    //15.尿素喷射异常（系统检测）
    //variable_1 = Get_ID_18FF2300_Sig_Amber1();
    //if(variable_1 == 1)
    if (PowerSts == COMMON_POWER_ON)
    {
        Popup_Request(POPUP4_ADBLUE_SPRAY);
    }
    else
    {
        Popup_Delete(POPUP4_ADBLUE_SPRAY);
    }

    //16.尿素水补给（系统检测）
    //variable_1 = Get_ID_18FF2300_Sig_Amber2();
    //if(variable_1 == 1)
    if (PowerSts == COMMON_POWER_ON)
    {
        Popup_Request(POPUP4_ADBLUE_SUPPLY);
    }
    else
    {
        Popup_Delete(POPUP4_ADBLUE_SUPPLY);
    }

    //17.AMT初始化结束               DM1 SPN4021  Key On時
    if (EOL == 0x13)
    {
        if (PowerSts == COMMON_POWER_ON)
        {
            Popup_Request(POPUP4_START_ENG);
        }
        else
        {
            Popup_Delete(POPUP4_START_ENG);
        }
    }
    else
    {
        Popup_Delete(POPUP4_START_ENG);
    }

    //18.DPD自动再生
    //variable_1 = Get_ID_18FED900_Sig_DPF_Regeneration_Status();
    if (PowerSts == COMMON_POWER_ON)
    {
        Popup_Request(POPUP4_DPD_AUTO);
    }
    else
    {
        Popup_Delete(POPUP4_DPD_AUTO);
    }


    //19.过热（过热，请在安全的场所停车）有车速     LID $43 :0x82
    //variable_1 = Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature();
    if (V_Speed && (Coolant_Get_CurSeg() > 10))
    {
        Popup_Request(POPUP5_OVER_HEAT_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_OVER_HEAT_SPEED);
    }
    //20.过热（冷却液温度过高）         无车速  LID $43 :0x82
    if ((V_Speed == 0) && (Coolant_Get_CurSeg() > 10))
    {
        Popup_Request(POPUP5_OVER_HEAT);
    }
    else
    {
        Popup_Delete(POPUP5_OVER_HEAT);
    }

    //21.冷却水（冷却液不足） B32 GND
    variable_1 = Line_In_Get_Status(LINE_IN_LOW_COOLANT);
    if (V_Speed && variable_1)
    {
        Popup_Request(POPUP5_LOW_COOLANT_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_LOW_COOLANT_SPEED);
    }
    //22.冷却水（冷却水不足）B32 GND
    if ((V_Speed == 0) && variable_1)
    {
        Popup_Request(POPUP5_LOW_COOLANT);
    }
    else
    {
        Popup_Delete(POPUP5_LOW_COOLANT);
    }

    //23.油压(机油)请在安全场所停车
    //发动机启动(350r/min)后、350r/min持续5秒以上时，A32信号（10ms周期监测），连续20次检出Lo时。
    variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);
    //variable_2 = Get_ID_CF00400_Sig_Engine_speed();发动机转速 预留
    if (V_Speed && (E_Speed > 350) && variable_1)
    {
        Popup_Request(POPUP5_ENGINE_OIL_PRESSURE_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_ENGINE_OIL_PRESSURE_SPEED);
    }
    //24.油压异常
    if ((V_Speed == 0) && (E_Speed > 350) && variable_1)
    {
        Popup_Request(POPUP5_ENGINE_OIL_PRESSURE);
    }
    else
    {
        Popup_Delete(POPUP5_ENGINE_OIL_PRESSURE);
    }


    //25.仪表故障-请在安全场所停车      //没给条件
    //26.仪表故障-请与五十铃公司联系

    //27.通信系统-请在安全场所停车      //没给条件
    //28.通信系统-请与五十铃公司联系


    //29.车速限制-图1   ID：18FF2300 Byte：7 Bit：4,3   10(B)
    variable_1 = Get_ID_18FF2300_Sig_Engine_Derate();
    if (V_Speed && (variable_1 == 2))
    {
        Popup_Request(POPUP5_SPEED_LIMIT_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_SPEED_LIMIT_SPEED);
    }
    //30.车速限制-图2 ID：18FF2300 Byte：7 Bit：4,3   10(B)
    if ((V_Speed == 0) && (variable_1 == 2))
    {
        Popup_Request(POPUP5_SPEED_LIMIT);
    }
    else
    {
        Popup_Delete(POPUP5_SPEED_LIMIT);
    }
    //31.扭矩限制-图1 ID：18FF2300 Byte：7 Bit：4,3   01(B)
    if (V_Speed && (variable_1 == 1))
    {
        Popup_Request(POPUP5_TORQUE_REDUCTION_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_TORQUE_REDUCTION_SPEED);
    }
    //32.扭矩限制-图2 ID：18FF2300 Byte：7 Bit：4,3   01(B)
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_TORQUE_REDUCTION);
    }
    else
    {
        Popup_Delete(POPUP5_TORQUE_REDUCTION);
    }
    //33.扭矩限制、车速限制 交互 显示 ID：18FF2300 Byte：7 Bit：4,3   11(B)
    if (variable_1 == 3)
    {
        Popup_Request(POPUP5_SPEED_TORQUE);
    }
    else
    {
        Popup_Delete(POPUP5_SPEED_TORQUE);
    }


    //34.尿素品质异常-图1 ID：18FF2300 Byte：3 Bit：6,5  01(B)
    variable_1 = Get_ID_18FF2300_Sig_Amber3();
    if (V_Speed && (variable_1 == 1))
    {
        Popup_Request(POPUP5_INCORRECT_ADBLUE_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_INCORRECT_ADBLUE_SPEED);
    }
    //35.尿素品质异常-图2 ID：18FF2300 Byte：3 Bit：6,5  01(B)
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_INCORRECT_ADBLUE);
    }
    else
    {
        Popup_Delete(POPUP5_INCORRECT_ADBLUE);
    }

    //36.临界排放故障-图1 ID：18FF2300 Byte：7 Bit：6,5  01(B)
    variable_1 = Get_ID_18FF2300_Sig_EXH_System();

    if (V_Speed && (variable_1 == 1))
    {
        Popup_Request(POPUP5_CRITICAL_EMISSION_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_CRITICAL_EMISSION_SPEED);
    }

    //37.临界排放故障-图2 ID：18FF2300 Byte：7 Bit：6,5  01(B)
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_CRITICAL_EMISSION);
    }
    else
    {
        Popup_Delete(POPUP5_CRITICAL_EMISSION);
    }


    //38.AMT异常-图1 ID：18FF8503 Byte：1 Bit：4,3 01(B) LID $41 : 0x13
    variable_1 = Get_ID_18FF8503_Sig_Spanner_Warning();
    if ((EOL == 0x13) && (V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AMT_SPANNER_WARNING_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_AMT_SPANNER_WARNING_SPEED);
    }

    //39.AMT异常-请重启发动机 ID：18FF8503 Byte：1 Bit：4,3 01(B) LID $41 : 0x13
    if ((EOL == 0x13) && (V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AMT_SPANNER_WARNING);
    }
    else
    {
        Popup_Delete(POPUP5_AMT_SPANNER_WARNING);
    }


    //40.AMT异常(气压低下)-图1 ID：18FF8503 Byte：2 Bit：6,5 01(B) LID $41 : 0x13
    variable_1 = Get_ID_18FF2300_Sig_Glow_Lamp();
    if ((EOL == 0x13) && (V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AMT_LOW_AIR_WARNING_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_AMT_LOW_AIR_WARNING_SPEED);
    }

    //41.AMT异常(气压低下)-图2
    if ((EOL == 0x13) && (V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AMT_LOW_AIR_WARNING);
    }
    else
    {
        Popup_Delete(POPUP5_AMT_LOW_AIR_WARNING);
    }

    //42.低圧警報-轮胎漏气警告 ID：18011733  Byte：5 Bit：5 01(B) LID $3E : 0x01
    variable_1 = Get_ID_18011733_Sig_Fast_air_leakage_alarm();
    if ((EOL == 0x01) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_LOW_PRESSURE_ALARM_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_LOW_PRESSURE_ALARM_SPEED);
    }
    //43.低圧警報 - 若报警图一样，同42.否则此处增加43报警逻辑

    //44.尿素补给-补充尿素溶液-图1 ID：18FF2300 Byte：3 Bit：4,3 01(B)
    variable_1 = Get_ID_18FF2300_Sig_Amber2();
    if ((V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_APP_ADBLUE_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_APP_ADBLUE_SPEED);
    }

    //45.尿素补给-补充尿素溶液-图2 ID：18FF2300 Byte：3 Bit：4,3 01(B)
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_APP_ADBLUE);
    }
    else
    {
        Popup_Delete(POPUP5_APP_ADBLUE);
    }

    //46.尿素余量少-有车速-图1 ID：18FF2300 Byte：3 Bit：4,3 10(B)
    if ((V_Speed) && (variable_1 == 2))
    {
        Popup_Request(POPUP5_ADBLUE_LEVEL_LOW_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_ADBLUE_LEVEL_LOW_SPEED);
    }

    //47.尿素余量少-无车速-图2 ID：18FF2300 Byte：3 Bit：4,3 10(B)
    if ((V_Speed == 0) && (variable_1 == 2))
    {
        Popup_Request(POPUP5_ADBLUE_LEVEL_LOW);
    }
    else
    {
        Popup_Delete(POPUP5_ADBLUE_LEVEL_LOW);
    }

    //48. 低圧警報（低下）ID：18011733  Byte：5 Bit：8 01(B) LID $3E : 0x01
    variable_1 = Get_ID_18011733_Sig_Low_Presure_Alarm();
    if ((EOL == 0x01) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_LOW_FAILURE_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_LOW_FAILURE_SPEED);
    }
    //49.低圧警報（低下） 同//48


    //50.摄像头有污染-图1 ID：18FE5BE8 Byte7  Bit5-8 0010(B) 0011(B) LID $27: 0x01
    variable_1 = Get_ID_18FE5BE8_Sig_Camera_Status();
    if (V_Speed)
    {
        if ((EOL == 0x01) && (V_Speed) && ((variable_1 == 2) || (variable_2 == 3)))
        {
            Popup_Request(POPUP5_CAMERA_POLLUTION_SPEED);
        }
        else
        {
            Popup_Delete(POPUP5_CAMERA_POLLUTION_SPEED);
        }
    }
    //51.摄像头有污染-请与五十铃公司联系 ID：18FE5BE8 Byte7  Bit5-8 0010(B) 0011(B) LID $27: 0x01
    if ((EOL == 0x01) && (V_Speed == 0x00) && ((variable_1 == 2) || (variable_2 == 3)))
    {
        Popup_Request(POPUP5_CAMERA_POLLUTION);
    }
    else
    {
        Popup_Delete(POPUP5_CAMERA_POLLUTION);
    }

    //52.尿素喷射异常（停止）-图1 ID：18FF2300 Byte：3 Bit：2,1 01(B)
    variable_1 = Get_ID_18FF2300_Sig_Amber1();
    if ((V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AdBlue_LEVEL_LOW_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_AdBlue_LEVEL_LOW_SPEED);
    }

    //53.尿素喷射异常（停止）-图2 ID：18FF2300 Byte：3 Bit：2,1 01(B)
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_AdBlue_LEVEL_LOW);
    }
    else
    {
        Popup_Delete(POPUP5_AdBlue_LEVEL_LOW);
    }

    //54.尿素喷射异常（消耗量）-图1  ID：18FF2300 Byte：3 Bit：2,1 10(B)
    if ((V_Speed) && (variable_1 == 2))
    {
        Popup_Request(POPUP5_AdBlue_INJ_SYSTEM_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_AdBlue_INJ_SYSTEM_SPEED);
    }

    //55.尿素喷射异常（消耗量）-图2 ID：18FF2300 Byte：3 Bit：2,1 10(B)
    if ((V_Speed == 0) && (variable_1 == 2))
    {
        Popup_Request(POPUP5_AdBlue_INJ_SYSTEM);
    }
    else
    {
        Popup_Delete(POPUP5_AdBlue_INJ_SYSTEM);
    }

    //56.高圧警報-轮胎高压警告 ID：18011733  Byte：5 Bit：7  01(B) LID $3E : 0x01
    variable_1 = Get_ID_18011733_Sig_High_Presure_Alarm();
    if ((EOL == 0x01) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_TPMS_HIGH_AIR);
    }
    else
    {
        Popup_Delete(POPUP5_TPMS_HIGH_AIR);
    }

    //57.高温警報-轮胎高温警告 ID：18011733  Byte：5 Bit：6  01(B) LID $3E : 0x01
    variable_1 = Get_ID_18011733_Sig_High_Temperature_Alarm();
    if ((EOL == 0x01) && (variable_1  == 1))
    {
        Popup_Request(POPUP5_TPMS_HIGH_TEMP);
    }
    else
    {
        Popup_Delete(POPUP5_TPMS_HIGH_TEMP);
    }

    //58.尿素喷射异常(停止、消耗量)交互显示----尿素喷射系统异常 ID：18FF2300 Byte：3 Bit：2,1 11(B)
    variable_1 = Get_ID_18FF2300_Sig_Amber1();
    if (variable_1 == 3)
    {
        Popup_Request(POPUP5_AdBlue_DOS_MALFUNC);
    }
    else
    {
        Popup_Delete(POPUP5_AdBlue_DOS_MALFUNC);
    }

    //59.DPD手动再生要求1-DPD需要再生 18FD7C00 Byte：1 Bit：3-1  001：On – solid
    variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();

    if ((V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_PUSH_DPD_SWITCH1_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_PUSH_DPD_SWITCH1_SPEED);
    }

    //60.DPD手动再生要求1-请按下DPD开关 18FD7C00 Byte：1 Bit：3-1   001：On – solid
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP5_PUSH_DPD_SWITCH1);
    }
    else
    {
        Popup_Delete(POPUP5_PUSH_DPD_SWITCH1);
    }

    //61.DPD手动再生要求2-DPD需要再生 18FD7C00 Byte：1 Bit：3-1     100：On – fast blink (1 HZ)
    if ((V_Speed) && (variable_1 == 4))
    {
        Popup_Request(POPUP5_PUSH_DPD_SWITCH2_SPEED);
    }
    else
    {
        Popup_Delete(POPUP5_PUSH_DPD_SWITCH2_SPEED);
    }

    //62.DPD手动再生要求2-请按下DPD开关 18FD7C00 Byte：1 Bit：3-1     100：On – fast blink (1 HZ)
    if ((V_Speed == 0) && (variable_1 == 4))
    {
        Popup_Request(POPUP5_PUSH_DPD_SWITCH2);
    }
    else
    {
        Popup_Delete(POPUP5_PUSH_DPD_SWITCH2);
    }

    //63.TPMS故障-轮胎监控失败  ID：18011733  Byte：6 Bit：ALL 0111(B) or 1000(B) or 1001(B)
    variable_1 = Get_ID_18011733_Sig_Sensor_fault_information();
    if ((variable_1 == 7) || (variable_1 == 8) || (variable_1 == 9) )
    {
        Popup_Request(POPUP5_TPMS_FAILURE);
    }
    else
    {
        Popup_Delete(POPUP5_TPMS_FAILURE);
    }


    //64.TPMS電池低下-轮胎监控传感器电压下降  ID：18011733  Byte：5 Bit：4  01(B)  LID $3E : 0x01
    variable_1 = Get_ID_18011733_Sig_Low_Voltage_Alarm();
    if ((EOL == 0x01) && (variable_1  == 1))
    {
        Popup_Request(POPUP5_TPMS_MONITOR_DROP);
    }
    else
    {
        Popup_Delete(POPUP5_TPMS_MONITOR_DROP);
    }
    //65.DPD手动再生中            //没有执行条件

    //66.遥控车辆高度调整中(无车速) B30 28V
    variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);//获取硬线结果 B30
    if ((V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP6_HEIGHT_CONTROL);
    }
    else
    {
        Popup_Delete(POPUP6_HEIGHT_CONTROL);
    }

    //67.PTO(停车中)(无车速)
    //ID：18FED900  Byte：2 Bit：8,7  01(B)   OR  B01 28V
    variable_1 = Get_ID_18FED900_Sig_PTO_SW();
    variable_2 = Line_In_Get_Status(LINE_IN_PTO);

    if ((V_Speed == 0) || (variable_1 == 1) || ( variable_2 == 1))
    {
        Popup_Request(POPUP6_PTO_STOP);
    }
    else
    {
        Popup_Delete(POPUP6_PTO_STOP);
    }

    //68.充电异常-请在安全的场所停车
    //エンジン始動(350r/min)後、350r/minが5秒以上継続している場合、A34信号（10ms周期で監視）で。
    //发动机启动(350r/min)后、350r/min持续5秒以上时，A34信号（10ms周期监测），
    //检出（Lo 或 连续500次以上电压值＜21V）时。
    variable_1                  = Line_In_Get_Status(LINE_IN_CHARGE);                //A34

    if ((V_Speed) && (variable_1 == 1) && (E_Speed > 350))
    {
        Popup_Request(POPUP7_CHARGE_ABNORMAL_SPEED);
    }
    else
    {
        Popup_Delete(POPUP7_CHARGE_ABNORMAL_SPEED);
    }

    //69.充电异常-请与五十铃公司联系
    if ((V_Speed == 0) && (variable_1 == 1) && (E_Speed > 350))
    {
        Popup_Request(POPUP7_CHARGE_ABNORMAL);
    }
    else
    {
        Popup_Delete(POPUP7_CHARGE_ABNORMAL);
    }

    //70.AMT異常-AMT异常  ID：18FF8503　Bite：1 Bit：2,1   LID $41 : 0x13
    variable_1 = Get_ID_18FF8503_Sig_Stop_Warning();

    if ((EOL == 0x13) && (V_Speed) && (variable_1))
    {
        Popup_Request(POPUP7_AMT_ERROR_SPEED);
    }
    else
    {
        Popup_Delete(POPUP7_AMT_ERROR_SPEED);
    }

    //71.AMT異常-请联系经销商
    if ((EOL == 0x13) && (V_Speed == 0) && (variable_1))
    {
        Popup_Request(POPUP7_AMT_ERROR);
    }
    else
    {
        Popup_Delete(POPUP7_AMT_ERROR);
    }

    //72.补充燃料-油箱单位  LID $43 : 0x82
    //显示条件　 　：　A11的13秒平均値≧128Ω
    //不显示条件　：　A11的13秒平均値< 128Ω

    if ((EOL == 0x82) && (Fuel_Get_Res() > 128))
    {
        Popup_Request(POPUP8_REFUEL);
    }
    else
    {
        Popup_Delete(POPUP8_REFUEL);
    }

    //73.AMT过热-离合器过载 ID：18FF8503　Bite：2 Bit：4,3  001(B)  LID $41 : 0x13
    variable_1 = Get_ID_18FF8503_Sig_Clutch_Overload_warning();
    if ((EOL == 0x13) && (V_Speed) && (variable_1 == 1))
    {
        Popup_Request(POPUP8_ATM_CLUCH_OVERHEATING_SPEED);
    }
    else
    {
        Popup_Delete(POPUP8_ATM_CLUCH_OVERHEATING_SPEED);
    }

    //74.AMT过热-选择合适的档位 ID：18FF8503　Bite：2 Bit：4,3  001(B)  LID $41 : 0x13
    if ((EOL == 0x13) && (V_Speed == 0) && (variable_1 == 1))
    {
        Popup_Request(POPUP8_ATM_CLUCH_OVERHEATING);
    }
    else
    {
        Popup_Delete(POPUP8_ATM_CLUCH_OVERHEATING);
    }

    //75.AMT磨耗-离合器磨损 ID：18FF8503　Bite：2 Bit：2,1  001(B)  LID $41 : 0x13
    variable_1 = Get_ID_18FF8503_Sig_Manouvering_mode();
    if ((EOL == 0x13) && (variable_1 == 1))
    {
        Popup_Request(POPUP1_BRAKE_BRAKE);
    }
    else
    {
        Popup_Delete(POPUP1_BRAKE_BRAKE);
    }


    //76.低电压报警
    //显示条件：发动机启动(350r/min)后，7秒检测到23.5V时
    //显示消失条件：10秒检测到25V以上时
    if ( E_Speed > 350) //转速350R/min
    {
        if ( KL30_Volt < 2350)   //23.5V
        {
            Popup_Request(POPUP8_LOW_VOLTAGE_SPEED);
        }
        else if (KL30_Volt > 2500)
        {
            Popup_Delete(POPUP8_LOW_VOLTAGE_SPEED);
        }
    }
    else
    {
        Popup_Delete(POPUP8_LOW_VOLTAGE_SPEED);
    }

    //77.过电压报警
    //显示条件：发动机启动(350r/min)后，7秒检测到30.4V以上时
    //显示消失条件：10秒检测到29.4V以下时
    if ( E_Speed > 350) //转速350R/min
    {
        if (KL30_Volt > 3044)   //30.44V
        {
            Popup_Request(POPUP8_OVERVOLTAGE);
        }
        else if (KL30_Volt < 2940)
        {
            Popup_Delete(POPUP8_OVERVOLTAGE);
        }
    }
    else
    {
        Popup_Delete(POPUP8_OVERVOLTAGE);
    }

    //78.DPD自动再生-DPD自动再生中  ID：18FED900 (AUXIO)  Byte：8  bit：5,4  01(B)  Engine Speed ： 350rpm以上
    variable_1  = Get_ID_18FED900_Sig_DPF_Regeneration_Status();

    if ((V_Speed) && (E_Speed >= 350) && (variable_1 == 1))
    {
        Popup_Request(POPUP8_DPD_AUTO_SPEED);
    }
    else
    {
        Popup_Delete(POPUP8_DPD_AUTO_SPEED);
    }
    //79.DPD自动再生-再生将自动完成，不需要操作开关
    if ((V_Speed == 0) && (E_Speed >= 350) && (variable_1 == 1)) //转速350R/min
    {
        Popup_Request(POPUP8_DPD_AUTO);
    }
    else
    {
        Popup_Delete(POPUP8_DPD_AUTO);
    }


    //80.气压过低-气压过低请注意  A28 GND
    //OR条件
    //与LED等同时 任一压力传感器为539kPa(1.89V)以下时
    variable_1 = Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS);
    if ((V_Speed) && (variable_1 == 0) )
    {
        Popup_Request(POPUP9_AIR_PRESSURE_SPEED);
    }
    else
    {
        Popup_Delete(POPUP9_AIR_PRESSURE_SPEED);
    }

    //81.气压过低-请冲入空气
    if ((V_Speed == 0) && (variable_1 == 0) )
    {
        Popup_Request(POPUP9_AIR_PRESSURE);
    }
    else
    {
        Popup_Delete(POPUP9_AIR_PRESSURE);
    }

    //82.EBS故障（红）-请在安全的场所停车 ID：18F0010B (EBC1)  Byte：6 Bit：3-4  01(B)  LID $21: 0x01
    variable_1 = Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();
    if ((EOL == 0x01) && (V_Speed ) && (variable_1 == 1))
    {
        Popup_Request(POPUP9_EBS_ERROR_SPEED);
    }
    else
    {
        Popup_Delete(POPUP9_EBS_ERROR_SPEED);
    }
    //83.EBS故障（红）-请与五十铃公司联系
    if ((EOL == 0x01) && (V_Speed == 0 ) && (variable_1 == 1))
    {
        Popup_Request(POPUP9_EBS_ERROR);
    }
    else
    {
        Popup_Delete(POPUP9_EBS_ERROR);
    }

    //84.省油耗建议-急加速
    //85.省油耗建议-急减速
    //86.省油耗建议-请降低发动机转速
    //87.省油耗建议-请降低速度

    //88.发动机机油＆滤清器  ID：18FF3018 Byte：1 Bit：8,7   01(B) 10(B)
    variable_1 = Get_ID_18FF3018_Sig_Engine_Oil_Warnning();
    if (variable_1 == 1 || variable_1 == 2)
    {
        Popup_Request(POPUP11_ENGINE_OIL_FILTER_ERROR);
    }
    else
    {
        Popup_Delete(POPUP11_ENGINE_OIL_FILTER_ERROR);
    }
    //89.燃油滤清器
    //依据警报阈值、前次重置时及现在的ODO值，剩余距离：1000km时，显示提前警报。
    //另外，剩余距离：负值时，再次显示本警报。

    //90.变速箱油


    //91.差速器油


    //92.顺畅系统离合器油


    //93.动力转向液


    //94.更换轮胎・轮胎位置

#endif
}



void Popups_Displaying(uint8_t PopupMsg)
{
    if ( PopupMsg < POPUP_MSG_NUMBER_TOTAL )
    {
        switch ( PopupMsgAttributeTable [ PopupMsg ].Type )
        {
        case POPUP_TYPE_GENERAL:
            GUI_General_Popup_Display(PopupMsg);
            break;

        default:
            break;
        }
    }
}

void Popups_Sound_Playing(uint8_t PopupSnd)
{
    uint8_t ReqCode = 0u;

    ReqCode = Popup_Get_Current_Sound_Req_Code( );

    switch ( PopupSnd )
    {
    default:
        if ( ReqCode )
            Sound_Request(PopupSnd, ReqCode);
        else
            Sound_Delete(PopupSnd);
        break;
    }
}
