/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Interface to user mode driver
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 9535 $
 *  $Date: 2016-08-04 19:45:11 +0200 (Do, 04. Aug 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_DRIVER_H_INCLUDED
#define DAVEHD_DRIVER_H_INCLUDED

#include "davehd_types.h"
#include "davehd_device_data_size_default.h"
/*----------------------------------------------------------------------------------------------------------*/
/* Select if the functions are actually inlined*/
/**/
#ifdef DHD_INLINE_INTERFACE
#define DHD_API_INLINE DHD_INLINE         
#else
#define DHD_API_INLINE 
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Utility macros to build edgecontrol words.*/
/**/
#define DHD_EDGE0(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 0u) )      /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_0_MASK */
#define DHD_EDGE1(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 4u) )      /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_1_MASK */
#define DHD_EDGE2(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 8u) )      /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_2_MASK */
#define DHD_EDGE3(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 12u) )     /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_3_MASK */
#define DHD_EDGE4(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 16u) )     /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_4_MASK */
#define DHD_EDGE5(x)  ((dhd_uint32_t)(( (x) & 0xfu) << 20u) )     /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/  /* see DHD_REG_LIM_CTRL_5_MASK */
#define DHD_EDGE(n,x) ((dhd_uint32_t)(( (x) & 0xfu) << ((n)*4)) ) /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/

/*----------------------------------------------------------------------------------------------------------*/
/* Utility macros to build draw attribute flags.*/
/**/
#define DHD_DRAW_UV(x)  ((dhd_uint32_t) (( (x) & 0xfu ) << 0u) )   /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/

#define DHD_DRAW_RHW(x) ((dhd_uint32_t) (( (x) & 0xfu) << 4u) )   /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/
#define DHD_DRAW_COL(x) ((dhd_uint32_t) (( (x) & 0xfu) << 8u) )   /* PRQA S 3453 *//* $Misra: #PERF_MACRO_FOR_PERFORMANCE $*/

/*----------------------------------------------------------------------------------------------------------*/
#define DHD_PREMULTIPLY_LIMIT_RGB  256ul       /* additional flag to that can be or'ed to dhd_pixel_org_t or dhd_texel_org_t enums*/
#define DHD_PIXEL_ORG_FLAG         0x4000u     /* internal flag indicating a buffer format is referring to a framebuffer (dhd_pixel_org_t)             */
#define DHD_TEXEL_ORG_FLAG         0x8000u     /* internal flag indicating a buffer format is referring to a texture (dhd_texel_org_t)*/
#define DHD_DEPTH_ORG_FLAG         0xC000u     /* internal flag indicating a buffer format is referring to a ZSAbuffer (dhd_depth_org_t)*/
#define DHD_BUFFERORG_MASK         0xF000u     /* mask covering all internal buffer format org flags*/

/*----------------------------------------------------------------------------------------------------------*/
/* Flags for building edgecontrol words. Designed to be used with DHD_EDGE macros.*/
/**/
typedef enum tagdhd_edge_flag {   /* bits have to match dhd_psu_lim_control_decomp_t layout*/
  E_DHD_ENABLE   = 1,             /* Edge is enabled (only enabled edges are considered in any way)*/
  E_DHD_SHARED   = 2,             /* Edge is shared (not antialiased)*/
  E_DHD_USE_ENUM = 4,             /* Edge is used during enumeration (only Bezier curves use non enum edges)*/
  E_DHD_INVERT   = 8,             /* Insied/Outside direction if this edge is inverted*/
  E_DHD_IEDGE    = 1+2+4,         /* Shortcut for 'inner' edge (combination of E_DHD_ENABLE, E_DHD_USE_ENUM and E_DHD_SHARED)*/
  E_DHD_OEDGE    = 1  +4          /* Shortcut for 'outer' edge (combination of E_DHD_ENABLE and E_DHD_USE_ENUM) */
} dhd_edge_flag_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Flags for bezier features inside edgecontrol word. */
/**/
typedef enum tagdhd_bezieredge_flag {  
  E_DHD_BEZIER_ENABLE   = 1,      /* Bezier rendering is enabled  */
  E_DHD_BEZIER_CONCAVE  = 2       /* Render the concave part of bezier (defaults to convex)*/
} dhd_bezieredge_flag_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Flags for draw command attribute control.*/
/* Flags can also be built using the DHD_DRAW_UV, DHD_DRAW_RHW and DHD_DRAW_COL macros.*/
/* See Also:*/
/*  dhd_draw*/
/**/
typedef enum tagdhd_drawattribute_flag {  
  E_DHD_DRAW_FLAT       = 0,                      /* drawing should use NO attributes (can not be combined with other E_DHD_DRAW_* elements)*/

  E_DHD_DRAW_UV         = ((dhd_uint32_t) (( 1ul & 0xful ) << 0ul) ), /*DHD_DRAW_UV(1ul), */        /* drawing should use one set of UV corrdinates per primitive*/
  E_DHD_DRAW_1UVS       = DHD_DRAW_UV(1ul),         /* drawing should use one set of UV corrdinates per primitive*/
  E_DHD_DRAW_2UVS       = DHD_DRAW_UV(2ul),         /* drawing should use two sets of UV corrdinates per primitive (texture units 0..1)*/
  E_DHD_DRAW_3UVS       = DHD_DRAW_UV(3ul),         /* drawing should use three sets of UV corrdinates per primitive (texture units 0..2)*/
  E_DHD_DRAW_4UVS       = DHD_DRAW_UV(4ul),         /* drawing should use four sets of UV corrdinates per primitive (texture units 0..3)*/
  E_DHD_DRAW_5UVS       = DHD_DRAW_UV(5ul),         /* drawing should use fife sets of UV corrdinates per primitive (texture units 0..4)*/
  E_DHD_DRAW_6UVS       = DHD_DRAW_UV(6ul),         /* drawing should use six sets of UV corrdinates per primitive (texture units 0..5)*/
  E_DHD_DRAW_7UVS       = DHD_DRAW_UV(7ul),         /* drawing should use seven sets of UV corrdinates per primitive (texture units 0..6)*/
  E_DHD_DRAW_8UVS       = DHD_DRAW_UV(8ul),         /* drawing should use eight sets of UV corrdinates per primitive (texture units 0..7)*/

  E_DHD_DRAW_RHW        = DHD_DRAW_RHW(1ul),         /* drawing should use one set of RHW corrdinates per primitive*/
  E_DHD_DRAW_1RHWS      = DHD_DRAW_RHW(1ul),         /* drawing should use one set of RHW corrdinates per primitive*/
  E_DHD_DRAW_2RHWS      = DHD_DRAW_RHW(2ul),         /* drawing should use two sets of RHW corrdinates per primitive (texture units 0..1)*/
  E_DHD_DRAW_3RHWS      = DHD_DRAW_RHW(3ul),         /* drawing should use three sets of RHW corrdinates per primitive (texture units 0..2)*/
  E_DHD_DRAW_4RHWS      = DHD_DRAW_RHW(4ul),         /* drawing should use four sets of RHW corrdinates per primitive (texture units 0..3)*/
  E_DHD_DRAW_5RHWS      = DHD_DRAW_RHW(5ul),         /* drawing should use fife sets of RHW corrdinates per primitive (texture units 0..4)*/
  E_DHD_DRAW_6RHWS      = DHD_DRAW_RHW(6ul),         /* drawing should use six sets of RHW corrdinates per primitive (texture units 0..5)*/
  E_DHD_DRAW_7RHWS      = DHD_DRAW_RHW(7ul),         /* drawing should use seven sets of RHW corrdinates per primitive (texture units 0..6)*/
  E_DHD_DRAW_8RHWS      = DHD_DRAW_RHW(8ul),         /* drawing should use eight sets of RHW corrdinates per primitive (texture units 0..7)*/

  E_DHD_DRAW_COL        = DHD_DRAW_COL(1ul),         /* drawing should use one constant color per primitive*/
  E_DHD_DRAW_1COLS      = DHD_DRAW_COL(1ul),         /* drawing should use one constant color per primitive*/
  E_DHD_DRAW_2COLS      = DHD_DRAW_COL(2ul),         /* drawing should use two constant colors per primitive (colors 0..1)*/
  E_DHD_DRAW_3COLS      = DHD_DRAW_COL(3ul),         /* drawing should use three constant colors per primitive (colors 0..2)*/
  E_DHD_DRAW_4COLS      = DHD_DRAW_COL(4ul),         /* drawing should use four constant colors per primitive (colors 0..3)*/
  E_DHD_DRAW_5COLS      = DHD_DRAW_COL(5ul),         /* drawing should use fife constant colors per primitive (colors 0..4)*/
  E_DHD_DRAW_6COLS      = DHD_DRAW_COL(6ul),         /* drawing should use six constant colors per primitive (colors 0..5)*/
  E_DHD_DRAW_7COLS      = DHD_DRAW_COL(7ul),         /* drawing should use seven constant colors per primitive (colors 0..6)*/
  E_DHD_DRAW_8COLS      = DHD_DRAW_COL(8ul),         /* drawing should use eight constant colors per primitive (colors 0..7)    */
  E_DHD_DRAW_9COLS      = DHD_DRAW_COL(9ul),         /* drawing should use two constant colors per primitive (colors 0..8)*/
  E_DHD_DRAW_10COLS     = DHD_DRAW_COL(10ul),        /* drawing should use two constant colors per primitive (colors 0..9)*/
  E_DHD_DRAW_11COLS     = DHD_DRAW_COL(11ul),        /* drawing should use three constant colors per primitive (colors 0..10)*/
  E_DHD_DRAW_12COLS     = DHD_DRAW_COL(12ul),        /* drawing should use four constant colors per primitive (colors 0..11)*/
  E_DHD_DRAW_13COLS     = DHD_DRAW_COL(13ul),        /* drawing should use fife constant colors per primitive (colors 0..12)*/
  E_DHD_DRAW_14COLS     = DHD_DRAW_COL(14ul),        /* drawing should use six constant colors per primitive (colors 0..13)*/
  E_DHD_DRAW_15COLS     = DHD_DRAW_COL(15ul),        /* drawing should use seven constant colors per primitive (colors 0..14)*/

  E_DHD_DRAW_DEPTH      = 0x1000ul,                  /* drawing should use a depth gradient per primitive*/
  E_DHD_DRAW_STRIPE     = 0x2000ul,                  /* drawing should use psu stripe width and offset from dhd_prim_data_t (only array draw commands)*/
  E_DHD_DRAW_COMMONBOX  = 0x4000ul                   /* drawing should not update the bounding box as all primitives will share a common bounding box*/
 
} dhd_drawattribute_flag_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Blend Factor. The following values can be selected as source or destination blendfactor.*/
/* See Also: dhd_set_color_blending, dhd_set_alpha_blending*/
/**/
typedef enum tagdhd_blend_factor {
  E_DHD_ZERO                  = 2,             /* Constant zero*/
  E_DHD_ONE                   = 2 + 4,         /* Constant one*/
  E_DHD_SRC_COLOR             = 0,             /* Fragment color (sc)*/
  E_DHD_DST_COLOR             = 1,             /* Framebuffer color (dc)*/
  E_DHD_ONE_MINUS_SRC_COLOR   = 0 + 4,         /* Inverted fragment color ( 1 - sc )*/
  E_DHD_ONE_MINUS_DST_COLOR   = 1 + 4,         /* Inverted framebuffer color ( 1 - dc )  */
  E_DHD_SRC_ALPHA             = 0 + 8,         /* Fragment alpha (sa)*/
  E_DHD_DST_ALPHA             = 1 + 8,         /* Framebuffer alpha (da)*/
  E_DHD_ONE_MINUS_SRC_ALPHA   = 0 + 4 + 8,     /* Inverted fragment alpha ( 1 - sa )*/
  E_DHD_ONE_MINUS_DST_ALPHA   = 1 + 4 + 8      /* Inverted framebuffer alpha ( 1 - da )*/

} dhd_blend_factor_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Blend Modes. Possible settings for color and alpha blend modes. */
/* See Also: dhd_set_blend_func*/
/**/
typedef enum tagdhd_blend_mode {                      
  E_DHD_BLEND                 ,/* Standard blend : f_src * src + f_dst * dst*/
  E_DHD_MULTIPLY_ADD          ,/* Multiply add blend : f_src * src + f_dst*/
  E_DHD_MULTIPLY              ,/* OVG multiply : (f_src+dst) * src + f_dst * dst*/
  E_DHD_DARKEN                ,/* OVG darken : min(src + f_dst * dst, dst + f_src * src)*/
  E_DHD_LIGHTEN                /* OVG lighten : max(src + f_dst * dst, dst + f_src * src)*/
 
} dhd_blend_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Framebuffer pixel organization. Describes the pixel size and encoding for framebuffer reads and writes.*/
/* Note that on reads luminance information is copied to all color channels (r,g and b) and formats without*/
/* an alpha channel will use the blue channel data for alpha. */
/* Most formats can be used in a _PRE variation that will limit the color channels to never exceed the */
/* alpha channel value on reads (to ensure valid premultiplied alpha data).*/
/**/
typedef enum tagdhd_pixel_org {
  E_DHD_PIXEL_ORG_ARGB_8888     = (dhd_uint32_t) (0ul | DHD_PIXEL_ORG_FLAG),   /* 32 Bit pixel using A8, R8, G8, B8 layout*/
  E_DHD_PIXEL_ORG_RGBA_8888     = (dhd_uint32_t) (1ul | DHD_PIXEL_ORG_FLAG),   /* 32 Bit pixel using R8, G8, B8, A8 layout*/
  E_DHD_PIXEL_ORG_ARGB_4444     = (dhd_uint32_t) (2ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using A4, R4, G4, B4 layout*/
  E_DHD_PIXEL_ORG_RGBA_4444     = (dhd_uint32_t) (3ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using R4, G4, B4, A4 layout*/
  E_DHD_PIXEL_ORG_ARGB_1555     = (dhd_uint32_t) (4ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using A1, R5, G5, B5 layout*/
  E_DHD_PIXEL_ORG_RGBA_5551     = (dhd_uint32_t) (5ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using R5, G5, B5, A1 layout*/
  E_DHD_PIXEL_ORG_RGB_565       = (dhd_uint32_t) (6ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using R5, G6, B5 layout */
  E_DHD_PIXEL_ORG_AL_88         = (dhd_uint32_t) (7ul | DHD_PIXEL_ORG_FLAG),   /* 16 Bit pixel using A8, L8 layout*/
  E_DHD_PIXEL_ORG_AL_44         = (dhd_uint32_t) (8ul | DHD_PIXEL_ORG_FLAG),   /* 8 Bit pixel using A4, L4 layout*/
  E_DHD_PIXEL_ORG_A_8           = (dhd_uint32_t) (9ul | DHD_PIXEL_ORG_FLAG),   /* 8 Bit pixel using alpha only*/
  E_DHD_PIXEL_ORG_L_8           = (dhd_uint32_t) (10ul | DHD_PIXEL_ORG_FLAG),  /* 8 Bit pixel using luminance only */
  E_DHD_PIXEL_ORG_AL_17         = (dhd_uint32_t) (11ul | DHD_PIXEL_ORG_FLAG),  /* 8 Bit pixel using A1, L7 layout*/

  E_DHD_PIXEL_ORG_ARGB_8888_PRE = E_DHD_PIXEL_ORG_ARGB_8888 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* 32 Bit pixel using A8, R8, G8, B8 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_RGBA_8888_PRE = E_DHD_PIXEL_ORG_RGBA_8888 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* 32 Bit pixel using R8, G8, B8, A8 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_ARGB_4444_PRE = E_DHD_PIXEL_ORG_ARGB_4444 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* DHD_PREMULTIPLY_LIMIT_RGB Bit pixel using A4, R4, G4, B4 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_RGBA_4444_PRE = E_DHD_PIXEL_ORG_RGBA_4444 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* DHD_PREMULTIPLY_LIMIT_RGB Bit pixel using R4, G4, B4, A4 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_ARGB_1555_PRE = E_DHD_PIXEL_ORG_ARGB_1555 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* DHD_PREMULTIPLY_LIMIT_RGB Bit pixel using A1, R5, G5, B5 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_RGBA_5551_PRE = E_DHD_PIXEL_ORG_RGBA_5551 | DHD_PREMULTIPLY_LIMIT_RGB ,   /* DHD_PREMULTIPLY_LIMIT_RGB Bit pixel using R5, G5, B5, A1 layout assuming premultiplied alpha  */
  E_DHD_PIXEL_ORG_AL_88_PRE     = E_DHD_PIXEL_ORG_AL_88     | DHD_PREMULTIPLY_LIMIT_RGB ,   /* DHD_PREMULTIPLY_LIMIT_RGB Bit pixel using A8, L8 layout assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_AL_44_PRE     = E_DHD_PIXEL_ORG_AL_44     | DHD_PREMULTIPLY_LIMIT_RGB ,   /* 8 Bit pixel using A4, L4 layout assuming premultiplied alpha  */
  E_DHD_PIXEL_ORG_L_8_PRE       = E_DHD_PIXEL_ORG_L_8       | DHD_PREMULTIPLY_LIMIT_RGB ,   /* 8 Bit pixel using luminance only assuming premultiplied alpha*/
  E_DHD_PIXEL_ORG_AL_17_PRE     = E_DHD_PIXEL_ORG_AL_17     | DHD_PREMULTIPLY_LIMIT_RGB     /* 8 Bit pixel using A1, L7 layout assuming premultiplied alpha*/

} dhd_pixel_org_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Texture CLUT mode. To be used in combination with the dhd_texel_org. */
/* Note that texture filtering has to be disabled for multi channel lookup formats (CLUT_MAP_*).*/
/**/
typedef enum tagdhd_clutmode_org {
  E_DHD_CLUT_NONE = 0,                 /* LUT is not used*/
  E_DHD_CLUT_INDEXED_COLOR = (dhd_uint32_t) (1ul << 4ul),     /* texture blue channel is used as LUT index*/
  E_DHD_CLUT_MAP_RGB = (dhd_uint32_t) (2ul << 4ul),           /* RGB channels are used as LUT indices */
  E_DHD_CLUT_MAP_ARGB = (dhd_uint32_t) (3ul << 4ul),          /* ARGB channels are used as LUT indices*/
  E_DHD_CLUT_KERNEL = (dhd_uint32_t) (4ul << 4ul),            /* lookup using a filter kernel from the CLUT (see dhd_set_texture_kernel)*/
  E_DHD_CLUT_KERNEL_SIGNED = (dhd_uint32_t) (5ul << 4ul)      /* lookup using a signed filter kernel from the CLUT (see dhd_set_texture_kernel)*/

} dhd_clutmode_org_t;    

/*----------------------------------------------------------------------------------------------------------*/
/* Texture pixel organization. Describes the texel size and encoding for texture reads.*/
/* Note that luminance information is copied to all color channels (r,g and b) and formats without an alpha*/
/* channel will copy the blue channel data to alpha. */
/* Most formats can be used in a _PRE variation that will limit the color channels to never exceed the */
/* alpha channel value on reads (to ensure valid premultiplied alpha data).*/
/**/
typedef enum tagdhd_texel_org {
  E_DHD_TEXEL_ORG_ARGB_8888 = (dhd_uint32_t) (0ul | DHD_TEXEL_ORG_FLAG),    /* 32 Bit texel using A8, R8, G8, B8 layout*/
  E_DHD_TEXEL_ORG_RGBA_8888 = (dhd_uint32_t) (1ul | DHD_TEXEL_ORG_FLAG),    /* 32 Bit texel using R8, G8, B8, A8 layout*/
  E_DHD_TEXEL_ORG_ARGB_4444 = (dhd_uint32_t) (2ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using A4, R4, G4, B4 layout*/
  E_DHD_TEXEL_ORG_RGBA_4444 = (dhd_uint32_t) (3ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using R4, G4, B4, A4 layout*/
  E_DHD_TEXEL_ORG_ARGB_1555 = (dhd_uint32_t) (4ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using A1, R5, G5, B5 layout*/
  E_DHD_TEXEL_ORG_RGBA_5551 = (dhd_uint32_t) (5ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using R5, G5, B5, A1 layout*/
  E_DHD_TEXEL_ORG_RGB_565   = (dhd_uint32_t) (6ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using R5, G6, B5 layout */
  E_DHD_TEXEL_ORG_AL_88     = (dhd_uint32_t) (7ul | DHD_TEXEL_ORG_FLAG),    /* 16 Bit texel using A8, L8 layout*/
  E_DHD_TEXEL_ORG_AL_44     = (dhd_uint32_t) (8ul | DHD_TEXEL_ORG_FLAG),    /* 8 Bit texel using A4, L4 layout*/
  E_DHD_TEXEL_ORG_AL_17     = (dhd_uint32_t) (9ul | DHD_TEXEL_ORG_FLAG),    /* 8 Bit texel using A1, L7 layout*/
  E_DHD_TEXEL_ORG_AL_8      = (dhd_uint32_t) (10ul | DHD_TEXEL_ORG_FLAG),   /* 8 Bit texel using a single value for all channels*/
  E_DHD_TEXEL_ORG_AL_4      = (dhd_uint32_t) (11ul | DHD_TEXEL_ORG_FLAG),   /* 4 Bit texel using a single value for all channels*/
  E_DHD_TEXEL_ORG_AL_2      = (dhd_uint32_t) (12ul | DHD_TEXEL_ORG_FLAG),   /* 2 Bit texel using a single value for all channels*/
  E_DHD_TEXEL_ORG_AL_1      = (dhd_uint32_t) (13ul | DHD_TEXEL_ORG_FLAG),   /* 1 Bit texel using a single value for all channels*/

  E_DHD_TEXEL_ORG_CLUT_88 = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_88 | E_DHD_CLUT_INDEXED_COLOR),  /* 8 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_44 = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_44 | E_DHD_CLUT_INDEXED_COLOR),  /* 4 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_8  = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_8 | E_DHD_CLUT_INDEXED_COLOR),   /* 8 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_4  = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_4 | E_DHD_CLUT_INDEXED_COLOR),   /* 4 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_2  = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_2 | E_DHD_CLUT_INDEXED_COLOR),   /* 2 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_1  = (dhd_uint32_t) (E_DHD_TEXEL_ORG_AL_1 | E_DHD_CLUT_INDEXED_COLOR),   /* 1 Bit texel used as index into the CLUT */

  E_DHD_TEXEL_ORG_ARGB_8888_PRE = E_DHD_TEXEL_ORG_ARGB_8888 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 32 Bit texel using A8, R8, G8, B8 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_RGBA_8888_PRE = E_DHD_TEXEL_ORG_RGBA_8888 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 32 Bit texel using R8, G8, B8, A8 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_ARGB_4444_PRE = E_DHD_TEXEL_ORG_ARGB_4444 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 16 Bit texel using A4, R4, G4, B4 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_RGBA_4444_PRE = E_DHD_TEXEL_ORG_RGBA_4444 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 16 Bit texel using R4, G4, B4, A4 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_ARGB_1555_PRE = E_DHD_TEXEL_ORG_ARGB_1555 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 16 Bit texel using A1, R5, G5, B5 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_RGBA_5551_PRE = E_DHD_TEXEL_ORG_RGBA_5551 | DHD_PREMULTIPLY_LIMIT_RGB,    /* 16 Bit texel using R5, G5, B5, A1 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_AL_88_PRE =     E_DHD_TEXEL_ORG_AL_88 | DHD_PREMULTIPLY_LIMIT_RGB,        /* 16 Bit texel using A8, L8 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_AL_44_PRE =     E_DHD_TEXEL_ORG_AL_44 | DHD_PREMULTIPLY_LIMIT_RGB,        /* 8 Bit texel using A4, L4 layout assuming premultiplied alpha*/
  E_DHD_TEXEL_ORG_AL_17_PRE =     E_DHD_TEXEL_ORG_AL_17 | DHD_PREMULTIPLY_LIMIT_RGB,        /* 2 channel 17, 8 bit (alpha=channel1, R/G/B=channel0) assuming premultiplied alpha */

  E_DHD_TEXEL_ORG_CLUT_88_PRE = E_DHD_TEXEL_ORG_CLUT_88 | DHD_PREMULTIPLY_LIMIT_RGB,        /* 8 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_44_PRE = E_DHD_TEXEL_ORG_CLUT_44 | DHD_PREMULTIPLY_LIMIT_RGB,        /* 4 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_8_PRE  = E_DHD_TEXEL_ORG_CLUT_8  | DHD_PREMULTIPLY_LIMIT_RGB,        /* 8 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_4_PRE  = E_DHD_TEXEL_ORG_CLUT_4  | DHD_PREMULTIPLY_LIMIT_RGB,        /* 4 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_2_PRE  = E_DHD_TEXEL_ORG_CLUT_2  | DHD_PREMULTIPLY_LIMIT_RGB,        /* 2 Bit texel used as index into the CLUT*/
  E_DHD_TEXEL_ORG_CLUT_1_PRE  = E_DHD_TEXEL_ORG_CLUT_1  | DHD_PREMULTIPLY_LIMIT_RGB         /* 1 Bit texel used as index into the CLUT*/

} dhd_texel_org_t;    

/*----------------------------------------------------------------------------------------------------------*/
/* Depth/Stencil/Alpha Buffer organization. Describes the pixel size and encoding used for the ZSA Buffer.*/
/**/
typedef enum tagdhd_depth_org {
  E_DHD_DEPTH_ORG_S8A8Z16 = 0ul | DHD_DEPTH_ORG_FLAG,    /* 32 Bit pixel using S8, A8, Z16 layout*/
  E_DHD_DEPTH_ORG_S8A0Z24 = 1ul | DHD_DEPTH_ORG_FLAG,    /* 32 Bit pixel using S8, Z24 layout without global alpha*/
  E_DHD_DEPTH_ORG_S1A5Z10 = 2ul | DHD_DEPTH_ORG_FLAG,    /* 16 Bit pixel using S1, A5, Z10 layout*/
  E_DHD_DEPTH_ORG_S8A8Z0  = 3ul | DHD_DEPTH_ORG_FLAG,    /* 16 bit pixel using S8, A8 layout */
  E_DHD_DEPTH_ORG_S1A0Z15 = 4ul | DHD_DEPTH_ORG_FLAG,    /* 16 Bit pixel using S1, Z15 layout without global alpha*/
  E_DHD_DEPTH_ORG_S1A7Z0  = 5ul | DHD_DEPTH_ORG_FLAG,    /* 8 Bit pixel using S1, A7 layout without depth*/
  E_DHD_DEPTH_ORG_S8A0Z0  = 6ul | DHD_DEPTH_ORG_FLAG,    /* 8 Bit pixel using only stencil*/
  E_DHD_DEPTH_ORG_S0A8Z0  = 7ul | DHD_DEPTH_ORG_FLAG     /* 8 Bit pixel using only global alpha*/

} dhd_depth_org_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Read decision flags.*/
/**/
typedef enum tagdhd_read_mode {   /* bits have to match dhd_fb_read_flags_decomp_t layout  */
  E_DHD_READ_NEVER            = 0,
  E_DHD_USING_ONE_MINUS_ALPHA = 1,      /*  E_DHD_ONE_MINUS_SRC_ALPHA is a dst blend factor ( Read when pixel src alpha != 1.0 )*/
  E_DHD_USING_ALPHA           = 2,      /*  E_DHD_SRC_ALPHA           is a dst blend factor ( Read when pixel src alpha != 0.0 )*/
  E_DHD_READ_ALWAYS           = 1 + 2

} dhd_read_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Comparison mode. Comparisons are used in depth, stencil and alpha tests.*/
/**/
typedef enum tagdhd_compare_op {
  E_DHD_PASS_NEVER      ,       /* pass never*/
  E_DHD_PASS_LESS       ,       /* pass if less */
  E_DHD_PASS_EQUAL      ,       /* pass if equal*/
  E_DHD_PASS_LEQUAL     ,       /* pass if less or equal*/
  E_DHD_PASS_GREATER    ,       /* pass if greater*/
  E_DHD_PASS_NOT_EQUAL  ,       /* pass if not equal*/
  E_DHD_PASS_GEQUAL     ,       /* pass if greater or equal*/
  E_DHD_PASS_ALWAYS             /* pass always */

} dhd_compare_op_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Colorunit output scale. Color and alpha channel information can be scaled at each color unit output stage.*/
/**/
typedef enum tagdhd_outscale {
  E_DHD_SCALE_HALF,             /* scale by 0.5 */
  E_DHD_SCALE_ONE ,             /* scale by 1.0 (do not scale)*/
  E_DHD_SCALE_TWO ,             /* scale by 2.0*/
  E_DHD_SCALE_FOUR              /* scale by 4.0*/

} dhd_outscale_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Color channel multiplexing. Every possible permutation of alpha, red, green and blue input channels can*/
/* be selected. The first char is mapped to the output red channel, the second to green and the third to blue.*/
/* E_DHD_CHANNEL_BAR would map out_red = in_blue, out_green = in_alpha and out_blue = in_red*/
/**/
typedef enum tagdhd_channel_select {
  E_DHD_CHANNEL_AAA, E_DHD_CHANNEL_AAR, E_DHD_CHANNEL_AAG, E_DHD_CHANNEL_AAB, E_DHD_CHANNEL_ARA, E_DHD_CHANNEL_ARR, E_DHD_CHANNEL_ARG, E_DHD_CHANNEL_ARB, 
  E_DHD_CHANNEL_AGA, E_DHD_CHANNEL_AGR, E_DHD_CHANNEL_AGG, E_DHD_CHANNEL_AGB, E_DHD_CHANNEL_ABA, E_DHD_CHANNEL_ABR, E_DHD_CHANNEL_ABG, E_DHD_CHANNEL_ABB,
  E_DHD_CHANNEL_RAA, E_DHD_CHANNEL_RAR, E_DHD_CHANNEL_RAG, E_DHD_CHANNEL_RAB, E_DHD_CHANNEL_RRA, E_DHD_CHANNEL_RRR, E_DHD_CHANNEL_RRG, E_DHD_CHANNEL_RRB,
  E_DHD_CHANNEL_RGA, E_DHD_CHANNEL_RGR, E_DHD_CHANNEL_RGG, E_DHD_CHANNEL_RGB, E_DHD_CHANNEL_RBA, E_DHD_CHANNEL_RBR, E_DHD_CHANNEL_RBG, E_DHD_CHANNEL_RBB, 
  E_DHD_CHANNEL_GAA, E_DHD_CHANNEL_GAR, E_DHD_CHANNEL_GAG, E_DHD_CHANNEL_GAB, E_DHD_CHANNEL_GRA, E_DHD_CHANNEL_GRR, E_DHD_CHANNEL_GRG, E_DHD_CHANNEL_GRB, 
  E_DHD_CHANNEL_GGA, E_DHD_CHANNEL_GGR, E_DHD_CHANNEL_GGG, E_DHD_CHANNEL_GGB, E_DHD_CHANNEL_GBA, E_DHD_CHANNEL_GBR, E_DHD_CHANNEL_GBG, E_DHD_CHANNEL_GBB, 
  E_DHD_CHANNEL_BAA, E_DHD_CHANNEL_BAR, E_DHD_CHANNEL_BAG, E_DHD_CHANNEL_BAB, E_DHD_CHANNEL_BRA, E_DHD_CHANNEL_BRR, E_DHD_CHANNEL_BRG, E_DHD_CHANNEL_BRB, 
  E_DHD_CHANNEL_BGA, E_DHD_CHANNEL_BGR, E_DHD_CHANNEL_BGG, E_DHD_CHANNEL_BGB, E_DHD_CHANNEL_BBA, E_DHD_CHANNEL_BBR, E_DHD_CHANNEL_BBG, E_DHD_CHANNEL_BBB

} dhd_channel_select_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Color channel selection. Any input channel can be selected for the alpha output.*/
/**/
typedef enum tagdhd_channel {
  E_DHD_CHANNEL_A,            /* Alpha*/
  E_DHD_CHANNEL_R,            /* Red*/
  E_DHD_CHANNEL_G,            /* Green*/
  E_DHD_CHANNEL_B             /* Blue*/

} dhd_channel_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Colorunit input selection. Each of the colorunit operands is based on one of this sources.*/
/**/
typedef enum tagdhd_col_input {
  E_DHD_INPUT_ZERO ,          /* Constant zero*/
  E_DHD_INPUT_COVERAGE ,      /* Fragment coverage*/
  E_DHD_INPUT_PREVIOUS ,      /* Previous units output*/
  E_DHD_INPUT_COLOR_0,        /* Constant color 0*/
  E_DHD_INPUT_COLOR_1,        /* Constant color 1*/
  E_DHD_INPUT_COLOR_2,        /* Constant color 2*/
  E_DHD_INPUT_COLOR_3,        /* Constant color 3 */
  E_DHD_INPUT_COLOR_4,        /* Constant color 4*/
  E_DHD_INPUT_COLOR_5,        /* Constant color 5*/
  E_DHD_INPUT_COLOR_6,        /* Constant color 6 */
  E_DHD_INPUT_COLOR_7,        /* Constant color 7 */
  E_DHD_INPUT_COLOR_8,        /* Constant color 8 */
  E_DHD_INPUT_COLOR_9,        /* Constant color 9 */
  E_DHD_INPUT_COLOR_10,       /* Constant color 10 */
  E_DHD_INPUT_COLOR_11,       /* Constant color 11*/
  E_DHD_INPUT_COLOR_12,       /* Constant color 12*/
  E_DHD_INPUT_COLOR_13,       /* Constant color 13*/
  E_DHD_INPUT_COLOR_14,       /* Constant color 14*/
  E_DHD_INPUT_COLOR_15,       /* Constant color 15*/
  E_DHD_INPUT_TEXTURE_0,      /* Texture 0  */
  E_DHD_INPUT_TEXTURE_1,      /* Texture 1*/
  E_DHD_INPUT_TEXTURE_2,      /* Texture 2  */
  E_DHD_INPUT_TEXTURE_3,      /* Texture 3  */
  E_DHD_INPUT_TEXTURE_4,      /* Texture 4  */
  E_DHD_INPUT_TEXTURE_5,      /* Texture 5  */
  E_DHD_INPUT_TEXTURE_6,      /* Texture 6 */
  E_DHD_INPUT_TEXTURE_7       /* Texture 7*/

} dhd_col_input_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Colorunit input modifiers.*/
/**/
typedef enum tagdhd_col_modify {
  E_DHD_INPUT_DIRECT            = 0,         /* operand not modified */
  E_DHD_INPUT_NEG9              = 1,         /* E_COL_OP_INVERT_MODE_INVERT_ALL_9*/
  E_DHD_INPUT_NEG               = 2,         /* E_COL_OP_INVERT_MODE_INVERT_8_LSBS*/
  E_DHD_INPUT_NEG9_BIAS         = 3,         /* E_COL_OP_INVERT_MODE_INVERT_SUB_128*/
  E_DHD_INPUT_SCALE2            = 0 + 4,     /* E_COL_OP_INVERT_MODE_NO_INVERSION  | mul2*/
  E_DHD_INPUT_NEG9_SCALE2       = 1 + 4,     /* E_COL_OP_INVERT_MODE_INVERT_ALL_9  | mul2*/
  E_DHD_INPUT_NEG_SCALE2        = 2 + 4,     /* E_COL_OP_INVERT_MODE_INVERT_8_LSBS | mul2*/
  E_DHD_INPUT_NEG9_BIAS_SCALE2  = 3 + 4      /* E_COL_OP_INVERT_MODE_INVERT_SUB_128 | mul2*/
  
} dhd_col_modify_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Colorunit operation modes. To simplify the colorunit operand selection unused operands can be omitted*/
/* if the operation mode is specified correctly.*/
/**/
typedef enum tagdhd_color_op {
  E_DHD_OP_COPY,                          /* out = op1a*/
  E_DHD_OP_MUL,                           /* out = op1a * op2a*/
  E_DHD_OP_ADD,                           /* out = op1a + op1b*/
  E_DHD_OP_MULADD,                        /* out = op1a * op2a + op3*/
  E_DHD_OP_LERP,                          /* out = (op1a + op1b) * op2a + op3*/
  E_DHD_OP_PROD,                          /* out = (op1a + op1b) * (op2a + op2b)*/
  E_DHD_OP_FULL                           /* out = (op1a + op1b) * (op2a + op2b) + op3*/

} dhd_color_op_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Texture wrap mode. */
/**/
typedef enum tagdhd_wrap_mode {
  E_DHD_TEX_CLAMP,                         /* no repeat*/
  E_DHD_TEX_WRAP,                          /* simple repeat*/
  E_DHD_TEX_MIRROR,                        /* mirrored repeat*/
  E_DHD_TEX_BORDER                         /* use border color outside texture*/

} dhd_wrap_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Texture address mode.*/
/**/
typedef enum tagdhd_address_mode {
  E_DHD_ACCESS_LINEAR               = 0 + (0*8),    /* linear (no swizzle)               */
  E_DHD_ACCESS_SWIZZLE_4            = 1 + (0*8),    /* 4x4 block swizzle*/
  E_DHD_ACCESS_SWIZZLE_16           = 2 + (0*8),    /* 16x16 block swizzle*/
  E_DHD_ACCESS_SWIZZLE_FULL         = 3 + (0*8),    /* full swizzle*/
  E_DHD_ACCESS_INVERSE_SWIZZLE_4    = 4 + (0*8),    /* inverse 4x4 block swizzle*/
  E_DHD_ACCESS_INVERSE_SWIZZLE_16   = 5 + (0*8),    /* inverse 16x16 block swizzle*/
  E_DHD_ACCESS_VIRTUAL_TILED_2      = 6 + (1*8),    /* virtual tiled 2 bursts per cacheline*/
  E_DHD_ACCESS_VIRTUAL_TILED_4      = 6 + (2*8),    /* virtual tiled 4 bursts per cacheline*/
  E_DHD_ACCESS_VIRTUAL_TILED_8      = 6 + (3*8),    /* virtual tiled 8 bursts per cacheline*/
  E_DHD_ACCESS_VIRTUAL_TILED_16     = 6 + (4*8)     /* virtual tiled 16 bursts per cacheline*/

} dhd_address_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Stencil buffer operation.*/
/**/
typedef enum tagdhd_stencil_op {
  E_DHD_STENCIL_OP_ZERO,                  /* set to zero*/
  E_DHD_STENCIL_OP_REPLACE,               /* replace with stencil ref*/
  E_DHD_STENCIL_OP_INCR,                  /* increment stencil   */
  E_DHD_STENCIL_OP_DECR,                  /* decrement stencil*/
  E_DHD_STENCIL_OP_INVERT,                /* invert stencil*/
  E_DHD_STENCIL_OP_KEEP                   /* do not modify */

} dhd_stencil_op_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Global alphamask operation mode.*/
/**/
typedef enum tagdhd_alphamask_mode {
  E_DHD_ALPHAMASK_DISABLE        = (0ul << 2ul) | (0ul << 1ul) | 0ul,     /* disable global alpha processing*/
  E_DHD_ALPHAMASK_MULTIPLY       = (0ul << 2ul) | (0ul << 1ul) | 1ul,     /* multiply fragment alpha with global alpha*/
  E_DHD_ALPHAMASK_REPLACE        = (0ul << 2ul) | (1ul << 1ul) | 1ul,     /* replace fragment alpha with global alpha*/
  E_DHD_ALPHAMASK_MAXIMIZE       = (1ul << 2ul) | (0ul << 1ul) | 0ul,     /* update global alpha if fragment alpha is higher*/
  E_DHD_ALPHAMASK_CLEAR          = (2ul << 2ul) | (0ul << 1ul) | 0ul,     /* clear global alpha (fragment alpha is unchanged)*/
  E_DHD_ALPHAMASK_MULTIPLY_CLEAR = (2ul << 2ul) | (0ul << 1ul) | 1ul,     /* multiply fragment alpha with global alpha and clear global alpha*/
  E_DHD_ALPHAMASK_REPLACE_CLEAR  = (2ul << 2ul) | (1ul << 1ul) | 1ul,     /* replace fragment alpha with global alpha and clear global alpha*/
  E_DHD_ALPHAMASK_ANTIALIAS      = (3ul << 2ul) | (0ul << 1ul) | 0ul      /* update global alpha for antialiased polygon drawing*/

} dhd_alphamask_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Register state groups.*/
/**/
typedef enum tagdhd_state_group {
  /* group 2*/
  E_DHD_GROUP_2     = 1ul << 0ul,
  E_DHD_GROUP_PSU   = E_DHD_GROUP_2,
  E_DHD_GROUP_EDGES = E_DHD_GROUP_2,
  /* group 3*/
  E_DHD_GROUP_3   = 1ul << 1ul,
  E_DHD_GROUP_TXI = E_DHD_GROUP_3,
  E_DHD_GROUP_UVS = E_DHD_GROUP_3,
  /* group 4*/
  E_DHD_GROUP_4       = 1ul << 2ul,
  E_DHD_GROUP_ZSS     = E_DHD_GROUP_4,
  E_DHD_GROUP_TXI_RHW = E_DHD_GROUP_4,
  E_DHD_GROUP_DEPTH   = E_DHD_GROUP_4,
  /* group 6*/
  E_DHD_GROUP_6   = 1ul << 3ul,
  E_DHD_GROUP_ZSA = E_DHD_GROUP_6,
  E_DHD_GROUP_TXA = E_DHD_GROUP_6,
  /* group 8*/
  E_DHD_GROUP_8          = 1ul << 4ul,
  E_DHD_GROUP_TEX_GLOBAL = E_DHD_GROUP_8,
  E_DHD_GROUP_COL_GLOBAL = E_DHD_GROUP_8,
  E_DHD_GROUP_FBD        = E_DHD_GROUP_8,
  E_DHD_GROUP_FBS        = E_DHD_GROUP_8,
  /* group 10*/
  E_DHD_GROUP_10       = 1ul << 5ul,
  E_DHD_GROUP_TEX_UNIT = E_DHD_GROUP_10,
  E_DHD_GROUP_TEXMODE  = E_DHD_GROUP_10,
  /* group 11*/
  E_DHD_GROUP_11       = 1ul << 6ul,
  E_DHD_GROUP_COL      = E_DHD_GROUP_11,
  E_DHD_GROUP_COL_PASS = E_DHD_GROUP_11,
  /* group 12*/
  E_DHD_GROUP_12    = 1ul << 7ul,
  E_DHD_GROUP_BLU   = E_DHD_GROUP_12,
  E_DHD_GROUP_BLEND = E_DHD_GROUP_12,
  /* group 15*/
  E_DHD_GROUP_15    = 1ul << 8ul,
  E_DHD_GROUP_CLR   = E_DHD_GROUP_15,
  E_DHD_GROUP_CLEAR = E_DHD_GROUP_15,

  E_DHD_GROUP_ALL = 511           /* all groups*/
  
} dhd_state_group_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Pixel pipeline debugging. */
/**/
typedef enum tagdhd_debug_mode {
  E_DHD_DEBUG_NONE,                /* No debugging                                                                  */
  E_DHD_DEBUG_ENUMERATION,         /* Color pixels depending on the enumeration state used to reach them*/
  E_DHD_DEBUG_FB_CACHE,            /* Color pixels depending on the framebuffer cache events*/
  E_DHD_DEBUG_TEX_SCHEDULING,      /* Highlight pixels, for which a fetch or refresh job was scheduled (texture cache)*/
  E_DHD_DEBUG_TEX_WAIT_CYCLES      /* Highlight pixels, for which a wait at TXC input and/or cache RAM was necessary (texture cache)*/

} dhd_debug_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Hardware wait conditions. Combine flags to wait for multiple conditions.*/
/**/
typedef enum tagdhd_wait_flags {
  E_DHD_WAIT_NONE  =   0,          /* Do not wait*/
  E_DHD_WAIT_STC   =   (dhd_uint32_t) (1ul << 0ul),       /* Wait while stream controller is busy           */
  E_DHD_WAIT_STR   =   (dhd_uint32_t) (1ul << 1ul),       /* Wait while stream reader is busy           */
  E_DHD_WAIT_STW   =   (dhd_uint32_t) (1ul << 2ul),       /* Wait while stream writer is busy           */
  E_DHD_WAIT_REG   =   (dhd_uint32_t) (1ul << 3ul),       /* Wait while register file is busy           */
  E_DHD_WAIT_PSU   =   (dhd_uint32_t) (1ul << 4ul),       /* Wait while pixel selection is busy           */
  E_DHD_WAIT_TXI   =   (dhd_uint32_t) (1ul << 5ul),       /* Wait while stages after PSU up to ZSS are busy*/
  E_DHD_WAIT_TEX   =   (dhd_uint32_t) (1ul << 6ul),       /* Wait while stages after ZSS up to TXS are busy*/
  E_DHD_WAIT_COL   =   (dhd_uint32_t) (1ul << 7ul),       /* Wait while stages after TXS up to FBS are busy*/
  E_DHD_WAIT_BLEND =   (dhd_uint32_t) (1ul << 8ul),       /* Wait while stages after FBS up to FBC are busy*/
  E_DHD_WAIT_CLEAR =   (dhd_uint32_t) (1ul << 9ul),       /* Wait while clear unit is busy             */
  E_DHD_WAIT_WRITEBACK = (dhd_uint32_t) (E_DHD_WAIT_REG) |
                         (dhd_uint32_t) (E_DHD_WAIT_PSU) |
                         (dhd_uint32_t) (E_DHD_WAIT_TXI) |
                         (dhd_uint32_t) (E_DHD_WAIT_TEX) |
                         (dhd_uint32_t) (E_DHD_WAIT_COL) |
                         (dhd_uint32_t) (E_DHD_WAIT_BLEND) /* Wait until all pixels are written (not including clear unit)*/

} dhd_wait_flags_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Buffer flags. */
/**/
typedef enum tagdhd_buffer_flags {
  E_DHD_BUFFER_NOLOCK        = 3,       /* Buffer will never be locked (accessed by the CPU in any way)*/
  E_DHD_BUFFER_CPUREAD_ONLY  = 1,       /* Buffer will only be locked for CPU reading*/
  E_DHD_BUFFER_CPUWRITE_ONLY = 2,       /* Buffer will only be locked for CPU writing*/
  E_DHD_BUFFER_STATIC        = 4,       /* Buffer will be updated / locked only once or infrequently */
  E_DHD_BUFFER_DYNAMIC       = 8,       /* Buffer will be updated / locked frequently*/
  E_DHD_BUFFER_GPUREAD_ONLY  = 16       /* GPU will not write into the buffer*/

} dhd_buffer_flags_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Performance counter events.*/
/**/
typedef enum tagdhd_pcevents {
  E_DHD_PC_STR_FETCH_START = 0,        /* Stream reader start of fetch event*/
  E_DHD_PC_STR_BURST_READ,             /* Stream reader did a burst read on MBI*/
  E_DHD_PC_STR_WORD_READ,              /* Stream reader received a word from MBI (1 event for every word in a burst)*/
  E_DHD_PC_STW_BURST_WRITE,            /* Stream writer did a burst write on MBI*/
  E_DHD_PC_STW_WORD_WRITE,             /* Stream writer did a word write on MBI (1 event for every word in a burst)*/
  E_DHD_PC_CLR_BURST_WRITE,            /* Clear unit did a burst write on MBI*/
  E_DHD_PC_CLR_WORD_WRITE,             /* Clear unit did a word write on MBI (1 event for every word in a burst)*/
  E_DHD_PC_PSU_PRIMITIVE,              /* New primitive enumerated*/
  E_DHD_PC_PSU_STRIPE,                 /* New stripe enumerated*/
  E_DHD_PC_PSU_VISIBLE_PIXEL,          /* Visible pixel enumerated*/
  E_DHD_PC_PSU_INVISIBLE_PIXEL,        /* Invisible pixel enumerated*/
  E_DHD_PC_ZSS_SPAN_LENGTH_LIMIT,      /* ZSA buffer span split due to span length limit reached*/
  E_DHD_PC_ZSC_BURST_READ,             /* ZSA buffer cache did a burst read on MBI*/
  E_DHD_PC_ZSC_BURST_WRITE,            /* ZSA buffer cache did a burst write on MBI*/
  E_DHD_PC_ZSC_WORD_READ,              /* ZSA buffer cache received a word from MBI (1 event for every word in a burst)*/
  E_DHD_PC_ZSC_WORD_WRITE,             /* ZSA buffer cache did a word write on MBI (1 event for every word in a burst)*/
  E_DHD_PC_ZSC_PIXEL_READ,             /* ZSA buffer cache processed a pixel read*/
  E_DHD_PC_ZSC_PIXEL_READ_HIT,         /* ZSA buffer cache processed a read without any wait cycle*/
  E_DHD_PC_ZSC_PIXEL_READ_WAIT,        /* ZSA buffer cache wait cycles on read side (>= 1 event per miss)*/
  E_DHD_PC_ZSC_PIXEL_WRITE,            /* ZSA buffer cache processed a pixel write*/
  E_DHD_PC_ZSC_SPAN_CONFLICT,          /* ZSA buffer span conflict occured between new job requiring a read and a line already in the ZSA cache: Read range of new job overlaps write range of open line.*/
  E_DHD_PC_ZSC_SPAN_CONFLICT_WAIT,     /* Wait cycles at ZSA buffer prefetch queue interface due to span conflict.*/
  E_DHD_PC_ZSC_CACHE_FULL_WAIT,        /* Wait cycles at ZSA buffer prefetch queue interface because line could not be allocated as there is no unused line available.*/
  E_DHD_PC_ZSU_DEPTH_TEST_FAILED,      /* Pixel failed depth test*/
  E_DHD_PC_ZSU_STENCIL_TEST_FAILED,    /* Pixel failed stencil test*/
  E_DHD_PC_FBD_ALPHA_TEST_FAILED,      /* Pixel dropped through alpha test*/
  E_DHD_PC_FBS_SPAN_LENGTH_LIMIT,      /* Span split due to span length limit reached*/
  E_DHD_PC_FBS_READ_GAP_LIMIT,         /* Span split due to read gap limit reached*/
  E_DHD_PC_FBC_BURST_READ,             /* Framebuffer cache did a burst read on MBI*/
  E_DHD_PC_FBC_BURST_WRITE,            /* Framebuffer cache did a burst write on MBI*/
  E_DHD_PC_FBC_WORD_READ,              /* Framebuffer cache received a word from MBI (1 event for every word in a burst)*/
  E_DHD_PC_FBC_WORD_WRITE,             /* Framebuffer cache did a word write on MBI (1 event for every word in a burst)*/
  E_DHD_PC_FBC_PIXEL_READ,             /* Framebuffer cache processed a pixel read*/
  E_DHD_PC_FBC_PIXEL_READ_HIT,         /* Framebuffer cache processed a read without any wait cycle*/
  E_DHD_PC_FBC_PIXEL_READ_WAIT,        /* Framebuffer cache wait cycles on read side (>= 1 event per miss)*/
  E_DHD_PC_FBC_PIXEL_WRITE,            /* Framebuffer cache processed a pixel write*/
  E_DHD_PC_FBC_SPAN_CONFLICT,          /* Span conflict occured between new job requiring a read and a line already in the framebuffer cache: Read range of new job overlaps write range of open line.*/
  E_DHD_PC_FBC_SPAN_CONFLICT_WAIT,     /* Wait cycles at prefetch queue interface due to span conflict.*/
  E_DHD_PC_FBC_CACHE_FULL_WAIT,        /* Wait cycles at prefetch queue interface because line could not be allocated as there is no unused line available.*/
  E_DHD_PC_TXS_PREFETCH_MISS,          /* Cache miss in the in the prefetching texture cache scheduler*/
  E_DHD_PC_TXS_REFRESH,                /* Line refresh job sent from texel schedule to texture cache*/
  E_DHD_PC_TXC_BURST_READ,             /* Texture cache did a burst read on MBI*/
  E_DHD_PC_TXC_WORD_READ,              /* Texture cache received a word from MBI (1 event for every word in a burst)*/
  E_DHD_PC_TXC_PIXEL_READ,             /* Texture cache processed a pixel read (i.e. potentially multiple texel reads, still only a single event)*/
  E_DHD_PC_TXC_PIXEL_READ_HIT,         /* Texture cache processed a pixel read without the need to wait for a fetch.*/
  E_DHD_PC_TXC_PIXEL_READ_FETCH_WAIT,  /* Wait cycles at pipeline read interface because of wait for line to be fetched.*/
  E_DHD_PC_TXC_PIXEL_READ_RAM_WAIT,    /* Wait cycles inserted in pipeline read path because read RAM needed to be accessed more than once and prefetch was not successful.*/
  E_DHD_PC_TXC_JOB_LINE_READY,         /* A job was taken from the prefetch queue without the need to wait for the access count to reach the replace count.*/
  E_DHD_PC_TXC_JOB_LINE_WAIT,          /* Wait cycles at prefetch queue interface because job could not be fetched as the access count had not yet reached the replace count.*/
  E_DHD_PC_RLD_BURST_READ,             /* RLD did a burst read on MBI*/
  E_DHD_PC_RLD_WORD_READ,              /* RLD did a word read on MBI (1 event for every word in a burst)*/
  E_DHD_PC_RLD_REWIND,                 /* RLD rewinds to start of texture code*/
  E_DHD_PC_TXP_CLUT_ACCESS_WAIT,       /* Wait cycles when accessing CLUT: Count every additional cycle of CLUT access which exceeds the optimal throughput of 1 cycle/pixel.*/
  E_DHD_PC_STC_COMMAND,                /* Finished execution of a stream command*/
  E_DHD_PC_STC_STR_WAIT,               /* Wait cycles when STC waits for data from STR*/
  E_DHD_PC_STC_REG_WAIT,               /* Wait cycles when STC waits for register write acknowledge from register file*/
  E_DHD_PC_STC_COMMAND_WAIT,           /* Wait cycles when STC waits because of wait command*/
  E_DHD_PC_STC_ACTIVE,                 /* Active cycles of the STC while not in pause-reached mode*/
  E_DHD_PC_STC_CORE_ACTIVE,            /* Active cycles of the STC-Core only when the ACG would be enabled*/
  E_DHD_PC_STC_BUSY,                   /* Busy cycles of STC*/
  E_DHD_PC_STR_BUSY,                   /* Busy cycles of STR*/
  E_DHD_PC_STW_BUSY,                   /* Busy cycles of STW*/
  E_DHD_PC_REG_BUSY,                   /* Busy cycles of REG*/
  E_DHD_PC_PSU_BUSY,                   /* Busy cycles of PSU*/
  E_DHD_PC_TXI_BUSY,                   /* Busy cycles of modules after PSU, up to ZSS*/
  E_DHD_PC_TEX_BUSY,                   /* Busy cycles of modules after ZSS, up to TXS*/
  E_DHD_PC_COL_BUSY,                   /* Busy cycles of modules after TXS, up to FBS*/
  E_DHD_PC_BLEND_BUSY,                 /* Busy cycles of modules after FBS, up to FBC*/
  E_DHD_PC_CLEAR_BUSY,                 /* Busy cycles of clear unit*/
  E_DHD_PC_CLOCK                       /* Every clock cycle               */
} dhd_pcevents_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Forward declarations*/
/**/

/* Internal driver context. Each user mode driver instance is based on this structure.*/
typedef struct tagdhd_buffer_internal dhd_buffer_internal_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Size of the internal device data.*/
/**/
#define DHD_DEVICE_DATA_NUM_POINTER 18
#define DHD_DEVICE_DATA_SIZE_ADD ((21 * 4) + 24)
#define DHD_DEVICE_DATA_SIZE    ((DHD_DEVICE_DATA_NUM_POINTER * sizeof(void *)) + DHD_DEVICE_DATA_SIZE_ADD + DHD_REGFILE_BYTES  + DHD_REGMASK_BYTES)

typedef struct tagdhd_device  {  
  dhd_uint32_t                m_data[ (DHD_DEVICE_DATA_SIZE + 3) / 4 ]; /* real content is internal*/
} dhd_device_t;


/*----------------------------------------------------------------------------------------------------------*/
/* Struct defining a single edge.*/
/**/
typedef struct tagdhd_edge_data {  
  dhd_fx14_18_t                m_start;                                 /* start value*/
  dhd_fx2_18_t                 m_dx, m_dy;                              /* 20 bit increment*/

} dhd_edge_data_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Struct defining an UV mapping.*/
/**/
typedef struct tagdhd_uv_data {  
  dhd_float32_t                m_u0, m_v0;                              /* start value*/
  dhd_float32_t                m_dux, m_duy;                            /* u increment*/
  dhd_float32_t                m_dvx, m_dvy;                            /* v increment*/

} dhd_uv_data_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Struct defining an RHW gradient.*/
/**/
typedef struct tagdhd_rhw_data {  
  dhd_float32_t                m_start;                                 /* start value*/
  dhd_float32_t                m_dx, m_dy;                              /* increment  */

} dhd_rhw_data_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Struct defining a Depth gradient.*/
/**/
typedef struct tagdhd_depth_data {  
  dhd_float32_t                m_z0;                                    /* z start value*/
  dhd_float32_t                m_dzx, m_dzy;                            /* z increment  */
  dhd_float32_t                m_rhw0;                                  /* rhw start value*/
  dhd_float32_t                m_dwx, m_dwy;                            /* rhw increment  */

} dhd_depth_data_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Struct defining a single primitive. Edge information is stored separately.*/
/* Stripe information is optional and will be used only when E_DHD_DRAW_STRIPE is set.*/
/**/
typedef struct tagdhd_prim_data {
  dhd_uint32_t                 m_edgecontrol;                           /* edge setup*/
  dhd_uint16_t                 m_xmin, m_xmax;                          /* bounding box*/
  dhd_uint16_t                 m_ymin, m_ymax; 
  dhd_uint16_t                 m_ystart;
  dhd_uint8_t                  m_stripe_width;                          /* optional*/
  dhd_uint8_t                  m_stripe_offset;                         /* optional*/

} dhd_prim_data_t;

/*----------------------------------------------------------------------------------------------------------*/
typedef struct tagdhd_bezprim_data {
  dhd_uint32_t                 m_edgecontrol;                           /* edge setup*/
  dhd_uint16_t                 m_xmin, m_xmax;                          /* bounding box*/
  dhd_uint16_t                 m_ymin, m_ymax; 
  dhd_uint16_t                 m_ystart;
  dhd_uint8_t                  m_stripe_width;                          /* optional*/
  dhd_uint8_t                  m_stripe_offset;                         /* optional*/
  dhd_fx14_18_t                m_offset0, m_offset1;                    /* bezier limiter offsets (fixedpoint 14.18)*/

} dhd_bezprim_data_t;

/*----------------------------------------------------------------------------------------------------------*/
/* A rectangular region of video memory. */
/**/
typedef struct tagdhd_buffer {    
  dhd_vidmem_t                 m_memory;                                /* memory region that contains this buffer*/
  dhd_buffer_internal_t       *m_internal;                              /* pointer to driver internal data for this buffer*/

  dhd_uint16_t                 m_width, m_height;                       /* size of this buffer rect in pixels*/
  dhd_uint16_t                 m_pitch;                                 /* pixels per line*/
  dhd_uint16_t                 m_bpp;                                   /* bytes per pixel*/
  dhd_uint16_t                 m_reserved;                              /* currently unused */
  dhd_memory_usage_t           m_usage;                                 /* intended buffer usage  */

  dhd_enum_t                   m_format;                                /* [optional] dhd_pixel_org_t, dhd_depth_org_t or dhd_texel_org_t for use with utility functions*/
  dhd_address_mode_t           m_access;                                /* [optional] memory storage format for use with utility functions*/
  dhd_wrap_mode_t              m_uaxis_wrap;                            /* [optional] U axis wrap mode for use with utility functions*/
  dhd_wrap_mode_t              m_vaxis_wrap;                            /* [optional] V axis wrap mode for use with utility functions*/

} dhd_buffer_t;

/*----------------------------------------------------------------------------------------------------------*/
/* State storage. Used by dhd_get_state nad dhd_set_state*/
/**/
typedef struct tagdhd_state {
  dhd_uint32_t                 m_sizeof;                                /* size of this structure*/
  dhd_uint32_t                 m_groups;                                /* bitmask for stored groups (see dhd_state_group_t)*/
  dhd_uint32_t                 m_state[1];                              /* copy of internal state, array is at least 1 element but usually larger*/
} dhd_state_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Performance counter storage.*/
/**/
typedef struct tagdhd_performance_counter {
  dhd_vidmem_t                 m_memory;                                 /* storage area*/
  dhd_pcevents_t               m_event;                                  /* currently selected event */
  dhd_jobid_t                  m_jobid;                                  /* job id of the latest read action*/
  dhd_uint32_t                 m_jobgen;                                 /* job generation of latest read action*/
  dhd_uint32_t                 m_value;                                  /* cache of last read value*/
  dhd_uint8_t                  m_id;                                     /* assigned counter ID (or DHD_INVALID_PCID)*/

} dhd_performance_counter_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Sync mark storage.*/
/**/
typedef struct tagdhd_mark {
  dhd_jobid_t                  m_jobid;                                  /* job id of the marked job  */
  dhd_uint32_t                 m_jobgen;                                 /* generation of the marked job  */

} dhd_mark_t;


/*----------------------------------------------------------------------------------------------------------*/
/* Pool setup functions*/

dhd_enum_t dhd_os_init(void);
dhd_enum_t dhd_os_shutdown(void);

/*----------------------------------------------------------------------------------------------------------*/
/* General functions*/

dhd_handle_t dhd_init(dhd_device_t *a_device, dhd_uint32_t a_hw_instance, dhd_enum_t a_flags);
dhd_enum_t dhd_shutdown(dhd_handle_t a_device);
dhd_enum_t dhd_set_panic_callback(dhd_handle_t a_device, const dhd_panic_callback_t a_callback);

dhd_enum_t dhd_flush(dhd_handle_t a_device);
dhd_enum_t dhd_finish(dhd_handle_t a_device);
dhd_enum_t dhd_finish_marked(dhd_handle_t a_device, const dhd_mark_t *a_mark);
dhd_enum_t dhd_sync_signal(dhd_handle_t a_device, dhd_gpu_ptr_t a_dest, dhd_uint32_t a_data);
dhd_enum_t dhd_sync_mark(dhd_handle_t a_device, dhd_mark_t *a_result);
dhd_bool_t dhd_isbusy_marked(dhd_handle_t a_device, const dhd_mark_t *a_mark);

dhd_state_t * dhd_alloc_state(dhd_handle_t a_device, dhd_state_group_t a_groups);
dhd_enum_t dhd_free_state(dhd_handle_t a_device, dhd_state_t *a_state);
dhd_enum_t dhd_get_state(dhd_handle_t a_device, dhd_state_group_t a_groups, dhd_state_t *a_state);
dhd_enum_t dhd_set_state(dhd_handle_t a_device, dhd_state_t *a_state);
dhd_enum_t dhd_alloc_vidmem(dhd_handle_t a_device, dhd_uint32_t a_size, dhd_uint32_t a_alignment, dhd_memory_usage_t a_usage, dhd_vidmem_t *a_result);
dhd_enum_t dhd_free_vidmem(dhd_handle_t a_device, dhd_vidmem_t *a_memory);
dhd_enum_t dhd_upload_vidmem(dhd_handle_t a_device, const dhd_uint8_t *a_src, dhd_gpu_ptr_t a_dest, dhd_uint32_t a_size);
dhd_enum_t dhd_download_vidmem(dhd_handle_t a_device, dhd_gpu_ptr_t a_src, dhd_uint8_t *a_dest, dhd_uint32_t a_size);

dhd_enum_t dhd_set_job_checksum_enable(dhd_handle_t a_device, dhd_bool_t a_enable);
dhd_bool_t dhd_get_job_checksum_enable(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* Buffer functions*/

dhd_enum_t dhd_alloc_buffer(dhd_handle_t a_device, dhd_buffer_t *a_buffer, dhd_buffer_flags_t a_flags);
dhd_enum_t dhd_alloc_buffer_simple(dhd_handle_t a_device, dhd_buffer_t *a_buffer, dhd_enum_t a_format, dhd_uint16_t a_width, dhd_uint16_t a_height, dhd_buffer_flags_t a_flags);
dhd_enum_t dhd_free_buffer(dhd_handle_t a_device, dhd_buffer_t *a_buffer);
dhd_enum_t dhd_change_buffer_flags(dhd_handle_t a_device, dhd_buffer_t *a_buffer, dhd_buffer_flags_t a_flags);
dhd_enum_t dhd_lock_buffer(dhd_handle_t a_device, dhd_buffer_t *a_buffer, dhd_enum_t a_access);
dhd_enum_t dhd_lock_buffer_region(dhd_handle_t a_device, dhd_buffer_t *a_buffer, dhd_enum_t a_access, dhd_uint16_t a_x, dhd_uint16_t a_y, dhd_uint16_t a_w, dhd_uint16_t a_h);
dhd_enum_t dhd_unlock_buffer(dhd_handle_t a_device, dhd_buffer_t *a_buffer);
dhd_enum_t dhd_fill_buffer(dhd_handle_t a_device, const dhd_buffer_t *a_buffer, dhd_uint32_t a_data, dhd_uint32_t a_mask);
dhd_enum_t dhd_fill_buffer_color(dhd_handle_t a_device, const dhd_buffer_t *a_buffer, dhd_uint32_t a_color);
dhd_uint8_t *dhd_get_lockedbuffer_ptr(const dhd_buffer_t *a_buffer);
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_buffer_gpuptr(const dhd_buffer_t *a_buffer);

/*----------------------------------------------------------------------------------------------------------*/
/* Configuration query functions*/

DHD_API_INLINE dhd_uint32_t dhd_get_texture_unit_count(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint32_t dhd_get_color_unit_count(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint32_t dhd_get_pipeline_count(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint32_t dhd_get_const_col_count(dhd_handle_t a_device);
dhd_uint32_t dhd_get_hw_revision(dhd_handle_t a_device);
dhd_uint32_t dhd_get_driver_revision(void);
dhd_bool_t dhd_get_bufferalignment_required(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* Blendunit and framebuffer configuration functions*/

DHD_API_INLINE void dhd_set_color_blending(dhd_handle_t a_device, dhd_blend_factor_t a_srcfactor, dhd_blend_factor_t a_dstfactor);
DHD_API_INLINE void dhd_set_alpha_blending(dhd_handle_t a_device, dhd_blend_factor_t a_srcfactor, dhd_blend_factor_t a_dstfactor);
DHD_API_INLINE void dhd_set_blend_func(dhd_handle_t a_device, dhd_blend_mode_t a_colormode, dhd_blend_mode_t a_alphamode);
DHD_API_INLINE void dhd_set_read_decision(dhd_handle_t a_device, dhd_read_mode_t a_readmode, dhd_bool_t a_covblend);
DHD_API_INLINE void dhd_set_dither(dhd_handle_t a_device, dhd_bool_t a_enable, dhd_uint32_t a_xoffset, dhd_uint32_t a_yoffset);
DHD_API_INLINE void dhd_set_dither_scale(dhd_handle_t a_device, dhd_uint32_t a_red, dhd_uint32_t a_green, dhd_uint32_t a_blue);
DHD_API_INLINE void dhd_set_framebuffer_format(dhd_handle_t a_device, dhd_pixel_org_t a_format);
DHD_API_INLINE void dhd_set_framebuffer_size(dhd_handle_t a_device, dhd_uint32_t a_width, dhd_uint32_t a_height, dhd_uint32_t a_pitch);
DHD_API_INLINE dhd_enum_t dhd_set_framebuffer_address(dhd_handle_t a_device, dhd_gpu_ptr_t a_address);
DHD_API_INLINE void dhd_set_write_mask(dhd_handle_t a_device, dhd_bool_t a_red, dhd_bool_t a_green, dhd_bool_t a_blue, dhd_bool_t a_alpha);
DHD_API_INLINE void dhd_set_coverage_blend(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_alpha_test(dhd_handle_t a_device, dhd_compare_op_t a_compare, dhd_uint8_t a_ref);
DHD_API_INLINE void dhd_set_fb_premultiply(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_fb_postdivide(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_get_color_blending(dhd_handle_t a_device, dhd_blend_factor_t *a_srcfactor, dhd_blend_factor_t *a_dstfactor);
DHD_API_INLINE void dhd_get_alpha_blending(dhd_handle_t a_device, dhd_blend_factor_t *a_srcfactor, dhd_blend_factor_t *a_dstfactor);
DHD_API_INLINE void dhd_get_blend_func(dhd_handle_t a_device, dhd_blend_mode_t *a_colormode, dhd_blend_mode_t *a_alphamode);
DHD_API_INLINE dhd_read_mode_t dhd_get_read_decision(dhd_handle_t a_device, dhd_bool_t *a_covblend);
DHD_API_INLINE dhd_bool_t dhd_get_dither(dhd_handle_t a_device, dhd_uint32_t *a_xoffset, dhd_uint32_t *a_yoffset);
DHD_API_INLINE void dhd_get_dither_scale(dhd_handle_t a_device, dhd_uint32_t *a_red, dhd_uint32_t *a_green, dhd_uint32_t *a_blue);
DHD_API_INLINE dhd_pixel_org_t dhd_get_framebuffer_format(dhd_handle_t a_device);
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_framebuffer_address(dhd_handle_t a_device);
DHD_API_INLINE void dhd_get_framebuffer_size(dhd_handle_t a_device, dhd_uint32_t *a_width, dhd_uint32_t *a_height, dhd_uint32_t *a_pitch);
DHD_API_INLINE void dhd_get_write_mask(dhd_handle_t a_device, dhd_bool_t *a_red, dhd_bool_t *a_green, dhd_bool_t *a_blue, dhd_bool_t *a_alpha);
DHD_API_INLINE dhd_bool_t dhd_get_coverage_blend(dhd_handle_t a_device);
DHD_API_INLINE dhd_compare_op_t dhd_get_alpha_test(dhd_handle_t a_device, dhd_uint8_t *a_ref);
DHD_API_INLINE dhd_bool_t dhd_get_fb_premultiply(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_fb_postdivide(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* ZSA unit configuration functions*/

DHD_API_INLINE void dhd_disable_zsa(dhd_handle_t a_device);
DHD_API_INLINE dhd_enum_t dhd_set_zsabuffer_address(dhd_handle_t a_device, dhd_gpu_ptr_t a_address);
DHD_API_INLINE void dhd_set_zsabuffer_format(dhd_handle_t a_device, dhd_depth_org_t a_format);  
DHD_API_INLINE void dhd_set_zsa_read(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_stencil_ref(dhd_handle_t a_device, dhd_uint8_t a_mask, dhd_uint8_t a_ref, dhd_uint8_t a_writemask);
DHD_API_INLINE void dhd_set_stencil_test(dhd_handle_t a_device, dhd_compare_op_t a_func, dhd_stencil_op_t a_fail, dhd_stencil_op_t a_zpass, dhd_stencil_op_t a_zfail);
DHD_API_INLINE void dhd_set_alphamask_aa(dhd_handle_t a_device, dhd_uint8_t a_bias, dhd_bool_t a_invert_on_opaque);
DHD_API_INLINE void dhd_set_alphamask_mode(dhd_handle_t a_device, dhd_alphamask_mode_t a_mode);
DHD_API_INLINE void dhd_set_alphamask_test(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_depth_test(dhd_handle_t a_device, dhd_compare_op_t a_func);
DHD_API_INLINE void dhd_set_depth_write(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_depth_enable(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_zsabuffer_address(dhd_handle_t a_device);
DHD_API_INLINE dhd_depth_org_t dhd_get_zsabuffer_format(dhd_handle_t a_device);  
DHD_API_INLINE dhd_bool_t dhd_get_zsa_read(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint8_t dhd_get_stencil_ref(dhd_handle_t a_device, dhd_uint8_t *a_mask, dhd_uint8_t *a_writemask);
DHD_API_INLINE dhd_compare_op_t dhd_get_stencil_test(dhd_handle_t a_device, dhd_stencil_op_t *a_fail, dhd_stencil_op_t *a_zpass, dhd_stencil_op_t *a_zfail);
DHD_API_INLINE void dhd_get_alphamask_aa(dhd_handle_t a_device, dhd_uint8_t *a_bias, dhd_bool_t *a_invert_on_opaque);
DHD_API_INLINE dhd_alphamask_mode_t dhd_get_alphamask_mode(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_alphamask_test(dhd_handle_t a_device);
DHD_API_INLINE dhd_compare_op_t dhd_get_depth_test(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_depth_write(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_depth_enable(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* Colorunit configuration functions*/
 
DHD_API_INLINE void dhd_set_color(dhd_handle_t a_device, dhd_uint32_t a_index, dhd_uint32_t a_color);
DHD_API_INLINE void dhd_set_color_array(dhd_handle_t a_device, dhd_uint32_t a_start, dhd_uint32_t a_count, const dhd_uint32_t *a_colors);
DHD_API_INLINE void dhd_active_color_unit(dhd_handle_t a_device, dhd_uint32_t a_index);
DHD_API_INLINE void dhd_set_color_scale(dhd_handle_t a_device, dhd_outscale_t a_scale);
DHD_API_INLINE void dhd_set_alpha_scale(dhd_handle_t a_device, dhd_outscale_t a_scale);
DHD_API_INLINE void dhd_set_color_clamp(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_alpha_clamp(dhd_handle_t a_device, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_color_op1a(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_select_t a_channels, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_color_op1b(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_select_t a_channels, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_alpha_op1a(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_t a_channel, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_alpha_op1b(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_t a_channel, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_color_op2a(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_select_t a_channels, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_color_op2b(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_select_t a_channels, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_alpha_op2a(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_t a_channel, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_alpha_op2b(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_t a_channel, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_color_op3(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_select_t a_channels, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_alpha_op3(dhd_handle_t a_device, dhd_col_input_t a_source, dhd_channel_t a_channel, dhd_col_modify_t a_modifier);
DHD_API_INLINE void dhd_set_color_carry(dhd_handle_t a_device, dhd_bool_t a_carry1, dhd_bool_t a_carry2);
DHD_API_INLINE void dhd_set_alpha_carry(dhd_handle_t a_device, dhd_bool_t a_carry1, dhd_bool_t a_carry2);
DHD_API_INLINE void dhd_set_color_operation(dhd_handle_t a_device, dhd_color_op_t a_operation);
DHD_API_INLINE void dhd_set_alpha_operation(dhd_handle_t a_device, dhd_color_op_t a_operation);
DHD_API_INLINE void dhd_set_color_unit_enable(dhd_handle_t a_device, dhd_uint32_t a_count);
DHD_API_INLINE dhd_uint32_t dhd_get_color(dhd_handle_t a_device, dhd_uint32_t a_index);
DHD_API_INLINE void dhd_get_color_array(dhd_handle_t a_device, dhd_uint32_t a_start, dhd_uint32_t a_count, dhd_uint32_t *a_colors);
DHD_API_INLINE dhd_uint32_t dhd_get_active_color_unit(dhd_handle_t a_device);
DHD_API_INLINE dhd_outscale_t dhd_get_color_scale(dhd_handle_t a_device);
DHD_API_INLINE dhd_outscale_t dhd_get_alpha_scale(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_color_clamp(dhd_handle_t a_device);
DHD_API_INLINE dhd_bool_t dhd_get_alpha_clamp(dhd_handle_t a_device);
DHD_API_INLINE dhd_col_input_t dhd_get_color_op1a(dhd_handle_t a_device, dhd_channel_select_t *a_channels, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_color_op1b(dhd_handle_t a_device, dhd_channel_select_t *a_channels, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_alpha_op1a(dhd_handle_t a_device, dhd_channel_t *a_channel, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_alpha_op1b(dhd_handle_t a_device, dhd_channel_t *a_channel, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_color_op2a(dhd_handle_t a_device, dhd_channel_select_t *a_channels, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_color_op2b(dhd_handle_t a_device, dhd_channel_select_t *a_channels, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_alpha_op2a(dhd_handle_t a_device, dhd_channel_t *a_channel, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_alpha_op2b(dhd_handle_t a_device, dhd_channel_t *a_channel, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_color_op3(dhd_handle_t a_device, dhd_channel_select_t *a_channels, dhd_col_modify_t *a_modifier);
DHD_API_INLINE dhd_col_input_t dhd_get_alpha_op3(dhd_handle_t a_device, dhd_channel_t *a_channel, dhd_col_modify_t *a_modifier);
DHD_API_INLINE void dhd_get_color_carry(dhd_handle_t a_device, dhd_bool_t *a_carry1, dhd_bool_t *a_carry2);
DHD_API_INLINE void dhd_get_alpha_carry(dhd_handle_t a_device, dhd_bool_t *a_carry1, dhd_bool_t *a_carry2);
DHD_API_INLINE dhd_uint32_t dhd_get_color_unit_enable(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* Textureunit configuration functions*/

DHD_API_INLINE void dhd_active_texture_unit(dhd_handle_t a_device, dhd_uint32_t a_index);
DHD_API_INLINE void dhd_set_texture_size(dhd_handle_t a_device, dhd_uint32_t a_width, dhd_uint32_t a_height, dhd_uint32_t a_pitch);
DHD_API_INLINE void dhd_set_texture_address(dhd_handle_t a_device, dhd_gpu_ptr_t a_address, dhd_uint8_t a_bitoffset);
DHD_API_INLINE void dhd_set_texture_wrap(dhd_handle_t a_device, dhd_wrap_mode_t a_uaxis, dhd_wrap_mode_t a_vaxis);
DHD_API_INLINE void dhd_set_texture_filter(dhd_handle_t a_device, dhd_bool_t a_uaxis, dhd_bool_t a_vaxis);
DHD_API_INLINE void dhd_set_texture_format(dhd_handle_t a_device, dhd_texel_org_t a_format, dhd_address_mode_t a_address, dhd_bool_t a_discard_alpha);
DHD_API_INLINE void dhd_set_texture_color_key(dhd_handle_t a_device, dhd_uint32_t a_color, dhd_bool_t a_enable);
DHD_API_INLINE void dhd_set_texture_border_color(dhd_handle_t a_device, dhd_uint32_t a_color);
DHD_API_INLINE void dhd_set_texture_clut_base(dhd_handle_t a_device, dhd_uint32_t a_offset);
DHD_API_INLINE void dhd_set_texture_unit_enable(dhd_handle_t a_device, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_set_texture_kernel(dhd_handle_t a_device, dhd_uint32_t a_width, dhd_uint32_t a_height, const dhd_uint8_t *a_data, dhd_uint32_t a_clutbase);
DHD_API_INLINE void dhd_set_texture_scalebias(dhd_handle_t a_device, dhd_float32_t a_scale, dhd_int32_t a_bias);
DHD_API_INLINE void dhd_flush_texture_cache(dhd_handle_t a_device);
DHD_API_INLINE dhd_enum_t dhd_set_texture_rle_decoder(dhd_handle_t a_device, dhd_uint32_t a_unit, dhd_gpu_ptr_t a_address, dhd_uint32_t a_wordsize);               
DHD_API_INLINE dhd_uint32_t dhd_get_active_texture_unit(dhd_handle_t a_device);
DHD_API_INLINE void dhd_get_texture_size(dhd_handle_t a_device, dhd_uint32_t *a_width, dhd_uint32_t *a_height, dhd_uint32_t *a_pitch);
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_texture_address(dhd_handle_t a_device, dhd_uint8_t *a_bitoffset);
DHD_API_INLINE void dhd_get_texture_wrap(dhd_handle_t a_device, dhd_wrap_mode_t *a_uaxis, dhd_wrap_mode_t *a_vaxis);
DHD_API_INLINE void dhd_get_texture_filter(dhd_handle_t a_device, dhd_bool_t *a_uaxis, dhd_bool_t *a_vaxis);
DHD_API_INLINE dhd_texel_org_t dhd_get_texture_format(dhd_handle_t a_device, dhd_address_mode_t *a_address, dhd_bool_t *a_discard_alpha);
DHD_API_INLINE dhd_uint32_t dhd_get_texture_color_key(dhd_handle_t a_device, dhd_bool_t *a_enable);
DHD_API_INLINE dhd_uint32_t dhd_get_texture_border_color(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint32_t dhd_get_texture_clut_base(dhd_handle_t a_device);
DHD_API_INLINE dhd_uint32_t dhd_get_texture_unit_enable(dhd_handle_t a_device);
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_texture_rle_decoder(dhd_handle_t a_device, dhd_uint32_t *a_unit, dhd_uint32_t *a_wordsize);               

/*----------------------------------------------------------------------------------------------------------*/
/* Palette Functions*/

dhd_enum_t dhd_alloc_clut(dhd_handle_t a_device, dhd_uint32_t a_size, dhd_uint32_t *a_result);
dhd_enum_t dhd_free_clut(dhd_handle_t a_device, dhd_uint32_t a_size, dhd_uint32_t a_start);
dhd_enum_t dhd_set_clut(dhd_handle_t a_device, const dhd_uint32_t *a_data, dhd_uint32_t a_start, dhd_uint32_t a_size);

/*----------------------------------------------------------------------------------------------------------*/
/* Rendering functions*/

DHD_API_INLINE void dhd_set_bbox(dhd_handle_t a_device, dhd_uint32_t a_xmin, dhd_uint32_t a_ymin, dhd_uint32_t a_xmax, dhd_uint32_t a_ymax, dhd_uint32_t a_ystart);
DHD_API_INLINE void dhd_set_psu_stripes(dhd_handle_t a_device, dhd_uint32_t a_offset, dhd_uint32_t a_width);
DHD_API_INLINE void dhd_set_bezier_offset(dhd_handle_t a_device, dhd_int32_t a_offset0, dhd_int32_t a_offset1);
DHD_API_INLINE void dhd_set_bezier_width(dhd_handle_t a_device, dhd_uint32_t a_width);
DHD_API_INLINE void dhd_set_bezier_aa(dhd_handle_t a_device, dhd_uint32_t a_width, dhd_int32_t a_offset);
DHD_API_INLINE void dhd_set_edge_buffer(dhd_handle_t a_device, dhd_edge_data_t *a_edges, dhd_uint32_t a_gap, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_set_uv_buffer(dhd_handle_t a_device, dhd_uv_data_t *a_uvs, dhd_uint32_t a_gap, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_set_rhw_buffer(dhd_handle_t a_device, dhd_rhw_data_t *a_rhws, dhd_uint32_t a_gap, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_set_col_buffer(dhd_handle_t a_device, dhd_uint32_t *a_colors, dhd_uint32_t a_gap, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_set_depth_buffer(dhd_handle_t a_device, dhd_depth_data_t *a_depths, dhd_uint32_t a_gap, dhd_uint32_t a_count);
DHD_API_INLINE void dhd_get_bbox(dhd_handle_t a_device, dhd_uint32_t *a_xmin, dhd_uint32_t *a_ymin, dhd_uint32_t *a_xmax, dhd_uint32_t *a_ymax, dhd_uint32_t *a_ystart);
DHD_API_INLINE void dhd_get_psu_stripes(dhd_handle_t a_device, dhd_uint32_t *a_offset, dhd_uint32_t *a_width);
DHD_API_INLINE void dhd_get_bezier_offset(dhd_handle_t a_device, dhd_int32_t *a_offset0, dhd_int32_t *a_offset1);
DHD_API_INLINE void dhd_get_bezier_aa(dhd_handle_t a_device, dhd_uint32_t *a_width, dhd_int32_t *a_offset);
DHD_API_INLINE dhd_uint32_t dhd_get_bezier_width(dhd_handle_t a_device);
DHD_API_INLINE dhd_edge_data_t * dhd_get_edge_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out);
DHD_API_INLINE dhd_uv_data_t * dhd_get_uv_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out);
DHD_API_INLINE dhd_rhw_data_t * dhd_get_rhw_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out);
DHD_API_INLINE dhd_uint32_t * dhd_get_col_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out);
DHD_API_INLINE dhd_depth_data_t * dhd_get_depth_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out);

void dhd_set_edge(dhd_handle_t a_device, dhd_uint32_t a_edgeid, const dhd_edge_data_t *a_edge);
void dhd_set_uv(dhd_handle_t a_device, dhd_uint32_t a_unitid, const dhd_uv_data_t *a_uv);
void dhd_set_rhw(dhd_handle_t a_device, dhd_uint32_t a_unitid, const dhd_rhw_data_t *a_rhw);
void dhd_draw(dhd_handle_t a_device, dhd_uint32_t a_edgecontrol, dhd_uint32_t a_edgecount, dhd_drawattribute_flag_t a_attributes);
void dhd_draw_array(dhd_handle_t a_device, dhd_uint32_t a_primcount, dhd_prim_data_t *a_prims, dhd_int32_t a_primpitch, 
                    dhd_uint32_t a_edgecount, dhd_drawattribute_flag_t a_attributes);
void dhd_draw_bezier_array(dhd_handle_t a_device, dhd_uint32_t a_primcount, dhd_bezprim_data_t *a_prims, dhd_int32_t a_primpitch, 
                           dhd_uint32_t a_edgecount, dhd_drawattribute_flag_t a_attributes);
void dhd_fill(dhd_handle_t a_device, dhd_gpu_ptr_t a_address, dhd_uint32_t a_width, dhd_uint32_t a_height, 
              dhd_uint32_t a_pitch, dhd_uint32_t a_bpp, dhd_uint32_t a_data, dhd_uint32_t a_mask );
void dhd_wait_fill(dhd_handle_t a_device);
void dhd_wait(dhd_handle_t a_device, dhd_wait_flags_t a_wait);

/*----------------------------------------------------------------------------------------------------------*/
/* Profiling functions*/

dhd_enum_t dhd_alloc_pc(dhd_handle_t a_device, dhd_performance_counter_t *a_output);
dhd_enum_t dhd_free_pc(dhd_handle_t a_device, dhd_performance_counter_t *a_counter);
dhd_enum_t dhd_reset_pc(dhd_handle_t a_device, const dhd_performance_counter_t *a_counter);
dhd_enum_t dhd_read_pc(dhd_handle_t a_device, dhd_performance_counter_t *a_counter, dhd_wait_flags_t a_wait);
dhd_enum_t dhd_set_pc_event(dhd_handle_t a_device, dhd_performance_counter_t *a_counter, dhd_pcevents_t a_event);
dhd_enum_t dhd_set_pc_enable(dhd_handle_t a_device, const dhd_performance_counter_t *a_counter, dhd_bool_t a_enable);
dhd_uint32_t dhd_get_pc_value(dhd_handle_t a_device, dhd_performance_counter_t *a_counter);

/*----------------------------------------------------------------------------------------------------------*/
/* Command list functions*/

dhd_enum_t dhd_cmdlist_create (dhd_handle_t a_device, dhd_handle_t *a_cmdlist);
dhd_enum_t dhd_cmdlist_destroy (dhd_handle_t a_device, dhd_handle_t a_cmdlist);
dhd_enum_t dhd_cmdlist_begin (dhd_handle_t a_device, dhd_handle_t a_cmdlist);
dhd_enum_t dhd_cmdlist_end (dhd_handle_t a_device);
dhd_enum_t dhd_cmdlist_exec (dhd_handle_t a_device, dhd_handle_t a_cmdlist);
dhd_enum_t dhd_cmdlist_serialize (dhd_handle_t a_device, dhd_handle_t a_cmdlist, void *a_dst, dhd_uint32_t a_dst_size);
dhd_enum_t dhd_cmdlist_deserialize (dhd_handle_t a_device, dhd_handle_t *a_cmdlist, void *a_src);
dhd_uint32_t dhd_cmdlist_get_job_count (dhd_handle_t a_device, dhd_handle_t a_cmdlist);
dhd_uint32_t dhd_cmdlist_get_size (dhd_handle_t a_device, dhd_handle_t a_cmdlist);

/*----------------------------------------------------------------------------------------------------------*/
/* Debugging functions*/

DHD_API_INLINE void dhd_set_debug_mode(dhd_handle_t a_device, dhd_debug_mode_t a_mode);
dhd_enum_t dhd_tlist_enable(dhd_handle_t a_device, const dhd_char_t *a_file);
dhd_enum_t dhd_tlist_write(dhd_handle_t a_device, const dhd_char_t *a_string);
dhd_enum_t dhd_tlist_write_kernel(dhd_handle_t a_device, const dhd_char_t *a_string, dhd_bool_t to_kernel);
dhd_enum_t dhd_debug_dump_hw_state(dhd_handle_t a_device, dhd_uint32_t *a_destination, dhd_uint32_t a_count);
dhd_enum_t dhd_debug_switch_memorymodel(dhd_handle_t a_device);
dhd_enum_t dhd_force_yield(dhd_handle_t a_device);

DHD_API_INLINE dhd_debug_mode_t dhd_get_debug_mode(dhd_handle_t a_device);

/*----------------------------------------------------------------------------------------------------------*/
/* include inline functions if API inlineing is enabled*/
/**/
#ifdef DHD_INLINE_INTERFACE
#include "davehd_driver_inl.h"
#endif

/*----------------------------------------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif 


#endif /*DAVEHD_DRIVER_H_INCLUDED*/
