

#ifndef _POPUP_LIST_H_
#define _POPUP_LIST_H_

#include "TYW_stdint.h"
#include "Popup_Lib.h"

/******************************************************************************
报警名称列表

注意：1. 报警名称所指代的序号应与该报警位于报警属性表中的序号一一对应
      2. 标注有的"[报警类]"的为报警类名称,不可直接用于报警的申请与删除,但可用于
         该类报警的查询
******************************************************************************/
enum PopupName
{
    POPUP1_BRAKE_BLACK     = 0x00u      ,/*00.紧急警报-刹车*/
    POPUP1_BRAKE_BRAKE                  ,/*01.紧急警报-紧急制动*/
    POPUP1_BRAKE_SPACING_R              ,/*02.车间距警报-刹车(红字)*/
    POPUP1_BRAKE_SPACING_COLLISION      ,/*03.车间距警报-碰撞报警*/
    POPUP1_BRAKE_SPACING_Y              ,/*04.车间距警报-刹车(黄字)*/
    POPUT1_ASR_OPERATE                  ,/*05.ASR工作*/
    POPUT2_PTO                          ,/*06.PTO紧急警报-刹车*/
    POPUP2_PARKING_BRAKE                ,/*07.忘记松手刹车*/
    POPUP2_AIRMATIC_HIGHT               ,/*08.遥控调整车辆高度(有车速)*/
    POPUP3_CRUISE                       ,/*09.自动巡航模式*/
    POPUP3_VARIABLE_SLD                 ,/*10.可变SLD 模式*/
    POPUT4_ABNORMAL_CHARGE              ,/*11.充电异常（系统检测）*/
    POPUP4_OIL_PRESSURE                 ,/*12.油压（系统检测）*/
    POPUP4_AMT_INIT_EXCE                ,/*13.AMT初始化异常*/
    POPUP4_ADBLUE_QUALITY               ,/*14.尿素品质异常（系统检测）*/
    POPUP4_ADBLUE_SPRAY                 ,/*15.尿素喷射异常（系统检测）*/
    POPUP4_ADBLUE_SUPPLY                ,/*16.尿素水补给（系统检测）*/
    POPUP4_START_ENG                    ,/*17.AMT初始化结束*/
    POPUP4_DPD_AUTO                     ,/*18.DPD自动再生*/
    POPUP5_OVER_HEAT_SPEED              ,/*19.过热（过热，请在安全的场所停车）*/
    POPUP5_OVER_HEAT                    ,/*20.过热（冷却液温度过高）*/
    POPUP5_LOW_COOLANT_SPEED            ,/*21.冷却水（冷却液不足）*/
    POPUP5_LOW_COOLANT                  ,/*22.冷却水（冷却水不足）*/
    POPUP5_ENGINE_OIL_PRESSURE_SPEED    ,/*23.油压(机油)请在安全场所停车*/
    POPUP5_ENGINE_OIL_PRESSURE          ,/*24.油压异常*/
    POPUP5_METER_FAILURE_SPEED          ,/*25.仪表故障-请在安全场所停车*/
    POPUP5_METER_FAILURE                ,/*26.仪表故障-请与五十铃公司联系*/
    POPUP5_CAN_ERROR_SPEED              ,/*27.通信系统-请在安全场所停车*/
    POPUP5_CAN_ERROR                    ,/*28.通信系统-请与五十铃公司联系*/
    POPUP5_SPEED_LIMIT_SPEED            ,/*29.车速限制-图1*/
    POPUP5_SPEED_LIMIT                  ,/*30.车速限制-图2*/
    POPUP5_TORQUE_REDUCTION_SPEED       ,/*31.扭矩限制-图1*/
    POPUP5_TORQUE_REDUCTION             ,/*32.扭矩限制-图2*/
    POPUP5_SPEED_TORQUE                 ,/*33.扭矩限制、车速限制 交互 显示-->扭矩限制*/
    POPUP5_INCORRECT_ADBLUE_SPEED       ,/*34.尿素品质异常-图1*/
    POPUP5_INCORRECT_ADBLUE             ,/*35.尿素品质异常-图2*/
    POPUP5_CRITICAL_EMISSION_SPEED      ,/*36.临界排放故障-图1*/
    POPUP5_CRITICAL_EMISSION            ,/*37.临界排放故障-图2*/
    POPUP5_AMT_SPANNER_WARNING_SPEED    ,/*38.AMT异常-图1*/
    POPUP5_AMT_SPANNER_WARNING          ,/*39.AMT异常-请重启发动机*/
    POPUP5_AMT_LOW_AIR_WARNING_SPEED    ,/*40.AMT异常(气压低下)-图1*/
    POPUP5_AMT_LOW_AIR_WARNING          ,/*41.AMT异常(气压低下)-图2*/
    POPUP5_LOW_PRESSURE_ALARM_SPEED     ,/*42.低圧警報-轮胎漏气警告*/
    POPUP5_LOW_PRESSURE_ALARM           ,/*43.同——44*/
    POPUP5_APP_ADBLUE_SPEED             ,/*44.尿素补给-补充尿素溶液-图1*/
    POPUP5_APP_ADBLUE                   ,/*45.尿素补给-补充尿素溶液-图2*/
    POPUP5_ADBLUE_LEVEL_LOW_SPEED       ,/*46.尿素余量少-有车速-图1*/
    POPUP5_ADBLUE_LEVEL_LOW             ,/*47.尿素余量少-无车速-图2*/
    POPUP5_LOW_FAILURE_SPEED            ,/*48.低圧警報（低下）*/
    POPUP5_LOW_FAILURE                  ,/*49.同——50*/
    POPUP5_CAMERA_POLLUTION_SPEED       ,/*50.摄像头有污染-图1*/
    POPUP5_CAMERA_POLLUTION             ,/*51.摄像头有污染-请与五十铃公司联系*/
    POPUP5_AdBlue_LEVEL_LOW_SPEED       ,/*52.尿素喷射异常（停止）-图1*/
    POPUP5_AdBlue_LEVEL_LOW             ,/*53.尿素喷射异常（停止）-图2*/
    POPUP5_AdBlue_INJ_SYSTEM_SPEED      ,/*54.尿素喷射异常（消耗量）-图1*/
    POPUP5_AdBlue_INJ_SYSTEM            ,/*55.尿素喷射异常（消耗量）-图2*/
    POPUP5_TPMS_HIGH_AIR                ,/*56.高圧警報-轮胎高压警告*/
    POPUP5_TPMS_HIGH_TEMP               ,/*57.高温警報-轮胎高温警告*/
    POPUP5_AdBlue_DOS_MALFUNC           ,/*58.尿素喷射异常(停止、消耗量)交互显示*/
    POPUP5_PUSH_DPD_SWITCH1_SPEED       ,/*59.DPD手动再生要求1-DPD需要再生*/
    POPUP5_PUSH_DPD_SWITCH1             ,/*60.DPD手动再生要求1-请按下DPD开关*/
    POPUP5_PUSH_DPD_SWITCH2_SPEED       ,/*61.DPD手动再生要求2-DPD需要再生*/
    POPUP5_PUSH_DPD_SWITCH2             ,/*62.DPD手动再生要求2-请按下DPD开关*/
    POPUP5_TPMS_FAILURE                 ,/*63.TPMS故障-轮胎监控失败*/
    POPUP5_TPMS_MONITOR_DROP            ,/*64.TPMS電池低下-轮胎监控传感器电压下降*/
    POPUP6_PUSH_DPD                     ,/*65.DPD手动再生中*/
    POPUP6_HEIGHT_CONTROL               ,/*66.遥控车辆高度调整中(无车速)*/
    POPUP6_PTO_STOP                     ,/*67.PTO(停车中)*/
    POPUP7_CHARGE_ABNORMAL_SPEED        ,/*68.充电异常-请在安全的场所停车*/
    POPUP7_CHARGE_ABNORMAL              ,/*69.充电异常-请与五十铃公司联系*/
    POPUP7_AMT_ERROR_SPEED              ,/*70.AMT異常-AMT异常*/
    POPUP7_AMT_ERROR                    ,/*71.AMT異常-请联系经销商*/
    POPUP8_REFUEL                       ,/*72.补充燃料-油箱单位*/
    POPUP8_ATM_CLUCH_OVERHEATING_SPEED  ,/*73.过热-离合器过载*/
    POPUP8_ATM_CLUCH_OVERHEATING        ,/*74.过热-选择合适的档位*/
    POPUP8_ATM_WORN_OUT                 ,/*75.AMT磨耗-离合器磨损*/
    POPUP8_LOW_VOLTAGE_SPEED            ,/*76.低电压报警*/
    POPUP8_OVERVOLTAGE                  ,/*77.过电压报警*/
    POPUP8_DPD_AUTO_SPEED               ,/*78.DPD自动再生-DPD自动再生中*/
    POPUP8_DPD_AUTO                     ,/*79.DPD自动再生-再生将自动完成，不需要操作开关*/
    POPUP9_AIR_PRESSURE_SPEED           ,/*80.气压过低-气压过低请注意*/
    POPUP9_AIR_PRESSURE                 ,/*81.气压过低-请冲入空气*/
    POPUP9_EBS_ERROR_SPEED              ,/*82.EBS故障（红）-请在安全的场所停车*/
    POPUP9_EBS_ERROR                    ,/*83.EBS故障（红）-请与五十铃公司联系*/
    POPUP10_RAPID_ACC                   ,/*84.省油耗建议-急加速*/
    POPUP10_RAPID_SUB                   ,/*85.省油耗建议-急减速*/
    POPUP10_REVAL_ENGINE                ,/*86.省油耗建议-请降低发动机转速*/
    POPUP10_REVAL_SPEED                 ,/*87.省油耗建议-请降低速度*/
    POPUP11_ENGINE_OIL_FILTER_ERROR     ,/*88.发动机机油＆滤清器*/
    POPUP11_FUEL_FILTER_ERROR           ,/*89.燃油滤清器*/
    POPUP11_T_MISSION_OIL_ERROR         ,/*90.变速箱油*/
    POPUP11_DIFF_OIL_ERROR              ,/*91.差速器油*/
    POPUP11_CLUTCH_OIL_ERROR            ,/*92.顺畅系统离合器油*/
    POPUP11_P_STEERING_FRUID_ERROR      ,/*93.动力转向液*/
    POPUP11_TIRE_ROTATION               ,/*94.更换轮胎・轮胎位置*/

    POPUP_MAX
};

#define   POPUP_NONE                        0xFFFF  /*无报警*/

/******************************************************************************
报警类型定义
******************************************************************************/
#define   POPUP_TYPE_FATAL                  0x00  /*严重报警信息*/
#define   POPUP_TYPE_HINT                   0x01  /*提示信息*/
#define   POPUP_TYPE_WARNING                0x02  /*报警信息*/
#define   POPUP_TYPE_EXCEPTION              0x04  /*特殊信息 */

/******************************************************************************
显示/声音模式
******************************************************************************/
#define   POPUP_MODE_MULTI                  0x00  /*可多次触发*/
#define   POPUP_MODE_SINGLE                 0x01  /*只触发一次*/

/******************************************************************************
+15 On / Off
******************************************************************************/
#define   POPUP_IGN_OFF                             0x00
#define   POPUP_IGN_ON                              0x01
#define   POPUP_IGN_ON_OFF                          0x02

/******************************************************************************
报警属性结构
******************************************************************************/
extern const Popup_Attribute_t PopupAttributeTable[POPUP_MAX];

#endif