#ifndef CAN_FUNC_H
#define CAN_FUNC_H

#include "TYW_stdint.h"

typedef struct
{
    uint32_t TripA_Fuel;
    uint32_t TripA_Average_Speed;
    uint32_t TripA_Fuel_Consume;
    uint32_t TripA_Idling;
    uint32_t TripA_Runing;
    uint32_t TripB_Fuel;
    uint32_t TripB_Average_Speed;
    uint32_t TripB_Fuel_Consume;
    uint32_t TripB_Idling;
    uint32_t TripB_Runing;
    uint32_t Engine_Surplus;

} USER_ECU;
extern USER_ECU User_ECU;

extern uint32_t DisDTCNumber[50];
extern uint8_t  DisDTCNum;

extern void Can_Set_Buff_18FEAE17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF3E17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FED917(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEE617(uint8_t CopyData[]);

extern void Can_Set_Buff_18EF1817(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEE017(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEFC17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF2517(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF2A17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF9D17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FFE517(uint8_t CopyData[]);

extern void Can_Set_Buff_18EF2D17(uint8_t CopyData[]);

extern void Can_Set_Buff_18033317(uint8_t CopyData[]);

extern void Can_Set_Buff_180433A2(uint8_t CopyData[]);

extern void Can_Set_Buff_18EA0017(uint8_t CopyData[]);

void Drive_Info_IC1_STATUS_Rx(void);
void Drive_Info_IC3_STATUS_Rx(void);

uint32_t Common_Data_Get_TripA_Fuel(void);
uint32_t Common_Data_Get_TripA_Average_Speed(void);
uint32_t Common_Data_Get_TripB_Fuel(void);
uint32_t Common_Data_Get_TripB_Average_Speed(void);

void Common_SetTXNum_18033317(void);
uint8_t Common_GetTXNum_18033317(void);

void Id18EF1817_Send_Service(void);
void Id18033317_Send_Service(void);
void Id18FFE517_Send_Service(void);

void MSG_18021733_REC_COPY(uint8_t copy[]);
void Common_SetId18FFE517Msg_TXSUCCESS(void);
uint8_t Common_GetId18FFE517Msg_TXSUCCESS(void);
void Common_Set_LDWS_Flag_Sta(uint8_t Vol);
uint8_t Common_Get_LDWS_Flag_Sta(void);
uint8_t Common_Get_Water_Temp_Level_Flag(void);

void Common_DTC_Server(void);
void GetAllDtcFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum);
void swap32(uint32_t *DwData);


#endif