

#ifndef _PCM_SOUND_TRACKS_H_
#define _PCM_SOUND_TRACKS_H_

#include "TYW_stdint.h"

/***     NOTICE: MUST be 12k sample rate !!!     ***/
/***        NOTICE: MUST be mono type !!!        ***/

typedef enum
{
    PCM_Track_Index_Crash = 0U,
    PCM_Track_Index_DoorOpen,
    PCM_Track_Index_Key,
    PCM_Track_Index_OverSpeed,
    PCM_Track_Index_OverSpeed_2S,
    PCM_Track_Index_Seatbelta,
    PCM_Track_Index_Warrning,
    PCM_Track_Index_TICK,
    PCM_Track_Index_TOCK,

    PCM_Track_Index_MAX,
} PCM_Track_Index_en_t;

typedef struct
{
    const uint8_t *pPCMData;
    uint32_t Size;
    int16_t Gain;
} PCM_Track_Attr_st_t;


extern const PCM_Track_Attr_st_t PCMTrackAttrTable[PCM_Track_Index_MAX];

#define PCM_TRACK_TOTAL_NUM PCM_Track_Index_MAX //(sizeof(PCMTrackAttrTable) / sizeof(PCM_Track_Attr_st_t))

#endif
