﻿
#ifndef GUI_H_
#define GUI_H_

#include "loc_graphics.h"
#include "images.h"
#include "TYW_stdint.h"

#define TRAPA 0u
#define TRAPB 1u

#define Language_En 0u
#define Language_Cn 1u

#define DTCNumeber             6u /*最小数值为1*/

#define FState_COilTimeOutNum 60u /*3S*/

#define SystemSupplierECUHardwareVersionNumberApp ((uint16_t)(10301)) /*硬件版本号   HV:01.02.02*/
#define SystemSupplierECUSoftwareInformationApp ((uint16_t)(10010))   /*软件版本号   SV:01.01.05*/
#define systemSupplierECUFlashInformationApp ((uint16_t)(7))          /*FLASH版本号 FV:00.14*/

typedef struct
{
    uint8_t FState_GZM;     /*故障码*/
    uint8_t FState_WXTZ;    /*维修提醒*/
    uint8_t FState_WXSD;    /*维修设定*/
    uint8_t FState_YHSD;    /*用户设定*/

    uint8_t FState_ECO;     /*ECO*/
    uint8_t FState_TPMS;    /*胎压显示*/
    uint8_t FState_TPMSSET; /*胎压设置*/
    uint8_t FState_SYSYS;   /*系统演示*/

    uint8_t WXTZ_FDJY;      /*发动机油*/
    uint8_t WXTZ_RYLQY;     /*燃油滤清油*/
    uint8_t WXTZ_BSXY;      /*变速箱油*/
    uint8_t WXTZ_CSQY;      /*差速器油*/

    uint8_t WXTZ_LHQY;      /*离合器油*/
    uint8_t WXTZ_KQGZJ;     /*空气干燥剂*/
    uint8_t WXTZ_DLZXY;     /*动力转向油*/
    uint8_t WXTZ_LT;        /*轮胎*/

    uint8_t WXTZ_QDJ;       /*起动机*/
    uint8_t WXSD_FDJY;      /*发动机*/
    uint8_t WXSD_RYLQY;     /*燃油滤清油*/
    uint8_t WXSD_BSXY;      /*变速箱油*/

    uint8_t WXSD_CSQY;      /*差速器油*/
    uint8_t WXSD_LHQY;      /*离合器油*/
    uint8_t WXSD_KQGZJ;     /*空气转向*/
    uint8_t WXSD_DLZXY;     /*动力转向*/

    uint8_t WXSD_LT;        /*轮胎*/
    uint8_t WXSD_QDJ;       /*起动机*/
    uint8_t USER_DATE;      /*日期设定*/
    uint8_t USER_TIME;      /*时间设定*/

    uint8_t USER_DISPLAY;   /*显示设定*/
    uint8_t USER_PROPOSAL;  /*省油设定*/
    uint8_t USER_HSA;       /*HAS*/
    uint8_t USER_VOLUEM;    /*音量设定*/

    uint8_t USER_LANGUAGE;  /*语言设定*/
    uint8_t USER_COMPANY;   /*单位设定*/
    uint8_t USER_LIGHT;     /*亮度设定*/
    uint8_t USER_SETIC;     /*仪表设定*/

    uint8_t DEMO_LDWS;
    uint8_t DEMO_AEBS1;
    uint8_t DEMO_AEBS2;
    uint8_t DEMO_AEBS3;

    uint8_t ENTER_RETURN;
    uint8_t Menu_Key_Static;
    uint8_t User_FDJYLQQ_FLAG;
    uint8_t User_RYLQQ_FLAG;

    uint8_t User_BSXY_FLAG;
    uint8_t User_CSQY_FLAG;
    uint8_t User_KQGZJ_FLAG;
    uint8_t User_DLZXY_FLAG;

    uint8_t User_LT_FLAG;
    uint8_t User_LHQY_FLAG;
    uint8_t FState_ClearOilTx;
    uint8_t FState_ClearOilRx;

    uint16_t FState_COilTimeOut;
    uint8_t Engine_Oil_Time;
    uint8_t Reserve2;

} _Display_State_Flag;

extern _Display_State_Flag State_Flag;

typedef struct
{
    uint16_t Year;            /*  年  */
    uint8_t Month;            /*  月  */
    uint8_t Date;             /*  日  */
    uint8_t Hour;             /*  时  */
    uint8_t Minute;           /*  分  */
    uint8_t Language;         /*  当前语言标识*/
    uint8_t LeapYear;         /*  设置闰年标识*/
    uint8_t User_Gsl;         /*  速度设定-高速路*/
    uint8_t User_Ybl;         /*  速度设定-一般路*/
    uint8_t User_Speed;       /*  发动机转速设定*/
    uint8_t User_JADD;        /*  急加速设定*/
    uint8_t User_JSUB;        /*  急减速设定*/
    uint8_t User_IDLING;      /*  长时间怠速*/
    uint8_t User_Parking;     /*  辅助驻车*/
    uint8_t User_Date;        /*  日期设置格式切换标识*/
    uint8_t User_Time;        /*  时间设置格式切换标识*/
    uint8_t Date_Time;        /*  显示时间日期标识*/
    uint8_t User_HSASET;      /*  HSA调整*/
    uint8_t User_Language;    /*  语言设置*/
    uint8_t User_Company;     /*  单位设定*/
    uint8_t User_Light1;      /*  亮度调节*/
    uint8_t User_Light2;      /*  亮度调节*/
    uint8_t User_CarJL;       /*  车间距离报警*/
    uint32_t User_FDJYLQQ;    /*  发送机油      0 未设定 1-50000 数值*/
    uint32_t User_RYLQQ;      /*  燃油滤清器    0 未设定 1-50000 数值*/
    uint32_t User_BSXY;       /*  变速箱油  */
    uint32_t User_CSQY;       /*  差速器油*/
    uint32_t User_KQGZJ;      /*  空气干燥剂*/
    uint32_t User_DLZXY;      /*  动力转向油*/
    uint32_t User_LT;         /*  轮胎*/
    uint32_t User_QDJ;        /*  起动机*/
    uint32_t User_LHQY;       /*  离合器油*/
    uint8_t User_Tpms;        /*  当前是哪个轮子  0-12*/
    uint8_t User_TpmsStatus;  /*  当前胎压匹配界面 0 胎压未配置状态， 1 轮胎选中界面， 2 轮胎正在配置*/
    uint8_t User_Temp_Return; /*  取消胎压配置  0  1 取消配对标记*/
    uint8_t User_TpmsSend;    /*  胎压匹配报文发送请求次数3    0 不发*/
    uint8_t Trip_Type;        /*  */
    uint8_t Reserve1;
    uint8_t Reserve2;
    uint8_t Reserve3;
} _UserSet;

extern _UserSet User_set_Num;
extern _UserSet User_App;

typedef struct
{
    uint8_t T01;
    uint8_t T02;
    uint8_t T03;
    uint8_t T04;
    uint8_t T05;
    uint8_t T06;
    uint8_t T07;
    uint8_t T08;
    uint8_t T09;
    uint8_t T10;
    uint8_t T11;
    uint8_t T12;
    uint8_t FLAG;
    uint8_t Reserve1;
    uint8_t Reserve2;
    uint8_t Reserve3;
} _TPMS;
extern _TPMS TPMS_Matching;

/******************************************************************************
报警
******************************************************************************/
typedef struct
{
    uint16_t PICIcon;
    uint16_t HImageCN1;
    uint16_t HImageCN2;
    uint16_t HImageCN3;
    uint16_t HImageCN4;

} GUIGeneralPopupStruct;

/*************************************************************************************************************
报警显示表
*************************************************************************************************************/
static const GUIGeneralPopupStruct GUIGeneralPopupTable[] =
{
    /*----图标-----------------有车速-----------------------------------------------------------无车速-------------------------------------------*/
    {SpriteSize,                 CN_Alarm_01_wenzi1,          SpriteSize,                 CN_Alarm_01_wenzi1,          SpriteSize},                /*00.第一组 紧急警报-刹车*/
    {SpriteSize,                 CN_Alarm_01_wenzi4,          SpriteSize,                 CN_Alarm_01_wenzi4,          SpriteSize},                /*01.      紧急警报-紧急制动*/
    {SpriteSize,                 CN_Alarm_01_wenzi2,          SpriteSize,                 CN_Alarm_01_wenzi2,          SpriteSize},                /*02.      车间距警报-刹车(红字)*/
    {SpriteSize,                 CN_Alarm_01_wenzi5,          SpriteSize,                 CN_Alarm_01_wenzi5,          SpriteSize},                /*03.      车间距警报-碰撞报警*/
    {SpriteSize,                 CN_Alarm_01_wenzi3,          SpriteSize,                 CN_Alarm_01_wenzi3,          SpriteSize},                /*04.      车间距警报-刹车(黄字)*/
    {SpriteSize,                 CN_Alarm_01_wenzi3,          SpriteSize,                 CN_Alarm_01_wenzi3,          SpriteSize},                /*         车间距警报-刹车(黄字)*/
    {CN_Alarm_drive_04_image,    CN_Alarm_drive_04_wenzi,     SpriteSize,                 CN_Alarm_drive_04_wenzi,     SpriteSize},                /*05.      ASR工作*/
    {CN_Alarm_drive_05_image,    CN_Alarm_drive_05_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*06.第二组 PTO紧急警报-刹车*/
    {CN_Alarm_drive_06_image,    CN_Alarm_drive_06_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*07.      忘记松手刹车*/
    {CN_Alarm_drive_10_image,    CN_Alarm_drive_10_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*08.      遥控调整车辆高度(有车速)*/
    {CN_Alarm_drive_12_image,    CN_Alarm_drive_12_wenzi,     SpriteSize,                 CN_Alarm_drive_12_wenzi,     SpriteSize},                /*09.第三组 自动巡航模式*/
    {CN_Alarm_drive_14_image,    CN_Alarm_drive_14_wenzi,     SpriteSize,                 CN_Alarm_drive_14_wenzi,     SpriteSize},                /*10.      可变SLD 模式*/
    {CN_Alarm_TST_2_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*11.第四组 充电异常（系统检测）*/
    {CN_Alarm_TST_1_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*12.      油压（系统检测）*/
    {CN_Alarm_TST_3_image,       CN_Alarm_TST_3_wenzi1,       SpriteSize,                 CN_Alarm_TST_3_wenzi1,       SpriteSize},                /*13.      AMT初始化异常*/
    {CN_Alarm_TST_5_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*14.      尿素品质异常（系统检测）*/
    {CN_Alarm_TST_6_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*15.      尿素喷射异常（系统检测）*/
    {CN_Alarm_TST_7_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*16.      尿素水补给（系统检测）*/
    {CN_Alarm_TST_4_image,       CN_Alarm_TST_4_wenzi1,       SpriteSize,                 CN_Alarm_TST_4_wenzi1,       SpriteSize},                /*17.      AMT初始化结束*/
    {CN_Alarm_TST_8_image,       CN_Alarm_TST_1_wenzi,        SpriteSize,                 CN_Alarm_TST_1_wenzi,        SpriteSize},                /*18.      DPD自动再生*/
    {CN_Alarm_G5_1_image,        CN_Alarm_G5_1_wenzi2,        CN_Alarm_G5_1_wenzi1,       CN_Alarm_G5_1_wenzi3,        CN_Alarm_G5_1_wenzi4},      /*19.第五组 过热（过热，请在安全的场所停车）*/
    {CN_Alarm_G5_2_image,        CN_Alarm_G5_2_image2,        CN_Alarm_G5_2_wenzi1,       CN_Alarm_G5_2_wenzi,         CN_Alarm_G5_2_wenzi2},      /*20.      冷却水（冷却水不足）*/
    {CN_Alarm_G5_3_image,        CN_Alarm_G5_3_wenzi4,        CN_Alarm_G5_3_wenzi1,       CN_Alarm_G5_3_wenzi3,        CN_Alarm_G5_3_wenzi2},      /*21.      油压异常*/
    {CN_Alarm_G5_4_image,        CN_Alarm_G5_4_wenzi1,        SpriteSize,                 CN_Alarm_G5_4_wenzi2,        CN_Alarm_G5_4_wenzi3},      /*22.      仪表故障-请与五十铃公司联系*/
    {CN_Alarm_G5_5_image,        CN_Alarm_G5_5_wenzi1,        SpriteSize,                 CN_Alarm_G5_5_wenzi2,        CN_Alarm_G5_5_wenzi3},      /*23.      通信系统-请与五十铃公司联系*/
    {CN_Alarm_G5_6_image,        CN_Alarm_G5_6_wenzi1,        SpriteSize,                 CN_Alarm_G5_6_wenzi2,        SpriteSize},                /*24.      车速限制*/
    {CN_Alarm_G5_7_image,        CN_Alarm_G5_7_wenzi1,        SpriteSize,                 CN_Alarm_G5_7_wenzi2,        SpriteSize},                /*25.      扭矩限制*/
    {CN_Alarm_G5_89_image,       CN_Alarm_G5_89_wenzi4,       SpriteSize,                 CN_Alarm_G5_89_wenzi1,       SpriteSize},                /*26.      尿素品质异常*/
    {CN_Alarm_G5_89_image,       CN_Alarm_G5_89_wenzi3,       SpriteSize,                 CN_Alarm_G5_89_wenzi2,       SpriteSize},                /*27.      临界排放故障*/
    {CN_Alarm_G5_10_11_image,    CN_Alarm_G5_10_11_wenzi5,    CN_Alarm_G5_10_11_wenzi1,   CN_Alarm_G5_10_11_wenzi5,    CN_Alarm_G5_10_11_wenzi4},  /*28.      AMT异常-请重启发动机*/
    {CN_Alarm_G5_10_11_image,    CN_Alarm_G5_10_11_wenzi2,    SpriteSize,                 CN_Alarm_G5_10_11_wenzi3,    SpriteSize},                /*29.      AMT异常(气压低下)*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi1,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi1,    SpriteSize},                /*30.      胎压报警-快速漏气*/
    {CN_Alarm_G5_13_14_image,    CN_Alarm_G5_13_14_wenzi5,    SpriteSize,                 CN_Alarm_G5_13_14_wenzi2,    SpriteSize},                /*31.      尿素补给-补充尿素溶液*/
    {CN_Alarm_G5_13_14_image,    CN_Alarm_G5_13_14_wenzi,     SpriteSize,                 CN_Alarm_G5_13_14_wenzi1,    SpriteSize},                /*32.      尿素余量少-无车速*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi2,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi2,    SpriteSize},                /*33.      胎压报警-气压低*/
    {CN_Alarm_G5_16_image,       CN_Alarm_G5_16_wenzi1,       SpriteSize,                 CN_Alarm_G5_16_wenzi2,       CN_Alarm_G5_16_wenzi3},     /*34.      摄像头有污染-请与五十铃公司联系*/
    {CN_Alarm_G5_17_18_21_image, CN_Alarm_G5_17_18_21_wenzi1, SpriteSize,                 CN_Alarm_G5_17_18_21_wenzi2, SpriteSize},                /*35.      尿素喷射异常（停止）*/
    {CN_Alarm_G5_17_18_21_image, CN_Alarm_G5_17_18_21_wenzi3, SpriteSize,                 CN_Alarm_G5_17_18_21_wenzi5, SpriteSize},                /*36.      尿素喷射异常（消耗量）*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi4,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi4,    SpriteSize},                /*37.      高圧警報-轮胎高压警告*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi9,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi9,    SpriteSize},                /*38.      高温警報-轮胎高温警告*/
    {CN_Alarm_G5_12_23_image,    CN_Alarm_G5_12_23_wenzi2,    SpriteSize,                 CN_Alarm_G5_12_23_wenzi1,    SpriteSize},                /*39.      DPD手动再生要求1-请按下DPD开关*/
    {CN_Alarm_G5_12_23_image,    CN_Alarm_G5_12_23_wenzi2,    CN_Alarm_G5_17_18_21_wenzi4, CN_Alarm_G5_12_23_wenzi1,    SpriteSize},               /*40.      DPD手动再生要求2-请按下DPD开关*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi7,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi7,    SpriteSize},                /*41.      TPMS故障*/
    {CN_Alarm_G5_12_25_image,    CN_Alarm_G5_12_25_wenzi6,    SpriteSize,                 CN_Alarm_G5_12_25_wenzi6,    SpriteSize},                /*42.      TPMS電池低下-轮胎监控传感器电压下降*/
    {CN_Alarm_stop_31_image,     SpriteSize,                  SpriteSize,                 CN_Alarm_stop_31_wenzi1,     SpriteSize},                /*43.第六组 遥控车辆高度调整中(无车速)*/
    {CN_Alarm_stop_32_image,     SpriteSize,                  SpriteSize,                 CN_Alarm_stop_32_wenzi,      SpriteSize},                /*44.      PTO(停车中)*/
    {CN_Alarm_drive_33_image,    CN_Alarm_drive_33_wenzi2,    CN_Alarm_drive_33_wenzi1,   CN_Alarm_stop_36_wenzi1,     CN_Alarm_stop_36_wenzi2},   /*45.第七组 充电异常-请与五十铃公司联系*/
    {CN_Alarm_drive_55_image,    CN_Alarm_drive_55_wenzi1_1,  CN_Alarm_drive_55_wenzi1_2, CN_Alarm_drive_55_wenzi1_1,  CN_Alarm_stop_55_wenzi1_2}, /*46.      AMT異常-请联系经销商*/
    {CN_Alarm_drive_37_image,    CN_Alarm_drive_37_wenzi,     SpriteSize,                 CN_Alarm_drive_37_wenzi,     SpriteSize},                /*47.第八组 补充燃料-油箱单位*/
    {CN_Alarm_drive_56_image,    CN_Alarm_drive_56_wenzi1,    SpriteSize,                 CN_Alarm_stop_56_wenzi1_1,   CN_Alarm_stop_56_wenzi1_2}, /*48.      AMT过热-选择合适的档位*/
    {CN_Alarm_drive_56_image,    CN_Alarm_drive_56_wenzi2,    SpriteSize,                 CN_Alarm_drive_56_wenzi2,    SpriteSize},                /*49.      AMT磨耗-离合器磨损*/
    {CN_Alarm_drive_33_image,    CN_Alarm_drive_39_wenzi1,    SpriteSize,                 CN_Alarm_drive_39_wenzi1,    SpriteSize},                /*50.      低电压报警*/
    {CN_Alarm_drive_33_image,    CN_Alarm_drive_39_wenzi2,    SpriteSize,                 CN_Alarm_drive_39_wenzi2,    SpriteSize},                /*51.      过电压报警*/
    {CN_Alarm_drive_70_image,    CN_Alarm_drive_70_wenzi1,    SpriteSize,                 CN_Alarm_stop_71_wenzi1_1,   CN_Alarm_stop_70_wenzi2},   /*52.      后蹄片磨损*/
    {CN_Alarm_drive_70_image,    CN_Alarm_drive_70_wenzi1,    SpriteSize,                 CN_Alarm_stop_70_wenzi1_1,   CN_Alarm_stop_70_wenzi2},   /*53.      前蹄片磨损*/

    {CN_Alarm_76_image,          CN_Alarm_76_wenzi1,          CN_Alarm_76_wenzi2,         CN_Alarm_76_wenzi1,          CN_Alarm_76_wenzi2},        /*   变速箱温度高*/
    {CN_Alarm_72_image,          CN_Alarm_72_wenzi,           SpriteSize,                 CN_Alarm_72_wenzi,           SpriteSize        },        /*   未检测到GW*/
    {CN_Alarm_73_image,          CN_Alarm_73_wenzi,           SpriteSize,                 CN_Alarm_73_wenzi,           SpriteSize        },        /*   未检测到TBOX*/
    {CN_Alarm_73_image,          CN_Alarm_74_wenzi,           SpriteSize,                 CN_Alarm_74_wenzi,           SpriteSize        },        /*   TBOX通信异常*/
    {CN_Alarm_75_image,          CN_Alarm_75_wenzi,           SpriteSize,                 CN_Alarm_75_wenzi,           SpriteSize        },        /*   平台通信异常*/

    {CN_Alarm_drive_41_image,    CN_Alarm_drive_41_wenzi,     SpriteSize,                 CN_Alarm_stop_43_wenzi1,     CN_Alarm_stop_43_wenzi2},   /*54.      DPD自动再生-再生将自动完成，不需要操作开关*/
    {CN_Alarm_drive_42_image,    CN_Alarm_drive_42_wenzi1,    SpriteSize,                 CN_Alarm_stop_44_wenzi1_1,   CN_Alarm_stop_44_wenzi1_2}, /*55.第九组 气压过低-请冲入空气*/
    {CN_Alarm_drive_42_image,    CN_Alarm_drive_42_wenzi2_2,  CN_Alarm_drive_42_wenzi2_1, CN_Alarm_stop_44_wenzi2_1,   CN_Alarm_stop_44_wenzi2_2}, /*56.      EBS故障（红）-请与五十铃公司联系*/
    {SpriteSize,                 CN_Alarm_drive_43_image,     CN_Alarm_drive_43_wenzi1,   SpriteSize,                  SpriteSize},                /*57.第十组 省油耗建议-急加速*/
    {SpriteSize,                 CN_Alarm_drive_43_image,     CN_Alarm_drive_43_wenzi2,   SpriteSize,                  SpriteSize},                /*58.      省油耗建议-急减速*/
    {SpriteSize,                 CN_Alarm_drive_43_image,     CN_Alarm_drive_43_wenzi3,   SpriteSize,                  SpriteSize},                /*59.      省油耗建议-请降低发动机转速*/
    {SpriteSize,                 CN_Alarm_drive_43_image,     CN_Alarm_drive_43_wenzi4,   SpriteSize,                  SpriteSize},                /*60.      省油耗建议-请降低速度*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_1,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_1,  CN_Alarm_drive_44_wenzi1},  /*61.第11组 发动机机油＆滤清器*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_2,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_2,  CN_Alarm_drive_44_wenzi1},  /*62.      燃油滤清器*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_3,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_3,  CN_Alarm_drive_44_wenzi1},  /*63.      变速箱油*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_4,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_4,  CN_Alarm_drive_44_wenzi1},  /*64.      差速器油*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_7,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_7,  CN_Alarm_drive_44_wenzi1},  /*65.      顺畅系统离合器油*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi1_5,  CN_Alarm_drive_44_wenzi1,   CN_Alarm_drive_44_wenzi1_5,  CN_Alarm_drive_44_wenzi1},  /*66.      动力转向液*/
    {CN_Alarm_drive_44_image,    CN_Alarm_drive_44_wenzi2_1,  CN_Alarm_drive_44_wenzi2,   CN_Alarm_drive_44_wenzi2_1,  CN_Alarm_drive_44_wenzi2},  /*67.      更换轮胎・轮胎位置*/
};

static const GUIGeneralPopupStruct GUIGeneralPopupTable_En[] =
{
    /*----图标-----------------有车速-----------------------------------------------------------无车速-------------------------------------------*/
    {SpriteSize,                 EN_Alarm_01_wenzi1,          SpriteSize,                 EN_Alarm_01_wenzi1,          SpriteSize},                /*00.第一组 紧急警报-刹车*/
    {SpriteSize,                 EN_Alarm_01_wenzi4,          SpriteSize,                 EN_Alarm_01_wenzi4,          SpriteSize},                /*01.      紧急警报-紧急制动*/
    {SpriteSize,                 EN_Alarm_01_wenzi2,          SpriteSize,                 EN_Alarm_01_wenzi2,          SpriteSize},                /*02.      车间距警报-刹车(红字)*/
    {SpriteSize,                 EN_Alarm_01_wenzi5,          SpriteSize,                 EN_Alarm_01_wenzi5,          SpriteSize},                /*03.      车间距警报-碰撞报警*/
    {SpriteSize,                 EN_Alarm_01_wenzi3,          SpriteSize,                 EN_Alarm_01_wenzi3,          SpriteSize},                /*04.      车间距警报-刹车(黄字)*/
    {SpriteSize,                 EN_Alarm_01_wenzi3,          SpriteSize,                 EN_Alarm_01_wenzi3,          SpriteSize},                /*05.      车间距警报-刹车(黄字)*/
    {CN_Alarm_drive_04_image,    EN_Alarm_drive_04_wenzi,     SpriteSize,                 EN_Alarm_drive_04_wenzi,     SpriteSize},                /*06.      ASR工作*/
    {CN_Alarm_drive_05_image,    EN_Alarm_drive_05_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*07.第二组 PTO紧急警报-刹车*/
    {CN_Alarm_drive_06_image,    EN_Alarm_drive_06_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*08.      忘记松手刹车*/
    {CN_Alarm_drive_10_image,    EN_Alarm_drive_10_wenzi,     SpriteSize,                 SpriteSize,                  SpriteSize},                /*09.      遥控调整车辆高度(有车速)*/
    {CN_Alarm_drive_12_image,    EN_Alarm_drive_12_wenzi,     SpriteSize,                 EN_Alarm_drive_12_wenzi,     SpriteSize},                /*10.第三组 自动巡航模式*/
    {CN_Alarm_drive_14_image,    EN_Alarm_drive_14_wenzi,     SpriteSize,                 EN_Alarm_drive_14_wenzi,     SpriteSize},                /*11.      可变SLD 模式*/
    {CN_Alarm_TST_2_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*12.第四组 充电异常（系统检测）*/
    {CN_Alarm_TST_1_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*13.      油压（系统检测）*/
    {CN_Alarm_TST_3_image,       EN_Alarm_TST_3_wenzi1,       SpriteSize,                 EN_Alarm_TST_3_wenzi1,       SpriteSize},                /*14.      AMT初始化异常*/
    {CN_Alarm_TST_5_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*15.      尿素品质异常（系统检测）*/
    {CN_Alarm_TST_6_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*16.      尿素喷射异常（系统检测）*/
    {CN_Alarm_TST_7_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*17.      尿素水补给（系统检测）*/
    {CN_Alarm_TST_4_image,       EN_Alarm_TST_4_wenzi1,       SpriteSize,                 EN_Alarm_TST_4_wenzi1,       SpriteSize},                /*18.      AMT初始化结束*/
    {CN_Alarm_TST_8_image,       EN_Alarm_TST_1_wenzi,        SpriteSize,                 EN_Alarm_TST_1_wenzi,        SpriteSize},                /*19.      DPD自动再生*/
    {CN_Alarm_G5_1_image,        EN_Alarm_G5_1_wenzi2,        EN_Alarm_G5_1_wenzi1,       EN_Alarm_G5_1_wenzi3,        EN_Alarm_G5_1_wenzi4},      /*20.第五组 过热（过热，请在安全的场所停车）*/
    {CN_Alarm_G5_2_image,        EN_Alarm_G5_2_image2,        EN_Alarm_G5_2_wenzi1,       EN_Alarm_G5_2_wenzi,         EN_Alarm_G5_2_wenzi2},      /*21.      冷却水（冷却水不足）*/
    {CN_Alarm_G5_3_image,        EN_Alarm_G5_3_wenzi4,        EN_Alarm_G5_3_wenzi1,       EN_Alarm_G5_3_wenzi3,        EN_Alarm_G5_3_wenzi2},      /*22.      油压异常*/
    {EN_Alarm_G5_4_image,        EN_Alarm_G5_4_wenzi1,        SpriteSize,                 EN_Alarm_G5_4_wenzi2,        EN_Alarm_G5_4_wenzi3},      /*23.      仪表故障-请与五十铃公司联系*/
    {EN_Alarm_G5_5_image,        EN_Alarm_G5_5_wenzi1,        SpriteSize,                 EN_Alarm_G5_5_wenzi2,        EN_Alarm_G5_5_wenzi3},      /*24.      通信系统-请与五十铃公司联系*/
    {CN_Alarm_G5_6_image,        EN_Alarm_G5_6_wenzi1,        SpriteSize,                 EN_Alarm_G5_6_wenzi2,        SpriteSize},                /*25.      车速限制*/
    {CN_Alarm_G5_7_image,        EN_Alarm_G5_7_wenzi1,        SpriteSize,                 EN_Alarm_G5_7_wenzi2,        SpriteSize},                /*26.      扭矩限制*/
    {CN_Alarm_G5_89_image,       EN_Alarm_G5_89_wenzi4,       SpriteSize,                 EN_Alarm_G5_89_wenzi1,       SpriteSize},                /*27.      尿素品质异常*/
    {CN_Alarm_G5_89_image,       EN_Alarm_G5_89_wenzi3,       SpriteSize,                 EN_Alarm_G5_89_wenzi2,       SpriteSize},                /*28.      临界排放故障*/
    {CN_Alarm_G5_10_11_image,    EN_Alarm_G5_10_11_wenzi5,    EN_Alarm_G5_10_11_wenzi1,   EN_Alarm_G5_10_11_wenzi5,    EN_Alarm_G5_10_11_wenzi4},  /*29.      AMT异常-请重启发动机*/
    {CN_Alarm_G5_10_11_image,    EN_Alarm_G5_10_11_wenzi2,    SpriteSize,                 EN_Alarm_G5_10_11_wenzi3,    SpriteSize},                /*30.      AMT异常(气压低下)*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi1,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi1,    SpriteSize},                /*31.      胎压报警-快速漏气*/
    {CN_Alarm_G5_13_14_image,    EN_Alarm_G5_13_14_wenzi5,    SpriteSize,                 EN_Alarm_G5_13_14_wenzi2,    SpriteSize},                /*32.      尿素补给-补充尿素溶液*/
    {CN_Alarm_G5_13_14_image,    EN_Alarm_G5_13_14_wenzi,     SpriteSize,                 EN_Alarm_G5_13_14_wenzi1,    SpriteSize},                /*33.      尿素余量少-无车速*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi2,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi2,    SpriteSize},                /*34.      胎压报警-气压低*/
    {CN_Alarm_G5_16_image,       EN_Alarm_G5_16_wenzi1,       SpriteSize,                 EN_Alarm_G5_16_wenzi2,       EN_Alarm_G5_16_wenzi3},     /*35.      摄像头有污染-请与五十铃公司联系*/
    {CN_Alarm_G5_17_18_21_image, EN_Alarm_G5_17_18_21_wenzi1, SpriteSize,                 EN_Alarm_G5_17_18_21_wenzi2, SpriteSize},                /*36.      尿素喷射异常（停止）*/
    {CN_Alarm_G5_17_18_21_image, EN_Alarm_G5_17_18_21_wenzi3, SpriteSize,                 EN_Alarm_G5_17_18_21_wenzi5, SpriteSize},                /*37.      尿素喷射异常（消耗量）*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi4,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi4,    SpriteSize},                /*38.      高圧警報-轮胎高压警告*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi9,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi9,    SpriteSize},                /*39.      高温警報-轮胎高温警告*/
    {CN_Alarm_G5_12_23_image,    EN_Alarm_G5_12_23_wenzi2,    SpriteSize,                 EN_Alarm_G5_12_23_wenzi1,    SpriteSize},                /*40.      DPD手动再生要求1-请按下DPD开关*/
    {CN_Alarm_G5_12_23_image,    EN_Alarm_G5_12_23_wenzi2,    EN_Alarm_G5_17_18_21_wenzi4, EN_Alarm_G5_12_23_wenzi1,   SpriteSize},                /*41.      DPD手动再生要求2-请按下DPD开关*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi7,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi7,    SpriteSize},                /*42.      TPMS故障*/
    {CN_Alarm_G5_12_25_image,    EN_Alarm_G5_12_25_wenzi6,    SpriteSize,                 EN_Alarm_G5_12_25_wenzi6,    SpriteSize},                /*43.      TPMS電池低下-轮胎监控传感器电压下降*/
    {CN_Alarm_stop_31_image,     SpriteSize,                  SpriteSize,                 EN_Alarm_stop_31_wenzi1,     SpriteSize},                /*44.第六组 遥控车辆高度调整中(无车速)*/
    {CN_Alarm_stop_32_image,     SpriteSize,                  SpriteSize,                 EN_Alarm_stop_32_wenzi,      SpriteSize},                /*45.      PTO(停车中)*/
    {CN_Alarm_drive_33_image,    EN_Alarm_drive_33_wenzi2,    EN_Alarm_drive_33_wenzi1,   EN_Alarm_stop_36_wenzi1,     EN_Alarm_stop_36_wenzi2},   /*46.第七组 充电异常-请与五十铃公司联系*/
    {CN_Alarm_drive_55_image,    EN_Alarm_drive_55_wenzi1_1,  EN_Alarm_drive_55_wenzi1_2, EN_Alarm_drive_55_wenzi1_1,  EN_Alarm_stop_55_wenzi1_2}, /*47.      AMT異常-请联系经销商*/
    {CN_Alarm_drive_37_image,    EN_Alarm_drive_37_wenzi,     SpriteSize,                 EN_Alarm_drive_37_wenzi,     SpriteSize},                /*48.第八组 补充燃料-油箱单位*/
    {CN_Alarm_drive_56_image,    EN_Alarm_drive_56_wenzi1,    SpriteSize,                 EN_Alarm_stop_56_wenzi1_1,   EN_Alarm_stop_43_wenzi2  }, /*49.      AMT过热-选择合适的档位*/
    {CN_Alarm_drive_56_image,    EN_Alarm_drive_56_wenzi2,    SpriteSize,                 EN_Alarm_drive_56_wenzi2,    SpriteSize},                /*50.      AMT磨耗-离合器磨损*/
    {CN_Alarm_drive_33_image,    EN_Alarm_drive_39_wenzi1,    SpriteSize,                 EN_Alarm_drive_39_wenzi1,    SpriteSize},                /*51.      低电压报警*/
    {CN_Alarm_drive_33_image,    EN_Alarm_drive_39_wenzi2,    SpriteSize,                 EN_Alarm_drive_39_wenzi2,    SpriteSize},                /*52.      过电压报警*/
    {CN_Alarm_drive_70_image,    EN_Alarm_drive_70_wenzi1,    SpriteSize,                 EN_Alarm_stop_71_wenzi1_1,   EN_Alarm_stop_70_wenzi2},   /*53.      后蹄片磨损*/
    {CN_Alarm_drive_70_image,    EN_Alarm_drive_70_wenzi1,    SpriteSize,                 EN_Alarm_stop_70_wenzi1_1,   EN_Alarm_stop_70_wenzi2},   /*54.      前蹄片磨损*/

    {CN_Alarm_76_image,          EN_Alarm_76_wenzi1,          EN_Alarm_76_wenzi2,         EN_Alarm_76_wenzi1,          EN_Alarm_76_wenzi2},        /*55.      变速箱温度高*/
    {CN_Alarm_72_image,          EN_Alarm_72_wenzi,           SpriteSize,                 EN_Alarm_72_wenzi,           SpriteSize        },        /*56.      未检测到GW*/
    {CN_Alarm_73_image,          EN_Alarm_73_wenzi,           SpriteSize,                 EN_Alarm_73_wenzi,           SpriteSize        },        /*57.      未检测到TBOX*/
    {CN_Alarm_73_image,          EN_Alarm_74_wenzi,           SpriteSize,                 EN_Alarm_74_wenzi,           SpriteSize        },        /*58.      TBOX通信异常*/
    {CN_Alarm_75_image,          EN_Alarm_75_wenzi,           SpriteSize,                 EN_Alarm_75_wenzi,           SpriteSize        },        /*59.      平台通信异常*/

    {CN_Alarm_drive_41_image,    EN_Alarm_drive_41_wenzi,     SpriteSize,                 EN_Alarm_stop_43_wenzi1,     EN_Alarm_stop_43_wenzi2},   /*60.      DPD自动再生-再生将自动完成，不需要操作开关*/
    {CN_Alarm_drive_42_image,    EN_Alarm_drive_42_wenzi1,    SpriteSize,                 EN_Alarm_stop_44_wenzi1_1,   EN_Alarm_stop_44_wenzi1_2}, /*61.第九组 气压过低-请冲入空气*/
    {CN_Alarm_drive_42_image,    EN_Alarm_drive_42_wenzi2_2,  EN_Alarm_drive_42_wenzi2_1, EN_Alarm_stop_44_wenzi2_1,   EN_Alarm_stop_44_wenzi2_2}, /*62.      EBS故障（红）-请与五十铃公司联系*/
    {SpriteSize,                 EN_Alarm_drive_43_image,     EN_Alarm_drive_43_wenzi1,   SpriteSize,                  SpriteSize},                /*63.第十组 省油耗建议-急加速*/
    {SpriteSize,                 EN_Alarm_drive_43_image,     EN_Alarm_drive_43_wenzi2,   SpriteSize,                  SpriteSize},                /*64.      省油耗建议-急减速*/
    {SpriteSize,                 EN_Alarm_drive_43_image,     EN_Alarm_drive_43_wenzi3,   SpriteSize,                  SpriteSize},                /*65.      省油耗建议-请降低发动机转速*/
    {SpriteSize,                 EN_Alarm_drive_43_image,     EN_Alarm_drive_43_wenzi4,   SpriteSize,                  SpriteSize},                /*66.      省油耗建议-请降低速度*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_1,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_1,  EN_Alarm_drive_44_wenzi1},  /*67.第11组 发动机机油＆滤清器*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_2,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_2,  EN_Alarm_drive_44_wenzi1},  /*68.      燃油滤清器*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_3,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_3,  EN_Alarm_drive_44_wenzi1},  /*69.      变速箱油*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_4,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_4,  EN_Alarm_drive_44_wenzi1},  /*70.      差速器油*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_7,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_7,  EN_Alarm_drive_44_wenzi1},  /*71.      顺畅系统离合器油*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi1_5,  EN_Alarm_drive_44_wenzi1,   EN_Alarm_drive_44_wenzi1_5,  EN_Alarm_drive_44_wenzi1},  /*72.      动力转向液*/
    {CN_Alarm_drive_44_image,    EN_Alarm_drive_44_wenzi2_1,  EN_Alarm_drive_44_wenzi2,   EN_Alarm_drive_44_wenzi2_1,  EN_Alarm_drive_44_wenzi2},  /*73.      更换轮胎・轮胎位置*/
};

static const uint16_t GUIWedk_Cn[7u] = {CN_xingqiri, CN_xingqiyi, CN_xingqier, CN_xingqisan, CN_xingqisi, CN_xingqiwu, CN_xingqiliu};
static const uint16_t GUIWedk_En[7u] = {EN_xingqiri, EN_xingqiyi, EN_xingqier, EN_xingqisan, EN_xingqisi, EN_xingqiwu, EN_xingqiliu};
static const uint16_t GUIMenuWedk_CN[7u] = {CN_ri, CN_Mon, CN_Tue, CN_Wed, CN_Thu, CN_Fri, CN_Sat};
static const uint16_t GUIMenuWedk_EN[7u] = {EN_Sun, EN_Mon, EN_Tue, EN_Wed, EN_Thu, EN_Fri, EN_Sat};
static const uint16_t GUIGear[12u] = {CN_dangwei_1, CN_dangwei_2, CN_dangwei_3, CN_dangwei_4, CN_dangwei_5, CN_dangwei_6,
                                      CN_dangwei_7, CN_dangwei_8, CN_dangwei_9, CN_dangwei_10, CN_dangwei_11, CN_dangwei_12
                                     };
static const uint16_t GUIMETERY[5u] = {Nb_15_2, Nb_15_3, Nb_15_4, Nb_15_5, CN_Fty_Menu2_08_A};
static const uint16_t GUIMETERYNUM[16u] = {Nb_15_0, Nb_15_1, Nb_15_2, Nb_15_3, Nb_15_4, Nb_15_5, Nb_15_6, Nb_15_7,
                                           Nb_15_8, Nb_15_9, CN_Fty_Menu2_08_A, CN_Fty_Menu2_08_B, CN_Fty_Menu2_08_C, CN_Fty_Menu2_08_D, CN_Fty_Menu2_08_E, CN_Fty_Menu2_08_F
                                          };
static const uint16_t GUIDTCNUM[16u] = {CN_Nb_28_0, CN_Nb_28_1, CN_Nb_28_2, CN_Nb_28_3, CN_Nb_28_4, CN_Nb_28_5, CN_Nb_28_6, CN_Nb_28_7, CN_Nb_28_8, CN_Nb_28_9,
                                        CN_Alarm_Fault_A, CN_Alarm_Fault_B, CN_Alarm_Fault_C, CN_Alarm_Fault_D, CN_Alarm_Fault_E, CN_Alarm_Fault_F
                                       };

static const uint16_t GUI_DISP_LEMPY[4] = {92u, 158u, 225u, 291u};
static const uint16_t GUI_DISP_AC_TEMP[2] = {229u, 216u}; /*室外温度数字显示*/
static const uint16_t GUI_DISP_Hours[2] = {370u, 349u};
static const uint16_t GUI_DISP_Minutes[2] = {428u, 406u};
static const uint16_t GUI_DISP_Year[4] = {568u, 552u, 538u, 522u};
static const uint16_t GUI_DISP_Month[2] = {617u, 604u};
static const uint16_t GUI_DISP_Date[2] = {669u, 653u};
static const uint16_t GUI_DISP_TRIPA[7] = {676u, 648u, 629u, 610u, 591u, 572u, 553u};   /*TRIP*/
static const uint16_t GUI_DISP_ODO[7] = {676u, 657u, 638u, 619u, 600u, 581u, 562u};     /*ODO*/
static const uint16_t GUI_DISP_DrivingSupport[3] = {481u, 459u, 436u};                  /*定速巡航*/
static const uint16_t GUI_DISP_OILTEMP[7] = {729u, 697u, 676u, 655u, 634u, 613u, 592u}; /*油温时间*/
static const uint16_t GUI_DISP_MENUHours[2] = {578u, 560u};
static const uint16_t GUI_DISP_MENUMinutes[2] = {623u, 605u};
static const uint16_t GUI_DISP_MENUYear[4] = {495u, 477u, 459u, 441u}; /*年月日*/
static const uint16_t GUI_DISP_MENUMonth[2] = {572u, 554u};
static const uint16_t GUI_DISP_MENUDate[2] = {648u, 630u};
static const uint16_t GUI_DISP_MENUYear_EN[4] = {443u, 426u, 410u, 393u}; /*年月日*/
static const uint16_t GUI_DISP_MENUMonth_EN[2] = {531u, 514u};
static const uint16_t GUI_DISP_MENUDate_EN[2] = {637u, 621u};
static const uint16_t GUI_DISP_MENUYear1[4] = {568u, 552u, 538u, 522u}; /*月日年*/
static const uint16_t GUI_DISP_MENUMonth1[2] = {617u, 604u};
static const uint16_t GUI_DISP_MENUDate1[2] = {669u, 653u};
static const uint16_t GUI_DISP_MENU_Y[4] = {150u, 198u, 246u, 294u}; /*菜单选项纵坐标*/
static const uint16_t GUI_TPMS_PIC_X[4] = {298u, 373u, 478u, 543u};
static const uint16_t GUI_TPMS_PIC_Y[4] = {115u, 140u, 214u, 238u};
static const uint16_t GUI_TPMS_NUM1_X[3] = {344u, 329u, 314u};
static const uint16_t GUI_TPMS_NUM2_X[3] = {419u, 404u, 389u};
static const uint16_t GUI_TPMS_NUM3_X[3] = {525u, 510u, 495u};
static const uint16_t GUI_TPMS_NUM4_X[3] = {589u, 574u, 559u};
static const uint16_t GUI_TPMS_NUM_Y[4] = {109u, 173u, 210u, 274u};
static const uint16_t GUI_TPMS_MIC3_X[4] = {314u, 389u, 495u, 559u};
static const uint16_t GUI_TPMS_MIC2_X[4] = {329u, 404u, 510u, 574u};

static const uint16_t GUI_REP1_X[6] = {582u, 565u, 547u, 521u, 503u, 485u};
static const uint16_t GUI_REP_X[4] = {582u, 565u, 547u, 521u};
static const uint16_t GUI_SETREP_X[6] = {520u, 503u, 485u, 458u, 441u, 424u};
static const uint16_t GUI_SYSSET_X[4] = {520u, 503u, 485u, 468u};
static const uint16_t GUI_SYSSPEED[2] = {485u, 468u};
static const uint16_t GUI_SYSJDD_X[2] = {469u, 441u};

static const uint16_t GUIUsetSetYPos[2] = {304u, 282u};
static const uint16_t GUIUsetSetYPosX[2] = {358u, 337u};
static const uint16_t GUIUsetSetMPosX[2] = {463u, 440u};
static const uint16_t GUIUsetSetDPosX[2] = {570u, 547u};

static const uint16_t GUIUsetSetHPosX[2] = {414u, 391u};
static const uint16_t GUIUsetSetMiPosX[2] = {490u, 467u};

static const uint16_t GUIBGAVGSpeedPosX[4] = {667u, 642u, 617u, 592u};
static const uint16_t GUIBGAVGFuelPosX[4] = {667u, 628u, 603u, 578u};

static const uint16_t GUIBGTestPosX[6] = {569u, 540u, 497u, 468u, 424u, 395u};
static const uint16_t GUIBGDTCPosX[5] = {558u, 528u, 468u, 438u, 408u};
static const uint16_t GUIBGDTCMPosX[4] = {521u, 491u, 461u, 431u};

extern void GUI_Display_KL15_ON_Init(void);
extern void GUI_Display_KL15_OFF_Init(void);
extern void GUI_Display_backgroundOFF(void);
extern void GUI_Display_Value_Init(void); /*显示数据初始化*/
extern void GUI_Display_background(void); /*刷底图*/
extern void GUI_OftenShow_Display(void);  /*常显界面*/
extern void GUI_OftenShowOFF_Display(void);
extern void GUI_Dynamic_DIsplay(void);
void GUI_Display_Animation_Frame(uint16_t frame);
void GUI_AC_Temp_Dispaly(uint8_t Mode);                 /*室外温度显示*/
void GUI_Time_Dispaly(uint8_t Mode);                    /*时间显示*/
void GUI_Data_Dispaly(uint8_t Mode);                    /*日历显示*/
void GUI_TFTTelltales_Display(uint8_t Mode);            /*TFT指示灯*/
void GUI_WetGas_Dispaly(uint8_t Mode);                  /*wet气压*/
void GUI_AdBlue_Dispaly(uint8_t Mode);                  /**/
void Gui_TRIPA_Display(uint8_t Mode);                   /*TRIPA*/
void Gui_TRIPB_Display(uint8_t Mode);                   /*TRIPB*/
void Gui_ODO_Display(uint8_t Mode);                     /*ODO*/
void Gui_ADAS_Display(uint8_t Mode);                    /*ADAS*/
void Gui_ADAS_Test_Display(uint8_t Mode);               /*ADAS TEST*/
void Gui_DrivingSupport_Display(uint8_t Mode);          /*定速巡航*/
void Gui_Gear_Display(uint8_t Mode);                    /*挡位*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode);           /*平均车速，平均油耗*/
void GUI_Drive_Info_Avg_Speed_Display(uint16_t Speed);  /*平均车速*/
void GUI_Drive_Info_Avg_Fuel_Display(uint16_t Fuel);    /*平均油耗*/
void GUI_Battery_Display_Display(uint8_t Mode);         /*电池电量*/
void GUI_DPD_Display_Display(uint8_t Mode);             /*DPD*/
void GUI_Time_OilTemp_Display(uint8_t Mode);            /*转速时间-油温*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode);        /*OFF 转速时间-油温*/
void GUI_Year_Month_Data_Display(uint8_t Mode);         /*年月日*/
void GUI_block_NULL_Display(uint8_t Mode);              /*……*/
void GUI_AEBS_Test1_Display(uint8_t Mode);              /*AEBS_TEST1*/
void GUI_AEBS_Test2_Display(uint8_t Mode);              /*AEBS_TEST2*/
void GUI_AEBS_Test3_Display(uint8_t Mode);              /*AEBS_TEST3*/
void GUI_BG_Menu_Display(uint8_t Mode);                 /*一级菜单项*/
void GUI_BG_Menu1_Display(uint8_t Mode);                /**/
void GUI_BG_Menu2_Display(uint8_t Mode);                /**/
void GUI_BG_Menu3_Display(uint8_t Mode);                /**/
void GUI_BG_Menu4_Display(uint8_t Mode);                /**/
void GUI_BG_Menu5_Display(uint8_t Mode);                /**/
void GUI_BG_Menu6_Display(uint8_t Mode);                /**/
void GUI_BG_Multiframe_Display(uint8_t Mode);           /*二级菜单--故障码*/
void GUI_BG_Multiframe1_Display(uint8_t Mode);          /* */
void GUI_BG_Multiframe2_Display(uint8_t Mode);          /* */
void GUI_BG_Multiframe3_Display(uint8_t Mode);          /* */
void GUI_BG_Multiframe4_Display(uint8_t Mode);          /* */
void GUI_BG_Multiframe5_Display(uint8_t Mode);          /* */
void GUI_BG_Multiframe6_Display(uint8_t Mode);          /* */
void GUI_BG_Rep_Menu_Display(uint8_t Mode);             /*二级菜单--保养通知*/
void GUI_BG_RepMenu1_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu2_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu3_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu4_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu5_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu6_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu7_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu8_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu9_Display(uint8_t Mode);             /**/
void GUI_BG_RepSet_Menu_Display(uint8_t Mode);          /*二级菜单--保养通知设定*/
void GUI_BG_RepSetMenu1_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu2_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu3_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu4_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu5_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu6_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu7_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu8_Display(uint8_t Mode);          /**/
void GUI_BG_UserSet_Menu_Display(uint8_t Mode);         /*二级菜单--用户设定*/
void GUI_BG_UserSetMenu1_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu2_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu3_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu4_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu5_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu6_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu7_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu8_Display(uint8_t Mode);         /**/
void GUI_BG_Demo_Menu_Display(uint8_t Mode);            /*二级菜单--系统演示模式*/
void GUI_BG_DemoMenu1_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu2_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu3_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu4_Display(uint8_t Mode);            /**/
void GUI_BG_TPMS_GasPIC_Display(uint8_t Mode);          /*二级菜单--TPMS*/
void GUI_BG_TPMS_GasNUM_Display(uint8_t Mode);          /**/
void GUI_BG_TPMS_TempPIC_Display(uint8_t Mode);         /**/
void GUI_BG_TPMS_TempNUM_Display(uint8_t Mode);         /**/
void GUI_BG_RepMenu_Display(uint8_t Mode);              /*三级菜单--保养通知*/
void GUI_BG_RepMenu_3_1_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_2_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_3_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_4_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_6_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_7_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_8_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenuSet_Menu_Display(uint8_t Mode);      /**/
void GUI_BG_RepSetMenu_3_1_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_2_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_3_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_4_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_5_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_6_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_7_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_Display(uint8_t Mode);              /**/
void GUI_BG_UserSet_Date_Display(uint8_t Mode);         /**/
void GUI_BG_UserSet_Time_Display(uint8_t Mode);         /**/
void GUI_BG_UserSet_Language_Display(uint8_t Mode);     /*语言设定*/
void GUI_BG_UserSet_SYSD_Display(uint8_t Mode);         /*省油设置*/
void GUI_BG_UserSet_SYSD_1_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_2_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_3_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_4_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_5_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_6_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_7_Display(uint8_t Mode);       /**/
void GUI_BG_TPMS_PictureSet_Display(uint8_t Mode);      /**/
void GUI_BG_UserSet_SYSD_GSL_Display(uint8_t Mode);     /**/
void GUI_BG_UserSet_SYSD_Ybl_Display(uint8_t Mode);     /**/
void GUI_BG_UserSet_SYSD_Speed_Display(uint8_t Mode);   /**/
void GUI_BG_UserSet_SYSD_JADD_Display(uint8_t Mode);    /**/
void GUI_BG_UserSet_SYSD_JSUB_Display(uint8_t Mode);    /**/
void GUI_BG_UserSet_SYSD_IDLING_Display(uint8_t Mode);  /**/
void GUI_BG_UserSet_SYSD_Parking_Display(uint8_t Mode); /**/
void GUI_BG_User_Light1_Display(uint8_t Mode);          /**/
void GUI_BG_User_Light2_Display(uint8_t Mode);          /**/
void GUI_FacMenu_Display(uint8_t Mode);                 /*工厂模式MENU*/
void GUI_BG_FacMenu_Display(uint8_t Mode);              /*工厂模式*/
void GUI_BG_FacMenu1_Display(uint8_t Mode);             /**/
void GUI_BG_FacMenu2_Display(uint8_t Mode);             /**/
void GUI_BG_FacMenu3_Display(uint8_t Mode);             /**/
void GUI_BG_FacMenu4_Display(uint8_t Mode);             /**/
void GUI_BG_FacMenu5_Display(uint8_t Mode);             /**/
void GUI_BG_FacMenu6_Display(uint8_t Mode);             /**/
void GUI_BG_FacDTCMenu_Display(uint8_t Mode);           /*工厂模式DTC显示*/
void GUI_BG_FacDTCMenu1_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCMenu2_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCMenu3_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCMenu4_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCMenu5_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCMenu6_Display(uint8_t Mode);          /**/
void GUI_BG_FacDTCClear_Display(uint8_t Mode);          /*工厂模式DTC清除*/
void GUI_BG_FacDTCClearA_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearB_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearC_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearD_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearE_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearF_Display(uint8_t Mode);         /**/
void GUI_BG_FacDTCClearEngine_Display(uint8_t Mode);    /**/
void GUI_BG_FacDTCClearBrake_Display(uint8_t Mode);     /**/
void GUI_BG_FacDTCClearAMT_Display(uint8_t Mode);       /**/
void GUI_BG_FacDTCClearRadar_Display(uint8_t Mode);     /**/
void GUI_BG_FacDTCClearCamer_Display(uint8_t Mode);     /**/
void GUI_BG_FacDTCClearRetarder_Display(uint8_t Mode);  /**/
void GUI_BG_FacDTCClearEngine1_Display(uint8_t Mode);   /**/
void GUI_BG_FacDTCClearBrake1_Display(uint8_t Mode);    /**/
void GUI_BG_FacDTCClearAMT1_Display(uint8_t Mode);      /**/
void GUI_BG_FacDTCClearRadar1_Display(uint8_t Mode);    /**/
void GUI_BG_FacDTCClearCamer1_Display(uint8_t Mode);    /**/
void GUI_BG_FacDTCClearRetarder1_Display(uint8_t Mode); /**/
void GUI_BG_FacDTCClear1_Display(uint8_t Mode);         /*工厂模式清除DTC1*/
void GUI_BG_FacDTCClear2_Display(uint8_t Mode);         /*工厂模式清除DTC2*/
void GUI_BG_FacDTCClear3_Display(uint8_t Mode);         /*工厂模式清除DTC2*/
void GUI_BG_FacDTCClear4_Display(uint8_t Mode);         /*工厂模式清除DTC2*/
void GUI_BG_FacMeter_Display(uint8_t Mode);             /*工厂模式仪表显示*/
void GUI_BG_FacHIDAutoInit1_Display(uint8_t Mode);      /**/
void GUI_BG_FacHIDAutoInit2_Display(uint8_t Mode);      /**/
void GUI_BG_FacMeterExit_Display(uint8_t Mode);         /*工厂模式是否结束工厂模式*/
void GUI_DeaMenu_Display(uint8_t Mode);                 /*经销商模式MENU*/
void GUI_BG_DeaMenu_Display(uint8_t Mode);              /*经销商模式*/
void GUI_BG_DeaMenu1_Display(uint8_t Mode);             /**/
void GUI_BG_DeaMenu2_Display(uint8_t Mode);             /**/
void GUI_BG_DeaMenu3_Display(uint8_t Mode);             /**/
void GUI_BG_DeaMenu4_Display(uint8_t Mode);             /**/
void GUI_BG_DeaMenu5_Display(uint8_t Mode);             /**/
void GUI_BG_DeaMenu6_Display(uint8_t Mode);             /**/
void GUI_BG_DeaDTCMenu_Display(uint8_t Mode);           /*经销商DTC显示*/
void GUI_BG_DeaDTCMenu1_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCMenu2_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCMenu3_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCMenu4_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCMenu5_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCMenu6_Display(uint8_t Mode);          /**/
void GUI_BG_DeaDTCClear_Display(uint8_t Mode);          /*经销商DTC清除*/
void GUI_BG_DeaDTCClearA_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearB_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearC_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearD_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearE_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearF_Display(uint8_t Mode);         /**/
void GUI_BG_DeaDTCClearEngine_Display(uint8_t Mode);    /**/
void GUI_BG_DeaDTCClearBrake_Display(uint8_t Mode);     /**/
void GUI_BG_DeaDTCClearAMT_Display(uint8_t Mode);       /**/
void GUI_BG_DeaDTCClearRadar_Display(uint8_t Mode);     /**/
void GUI_BG_DeaDTCClearCamer_Display(uint8_t Mode);     /**/
void GUI_BG_DeaDTCClearRetarder_Display(uint8_t Mode);  /**/
void GUI_BG_DeaDTCClearEngine1_Display(uint8_t Mode);   /**/
void GUI_BG_DeaDTCClearBrake1_Display(uint8_t Mode);    /**/
void GUI_BG_DeaDTCClearAMT1_Display(uint8_t Mode);      /**/
void GUI_BG_DeaDTCClearRadar1_Display(uint8_t Mode);    /**/
void GUI_BG_DeaDTCClearCamer1_Display(uint8_t Mode);    /**/
void GUI_BG_DeaDTCClearRetarder1_Display(uint8_t Mode); /**/
void GUI_BG_DeaDTCClear1_Display(uint8_t Mode);         /*经销商模式清除DTC1*/
void GUI_BG_DeaDTCClear2_Display(uint8_t Mode);         /*经销商模式清除DTC2*/
void GUI_BG_DeaDTCClear3_Display(uint8_t Mode);         /*经销商模式清除DTC3*/
void GUI_BG_DeaDTCClear4_Display(uint8_t Mode);         /*经销商模式清除DTC4*/
void GUI_BG_DeaMeter_Display(uint8_t Mode);             /*经销商模式仪表显示*/
void GUI_BG_DeaHIDAutoInit1_Display(uint8_t Mode);      /**/
void GUI_BG_DeaHIDAutoInit2_Display(uint8_t Mode);      /**/
void GUI_BG_DeaMeterExit_Display(uint8_t Mode);         /*经销商模式是否结束经销商模式*/
void GUI_BG_DTCClear_Display(uint8_t Mode);
void GUI_BG_DTCClear1_Display(uint8_t Mode);

void GUI_BG_MenuDTCEngine_Display(uint8_t Mode);        /*MENU发动机故障*/
void GUI_BG_MenuDTCBrake_Display(uint8_t Mode);         /*MENU刹车故障*/
void GUI_BG_MenuDTCAMT_Display(uint8_t Mode);           /*MENU变速箱故障*/
void GUI_BG_MenuDTCRadar_Display(uint8_t Mode);         /*MENU雷达故障码*/
void GUI_BG_MenuDTCCamera_Display(uint8_t Mode);        /*MENU摄像头故障码*/
void GUI_BG_MenuDTCIntarder_Display(uint8_t Mode);      /*MENU液力缓速器故障码*/
void GUI_BG_DTCEngine_Display(uint8_t Mode);            /*发动机故障*/
void GUI_BG_DTCBrake_Display(uint8_t Mode);             /*刹车故障*/
void GUI_BG_DTCAMT_Display(uint8_t Mode);               /*变速箱故障*/
void GUI_BG_DTCRadar_Display(uint8_t Mode);             /*雷达故障码*/
void GUI_BG_DTCCamera_Display(uint8_t Mode);            /*摄像头故障码*/
void GUI_BG_DTCRetarder_Display(uint8_t Mode);          /*液力缓速器故障码*/
void GUI_BG_DTCSCR_Display(uint8_t Mode);               /*SCR故障*/
void GUI_Display_Fault_Code_Menu_Display(uint8_t Mode); /**/
void GUI_Display_Fault_Code_DTC_Display(uint8_t Mode);  /*显示DTC字幕*/

void GUI_BG_DTCReading_Display(uint8_t Mode);           /*故障码读取中*/
void GUI_BG_Enter_Return_Display(uint8_t Mode);         /**/
void GUI_Test_Display(uint8_t Mode);                    /**/
void Common_EOL_User_Server(void);                      /**/
void K_LINE_EOL_Val_Server(void);                       /**/

void Common_Set_MenuDTCNumTime(uint32_t Vol);
void Common_Set_DTCNumTime(uint32_t Vol);

/*-----报警--------------------------------------------------------*/
void GUI_General_Popup(void);
void GUI_General_Popup_Display(uint16_t PopupMsg);

#endif
