/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Registerfile definition
 ****************************************************************************
 * Version Control Information :
 * DO NOT EDIT THIS FILE - This file will be automatically generated by
 * 'gen_register_headers_sw.py'
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_REGISTER_FILE_D1MX_H_INCLUDED
#define DAVEHD_REGISTER_FILE_D1MX_H_INCLUDED

#include "davehd_registermap.h"

/*----------------------------------------------------------------------------------------------------------*/
/* Registermap constants*/

#define DHD_REG_MAXINDEX 963    /* Maximum register index that is covered by name/description arrays*/
#define DHD_REGFILE_SIZE 120    /* Number of registers in register file (dhd_reg_registerfile_t)*/
#define DHD_REGMASK_SIZE 10    /* Number of dwords in register file mask (dhd_reg_registerfile_mask_t)*/

/*----------------------------------------------------------------------------------------------------------*/
/* DaveHD internal registerfile (inter-group gaps not included)*/

typedef union tagdhd_reg_registerfile_t {
  struct tagdhd_reg_registerfile_fields_t {
    /* Group 2 ------------------                                  */
    dhd_reg_psu_lim_bbox_min_t        m_psu_lim_bbox_min;          /* Bounding box upper left corner*/
    dhd_reg_psu_lim_bbox_max_t        m_psu_lim_bbox_max;          /* Bounding box lower right corner*/
    dhd_reg_psu_lim_start_t           m_psu_lim_start;             /* Start position for enumeration*/
    dhd_reg_psu_lim_ctrl_t            m_psu_lim_ctrl;              /* Pixel selection unit Limiter+Bezier control registers*/
    dhd_reg_psu_lim_stripe_t          m_psu_lim_stripe;            /* Enumeration stripes width and offset*/
    dhd_reg_psu_bez_ctrl_t            m_psu_bez_ctrl;              /* Bezier control*/
    dhd_reg_psu_bez_voff_0_t          m_psu_bez_voff_0;            /* Offset to Limiter #0 value for Bezier function (14.18 signed fixed point)*/
    dhd_reg_psu_bez_voff_1_t          m_psu_bez_voff_1;            /* Offset to Limiter #1 value for Bezier function (14.18 signed fixed point)*/
    dhd_reg_psu_bez_aa_ctrl_t         m_psu_bez_aa_ctrl;           /* Bezier anti-aliasing and width control*/
    dhd_reg_psu_lim_vstart_0_t        m_psu_lim_vstart_0;          /* Initial value of limiter #0 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_0_t            m_psu_lim_dx_0;              /* Fractional part of Limiter #0 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_0_t            m_psu_lim_dy_0;              /* Fractional part of Limiter y #0 step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_vstart_1_t        m_psu_lim_vstart_1;          /* Initial value of limiter #1 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_1_t            m_psu_lim_dx_1;              /* Fractional part of Limiter #1 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_1_t            m_psu_lim_dy_1;              /* Fractional part of Limiter y #1 step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_vstart_2_t        m_psu_lim_vstart_2;          /* Initial value of limiter #2 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_2_t            m_psu_lim_dx_2;              /* Fractional part of Limiter #2 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_2_t            m_psu_lim_dy_2;              /* Fractional part of Limiter y #2 step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_vstart_3_t        m_psu_lim_vstart_3;          /* Initial value of limiter #3 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_3_t            m_psu_lim_dx_3;              /* Fractional part of Limiter #3 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_3_t            m_psu_lim_dy_3;              /* Fractional part of Limiter y #3 step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_vstart_4_t        m_psu_lim_vstart_4;          /* Initial value of limiter #4 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_4_t            m_psu_lim_dx_4;              /* Fractional part of Limiter #4 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_4_t            m_psu_lim_dy_4;              /* Fractional part of Limiter y #4 step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_vstart_5_t        m_psu_lim_vstart_5;          /* Initial value of limiter #5 at enumeration start position (14.18 signed fixed point)*/
    dhd_reg_psu_lim_dx_5_t            m_psu_lim_dx_5;              /* Fractional part of Limiter #5 x step (2.18 signed fixed point)*/
    dhd_reg_psu_lim_dy_5_t            m_psu_lim_dy_5;              /* Fractional part of Limiter y #5 step (2.18 signed fixed point)*/
    dhd_reg_psu_debug_ctrl_t          m_psu_debug_ctrl;            /* Debug control*/
    dhd_reg_psu_lim_max_coord_t       m_psu_lim_max_coord;         /* Maximum coordinates generated by PSU, clipping limits for bounding box*/
    /* Group 3 ------------------                                  */
    dhd_reg_txa_u_offset_0_t          m_txa_u_offset_0;            /* Start value for texture U coordinate of texture unit #0.*/
    dhd_reg_txa_v_offset_0_t          m_txa_v_offset_0;            /* Start value for texture V coordinate of texture unit #0.*/
    dhd_reg_txa_dux_0_t               m_txa_dux_0;                 /* Increment of texture U coordinate for a pixel step in X direction of texture unit #0*/
    dhd_reg_txa_duy_0_t               m_txa_duy_0;                 /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #0*/
    dhd_reg_txa_dvx_0_t               m_txa_dvx_0;                 /* Increment of texture V coordinate for a pixel step in X direction of texture unit #0*/
    dhd_reg_txa_dvy_0_t               m_txa_dvy_0;                 /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #0*/
    dhd_reg_txa_u_offset_1_t          m_txa_u_offset_1;            /* Start value for texture U coordinate of texture unit #1.*/
    dhd_reg_txa_v_offset_1_t          m_txa_v_offset_1;            /* Start value for texture V coordinate of texture unit #1.*/
    dhd_reg_txa_dux_1_t               m_txa_dux_1;                 /* Increment of texture U coordinate for a pixel step in X direction of texture unit #1*/
    dhd_reg_txa_duy_1_t               m_txa_duy_1;                 /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #1*/
    dhd_reg_txa_dvx_1_t               m_txa_dvx_1;                 /* Increment of texture V coordinate for a pixel step in X direction of texture unit #1*/
    dhd_reg_txa_dvy_1_t               m_txa_dvy_1;                 /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #1*/
    /* Group 4 ------------------                                  */
    dhd_reg_zss_pitch_t               m_zss_pitch;                 /* ZSA cache scheduler pitch*/
    dhd_reg_zss_span_config_t         m_zss_span_config;           /* ZSA cache scheduler span config*/
    dhd_reg_txa_z_offset_t            m_txa_z_offset;              /* Start value for Z coordinate*/
    dhd_reg_txa_dzx_t                 m_txa_dzx;                   /* Increment of Z coordinate for a pixel step in X direction*/
    dhd_reg_txa_dzy_t                 m_txa_dzy;                   /* Increment of Z coordinate for a pixel step in Y direction*/
    dhd_reg_txa_z_rhw_offset_t        m_txa_z_rhw_offset;          /* Start value for RHW attribute (1/w) of Z*/
    dhd_reg_txa_z_drhwx_t             m_txa_z_drhwx;               /* Increment of RHW attribute of Z for a pixel step in X direction*/
    dhd_reg_txa_z_drhwy_t             m_txa_z_drhwy;               /* Increment of RHW attribute of Z for a pixel step in Y direction*/
    dhd_reg_txa_rhw_offset_0_t        m_txa_rhw_offset_0;          /* Start value for RHW attribute (1/w) of texture unit #0*/
    dhd_reg_txa_drhwx_0_t             m_txa_drhwx_0;               /* Increment of RHW attribute for a pixel step in X direction of texture unit #0*/
    dhd_reg_txa_drhwy_0_t             m_txa_drhwy_0;               /* Increment of RHW attribute for a pixel step in Y direction of texture unit #0*/
    dhd_reg_txa_rhw_offset_1_t        m_txa_rhw_offset_1;          /* Start value for RHW attribute (1/w) of texture unit #1*/
    dhd_reg_txa_drhwx_1_t             m_txa_drhwx_1;               /* Increment of RHW attribute for a pixel step in X direction of texture unit #1*/
    dhd_reg_txa_drhwy_1_t             m_txa_drhwy_1;               /* Increment of RHW attribute for a pixel step in Y direction of texture unit #1*/
    /* Group 6 ------------------                                  */
    dhd_reg_zsa_ctrl_t                m_zsa_ctrl;                  /* ZSA control registers*/
    dhd_reg_zsc_start_address_t       m_zsc_start_address;         /* ZSA buffer start address*/
    dhd_reg_zsu_ctrl1_t               m_zsu_ctrl1;                 /* ZSA Unit Control register 1*/
    dhd_reg_zsu_ctrl2_t               m_zsu_ctrl2;                 /* ZSA Unit Control register 2*/
    dhd_reg_txa_size_0_t              m_txa_size_0;                /* Texture size of texture unit #0*/
    dhd_reg_txa_access_0_t            m_txa_access_0;              /* Filter shape, size and texture pitch of texture unit #0*/
    dhd_reg_txa_size_1_t              m_txa_size_1;                /* Texture size of texture unit #1*/
    dhd_reg_txa_access_1_t            m_txa_access_1;              /* Filter shape, size and texture pitch of texture unit #1*/
    /* Group 8 ------------------                                  */
    dhd_reg_tex_global_t              m_tex_global;                /* Global texture unit register*/
    dhd_reg_col_global_t              m_col_global;                /* Global color unit registers*/
    dhd_reg_fbd_config_t              m_fbd_config;                /* Framebuffer read decision registers*/
    dhd_reg_fbs_pitch_t               m_fbs_pitch;                 /* Framebuffer cache scheduler pitch and debug control*/
    dhd_reg_fbs_span_config_t         m_fbs_span_config;           /* Framebuffer cache scheduler span config*/
    dhd_reg_rld_start_address_t       m_rld_start_address;         /* Start address of RLE code of the texture in memory*/
    dhd_reg_col_const_color_0_t       m_col_const_color_0;         /* Constant color register #0*/
    dhd_reg_col_const_color_1_t       m_col_const_color_1;         /* Constant color register #1*/
    dhd_reg_col_const_color_2_t       m_col_const_color_2;         /* Constant color register #2*/
    dhd_reg_col_const_color_3_t       m_col_const_color_3;         /* Constant color register #3*/
    /* Group 10 ------------------                                 */
    dhd_reg_tex_mode_0_t              m_tex_mode_0;                /* Texture mode of texture unit #0*/
    dhd_reg_txc_start_address_0_t     m_txc_start_address_0;       /* Start address of top-left texel of the texture in memory of texture unit #0*/
    dhd_reg_txp_ctrl_0_t              m_txp_ctrl_0;                /* TXP control of texture unit #0*/
    dhd_reg_txp_clut_offset_0_t       m_txp_clut_offset_0;         /* Offset for CLUT lookups of texture unit #0*/
    dhd_reg_txp_color_key_0_t         m_txp_color_key_0;           /* Color key comparison value of texture unit #0*/
    dhd_reg_txp_fill_color_0_t        m_txp_fill_color_0;          /* Texel fill color for wrap mode FILL of texture unit #0*/
    dhd_reg_txp_filter_scale_bias_0_t m_txp_filter_scale_bias_0;   /* Scale and bias for filter in TXP of texture unit #0*/
    dhd_reg_tex_mode_1_t              m_tex_mode_1;                /* Texture mode of texture unit #1*/
    dhd_reg_txc_start_address_1_t     m_txc_start_address_1;       /* Start address of top-left texel of the texture in memory of texture unit #1*/
    dhd_reg_txp_ctrl_1_t              m_txp_ctrl_1;                /* TXP control of texture unit #1*/
    dhd_reg_txp_clut_offset_1_t       m_txp_clut_offset_1;         /* Offset for CLUT lookups of texture unit #1*/
    dhd_reg_txp_color_key_1_t         m_txp_color_key_1;           /* Color key comparison value of texture unit #1*/
    dhd_reg_txp_fill_color_1_t        m_txp_fill_color_1;          /* Texel fill color for wrap mode FILL of texture unit #1*/
    dhd_reg_txp_filter_scale_bias_1_t m_txp_filter_scale_bias_1;   /* Scale and bias for filter in TXP of texture unit #1*/
    /* Group 11 ------------------                                 */
    dhd_reg_col_argb_op1a_0_t         m_col_argb_op1a_0;           /* Control structure for Op1a of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_op1b_0_t         m_col_argb_op1b_0;           /* Control structure for Op1b of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2a_0_t         m_col_argb_op2a_0;           /* Control structure for Op2a of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2b_0_t         m_col_argb_op2b_0;           /* Control structure for Op2b of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_op3_0_t          m_col_argb_op3_0;            /* Control structure for Op3 of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_out_0_t          m_col_argb_out_0;            /* Control structure for core output of color pass 0 (Alpha and RGB path)*/
    dhd_reg_col_argb_op1a_1_t         m_col_argb_op1a_1;           /* Control structure for Op1a of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_op1b_1_t         m_col_argb_op1b_1;           /* Control structure for Op1b of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2a_1_t         m_col_argb_op2a_1;           /* Control structure for Op2a of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2b_1_t         m_col_argb_op2b_1;           /* Control structure for Op2b of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_op3_1_t          m_col_argb_op3_1;            /* Control structure for Op3 of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_out_1_t          m_col_argb_out_1;            /* Control structure for core output of color pass 1 (Alpha and RGB path)*/
    dhd_reg_col_argb_op1a_2_t         m_col_argb_op1a_2;           /* Control structure for Op1a of color pass 2 (Alpha and RGB path)*/
    dhd_reg_col_argb_op1b_2_t         m_col_argb_op1b_2;           /* Control structure for Op1b of color pass 2 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2a_2_t         m_col_argb_op2a_2;           /* Control structure for Op2a of color pass 2 (Alpha and RGB path)*/
    dhd_reg_col_argb_op2b_2_t         m_col_argb_op2b_2;           /* Control structure for Op2b of color pass 2 (Alpha and RGB path)*/
    dhd_reg_col_argb_op3_2_t          m_col_argb_op3_2;            /* Control structure for Op3 of color pass 2 (Alpha and RGB path)*/
    dhd_reg_col_argb_out_2_t          m_col_argb_out_2;            /* Control structure for core output of color pass 2 (Alpha and RGB path)*/
    /* Group 12 ------------------                                 */
    dhd_reg_fb_pixel_org_t            m_fb_pixel_org;              /* Framebuffer pixel organization/format*/
    dhd_reg_fbc_start_address_t       m_fbc_start_address;         /* Framebuffer start address*/
    dhd_reg_blu_blend_t               m_blu_blend;                 /* Blend unit factor and mode*/
    dhd_reg_blu_dither_t              m_blu_dither;                /* Blend unit dither control*/
    dhd_reg_blu_write_t               m_blu_write;                 /* Blend unit write control*/
    /* Group 14 ------------------                                 */
    dhd_reg_pfc_enable_t              m_pfc_enable;                /* Performance counter enable*/
    dhd_reg_pfc_clear_t               m_pfc_clear;                 /* Performance counter clear*/
    dhd_reg_pfc_event_select_0_t      m_pfc_event_select_0;        /* Performance counter #0 event selection*/
    dhd_reg_pfc_event_select_1_t      m_pfc_event_select_1;        /* Performance counter #1 event selection*/
    dhd_reg_pfc_event_select_2_t      m_pfc_event_select_2;        /* Performance counter #2 event selection*/
    dhd_reg_pfc_event_select_3_t      m_pfc_event_select_3;        /* Performance counter #3 event selection*/
    /* Group 15 ------------------                                 */
    dhd_reg_clr_value_t               m_clr_value;                 /* Clear unit color value*/
    dhd_reg_clr_line_config_t         m_clr_line_config;           /* Clear unit line config*/
    dhd_reg_clr_ctrl_t                m_clr_ctrl;                  /* Clear unit number of lines*/
    dhd_reg_clr_start_address_t       m_clr_start_address;         /* Start address for clear unit*/
  } m_named;
  struct tagdhd_reg_registerfile_groups_t {
    dhd_uint32_t m_group2[29];    
    dhd_uint32_t m_group3[12];    
    dhd_uint32_t m_group4[14];    
    dhd_uint32_t m_group6[8];     
    dhd_uint32_t m_group8[10];    
    dhd_uint32_t m_group10[14];   
    dhd_uint32_t m_group11[18];   
    dhd_uint32_t m_group12[5];    
    dhd_uint32_t m_group14[6];    
    dhd_uint32_t m_group15[4];    
  } m_groups;
  dhd_uint32_t m_all[DHD_REGFILE_SIZE];
} dhd_reg_registerfile_t;

typedef union tagdhd_reg_registerfile_mask_t {
  struct tagdhd_reg_registerfile_fields_mask_t {
    /* Group 2 ---                                           */
    dhd_uint32_t    m_psu_lim_bbox_min:1;                    /* Bounding box upper left corner*/
    dhd_uint32_t    m_psu_lim_bbox_max:1;                    /* Bounding box lower right corner*/
    dhd_uint32_t    m_psu_lim_start:1;                       /* Start position for enumeration*/
    dhd_uint32_t    m_psu_lim_ctrl:1;                        /* Pixel selection unit Limiter+Bezier control registers*/
    dhd_uint32_t    m_psu_lim_stripe:1;                      /* Enumeration stripes width and offset*/
    dhd_uint32_t    m_psu_bez_ctrl:1;                        /* Bezier control*/
    dhd_uint32_t    m_psu_bez_voff_0:1;                      /* Offset to Limiter #0 value for Bezier function (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_bez_voff_1:1;                      /* Offset to Limiter #1 value for Bezier function (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_bez_aa_ctrl:1;                     /* Bezier anti-aliasing and width control*/
    dhd_uint32_t    m_psu_lim_vstart_0:1;                    /* Initial value of limiter #0 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_0:1;                        /* Fractional part of Limiter #0 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_0:1;                        /* Fractional part of Limiter y #0 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_vstart_1:1;                    /* Initial value of limiter #1 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_1:1;                        /* Fractional part of Limiter #1 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_1:1;                        /* Fractional part of Limiter y #1 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_vstart_2:1;                    /* Initial value of limiter #2 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_2:1;                        /* Fractional part of Limiter #2 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_2:1;                        /* Fractional part of Limiter y #2 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_vstart_3:1;                    /* Initial value of limiter #3 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_3:1;                        /* Fractional part of Limiter #3 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_3:1;                        /* Fractional part of Limiter y #3 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_vstart_4:1;                    /* Initial value of limiter #4 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_4:1;                        /* Fractional part of Limiter #4 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_4:1;                        /* Fractional part of Limiter y #4 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_vstart_5:1;                    /* Initial value of limiter #5 at enumeration start position (14.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dx_5:1;                        /* Fractional part of Limiter #5 x step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_lim_dy_5:1;                        /* Fractional part of Limiter y #5 step (2.18 signed fixed point)*/
    dhd_uint32_t    m_psu_debug_ctrl:1;                      /* Debug control*/
    dhd_uint32_t    m_psu_lim_max_coord:1;                   /* Maximum coordinates generated by PSU, clipping limits for bounding box*/
    dhd_uint32_t    m_reserved1:3;                           /* make sure group uses a multiple of 32 bits*/
    /* Group 3 ---                                           */
    dhd_uint32_t    m_txa_u_offset_0:1;                      /* Start value for texture U coordinate of texture unit #0.*/
    dhd_uint32_t    m_txa_v_offset_0:1;                      /* Start value for texture V coordinate of texture unit #0.*/
    dhd_uint32_t    m_txa_dux_0:1;                           /* Increment of texture U coordinate for a pixel step in X direction of texture unit #0*/
    dhd_uint32_t    m_txa_duy_0:1;                           /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #0*/
    dhd_uint32_t    m_txa_dvx_0:1;                           /* Increment of texture V coordinate for a pixel step in X direction of texture unit #0*/
    dhd_uint32_t    m_txa_dvy_0:1;                           /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #0*/
    dhd_uint32_t    m_txa_u_offset_1:1;                      /* Start value for texture U coordinate of texture unit #1.*/
    dhd_uint32_t    m_txa_v_offset_1:1;                      /* Start value for texture V coordinate of texture unit #1.*/
    dhd_uint32_t    m_txa_dux_1:1;                           /* Increment of texture U coordinate for a pixel step in X direction of texture unit #1*/
    dhd_uint32_t    m_txa_duy_1:1;                           /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #1*/
    dhd_uint32_t    m_txa_dvx_1:1;                           /* Increment of texture V coordinate for a pixel step in X direction of texture unit #1*/
    dhd_uint32_t    m_txa_dvy_1:1;                           /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #1*/
    dhd_uint32_t    m_reserved2:20;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 4 ---                                           */
    dhd_uint32_t    m_zss_pitch:1;                           /* ZSA cache scheduler pitch*/
    dhd_uint32_t    m_zss_span_config:1;                     /* ZSA cache scheduler span config*/
    dhd_uint32_t    m_txa_z_offset:1;                        /* Start value for Z coordinate*/
    dhd_uint32_t    m_txa_dzx:1;                             /* Increment of Z coordinate for a pixel step in X direction*/
    dhd_uint32_t    m_txa_dzy:1;                             /* Increment of Z coordinate for a pixel step in Y direction*/
    dhd_uint32_t    m_txa_z_rhw_offset:1;                    /* Start value for RHW attribute (1/w) of Z*/
    dhd_uint32_t    m_txa_z_drhwx:1;                         /* Increment of RHW attribute of Z for a pixel step in X direction*/
    dhd_uint32_t    m_txa_z_drhwy:1;                         /* Increment of RHW attribute of Z for a pixel step in Y direction*/
    dhd_uint32_t    m_txa_rhw_offset_0:1;                    /* Start value for RHW attribute (1/w) of texture unit #0*/
    dhd_uint32_t    m_txa_drhwx_0:1;                         /* Increment of RHW attribute for a pixel step in X direction of texture unit #0*/
    dhd_uint32_t    m_txa_drhwy_0:1;                         /* Increment of RHW attribute for a pixel step in Y direction of texture unit #0*/
    dhd_uint32_t    m_txa_rhw_offset_1:1;                    /* Start value for RHW attribute (1/w) of texture unit #1*/
    dhd_uint32_t    m_txa_drhwx_1:1;                         /* Increment of RHW attribute for a pixel step in X direction of texture unit #1*/
    dhd_uint32_t    m_txa_drhwy_1:1;                         /* Increment of RHW attribute for a pixel step in Y direction of texture unit #1*/
    dhd_uint32_t    m_reserved3:18;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 6 ---                                           */
    dhd_uint32_t    m_zsa_ctrl:1;                            /* ZSA control registers*/
    dhd_uint32_t    m_zsc_start_address:1;                   /* ZSA buffer start address*/
    dhd_uint32_t    m_zsu_ctrl1:1;                           /* ZSA Unit Control register 1*/
    dhd_uint32_t    m_zsu_ctrl2:1;                           /* ZSA Unit Control register 2*/
    dhd_uint32_t    m_txa_size_0:1;                          /* Texture size of texture unit #0*/
    dhd_uint32_t    m_txa_access_0:1;                        /* Filter shape, size and texture pitch of texture unit #0*/
    dhd_uint32_t    m_txa_size_1:1;                          /* Texture size of texture unit #1*/
    dhd_uint32_t    m_txa_access_1:1;                        /* Filter shape, size and texture pitch of texture unit #1*/
    dhd_uint32_t    m_reserved4:24;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 8 ---                                           */
    dhd_uint32_t    m_tex_global:1;                          /* Global texture unit register*/
    dhd_uint32_t    m_col_global:1;                          /* Global color unit registers*/
    dhd_uint32_t    m_fbd_config:1;                          /* Framebuffer read decision registers*/
    dhd_uint32_t    m_fbs_pitch:1;                           /* Framebuffer cache scheduler pitch and debug control*/
    dhd_uint32_t    m_fbs_span_config:1;                     /* Framebuffer cache scheduler span config*/
    dhd_uint32_t    m_rld_start_address:1;                   /* Start address of RLE code of the texture in memory*/
    dhd_uint32_t    m_col_const_color_0:1;                   /* Constant color register #0*/
    dhd_uint32_t    m_col_const_color_1:1;                   /* Constant color register #1*/
    dhd_uint32_t    m_col_const_color_2:1;                   /* Constant color register #2*/
    dhd_uint32_t    m_col_const_color_3:1;                   /* Constant color register #3*/
    dhd_uint32_t    m_reserved5:22;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 10 ---                                          */
    dhd_uint32_t    m_tex_mode_0:1;                          /* Texture mode of texture unit #0*/
    dhd_uint32_t    m_txc_start_address_0:1;                 /* Start address of top-left texel of the texture in memory of texture unit #0*/
    dhd_uint32_t    m_txp_ctrl_0:1;                          /* TXP control of texture unit #0*/
    dhd_uint32_t    m_txp_clut_offset_0:1;                   /* Offset for CLUT lookups of texture unit #0*/
    dhd_uint32_t    m_txp_color_key_0:1;                     /* Color key comparison value of texture unit #0*/
    dhd_uint32_t    m_txp_fill_color_0:1;                    /* Texel fill color for wrap mode FILL of texture unit #0*/
    dhd_uint32_t    m_txp_filter_scale_bias_0:1;             /* Scale and bias for filter in TXP of texture unit #0*/
    dhd_uint32_t    m_tex_mode_1:1;                          /* Texture mode of texture unit #1*/
    dhd_uint32_t    m_txc_start_address_1:1;                 /* Start address of top-left texel of the texture in memory of texture unit #1*/
    dhd_uint32_t    m_txp_ctrl_1:1;                          /* TXP control of texture unit #1*/
    dhd_uint32_t    m_txp_clut_offset_1:1;                   /* Offset for CLUT lookups of texture unit #1*/
    dhd_uint32_t    m_txp_color_key_1:1;                     /* Color key comparison value of texture unit #1*/
    dhd_uint32_t    m_txp_fill_color_1:1;                    /* Texel fill color for wrap mode FILL of texture unit #1*/
    dhd_uint32_t    m_txp_filter_scale_bias_1:1;             /* Scale and bias for filter in TXP of texture unit #1*/
    dhd_uint32_t    m_reserved6:18;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 11 ---                                          */
    dhd_uint32_t    m_col_argb_op1a_0:1;                     /* Control structure for Op1a of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op1b_0:1;                     /* Control structure for Op1b of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2a_0:1;                     /* Control structure for Op2a of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2b_0:1;                     /* Control structure for Op2b of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op3_0:1;                      /* Control structure for Op3 of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_out_0:1;                      /* Control structure for core output of color pass 0 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op1a_1:1;                     /* Control structure for Op1a of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op1b_1:1;                     /* Control structure for Op1b of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2a_1:1;                     /* Control structure for Op2a of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2b_1:1;                     /* Control structure for Op2b of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op3_1:1;                      /* Control structure for Op3 of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_out_1:1;                      /* Control structure for core output of color pass 1 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op1a_2:1;                     /* Control structure for Op1a of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op1b_2:1;                     /* Control structure for Op1b of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2a_2:1;                     /* Control structure for Op2a of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op2b_2:1;                     /* Control structure for Op2b of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_op3_2:1;                      /* Control structure for Op3 of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_col_argb_out_2:1;                      /* Control structure for core output of color pass 2 (Alpha and RGB path)*/
    dhd_uint32_t    m_reserved7:14;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 12 ---                                          */
    dhd_uint32_t    m_fb_pixel_org:1;                        /* Framebuffer pixel organization/format*/
    dhd_uint32_t    m_fbc_start_address:1;                   /* Framebuffer start address*/
    dhd_uint32_t    m_blu_blend:1;                           /* Blend unit factor and mode*/
    dhd_uint32_t    m_blu_dither:1;                          /* Blend unit dither control*/
    dhd_uint32_t    m_blu_write:1;                           /* Blend unit write control*/
    dhd_uint32_t    m_reserved8:27;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 14 ---                                          */
    dhd_uint32_t    m_pfc_enable:1;                          /* Performance counter enable*/
    dhd_uint32_t    m_pfc_clear:1;                           /* Performance counter clear*/
    dhd_uint32_t    m_pfc_event_select_0:1;                  /* Performance counter #0 event selection*/
    dhd_uint32_t    m_pfc_event_select_1:1;                  /* Performance counter #1 event selection*/
    dhd_uint32_t    m_pfc_event_select_2:1;                  /* Performance counter #2 event selection*/
    dhd_uint32_t    m_pfc_event_select_3:1;                  /* Performance counter #3 event selection*/
    dhd_uint32_t    m_reserved9:26;                          /* make sure group uses a multiple of 32 bits*/
    /* Group 15 ---                                          */
    dhd_uint32_t    m_clr_value:1;                           /* Clear unit color value*/
    dhd_uint32_t    m_clr_line_config:1;                     /* Clear unit line config*/
    dhd_uint32_t    m_clr_ctrl:1;                            /* Clear unit number of lines*/
    dhd_uint32_t    m_clr_start_address:1;                   /* Start address for clear unit*/
  } m_named;
  struct tagdhd_reg_registerfile_maskgroups_t {
    dhd_uint32_t    m_group2[1];    
    dhd_uint32_t    m_group3[1];    
    dhd_uint32_t    m_group4[1];    
    dhd_uint32_t    m_group6[1];    
    dhd_uint32_t    m_group8[1];    
    dhd_uint32_t    m_group10[1];   
    dhd_uint32_t    m_group11[1];   
    dhd_uint32_t    m_group12[1];   
    dhd_uint32_t    m_group14[1];   
    dhd_uint32_t    m_group15[1];   
  } m_groups;
  dhd_uint32_t m_all[DHD_REGMASK_SIZE];
} dhd_reg_registerfile_mask_t;

#define DHD_REGFILE_GROUP_SIZE(g) (\
      ((g ==  0) ?  0 : \
      ((g ==  1) ?  0 : \
      ((g ==  2) ? 29 : \
      ((g ==  3) ? 12 : \
      ((g ==  4) ? 14 : \
      ((g ==  5) ?  0 : \
      ((g ==  6) ?  8 : \
      ((g ==  7) ?  0 : \
      ((g ==  8) ? 10 : \
      ((g ==  9) ?  0 : \
      ((g == 10) ? 14 : \
      ((g == 11) ? 18 : \
      ((g == 12) ?  5 : \
      ((g == 13) ?  0 : \
      ((g == 14) ?  6 : \
      ((g == 15) ?  4 : \
        0 )))))))))))))))) )

#endif /*DAVEHD_REGISTER_FILE_D1MX_H_INCLUDED*/

