#include "UDS_DTC.h"
//#include "Services_ODO.h"

uint8_t isNeedSaveDTC = 0u;
uint8_t HVoltageStatus = 0u;
uint8_t LVoltageStatus = 0u;

/**
  *DTC列表
  */
const uint32_t DTCList[18u][2u] = 
{
    {U100700, 1u},
    {U100701, 1u},
    {U100702, 1u},
    {U100703, 1u},
    {U100706, 1u},
    {U10070F, 1u},
    {U100710, 1u},
    {B110000, 1u},
    {B110001, 1u},
    {B110002, 1u},
    {B110005, 1u},
    {B110006, 1u},
    {B110007, 1u},
    {B110008, 1u},
    {B110009, 1u},
    {B11000A, 1u},
    {B11000B, 1u},
    {B11000C, 1u},
};

/**
  *DTC发生时间
  */
uint32_t DTCTimerList[18u] = {0u};

/**
  *msg列表
  */
uint32_t msgList[6][4] = 
{
    {0x18FFC325ul, 8u,  200u ,0u},
    {0x18FFDA21ul, 8u,  200u ,0u},
    {0x18FE4EECul, 8u,  100u ,0u},
    {0x18FF14E8ul, 8u,  100u ,0u},//周期不知道
    {0x18F0010Bul, 8u,  100u ,0u},
    {0x0CF00400ul, 8u,  10u ,0u},
};

/**
  *测试DTC
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC(uint16_t timer)
{
    if(getKL15Status())
    {
        if(!getEngStatus())
        {
            TestDTC_B110001(timer);                                         /*检测控制模块输入电压低*/
            TestDTC_B110000(timer);                                         /*检测控制模块输入电压高*/
            if(!getPowerStatus())
            {
                TestDTC_U100700();                                          /*检测can总线关闭*/
                TestDTC_B110002();                                          /*EEPROM 故障*/
                TestDTC_B110005();                                          /*气压传感器1开路/对地短路故障*/
                TestDTC_B110006();                                          /* 气压传感器1对电源短路故障*/
                TestDTC_B110007();                                          /*气压传感器2开路/对地短路故障*/   
                TestDTC_B110008();                                          /*气压传感器2开路对电源短路故障*/
                TestDTC_B110009();                                          /*驱动桥1机油温度传感器对地短路故障*/
                TestDTC_B11000A();                                          /* 驱动桥2机油温度传感器对地短路故障*/
                TestDTC_B11000B();                                          /* 转向机油温度传感器对地短路故障*/ 
                TestDTC_B11000C();                                          /*IC 功能limphome故障*/
                if(!getBusoffStatus())
                {
                    if(isDTCEnable())
                    {
                        TestDTC_U100701();                                  /*Switch2通讯丢失*/
                        TestDTC_U100702();                                  /*BCM1通讯丢失*/
                        TestDTC_U100703();                                  /*DCM1通讯丢失*/
                        TestDTC_U100706();                                  /*与车道偏离系统通讯丢失*/
                        TestDTC_U10070F();                                  /*EBC1_ABS通讯丢失*/
                        TestDTC_U100710();                                  /*EEC1通讯丢失*/
                    }
                }
            }
            if(isNeedSaveDTC)
            {
                SaveDTCData();
                isNeedSaveDTC = 0u;
            }
        }
    }
}

/**
  *检测can总线关闭
  */
void TestDTC_U100700(void)
{
    if(DTCList[U100700][1u])
    {
        if(getBUS_OFF_FLAG())
        {
            ChangeDTCData(cnU100700, DTCError);
        }
        else
        {
            ChangeDTCData(cnU100700, DTCNoError);
        }
    }
}

/**
  *检测控制模块输入电压低
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC_B110001(uint16_t timer)
{
    uint32_t KL30Voltage = 0u;
    if(DTCList[cnB110001][1u])
    {
        KL30Voltage = getKL30Voltage();
        if(KL30Voltage <= MinimumVoltage)
        {
            if(DTCTimerList[cnB110001] == LowVoltageTimer)
            {
                ChangeDTCData(cnB110001, DTCError);
            }
            else
            {
                DTCTimerList[cnB110001] += timer;
            }
        }
        if(KL30Voltage >= RestoreMinimumVoltage)
        {
            if(DTCTimerList[cnB110001] == 0u)
            {
                ChangeDTCData(cnB110001, DTCNoError);
            }
            else
            {
                if(DTCTimerList[cnB110001] > timer)
                {
                    DTCTimerList[cnB110001] -= timer;
                }
                else
                {
                    DTCTimerList[cnB110001] = 0u;
                }
            }
        }
    }
}

/**
  *检测控制模块输入电压高
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC_B110000(uint16_t timer)
{
    uint16_t KL30Voltage = 0u;
    if(DTCList[cnB110000][1u])
    {
        KL30Voltage = getKL30Voltage();
        if(KL30Voltage >= MaximumVoltage)
        {
            if(DTCTimerList[cnB110000] == HightVoltageTimer)
            {
                ChangeDTCData(cnB110000, DTCError);
            }
            else
            {
                DTCTimerList[cnB110000] += timer;
            }
        }
        if(KL30Voltage <= RestoreMaximumVoltage)
        {
            if(DTCTimerList[cnB110000] == 0u)
            {
                ChangeDTCData(cnB110000, DTCNoError);
            }
            else
            {
                if(DTCTimerList[cnB110000] > timer)
                {
                    DTCTimerList[cnB110000] -= timer;
                }
                else
                {
                    DTCTimerList[cnB110000] = 0u;
                }
            }
        }
    }
}

/**
  *Switch2通讯丢失
  */
void TestDTC_U100701(void)
{
    if(DTCList[cnU100701][1u])
    {
        //if(Val_EOL_F110_EMS())
        {
            if(getMSGStatus(cnMSG325))
            {
                ChangeDTCData(cnU100701, DTCError);
            }
            else
            {
                ChangeDTCData(cnU100701, DTCNoError);
            }
        }
    }
}

/**
  *BCM1通讯丢失
  */
void TestDTC_U100702(void)
{
    if(DTCList[cnU100702][1u])
    {
        //if(Val_EOL_F110_TCU())
        {
            if(getMSGStatus(cnMSGA21))
            {
                ChangeDTCData(cnU100702, DTCError);
            }
            else
            {
                ChangeDTCData(cnU100702, DTCNoError);
            }
        }
    }
}

/**
  *DCM1通讯丢失
  */
void TestDTC_U100703(void)
{
    if(DTCList[cnU100703][1u])
    {
        //if(Val_EOL_F110_ESC())
        {
            if(getMSGStatus(cnMSGEEC))
            {
                ChangeDTCData(cnU100703, DTCError);
            }
            else
            {
                ChangeDTCData(cnU100703, DTCNoError);
            }
        }
    }
}

/**
  *与车道偏离系统通讯丢失
  */
void TestDTC_U100706(void)
{
    if(DTCList[cnU100706][1u])
    {
        if(Val_EOL_605C_LDWS())
        {
            if(getMSGStatus(cnMSG4E8))
            {
                ChangeDTCData(cnU100706, DTCError);
            }
            else
            {
                ChangeDTCData(cnU100706, DTCNoError);
            }
        }
        
    }
}

/**
  *EBC1_ABS通讯丢失
  */
void TestDTC_U10070F(void)
{
    if(DTCList[cnU10070F][1u])
    {
        //if(Val_EOL_F110_BCM())
        {
            if(getMSGStatus(cnMSG10B))
            {
                ChangeDTCData(cnU10070F, DTCError);
            }
            else
            {
                ChangeDTCData(cnU10070F, DTCNoError);
            }
        }
    }
}

/**
  *EEC1通讯丢失
  */
void TestDTC_U100710(void)
{
    if(DTCList[cnU100710][1u])
    {
        //if(Val_EOL_F110_GW())
        {
            if(getMSGStatus(cnMSG400))
            {
                ChangeDTCData(cnU100710, DTCError);
            }
            else
            {
                ChangeDTCData(cnU100710, DTCNoError);
            }
        }
    }
}

/**
  *EEPROM 故障
  */
void TestDTC_B110002(void)
{

}

/**
  *气压传感器1开路/对地短路故障
  */
void TestDTC_B110005(void)
{
    if(DTCList[cnB110005][1u])
    {
        if(0u)
        {
            ChangeDTCData(cnB110005, DTCError);
        }
        else
        {
            ChangeDTCData(cnB110005, DTCNoError);
        }
    }
}

/**
  *气压传感器1对电源短路故障
  */
void TestDTC_B110006(void)
{
    if(DTCList[cnB110006][1u])
    {
        if(0u)
        {
            ChangeDTCData(cnB110006, DTCError);
        }
        else
        {
            ChangeDTCData(cnB110006, DTCNoError);
        }
    }
}

/**
  *气压传感器2开路/对地短路故障
  */
void TestDTC_B110007(void)      
{

}    

/**
  *气压传感器2开路对电源短路故障
  */                                   
void TestDTC_B110008(void)
{

}                                          

/**
  *驱动桥1机油温度传感器对地短路故障
  */ 
void TestDTC_B110009(void)
{

}                                          

/**
  *驱动桥2机油温度传感器对地短路故障
  */
void TestDTC_B11000A(void)
{

}                                          

/**
  *转向机油温度传感器对地短路故障
  */
void TestDTC_B11000B(void)
{

}                                         

/**
  *IC 功能limphome故障
  */
void TestDTC_B11000C(void)
{

}                                          

/**
  *获取30电电压状态
  *@return 30电电压状态 0为电压正常,1为低压,2为高压
  */
uint8_t getPowerStatus(void)
{
    uint8_t  enResult = NormalVottage;
    uint32_t KL30Voltage = getKL30Voltage();
    
    if((KL30Voltage >= 16000u) && (KL30Voltage <= 32000u))
    {
        //if(LVoltageStatus == 1u)
        {
            if(KL30Voltage < 17000u)
            {
                enResult = LowVottage;
                setDTCEnableTimer(H_LVoltageDTCEnableTimer);
            }
            else
            {
                LVoltageStatus = 0u;
                enResult = NormalVottage;
            }
        }
        //else if(HVoltageStatus == 1u)
        {
            if(KL30Voltage > 31000u)
            {
                enResult = HightVottage;
                setDTCEnableTimer(H_LVoltageDTCEnableTimer);
            }
            else
            {
                HVoltageStatus = 0u;
                enResult = NormalVottage;
            }
        }
        //else
        {
            enResult = NormalVottage;
        }
    }
    else if(KL30Voltage > 16000u)
    {
        HVoltageStatus = 1u;
        enResult = HightVottage;
        setDTCEnableTimer(H_LVoltageDTCEnableTimer);
    }
    else
    {
        LVoltageStatus = 1u;
        enResult = LowVottage;
        setDTCEnableTimer(H_LVoltageDTCEnableTimer);
    }
    return enResult;
}

/**
  *获取busoff状态
  *@return busoff状态 0为正常,1为异常
  */
uint8_t getBusoffStatus(void)
{
    if(getBUS_OFF_Status())
    {
        setDTCEnableTimer(BusOffDTCEnableTimer);
    }
    return getBUS_OFF_Status();
    return 0;
}

/**
  *获取发动机启动状态
  *@return EngStatus 0为未启动,1为启动
  */
uint8_t getEngStatus(void)
{
    return 0u;
}

/**
  *获取报文状态
  *@param cnMsgID 报文数组下标
  *@return 报文状态 0为在线,1为掉线
  */
uint8_t getMSGStatus(uint8_t cnMsgID)
{
    uint8_t enResult;
    if(msgList[cnMsgID][3u] < msgList[cnMsgID][2u] * OfflineLoopMultiple)
    {
        enResult = 0u;
    }
    else
    {
        enResult = 1u;
    }
    return enResult;
}

/**
  *更改DTC状态
  *@param DTCNum DTC编号
  *@param DTCStatus DTC状态
  */
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus)
{
    if(DTCTestIsOpen())
    {
        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCNoTestLastClear) == DTCNoTestLastClear)
        {
            DTCToDFlashInfo.DTC[DTCNum].DTCStatus &= (uint8_t)(~DTCNoTestLastClear);
        }
        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCNoTestThisCycle) == DTCNoTestThisCycle)
        {
            DTCToDFlashInfo.DTC[DTCNum].DTCStatus &= (uint8_t)(~DTCNoTestThisCycle);
        }
        if(DTCStatus == DTCError)
        {
            if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCError) != DTCError)
            {
                DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCError;
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCErrorThisCycle;
                    DTCToDFlashInfo.DTC[DTCNum].DTCAgeing = 0u;
                    DTCToDFlashInfo.DTC[DTCNum].DTCPendingCount++;
                    if(DTCToDFlashInfo.DTC[DTCNum].DTCPendingCount >= MaxDTCPendingCount)
                    {
                        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCConfirmed) != DTCConfirmed)
                        {
                            DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCConfirmed;
                        }
                    }
                }
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCPending) != DTCPending)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCPending;
                }
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCErrorLastClear) != DTCErrorLastClear)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCErrorLastClear;
                }
                /*DTCToDFlashInfo.DTC[DTCNum].Snapshot.ECUPowerVoltage = (uint8_t)(getKL30Voltage() / 100u);
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.VehicleSpeed = 0u;
                if(DTCToDFlashInfo.DTC[DTCNum].Snapshot.OccurrenceCounter == 0u)
                {
                    DTCToDFlashInfo.DTC[DTCNum].Snapshot.FirstMalfunction = (Data_ODO_Read() / 10u);
                }
                if(DTCToDFlashInfo.DTC[DTCNum].Snapshot.OccurrenceCounter < 255u)
                {
                    DTCToDFlashInfo.DTC[DTCNum].Snapshot.OccurrenceCounter++;
                }
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.LastMalfunction = (Data_ODO_Read() / 10u);*/
                isNeedSaveDTC = 1u;
            }
        }
        else
        {
            if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCError) == DTCError)
            {
                DTCToDFlashInfo.DTC[DTCNum].DTCStatus &= DTCNoError;
                isNeedSaveDTC = 1u;
            }
        }
    }
}

/**
  *保存DTC状态
  */
void SaveDTCData(void)
{
    WriteDFlashData(EEPROM_BLOCK_UDS_DTC, (uint32_t *)&DTCToDFlashInfo.Flag, sizeof(DTCToDFlashInfo) / 4u, NoNeedWait);
}
