/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Compiletime settings, specifics for Linux (C5SoC platform)
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 14856 $
 *  $Date: 2017-10-11 11:22:56 +0200 (Mi, 11. Okt 2017) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_SETTINGS_D1HX_H_INCLUDED
#define DAVEHD_SETTINGS_D1HX_H_INCLUDED

#include "davehd_device_data_size_d1x.h"

/* The Integrity port does not yet support asynchronous mode. However, the
 * driver's kernel part runs in its own thread anyway. The implementation uses
 * Integrity's Connections to implement a remote procedure call for the clients.
 */

/* #define DHD_KERNEL_SYNCHRONOUS_ONLY */

/* #define DHD_DEBUG_MODE */
/* #define DHD_KERNEL_DEBUG */
/* #define DHD_KERNEL_DEBUG_ERROR */
/* #define DHD_KERNEL_TLIST_SUPPORT */

/* #define DHD_KERNEL_DEBUG_MEMORY */
/* #define DHD_KERNEL_DEBUG_MEMORY_VERBOSE */

/* User code shall not call init / shutdown functions on D1Hx Integrity */
/* #define DHD_USER_INIT */

/* Only one DaveHD GPU core is supported on D1Hx Integrity */
/* #define DHD_MULTIPLE_INSTANCE_SUPPORT */

/* Memory mapping is supported by default on D1Hx Integrity */
/* #define DHD_CAN_MAP_SUPPORT */

#define DHD_KERNEL_SOFT_IRQ
#define DHD_MEMORY_MMU
#define DHD_MEMORY_NO_UMA

#undef DHD_CACHELINE_SIZE
#define DHD_CACHELINE_SIZE             128
#undef DHD_VIDMEM_MINALIGN_LOG2
#define DHD_VIDMEM_MINALIGN_LOG2       7
#undef DHD_MAX_CPU_REGISTER_ACCESS
#define DHD_MAX_CPU_REGISTER_ACCESS    1024     /* architecture can only CPU access the first 4 kB of DHD register space*/
#undef DHD_MIN_JOB_SIZE
#define DHD_MIN_JOB_SIZE               512



#define DHD_JOB_CHECKSUM_SUPPORTED

#if defined (__ghs__)
#pragma ghs startnomisra
#endif /* __ghs__ */

#undef DHD_INLINE
#define DHD_INLINE static inline                             /* Function specifier used for inlined functions.*/


#if defined (__ghs__)
#pragma ghs endnomisra
#endif




#endif /* DAVEHD_SETTINGS_D1HX_H_INCLUDED */
