#include "UDS_22Service_Filter.h"

uint8_t  S22DLC[] =
{
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2U, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u, 2u,
    2u, 2u
};
uint16_t S22DID[] =
{
    0xF180u, 0xF181u, 0xF182u, 0xF183u, 0xF184u, 0xF185u, 0xF187u, 0xF18Au, 0xF18Bu, 0xF18Cu,
    0xF190u, 0xF193u, 0xF195u, 0xF1F0u, 0xF1F1u, 0x6000u, 0x6001u, 0x6078u, 0x6079u, 0x607Au,
    0x607Bu, 0x607Cu, 0x607Du, 0x60C8u, 0x6005u, 0x600Bu, 0x607Eu, 0x607Fu, 0x6080u, 0x6002u,
    0x600Fu, 0x6011u, 0x600Eu, 0x6081u, 0x6009u, 0x6010u, 0x6082u, 0x6083u, 0x6084u, 0x600Au,
    0x6085u, 0x6086u, 0x6087u, 0x6088u, 0x6089u, 0x608Au, 0x608Bu, 0x608Cu, 0x608Du, 0x608Eu,
    0x6029u, 0x6090u, 0x6013u, 0x602Au, 0x6023u, 0x602Cu, 0x60A2u, 0x60ABu, 0x60ACu, 0x605Cu,
    0x605Du, 0x605Eu, 0x605Fu, 0x6060u, 0x6062u, 0x6063u, 0x6064u, 0x6065u, 0x6066u, 0x6068u,
    0x6069u, 0x606Du, 0x606Eu, 0x606Fu, 0x6070u, 0x6071u, 0x6072u, 0x6073u, 0x6074u, 0x6075u,
    0x6076u, 0x6077u, 0x60C9u, 0x60CAu, 0x60CBu, 0x60CCu, 0x60CDu, 0x60CEu, 0x60CFu, 0x60D0u,
    0x60D1u, 0x60D2u
};

/**
  *22服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *22服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *22服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *22服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if (DiagMSG.msgDLC < 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *22服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC31(void)
{
    uint8_t i;
    uint8_t NRC = requestOutOfRange;
    uint8_t count = 0u;
    count = DIM(S22DID);

    if (App_TYWUDS_GetStatus() == 1)
    {
        NRC = positiveResponse;
    }
    else
    {
        for (i = 0u; i < count; ++i)
        {
            if (getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID[i])
            {
                NRC = positiveResponse;
                break;
            }
        }
    }
    //NRC = requestOutOfRange;
    if ((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *22服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if (DiagMSG.msgDLC != 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    /* for(i = 0u; i < DIM(S22DID); ++i)
     {
         if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID[i])
         {
             if(DiagMSG.msgDLC != S22DLC[i])
             {
                 NRC = incorrectMessageLength;
                 UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
             }
             else
             {
                 NRC = positiveResponse;
             }
             break;
         }
     }*/
    return NRC;
}

/**
  *22服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_22Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    /*判断车速大于0*/
    return NRC;
}
