#include "Rscan.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"

#include "RTE_CAN.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_Lib.h"
//#include "CAN_Signal_Tx.h"
#include "AlarmGeneralFilie.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"

#include "PowerManagement.h"
#include "UDS_Common.h"

#include "Watchdog.h"
#include "RSCAN.h"

static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    Can_Init_Lock = 0u;
}

/***Middle***/
void Can_Init(void)
{
    /* filter 变量声明 */
    uint32_t IDFilterNum;

    uint8_t CH0_IDFilterNum;
    uint32_t CANLLCCh0NMIDRange[2];
    uint32_t CANLLCCh0MsgIDList[ID_TOTAL_MAX + 2u];
    uint32_t CANLLCCh0OwnIDList[4];

    uint32_t i;
    RSCAN0_Config_st_t CANLLCCh0Filter;

    CANLLCCh0Filter.stRSCANCh0.u32RSCANChEn = 1u;       /*通道是否使能*/
    CANLLCCh0Filter.stRSCANCh0.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    CANLLCCh0Filter.stRSCANCh0.u32RSCANChRuleSize = CANFD0_CH0_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANConfirmCallBack = 0u;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANReadMsgCallBack = 0u; /*接收完成*/

    CANLLCCh0Filter.stRSCANCh1.u32RSCANChEn = 0u;       /*通道是否使能*/
    CANLLCCh0Filter.stRSCANCh1.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    CANLLCCh0Filter.stRSCANCh1.u32RSCANChRuleSize = CANFD0_CH1_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANConfirmCallBack = 0u;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANReadMsgCallBack = 0u; /*接收完成*/

    CANLLCCh0Filter.stRSCANCh2.u32RSCANChEn = 1u;       /*通道是否使能*/
    CANLLCCh0Filter.stRSCANCh2.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    CANLLCCh0Filter.stRSCANCh2.u32RSCANChRuleSize = CANFD0_CH2_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANConfirmCallBack = 0u;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANReadMsgCallBack = 0u; /*接收完成*/

    CANSTB_OUT  = 1U; //CANSTB_OUT
    CANSTB2_OUT = 1U; //CANSTB2_OUT

    RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &CANLLCCh0Filter);

    CANSTB_OUT  = 0U; //CANSTB_OUT
    CANSTB2_OUT = 0U; //CANSTB2_OUT
}

void Can_DeInit(void)
{
}

uint8_t Can_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t CANFrame;

    CANFrame.unCANData.u8CANData[0] = Msg->Msg[0];
    CANFrame.unCANData.u8CANData[1] = Msg->Msg[1];
    CANFrame.unCANData.u8CANData[2] = Msg->Msg[2];
    CANFrame.unCANData.u8CANData[3] = Msg->Msg[3];
    CANFrame.unCANData.u8CANData[4] = Msg->Msg[4];
    CANFrame.unCANData.u8CANData[5] = Msg->Msg[5];
    CANFrame.unCANData.u8CANData[6] = Msg->Msg[6];
    CANFrame.unCANData.u8CANData[7] = Msg->Msg[7];

    CANFrame.u32CANID = Msg->MsgID;
    CANFrame.u8CANLEN = Msg->MsgDLC;
    CANFrame.u8CANFrameIDE = 1u;

    switch (Msg->MsgPro)
    {
    case 0x00u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_0, &CANFrame);  break;
    case 0x01u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_1, &CANFrame);  break;
    case 0x02u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_2, &CANFrame);  break;
    case 0x03u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_3, &CANFrame);  break;
    case 0x04u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_4, &CANFrame);  break;
    case 0x05u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_5, &CANFrame);  break;
    case 0x06u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_6, &CANFrame);  break;
    case 0x07u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_7, &CANFrame);  break;
    case 0x08u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_8, &CANFrame);  break;
    case 0x09u : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_9, &CANFrame);  break;
    case 0x0Au : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_10, &CANFrame);  break;
    case 0x0Bu : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_11, &CANFrame);  break;
    case 0x0Cu : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_12, &CANFrame);  break;
    case 0x0Du : RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_13, &CANFrame);  break;

    default:
        break;

    }

    /*
    switch (Msg->MsgPro)
    {
    case 0:
      RSCAN0_SendCH0_TxBuf0(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 1:
      RSCAN0_SendCH0_TxBuf1(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 2:
      RSCAN0_SendCH0_TxBuf2(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 3:
      RSCAN0_SendCH0_TxBuf3(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 4:
      RSCAN0_SendCH0_TxBuf4(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 5:
      RSCAN0_SendCH0_TxBuf5(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 6:
      RSCAN0_SendCH0_TxBuf6(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 7:
      RSCAN0_SendCH0_TxBuf7(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 8:
      RSCAN0_SendCH0_TxBuf8(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 9:
      RSCAN0_SendCH0_TxBuf9(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 10:
      RSCAN0_SendCH0_TxBuf10(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 11:
      RSCAN0_SendCH0_TxBuf11(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 12:
      RSCAN0_SendCH0_TxBuf12(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 13:
      RSCAN0_SendCH0_TxBuf13(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 14:
      RSCAN0_SendCH0_TxBuf14(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    case 15:
      RSCAN0_SendCH0_TxBuf15(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
      break;
    default:
      CAN_CH0_Data_Request(Msg->MsgID, Msg->MsgStd, Msg->MsgRTR, Msg->MsgDLC, Msg->Msg);
      break;
    }
    */
    return 0;
}

void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

/*诊断发送终止----20220320----*/
void Can_Uds_Abort(void)
{
    //CANFD_SetTX_Abort();
    RSCAN0_CH2_Abort(RSCAN_CHANNEL_BUF_0);
    RSCAN0_CH2_Abort(RSCAN_CHANNEL_BUF_1);
}

void Can_Abort_All(void)
{
}

/*****Lower*******/
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{
    ReceivedMsg(m_id, m_dlc);

    Co_Can_Buff_Set(Co_Can_ConvertSubID(m_id), m_dlc, m_Msg);

    if ((m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY))
    {
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}


void CAN_BUSOFF_Recover(void)
{
    //CH0_BusOff_Recovery();
    RSCAN0_CH0_Busoff_Recover();
}
