
#ifndef INTERNAL_FLASH_H__
#define INTERNAL_FLASH_H__

typedef enum
{
	INT_FLASH_PASS = 0U,
	INT_FLASH_FAIL,
} Int_Flash_Result_en_t;

typedef enum
{
	INT_DATA_FLASH_IDLE = 0U,
	INT_DATA_FLASH_BUSY,
	INT_DATA_FLASH_ERROR,
} Int_Data_Flash_Status_en_t;

typedef void (*Int_Flash_Cb_Func_t)(void);

#define INT_DATA_FLASH_START_ADDR (0xFF200000UL)
#define INT_DATA_FLASH_END_ADDR (0xFF20FFFFUL)
#define INT_DATA_FLASH_BLOCK_SIZE (64U)
#define INT_DATA_FLASH_BUFFER_SIZE (256U) /* 256 * 4 = 1024 bytes */

#define INT_CODE_FLASH_START_ADDR (0x00000000UL)
#define INT_CODE_FLASH_END_ADDR (0x003FFFFFUL)
#define INT_CODE_FLASH_8k_BLOCK_START (0x00000000UL)
#define INT_CODE_FLASH_32k_BLOCK_START (0x00010000UL)
#define INT_CODE_FLASH_BLOCK_0_7_SIZE (8U * 1024U)
#define INT_CODE_FLASH_BLOCK_8_133_SIZE (32U * 1024U)
#define INT_CODE_FLASH_SIZE (INT_CODE_FLASH_END_ADDR - INT_CODE_FLASH_START_ADDR + 1UL)

extern void Int_Flash_Init(void);

extern void Int_Data_Flash_Read(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern void Int_Data_Flash_Erase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern uint32_t Int_Data_Flash_Blank_Check(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern void Int_Data_Flash_Write(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern Int_Data_Flash_Status_en_t Int_Data_Flash_Status_Get(void);
extern void Int_Data_Flash_Register_P_E_Complete_Cb(Int_Flash_Cb_Func_t pfnCmpleteCb);
extern void Int_Data_Flash_Force_Stop(void);

extern Int_Flash_Result_en_t Int_Code_Flash_Read(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern Int_Flash_Result_en_t Int_Code_Flash_Erase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern uint32_t Int_Code_Flash_Blank_Check(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern Int_Flash_Result_en_t Int_Code_Flash_Write(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern void Int_Code_Flash_Force_Stop(void);
extern Int_Flash_Result_en_t Int_Config_Set_Read(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);
extern Int_Flash_Result_en_t Int_Config_Program_Set_Write(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);

extern void Int_Flash_Ready_ISR(void);

#endif
