
#define   GLOBALS_MEU_PROCESS
#include "Menu.h"
#include "GUI.h"
#include "Services_Mileage.h"
#include "Data_FuelConsump.h"
#include "CAN_Communication_Matrix.h"
#include "Common_Interface.h"

uint8_t     bMenuSwFlag;
uint8_t     g_ClearWin1;
uint8_t     bNextMenuIDX;
uint8_t     bCurMenuIDX;
uint8_t     bMainMenuIDX;
uint8_t     bOldMenuIDX;

_MenuFlag    MenuFlag   ;

const _MenuOptTab   MenuOptTab[] =
{
    /*---------ENTER---------------------UP-----------------------DOWN----------------------EXIT------------------ENTER------------------DO-----------------EXIT------------*/
    /*主循环界面*/
    /*00*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_6,    _MN_DSP_LEVEL1MENU_2,     _MN_IDX_NULL,         Level1Menu_1Enter,      Level1Menu_1Do,     Level1Menu_1Exit},        /*  _MN_DSP_LEVEL1MENU_1  */
    /*01*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_1,    _MN_DSP_LEVEL1MENU_3,     _MN_IDX_NULL,         Level1Menu_2Enter,      Level1Menu_2Do,     Level1Menu_2Exit},        /*  _MN_DSP_LEVEL1MENU_2  */
    /*02*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_2,    _MN_DSP_LEVEL1MENU_4,     _MN_IDX_NULL,         Level1Menu_3Enter,      Level1Menu_3Do,     Level1Menu_3Exit},        /*  _MN_DSP_LEVEL1MENU_3  */
    /*03*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_3,    _MN_DSP_LEVEL1MENU_5,     _MN_IDX_NULL,         Level1Menu_4Enter,      Level1Menu_4Do,     Level1Menu_4Exit},        /*  _MN_DSP_LEVEL1MENU_4  */
    /*04*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_4,    _MN_DSP_LEVEL1MENU_6,     _MN_IDX_NULL,         Level1Menu_5Enter,      Level1Menu_5Do,     Level1Menu_5Exit},        /*  _MN_DSP_LEVEL1MENU_5  */
    /*05*/{ _MN_DSP_LEVEL2MENU_2,      _MN_DSP_LEVEL1MENU_5,    _MN_DSP_LEVEL1MENU_1,     _MN_IDX_NULL,         Level1Menu_6Enter,      Level1Menu_6Do,     Level1Menu_6Exit},        /*  _MN_DSP_LEVEL1MENU_6  */
    /*06*/{ _MN_IDX_NULL,              _MN_IDX_NULL,            _MN_IDX_NULL,             _MN_IDX_NULL,         LevelPopup_Enter,       LevelPopup_Do,      LevelPopup_Exit },        /*  _MN_DSP_LEVEPOPUP     */
    /*一级菜单 */
    /*07*/{ _MN_DSP_LEVEL2_1_MENU_1,   _MN_IDX_NULL,            _MN_DSP_LEVEL2MENU_2,     _MN_IDX_NULL,         Level2Menu_1Enter,      Level2Menu_1Do,     Level2Menu_1Exit},        /*  _MN_DSP_LEVEL2MENU_1  */
    /*08*/{ _MN_DSP_LEVEL2_2_MENU_1,   _MN_DSP_LEVEL2MENU_1,    _MN_DSP_LEVEL2MENU_3,     _MN_IDX_NULL,         Level2Menu_2Enter,      Level2Menu_2Do,     Level2Menu_2Exit},        /*  _MN_DSP_LEVEL2MENU_2  */
    /*09*/{ _MN_DSP_LEVEL2_3_MENU_1,   _MN_DSP_LEVEL2MENU_2,    _MN_DSP_LEVEL2MENU_4,     _MN_IDX_NULL,         Level2Menu_3Enter,      Level2Menu_3Do,     Level2Menu_3Exit},        /*  _MN_DSP_LEVEL2MENU_3  */
    /*10*/{ _MN_DSP_LEVEL2_4_MENU_1,   _MN_DSP_LEVEL2MENU_3,    _MN_DSP_LEVEL2MENU_5,     _MN_IDX_NULL,         Level2Menu_4Enter,      Level2Menu_4Do,     Level2Menu_4Exit},        /*  _MN_DSP_LEVEL2MENU_4  */
    /*11*/{ _MN_DSP_LEVEL2_5_MENU_1,   _MN_DSP_LEVEL2MENU_4,    _MN_DSP_LEVEL2MENU_6,     _MN_IDX_NULL,         Level2Menu_5Enter,      Level2Menu_5Do,     Level2Menu_5Exit},        /*  _MN_DSP_LEVEL2MENU_5  */
    /*12*/{ _MN_DSP_LEVEL2_6_MENU_1,   _MN_DSP_LEVEL2MENU_5,    _MN_IDX_NULL,             _MN_IDX_NULL,         Level2Menu_6Enter,      Level2Menu_6Do,     Level2Menu_6Exit},        /*  _MN_DSP_LEVEL2MENU_6  */
    /*二级菜单 */
    /*13*/{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_1, Level2_1Menu_1Enter,  Level2_1Menu_1Do,   Level2_1Menu_1Exit},          /*  _MN_DSP_LEVEL2_1_MENU_1 */

    /*14*/{ _MN_DSP_LEVEL3_2_MENU_1, _MN_IDX_NULL,            _MN_DSP_LEVEL2_2_MENU_2,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_1Enter,  Level2_2Menu_1Do,   Level2_2Menu_1Exit},          /*  _MN_DSP_LEVEL2_2_MENU_1 */
    /*15*/{ _MN_DSP_LEVEL3_2_MENU_2, _MN_DSP_LEVEL2_2_MENU_1, _MN_DSP_LEVEL2_2_MENU_3,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_2Enter,  Level2_2Menu_2Do,   Level2_2Menu_2Exit},          /*  _MN_DSP_LEVEL2_2_MENU_2 */
    /*16*/{ _MN_DSP_LEVEL3_2_MENU_3, _MN_DSP_LEVEL2_2_MENU_2, _MN_DSP_LEVEL2_2_MENU_4,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_3Enter,  Level2_2Menu_3Do,   Level2_2Menu_3Exit},          /*  _MN_DSP_LEVEL2_2_MENU_3 */
    /*17*/{ _MN_DSP_LEVEL3_2_MENU_4, _MN_DSP_LEVEL2_2_MENU_3, _MN_DSP_LEVEL2_2_MENU_6,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_4Enter,  Level2_2Menu_4Do,   Level2_2Menu_4Exit},          /*  _MN_DSP_LEVEL2_2_MENU_4 */
    /*19*/{ _MN_DSP_LEVEL3_2_MENU_6, _MN_DSP_LEVEL2_2_MENU_4, _MN_DSP_LEVEL2_2_MENU_7,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_6Enter,  Level2_2Menu_6Do,   Level2_2Menu_6Exit},          /*  _MN_DSP_LEVEL2_2_MENU_6 */
    /*20*/{ _MN_DSP_LEVEL3_2_MENU_7, _MN_DSP_LEVEL2_2_MENU_6, _MN_DSP_LEVEL2_2_MENU_8,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_7Enter,  Level2_2Menu_7Do,   Level2_2Menu_7Exit},          /*  _MN_DSP_LEVEL2_2_MENU_7 */
    /*21*/{ _MN_DSP_LEVEL3_2_MENU_8, _MN_DSP_LEVEL2_2_MENU_7, _MN_DSP_LEVEL2_2_MENU_9,  _MN_DSP_LEVEL2MENU_2, Level2_2Menu_8Enter,  Level2_2Menu_8Do,   Level2_2Menu_8Exit},          /*  _MN_DSP_LEVEL2_2_MENU_8 */
    /*22*/{ _MN_DSP_LEVEL3_2_MENU_9, _MN_DSP_LEVEL2_2_MENU_8, _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_2, Level2_2Menu_9Enter,  Level2_2Menu_9Do,   Level2_2Menu_9Exit},          /*  _MN_DSP_LEVEL2_2_MENU_9 */

    /*23*/{ _MN_DSP_LEVEL3_3_MENU_1, _MN_IDX_NULL,            _MN_DSP_LEVEL2_3_MENU_2,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_1Enter,  Level2_3Menu_1Do,   Level2_3Menu_1Exit},          /*  _MN_DSP_LEVEL2_3_MENU_1 */
    /*24*/{ _MN_DSP_LEVEL3_3_MENU_2, _MN_DSP_LEVEL2_3_MENU_1, _MN_DSP_LEVEL2_3_MENU_3,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_2Enter,  Level2_3Menu_2Do,   Level2_3Menu_2Exit},          /*  _MN_DSP_LEVEL2_3_MENU_2 */
    /*25*/{ _MN_DSP_LEVEL3_3_MENU_3, _MN_DSP_LEVEL2_3_MENU_2, _MN_DSP_LEVEL2_3_MENU_4,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_3Enter,  Level2_3Menu_3Do,   Level2_3Menu_3Exit},          /*  _MN_DSP_LEVEL2_3_MENU_3 */
    /*26*/{ _MN_DSP_LEVEL3_3_MENU_4, _MN_DSP_LEVEL2_3_MENU_3, _MN_DSP_LEVEL2_3_MENU_5,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_4Enter,  Level2_3Menu_4Do,   Level2_3Menu_4Exit},          /*  _MN_DSP_LEVEL2_3_MENU_4 */
    /*27*/{ _MN_DSP_LEVEL3_3_MENU_5, _MN_DSP_LEVEL2_3_MENU_4, _MN_DSP_LEVEL2_3_MENU_6,   _MN_DSP_LEVEL2MENU_3, Level2_3Menu_5Enter,  Level2_3Menu_5Do,   Level2_3Menu_5Exit},          /*  _MN_DSP_LEVEL2_3_MENU_5 */
    /*28*/{ _MN_DSP_LEVEL3_3_MENU_6, _MN_DSP_LEVEL2_3_MENU_5, _MN_DSP_LEVEL2_3_MENU_7,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_6Enter,  Level2_3Menu_6Do,   Level2_3Menu_6Exit},          /*  _MN_DSP_LEVEL2_3_MENU_6 */
    /*29*/{ _MN_DSP_LEVEL3_3_MENU_7, _MN_DSP_LEVEL2_3_MENU_6, _MN_DSP_LEVEL2_3_MENU_8,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_7Enter,  Level2_3Menu_7Do,   Level2_3Menu_7Exit},          /*  _MN_DSP_LEVEL2_3_MENU_7 */
    /*30*/{ _MN_DSP_LEVEL3_3_MENU_8, _MN_DSP_LEVEL2_3_MENU_7, _MN_IDX_NULL           ,  _MN_DSP_LEVEL2MENU_3, Level2_3Menu_8Enter,  Level2_3Menu_8Do,   Level2_3Menu_8Exit},          /*  _MN_DSP_LEVEL2_3_MENU_8 */

    /*31*/{ _MN_DSP_LEVEL3_4_MENU_11, _MN_IDX_NULL,            _MN_DSP_LEVEL2_4_MENU_2,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_1Enter,  Level2_4Menu_1Do,   Level2_4Menu_1Exit},       /*   _MN_DSP_LEVEL2_4_MENU_1 */
    /*32*/{ _MN_DSP_LEVEL3_4_MENU_21, _MN_DSP_LEVEL2_4_MENU_1, _MN_DSP_LEVEL2_4_MENU_3,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_2Enter,  Level2_4Menu_2Do,   Level2_4Menu_2Exit},       /*   _MN_DSP_LEVEL2_4_MENU_2 */
    /*33*/{ _MN_DSP_LEVEL3_4_MENU_3, _MN_DSP_LEVEL2_4_MENU_2, _MN_DSP_LEVEL2_4_MENU_4,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_3Enter,  Level2_4Menu_3Do,   Level2_4Menu_3Exit},       /*   _MN_DSP_LEVEL2_4_MENU_3 */
    /*34*/{ _MN_DSP_LEVEL3_4_MENU_41, _MN_DSP_LEVEL2_4_MENU_3, _MN_DSP_LEVEL2_4_MENU_5,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_4Enter,  Level2_4Menu_4Do,   Level2_4Menu_4Exit},       /*   _MN_DSP_LEVEL2_4_MENU_4 */
    /*35*/{ _MN_IDX_NULL, _MN_DSP_LEVEL2_4_MENU_4, _MN_DSP_LEVEL2_4_MENU_6,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_5Enter,  Level2_4Menu_5Do,   Level2_4Menu_5Exit},       /*   _MN_DSP_LEVEL2_4_MENU_5 */
    /*36*/{ _MN_IDX_NULL, _MN_DSP_LEVEL2_4_MENU_5, _MN_DSP_LEVEL2_4_MENU_7,  _MN_DSP_LEVEL2MENU_4, Level2_4Menu_6Enter,  Level2_4Menu_6Do,   Level2_4Menu_6Exit},       /*   _MN_DSP_LEVEL2_4_MENU_6 */
    /*37*/{ _MN_IDX_NULL, _MN_DSP_LEVEL2_4_MENU_6, _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_4, Level2_4Menu_7Enter,  Level2_4Menu_7Do,   Level2_4Menu_7Exit},       /*   _MN_DSP_LEVEL2_4_MENU_7 */

    /*三级菜单*/
    /*42*///{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_1_MENU_1, Level3_1Menu_1Enter, Level3_1Menu_1Do, Level3_1Menu_1Exit},        //   _MN_DSP_LEVEL3_1_MENU_1
    /*43*///{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_1_MENU_2, Level3_1Menu_2Enter, Level3_1Menu_2Do, Level3_1Menu_2Exit},        //   _MN_DSP_LEVEL3_1_MENU_2
    /*44*///{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_1_MENU_3, Level3_1Menu_3Enter, Level3_1Menu_3Do, Level3_1Menu_3Exit},        //   _MN_DSP_LEVEL3_1_MENU_3
    /*45*///{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_1_MENU_4, Level3_1Menu_4Enter, Level3_1Menu_4Do, Level3_1Menu_4Exit},        //   _MN_DSP_LEVEL3_1_MENU_4
    /*45*///{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_1_MENU_5, Level3_1Menu_5Enter, Level3_1Menu_5Do, Level3_1Menu_5Exit},        //   _MN_DSP_LEVEL3_1_MENU_5
    ////
    ///*39*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_1, Level3_2Menu_1Enter, Level3_2Menu_1Do,   Level3_2Menu_1Exit},    //   _MN_DSP_LEVEL3_2_MENU_1
    ///*40*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_2, Level3_2Menu_2Enter, Level3_2Menu_2Do,   Level3_2Menu_2Exit},        //   _MN_DSP_LEVEL3_2_MENU_2
    ///*41*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_3, Level3_2Menu_3Enter, Level3_2Menu_3Do,   Level3_2Menu_3Exit},        //   _MN_DSP_LEVEL3_2_MENU_3
    ///*42*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_4, Level3_2Menu_4Enter, Level3_2Menu_4Do,   Level3_2Menu_4Exit},        //   _MN_DSP_LEVEL3_2_MENU_4
    ///*43*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_6, Level3_2Menu_6Enter, Level3_2Menu_6Do,   Level3_2Menu_6Exit},        //   _MN_DSP_LEVEL3_2_MENU_6
    ///*44*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_7, Level3_2Menu_7Enter, Level3_2Menu_7Do,   Level3_2Menu_7Exit},        //   _MN_DSP_LEVEL3_2_MENU_7
    ///*45*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_8, Level3_2Menu_8Enter, Level3_2Menu_8Do,   Level3_2Menu_8Exit},        //   _MN_DSP_LEVEL3_2_MENU_8
    ///*46*/{_MN_DSP_ENTER_MENU,       _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_2_MENU_9, Level3_2Menu_9Enter, Level3_2Menu_9Do,   Level3_2Menu_9Exit},        //   _MN_DSP_LEVEL3_2_MENU_9
    //
    ///*47*/{ _MN_DSP_LEVEL2_3_MENU_1, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_1, Level3_3Menu_1Enter, Level3_3Menu_1Do,   Level3_3Menu_1Exit},    //   _MN_DSP_LEVEL3_3_MENU_1
    ///*48*/{ _MN_DSP_LEVEL2_3_MENU_2, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_2, Level3_3Menu_2Enter, Level3_3Menu_2Do,   Level3_3Menu_2Exit},        //   _MN_DSP_LEVEL3_3_MENU_2
    ///*49*/{ _MN_DSP_LEVEL2_3_MENU_3, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_3, Level3_3Menu_3Enter, Level3_3Menu_3Do,   Level3_3Menu_3Exit},        //   _MN_DSP_LEVEL3_3_MENU_3
    ///*50*/{ _MN_DSP_LEVEL2_3_MENU_4, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_4, Level3_3Menu_4Enter, Level3_3Menu_4Do,   Level3_3Menu_4Exit},        //   _MN_DSP_LEVEL3_3_MENU_4
    ///*59*///{ _MN_DSP_LEVEL2_3_MENU_5, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_5, Level3_3Menu_5Enter, Level3_3Menu_5Do, Level3_3Menu_5Exit},        //   _MN_DSP_LEVEL3_3_MENU_5
    ///*51*/{ _MN_DSP_LEVEL2_3_MENU_6, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_6, Level3_3Menu_6Enter, Level3_3Menu_6Do,   Level3_3Menu_6Exit},        //   _MN_DSP_LEVEL3_3_MENU_6
    ///*52*/{ _MN_DSP_LEVEL2_3_MENU_7, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_3_MENU_7, Level3_3Menu_7Enter, Level3_3Menu_7Do,   Level3_3Menu_7Exit},        //   _MN_DSP_LEVEL3_3_MENU_7
    //
    ///*53*/{ _MN_DSP_LEVEL4_1_MENU_1, _MN_IDX_NULL,           _MN_DSP_LEVEL3_4_MENU_12, _MN_DSP_LEVEL2_4_MENU_1, Level3_4Menu_1Enter_1, Level3_4Menu_1Do_1,   Level3_4Menu_1Exit_1},   //   _MN_DSP_LEVEL3_4_MENU_11  ÈÕÆÚÉè¶¨
    ///*54*/{ _MN_DSP_LEVEL4_1_MENU_2, _MN_DSP_LEVEL3_4_MENU_11, _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_1, Level3_4Menu_1Enter_2, Level3_4Menu_1Do_2,   Level3_4Menu_1Exit_2},   //   _MN_DSP_LEVEL3_4_MENU_12  ¸ñÊ½Éè¶¨
    ///*55*/{ _MN_DSP_LEVEL4_2_MENU_1, _MN_IDX_NULL,           _MN_DSP_LEVEL3_4_MENU_22, _MN_DSP_LEVEL2_4_MENU_2, Level3_4Menu_2Enter_1, Level3_4Menu_2Do_1,   Level3_4Menu_2Exit_1},     //   _MN_DSP_LEVEL3_4_MENU_21  Ê±¼äÉè¶¨
    ///*56*/{ _MN_DSP_LEVEL4_2_MENU_2, _MN_DSP_LEVEL3_4_MENU_21, _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_2, Level3_4Menu_2Enter_2, Level3_4Menu_2Do_2,   Level3_4Menu_2Exit_2},     //   _MN_DSP_LEVEL3_4_MENU_22  ¸ñÊ½Éè¶¨
    ///*57*/{ _MN_DSP_LEVEL2_4_MENU_3, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_3, Level3_4Menu_3Enter, Level3_4Menu_3Do,   Level3_4Menu_3Exit},        //   _MN_DSP_LEVEL3_4_MENU_3
    ///*58*/{ _MN_DSP_LEVEL4_4_MENU_1, _MN_IDX_NULL,            _MN_DSP_LEVEL3_4_MENU_42, _MN_DSP_LEVEL2_4_MENU_4, Level3_4Menu_4Enter_1, Level3_4Menu_4Do_1, Level3_4Menu_4Exit_1}, //     _MN_DSP_LEVEL3_4_MENU_41  Ê¡ÓÍÉè¶¨1
    ///*59*/{ _MN_DSP_LEVEL4_4_MENU_2, _MN_DSP_LEVEL3_4_MENU_41, _MN_DSP_LEVEL3_4_MENU_43, _MN_DSP_LEVEL2_4_MENU_4, Level3_4Menu_4Enter_2, Level3_4Menu_4Do_2, Level3_4Menu_4Exit_2}, //     _MN_DSP_LEVEL3_4_MENU_42  Ê¡ÓÍÉè¶¨2
    ///*60*/{ _MN_DSP_LEVEL4_4_MENU_3, _MN_DSP_LEVEL3_4_MENU_42, _MN_DSP_LEVEL3_4_MENU_44, _MN_DSP_LEVEL2_4_MENU_4, Level3_4Menu_4Enter_3, Level3_4Menu_4Do_3, Level3_4Menu_4Exit_3}, //     _MN_DSP_LEVEL3_4_MENU_43  Ê¡ÓÍÉè¶¨3
    ///*61*/{ _MN_DSP_LEVEL4_4_MENU_4, _MN_DSP_LEVEL3_4_MENU_43, _MN_DSP_LEVEL3_4_MENU_45, _MN_DSP_LEVEL2_4_MENU_4, Level3_4Menu_4Enter_4, Level3_4Menu_4Do_4, Level3_4Menu_4Exit_4}, //     _MN_DSP_LEVEL3_4_MENU_44  Ê¡ÓÍÉè¶¨4
    ///*62*/{ _MN_DSP_LEVEL4_4_MENU_5, _MN_DSP_LEVEL3_4_MENU_44, _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_4, Level3_4Menu_4Enter_5, Level3_4Menu_4Do_5, Level3_4Menu_4Exit_5}, //      _MN_DSP_LEVEL3_4_MENU_45  Ê¡ÓÍÉè¶¨5
    ///*63*/{ _MN_DSP_LEVEL4_5_MENU_1, _MN_IDX_NULL,           _MN_DSP_LEVEL3_4_MENU_52, _MN_DSP_LEVEL2_4_MENU_5, Level3_4Menu_5Enter_1, Level3_4Menu_5Do_1, Level3_4Menu_5Exit_1}, //     _MN_DSP_LEVEL3_4_MENU_51  HASÉè¶¨  HSAµ÷Õû
    ///*64*/{ _MN_DSP_LEVEL4_5_MENU_2, _MN_DSP_LEVEL3_4_MENU_51, _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_5, Level3_4Menu_5Enter_2, Level3_4Menu_5Do_2, Level3_4Menu_5Exit_2}, //     _MN_DSP_LEVEL3_4_MENU_52  HASÉè¶¨  HSAÖØÖÃ
    ///*65*/{ _MN_DSP_LEVEL2_4_MENU_6, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_6, Level3_4Menu_6Enter, Level3_4Menu_6Do,   Level3_4Menu_6Exit},        //   _MN_DSP_LEVEL3_4_MENU_6   ³µ¼ä¾àÀë±¨¾¯Òô
    ///*66*/{ _MN_DSP_LEVEL2_4_MENU_7, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_7, Level3_4Menu_7Enter, Level3_4Menu_7Do,   Level3_4Menu_7Exit},        //   _MN_DSP_LEVEL3_4_MENU_7   ÓïÑÔÉè¶¨
    ///*67*/{ _MN_DSP_LEVEL2_4_MENU_8, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_8, Level3_4Menu_8Enter, Level3_4Menu_8Do,   Level3_4Menu_8Exit},        //   _MN_DSP_LEVEL3_4_MENU_8   ÁÁ¶Èµ÷½Ú//µ¥Î»Éè¶¨
    ///*68*/{ _MN_DSP_LEVEL2_4_MENU_9, _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_9, Level3_4Menu_9Enter, Level3_4Menu_9Do,   Level3_4Menu_9Exit},        //   _MN_DSP_LEVEL3_4_MENU_9   µ¥Î»Éè¶¨//ÁÁ¶Èµ÷½Ú
    ///*69*/{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,           _MN_DSP_LEVEL2_4_MENU_A, Level3_4Menu_AEnter, Level3_4Menu_ADo, Level3_4Menu_AExit},    //   _MN_DSP_LEVEL3_4_MENU_A   Ì¥Ñ¹ÉèÖÃ½çÃæÏÔÊ¾
    //
    //ËÄ¼¶²Ëµ¥                                                                                                                                                                //    //ËÄ¼¶²Ëµ¥
    //*70*/{ _MN_DSP_LEVEL3_4_MENU_11, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_11, Level4_1Menu_1Enter, Level4_1Menu_1Do,    Level4_1Menu_1Exit},        //   _MN_DSP_LEVEL4_1_MENU_1
    //*71*/{ _MN_DSP_LEVEL3_4_MENU_12, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_12, Level4_1Menu_2Enter, Level4_1Menu_2Do,    Level4_1Menu_2Exit},        //   _MN_DSP_LEVEL4_1_MENU_2
    //*72*/{ _MN_DSP_LEVEL3_4_MENU_21, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_21, Level4_2Menu_1Enter, Level4_2Menu_1Do,    Level4_2Menu_1Exit},        //   _MN_DSP_LEVEL4_2_MENU_1
    //*73*/{ _MN_DSP_LEVEL3_4_MENU_22, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_22, Level4_2Menu_2Enter, Level4_2Menu_2Do,    Level4_2Menu_2Exit},        //   _MN_DSP_LEVEL4_2_MENU_2
    //*74*/{ _MN_DSP_LEVEL3_4_MENU_41, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_41, Level4_4Menu_1Enter, Level4_4Menu_1Do,    Level4_4Menu_1Exit},        //   _MN_DSP_LEVEL4_4_MENU_1
    //*75*/{ _MN_DSP_LEVEL3_4_MENU_42, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_42, Level4_4Menu_2Enter, Level4_4Menu_2Do,    Level4_4Menu_2Exit},        //   _MN_DSP_LEVEL4_4_MENU_2
    //*76*/{ _MN_DSP_LEVEL3_4_MENU_43, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_43, Level4_4Menu_3Enter, Level4_4Menu_3Do,    Level4_4Menu_3Exit},        //   _MN_DSP_LEVEL4_4_MENU_3
    //*77*/{ _MN_DSP_LEVEL3_4_MENU_44, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_44, Level4_4Menu_4Enter, Level4_4Menu_4Do,    Level4_4Menu_4Exit},        //   _MN_DSP_LEVEL4_4_MENU_4
    //*78*/{ _MN_DSP_LEVEL3_4_MENU_45, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_45, Level4_4Menu_5Enter, Level4_4Menu_5Do,    Level4_4Menu_5Exit},        //   _MN_DSP_LEVEL4_4_MENU_5
    //*79*/{ _MN_DSP_LEVEL3_4_MENU_51, _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_51, Level4_5Menu_1Enter, Level4_5Menu_1Do,    Level4_5Menu_1Exit},        //   _MN_DSP_LEVEL4_5_MENU_1
    //*80*/{ _MN_DSP_HSAENTER_MENU,    _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_DSP_LEVEL3_4_MENU_52, Level4_5Menu_2Enter, Level4_5Menu_2Do,    Level4_5Menu_2Exit},        //   _MN_DSP_LEVEL4_5_MENU_2

    ///*81*/{ _MN_DSP_LEVEL3_4_MENU_52, _MN_IDX_NULL,            _MN_IDX_NULL, _MN_DSP_LEVEL4_5_MENU_2,  Level_Enter_HMenu_Enter, Level_Enter_HMenu_Do, Level_Enter_HMenu_Exit},  //   _MN_DSP_HSAENTER_MENU
    ///*82*/{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_IDX_NULL,     Level_Enter_Menu_Enter, Level_Enter_Menu_Do, Level_Enter_Menu_Exit},           //
    ///*83*/{ _MN_IDX_NULL,            _MN_IDX_NULL,            _MN_IDX_NULL,        _MN_IDX_NULL,     Level_Return_Menu_Enter, Level_Return_Menu_Do, Level_Return_Menu_Exit},    //

};
void NextMenu(_MENU_IDX idx)
{
    if ((idx) != _MN_IDX_NULL)
    {
        bNextMenuIDX = (idx);
    }
    else
    {
    }
    bOldMenuIDX = 0xFF;
}
void MenuInit(void)
{
    bCurMenuIDX = 0;
    bNextMenuIDX = 0;
    bMenuSwFlag = 1;

    if (bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1)
    {
        bCurMenuIDX = MenuFlag.Menu_Flag; /*记录上次位置*/
        bNextMenuIDX = bCurMenuIDX;
    }
    else
    {
        ;/*do nothing*/
    }
}
void MenuManage(void)
{
    if (bMenuSwFlag)
    {
        if (MenuOptTab[bCurMenuIDX].Enter)
        {
            MenuOptTab[bCurMenuIDX].Enter();
        }
        else
        {
            ;/*do nothing*/
        }
    }
    else
    {
        ;/*do nothing*/
    }

    if (MenuOptTab[bCurMenuIDX].Do)
    {
        MenuOptTab[bCurMenuIDX].Do();
    }
    else
    {
        ;/*do nothing*/
    }

    bMenuSwFlag = (bCurMenuIDX != bNextMenuIDX) ? 1 : 0;
    if (bMenuSwFlag)
    {
        if (MenuOptTab[bCurMenuIDX].Exit && MenuOptTab[bCurMenuIDX].VK_IDX_EXIT)
        {
            MenuOptTab[bCurMenuIDX].Exit();
        }
        else
        {
            ;/*do nothing*/
        }
    }

    bCurMenuIDX = bNextMenuIDX;
}

/*主界面1   平均油耗，平均车速*/
void Level1Menu_1Enter(void)
{
}
void Level1Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_AVG_FuelSpeed_Display(GUI_DISP_MODE_BLANK);
}
void Level1Menu_1Exit(void)
{}

/*主界面2 电池显示*/
void Level1Menu_2Enter(void)
{
}
void Level1Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Battery_Display_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_2Exit(void)
{}

/*主界面3 DPD*/
void Level1Menu_3Enter(void)
{
}
void Level1Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_DPD_Display_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_3Exit(void)
{}

/*主界面4 油温时间*/
void Level1Menu_4Enter(void)
{
}
void Level1Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Time_OilTemp_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_4Exit(void)
{}

/*主界面5 万年历*/
void Level1Menu_5Enter(void)
{
}
void Level1Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Year_Month_Data_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_5Exit(void)
{}

/*主界面6  空白*/
void Level1Menu_6Enter(void)
{
}
void Level1Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_block_NULL_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_6Exit(void)
{}

/*主界面 报警界面*/
void LevelPopup_Enter(void)
{
}
void LevelPopup_Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
}
void LevelPopup_Exit(void)
{}

/*----MENU----*/
/*二级菜单 故障码*/
void Level2Menu_1Enter(void)
{
}
void Level2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_1Exit(void)
{}
/*二级菜单 维修通知*/
void Level2Menu_2Enter(void)
{
}
void Level2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_2Exit(void)
{}
/*二级菜单 维修通知设定*/
void Level2Menu_3Enter(void)
{
}
void Level2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_3Exit(void)
{}
/*二级菜单 用户设定*/
void Level2Menu_4Enter(void)
{
}
void Level2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_4Exit(void)
{}
/*二级界面 系统演示*/
void Level2Menu_5Enter(void)
{
}
void Level2Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_5Exit(void)
{}
/*二级界面 胎压显示*/
void Level2Menu_6Enter(void)
{
}
void Level2Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_6Exit(void)
{}
/*----故障代码----子菜单系列*/
/*发动机故障*/
void Level2_1Menu_1Enter(void)
{
}
void Level2_1Menu_1Do(void)
{
    GUI_OftenShow_Display();
}
void Level2_1Menu_1Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*发动机油滤清器*/
void Level2_2Menu_1Enter(void)
{
}
void Level2_2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_1Exit(void)
{}
/*燃油滤清器*/
void Level2_2Menu_2Enter(void)
{
}
void Level2_2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_2Exit(void)
{}
/*变速箱油*/
void Level2_2Menu_3Enter(void)
{
}
void Level2_2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_3Exit(void)
{}
/*差速器油*/
void Level2_2Menu_4Enter(void)
{
}
void Level2_2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_4Exit(void)
{}
/*离合油*/
void Level2_2Menu_5Enter(void)
{
}
void Level2_2Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_5Exit(void)
{}
/*空气干燥剂*/
void Level2_2Menu_6Enter(void)
{
}
void Level2_2Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_6Exit(void)
{}
/*动力转向油*/
void Level2_2Menu_7Enter(void)
{
}
void Level2_2Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu7_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_7Exit(void)
{}
/*轮胎*/
void Level2_2Menu_8Enter(void)
{
}
void Level2_2Menu_8Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu8_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_8Exit(void)
{}
/*起动机*/
void Level2_2Menu_9Enter(void)
{
}
void Level2_2Menu_9Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu9_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_9Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换发动机滤清器*/
void Level2_3Menu_1Enter(void)
{
}
void Level2_3Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_1Exit(void)
{}
/*更换燃油滤清器*/
void Level2_3Menu_2Enter(void)
{
}
void Level2_3Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_2Exit(void)
{}
/*更换变速箱油*/
void Level2_3Menu_3Enter(void)
{
}
void Level2_3Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_3Exit(void)
{}
/*更换差速器油*/
void Level2_3Menu_4Enter(void)
{
}
void Level2_3Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_4Exit(void)
{}
/*离合器油*/
void Level2_3Menu_5Enter(void)
{
}
void Level2_3Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_5Exit(void)
{}
/*更换动力转向油*/
void Level2_3Menu_6Enter(void)
{
}
void Level2_3Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_6Exit(void)
{}
/*更换轮胎轮胎*/
void Level2_3Menu_7Enter(void)
{
}
void Level2_3Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu7_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_7Exit(void)
{}
/*更换起动机*/
void Level2_3Menu_8Enter(void)
{
}
void Level2_3Menu_8Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu8_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_8Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*日期设定*/
void Level2_4Menu_1Enter(void)
{
}
void Level2_4Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu1_Display(GUI_DISP_MODE_NORMAL);
    //User_set_Num.User_Date = 0;
}
void Level2_4Menu_1Exit(void)
{}
/*时间设定*/
void Level2_4Menu_2Enter(void)
{
}
void Level2_4Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu2_Display(GUI_DISP_MODE_NORMAL);
    //User_set_Num.User_Time = 0;
}
void Level2_4Menu_2Exit(void)
{}

/*设置显示*/
void Level2_4Menu_3Enter(void)
{
}
void Level2_4Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_3Exit(void)
{}
/*设定节油驾驶建议*/
void Level2_4Menu_4Enter(void)
{
}
void Level2_4Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_4Exit(void)
{}
/*tTPMS轮胎设定*/
void Level2_4Menu_5Enter(void)
{
}
void Level2_4Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_5Exit(void)
{}
/*仪表设定*/
void Level2_4Menu_6Enter(void)
{
}
void Level2_4Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_6Exit(void)
{}
//ÓïÑÔÉè¶¨Éè¶¨
void Level2_4Menu_7Enter(void)
{
}
void Level2_4Menu_7Do(void)
{
    //GUI_BG_UserSet_Menu_Display(0);
    //GUI_BG_Menu_Flag_Display(0, 6);
    //GUI_BG_UserSetMenu7_Display(0);
}
void Level2_4Menu_7Exit(void)
{}
//µ¥Î»Éè¶¨
void Level2_4Menu_9Enter(void)
{
}
void Level2_4Menu_9Do(void)
{
    //GUI_BG_UserSet_Menu_Display(0);
    //GUI_BG_Menu_Flag_Display(0, 6);
    //GUI_BG_UserSetMenu8_Display(0);
}
void Level2_4Menu_8Exit(void)
{}
//ÁÁ¶Èµ÷½Ú
void Level2_4Menu_8Enter(void)
{
}
void Level2_4Menu_8Do(void)
{
    //GUI_BG_UserSet_Menu_Display(0);
    //GUI_BG_Menu_Flag_Display(0, 6);
    //GUI_BG_UserSetMenu9_Display(0);
}
void Level2_4Menu_9Exit(void)
{}

//Ì¥Ñ¹ÏÔÊ¾½çÃæ
uint8_t TPMS_FLAG;
void Level2_7Menu_1Enter(void)
{
}
void Level2_7Menu_1Do(void)
{
    //GUI_BG_TPMS_Picture_Display(0);
    //GUI_BG_TPMS_Picture_Num_Display(0);
}
void Level2_7Menu_1Exit(void)
{
    //TPMS_FLAG = 0;
}

//Ì¥Ñ¹ÉèÖÃÑ¡Ïî
void Level2_4Menu_AEnter(void)
{
}
void Level2_4Menu_ADo(void)
{
    //GUI_BG_UserSet_Menu_Display(0);
    //GUI_BG_Menu_Flag_Display(0, 4);
    //GUI_BG_UserSetMenuA_Display(0);
}
void Level2_4Menu_AExit(void)
{
}

//Ì¥Ñ¹ÉèÖÃÏÔÊ¾½çÃæ
void Level3_4Menu_AEnter(void)
{
    //User_set_Num.User_Tpms = 0 ;             //µ±Ç°ÊÇÄÄ¸öÂÖ×Ó
    //User_set_Num.User_TpmsStatus = 0 ;       //µ±Ç°Ì¥Ñ¹Æ¥Åä½çÃæ×´Ì¬
    //User_set_Num.User_Temp_Return = 0 ;      //È¡ÏûÌ¥Ñ¹Æ¥Åä
}
void Level3_4Menu_ADo(void)
{
    //GUI_BG_TPMS_PictureSet_Display(0);
    //
    //if (User_set_Num.User_Tpms == 0x0d)
    //{
    //    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
    //}
}
void Level3_4Menu_AExit(void)
{

}
