#include "GUI.h"

#include "r_typedefs.h"
#include "loc_graphics.h"
#include "images.h"
#include "jcua.h"
#include "Watchdog.h"
#include "Menu.h"
#include "GUI_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "GaugesInterface.h"
#include "Service_TPMS.h"
#include "DisplaySch_user.h"
#include "CD4051.h"
#include "Data_Gear.h"
#include "Maintenance.h"
#include "Data_FuelConsump.h"
#include "Common_Interface.h"
#include "System_Monitor.h"
#include "Flash_synchronizer.h"
#include "Popups.h"
#include "Data_Fuel_User.h"

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_ON_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_ON_Init(void)
{
    loc_enable_mem(WET_Sprite, Calendar_Sprite);
    GUI_Display_background();
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_OFF_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_OFF_Init(void)
{
    loc_Del_Sprite(WET_Sprite, Calendar_Sprite);
    loc_free_mem(WET_Sprite, Calendar_Sprite);
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_background
 * Description    : 显示底图
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_background(void)
{
    GUI_General_Display(WET_Sprite, ditu_2, GUI_BLENDMODE_CUSTOM);
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_OftenShow_Group
 * Description    : 常显界面
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 常显功能界面均放在此处 此处显示区域 1 2 3 8
 --------------------------------------------------------------------------*/
void GUI_OftenShow_Display(void)
{
    GUI_AC_Temp_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_Time_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_Data_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_TFTTelltales_Display(GUI_DISP_MODE_NORMAL);
    GUI_WetGas_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_AdBlue_Dispaly(GUI_DISP_MODE_NORMAL);
    Gui_ODO_Display(GUI_DISP_MODE_NORMAL);
    if (1)
    {
        Gui_TRIPA_Display(GUI_DISP_MODE_NORMAL);
    }
    else
    {
        Gui_TRIPB_Display(GUI_DISP_MODE_NORMAL);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Dynamic_DIsplay
 * Description    : 常显界面
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_Dynamic_DIsplay(void)
{
    Gui_ADAS_Display(GUI_DISP_MODE_NORMAL);
    Gui_DrivingSupport_Display(GUI_DISP_MODE_NORMAL);
    Gui_Gear_Display(GUI_DISP_MODE_NORMAL);
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_AC_Temp_Dispaly
 * Description    : 室外温度显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Temp_Sprite
 --------------------------------------------------------------------------*/
void GUI_AC_Temp_Dispaly(uint8_t Mode)
{
    uint8_t AC_TEMP_value = 0u;

    AC_TEMP_value = 17u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(Temp_Sprite, CN_xiaotianqi, GUI_BLENDMODE_SRC_OVER);  /*天气图标*/
        GUI_General_Display(Temp_Sprite, CN_shiwaiwendu, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ 室外温度 ”*/

        if (1u)
        {
            GUI_Translate_Display(Temp_Sprite, Nb_12_heng, 207u, 58u, GUI_BLENDMODE_SRC_OVER); /*显示 负号*/
        }
        else
        {
            GUI_Translate_Display(Temp_Sprite, SpriteSize, 207u, 58u, GUI_BLENDMODE_SRC_OVER);
        }

        /*显示 外温 的数值*/
        GUI_General_Digit_Display(Temp_Sprite, AC_TEMP_value, Nb_12_0, 2u, 1u, GUI_DISP_AC_TEMP, 48u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(Temp_Sprite, CN_wendudanwei, GUI_BLENDMODE_SRC_OVER); /*显示 温度单位*/
    }
    else
    {
        GUI_General_Display(Temp_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Time_Dispaly
 * Description    : 时间显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Time_Sprite
 --------------------------------------------------------------------------*/
void GUI_Time_Dispaly (uint8_t Mode)
{
    uint8_t Time_Hours   = 0u;
    uint8_t Time_Minutes = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*时*/
        Time_Hours = Get_RTC_HOUR();
        if (1) /*24小时*/
        {
            if (Time_Hours == 0)
            {
                GUI_General_Digit_Display(Time_Sprite, (Time_Hours + 12u) , Nb_21_0, 2u, 1u, GUI_DISP_Hours  , 37, GUI_BLENDMODE_SRC_OVER);
            }
            else if (Time_Hours > 12u)
            {
                GUI_General_Digit_Display(Time_Sprite, (Time_Hours - 12u)  , Nb_21_0, 2u, 1u, GUI_DISP_Hours  , 37, GUI_BLENDMODE_SRC_OVER); //PM
            }
            else
            {
                GUI_General_Digit_Display(Time_Sprite, Time_Hours  , Nb_21_0, 2u, 1u, GUI_DISP_Hours  , 37, GUI_BLENDMODE_SRC_OVER); //AM
            }
        }
        else
        {
            GUI_General_Digit_Display(Time_Sprite, Time_Hours  , Nb_21_0, 2u, 1u, GUI_DISP_Hours  , 37, GUI_BLENDMODE_SRC_OVER);/*显示小时*/
        }

        /*分钟*/
        Time_Minutes = Get_RTC_MINUTE();
        GUI_General_Digit_Display(Time_Sprite, Time_Minutes, Nb_21_0, 2u, 0u, GUI_DISP_Minutes, 37, GUI_BLENDMODE_SRC_OVER);/*显示分钟*/

        if (FLASH_SYNC_1Hz)
        {
            GUI_Translate_Display(Time_Sprite, Nb_21_maohao, 396u, 45u, GUI_BLENDMODE_SRC_OVER); /*显示冒号*/
        }
        else
        {
            GUI_General_Display(Time_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(Time_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Data_Dispaly
 * Description    : 日历显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Calendar_Sprite
 --------------------------------------------------------------------------*/
void GUI_Data_Dispaly (uint8_t Mode)
{
    uint16_t Year  = 0u;/*年*/
    uint8_t Month = 0u;/*月*/
    uint8_t Date  = 0u;/*日*/
    uint8_t Week   = 0u;/*星期*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Year  = 2000 + Get_RTC_YEAR();
        Month = Get_RTC_MONTH();
        Date  = Get_RTC_DATE();
        Week  = Get_RTC_WEEK();

        GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 591u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示年份后面的 “ . ”   */
        GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 642u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示月份后面的 “ . ”   */

        GUI_General_Digit_Display(Calendar_Sprite, Year , Nb_14_0, 4u, 0u, GUI_DISP_Year, 48, GUI_BLENDMODE_SRC_OVER);/*显示年*/
        GUI_General_Digit_Display(Calendar_Sprite, Month, Nb_14_0, 2u, 0u, GUI_DISP_Month, 48, GUI_BLENDMODE_SRC_OVER); /*显示月*/
        GUI_General_Digit_Display(Calendar_Sprite, Date , Nb_14_0, 2u, 0u, GUI_DISP_Date, 48, GUI_BLENDMODE_SRC_OVER);/*显示日*/
        GUI_General_Display(Calendar_Sprite, GUIWedk[Week - 1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(Calendar_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_TFTTelltales_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_TFTTelltales_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if (1)
        {
            GUI_General_Display(WarningLight_Sprite, CN_Alarm_01, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(WarningLight_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

    }
    else
    {
        GUI_General_Display(WarningLight_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_WetGas_Dispaly
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
uint32_t HYQ_TEST = 3 ;
void GUI_WetGas_Dispaly (uint8_t Mode)
{
    uint8_t current_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        current_value = HYQ_TEST;

        GUI_General_Display(WET_Sprite, CN_qiyafuhaodeng, GUI_BLENDMODE_SRC_OVER); /*气压符号灯。*/

        if (current_value <= 17u)
        {
            GUI_General_Display(WET_Sprite, CN_qiya, GUI_BLENDMODE_SRC_OVER);  /*刷长条的气压表框。*/
        }
        else
        {
            GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

        switch (current_value)
        {
        case 0x11u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x10), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x10u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0F), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Fu :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0E), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Eu :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0D), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Du :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0C), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Cu :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0B), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Bu :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0A), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x0Au :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x09), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x09u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x08), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x08u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x07), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x07u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x06), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x06u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x05), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x05u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x04), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x04u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x03), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x03u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x02), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x02u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x01), 405u, GUI_BLENDMODE_SRC_OVER);
        case 0x01u :
            GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x00), 405u, GUI_BLENDMODE_SRC_OVER);
            break;
        default  :
            GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            break;
        }
    }
    else
    {
        GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}
/*--------------------------------------------------------------------------
 * Function Name  : GUI_AdBlue_Dispaly
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AdBlue_Dispaly (uint8_t Mode)
{
    uint8_t current_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        current_value = HYQ_TEST;

        GUI_General_Display(AdBlue_Sprite, CN_tianlanyefuhaodeng, GUI_BLENDMODE_SRC_OVER);/*AdBlue*/
        GUI_General_Display(AdBlue_Sprite, CN_tianlanye, GUI_BLENDMODE_SRC_OVER);/*框*/

        switch (current_value)
        {
        case 0x05u  :
            GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x04u), 450u, GUI_BLENDMODE_SRC_OVER);
        case 0x04u  :
            GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x03u), 450u, GUI_BLENDMODE_SRC_OVER);
        case 0x03u  :
            GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x02u), 450u, GUI_BLENDMODE_SRC_OVER);
        case 0x02u  :
            GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x01u), 450u, GUI_BLENDMODE_SRC_OVER);
        case 0x01u  :
            GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x00u), 450u, GUI_BLENDMODE_SRC_OVER);
            break;
        default :
            GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            break;
        }
    }
    else
    {
        GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_TRIPA_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_TRIPA_Display(uint8_t Mode)
{
    uint16_t TRIPA_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        TRIPA_value = Data_Read_Trip(EM_TRIP_A); /*此处TRIPA_value的值应为仪表显示的值的10倍。*/

        GUI_General_Display(TRIP_Sprite, CN_TRIP, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ TRIP ”*/
        GUI_General_Display(TRIP_Sprite, CN_TRIP_A, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ A ”*/

        GUI_Translate_Display(TRIP_Sprite, Nb_19_dian, 668u, 410u, GUI_BLENDMODE_SRC_OVER); /*显示 小数点*/

        /*显示 TRIP A 的数值*/
        GUI_General_Digit_Display(TRIP_Sprite, TRIPA_value, Nb_19_0, 5u, 3u, GUI_DISP_TRIPA, 389, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(TRIP_Sprite, CN_TRIP_danwei, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ km ”*/
    }
    else
    {
        GUI_General_Display(TRIP_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void Gui_TRIPB_Display(uint8_t Mode)
{
    uint16_t TRIPB_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        TRIPB_value = Data_Read_Trip(EM_TRIP_B); /*此处TRIPA_value的值应为仪表显示的值的10倍。*/

        GUI_General_Display(TRIP_Sprite, CN_TRIP, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ TRIP ”*/
        GUI_General_Display(TRIP_Sprite, CN_TRIP_B, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ B ”*/

        GUI_Translate_Display(TRIP_Sprite, Nb_19_dian, 668u, 410u, GUI_BLENDMODE_SRC_OVER); /*显示 小数点*/

        /*显示 TRIP B 的数值*/
        GUI_General_Digit_Display(TRIP_Sprite, TRIPB_value, Nb_19_0, 5u, 3u, GUI_DISP_TRIPA, 389, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(TRIP_Sprite, CN_TRIP_danwei, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ km ”*/
    }
    else
    {
        GUI_General_Display(TRIP_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_ODO_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_ODO_Display(uint8_t Mode)
{
    uint32_t ODO_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        ODO_value = (Data_ODO_Read() / 10); /*此处需将ODO函数返回值赋给变量，ODO函数在其他文件中实现。*/

        GUI_General_Display(ODO_Sprite, CN_ODO, GUI_BLENDMODE_SRC_OVER); /*显示文/*字 “ ODO ”*/
        GUI_General_Display(ODO_Sprite, CN_ODO_danwei, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ km ”*/
        GUI_General_Digit_Display(ODO_Sprite, ODO_value, Nb_19_0, 7u, 6u, GUI_DISP_ODO, 425, GUI_BLENDMODE_SRC_OVER);/*显示ODO的数值*/
    }
    else
    {
        GUI_General_Display(ODO_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_ADAS_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_ADAS_Display(uint8_t Mode)
{
    uint8_t ADAS_Value = 0u;
    uint8_t CanStatus1 = 0u;
    uint8_t CanStatus2 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if (K_Line_Set.K_Line_LID28 == 0x01)
        {
            CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF02FA0_Msg_Count);
            CanStatus2 = CAN_MSG_Status(ID_CanMsg0CF02F2A_Msg_Count);

            if ((CanStatus1 == CAN_SIG_LOST) && (CanStatus2 == CAN_SIG_LOST))
            {
                GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                /*刷文字“ADAS”：*/
                GUI_General_Display(ADAS_Sprite, CN_ADAS_wenzi, GUI_BLENDMODE_SRC_OVER);
                /*刷4个绿色的边框框角：*/
                GUI_General_Display(ADAS_Sprite, CN_jiao1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao4, GUI_BLENDMODE_SRC_OVER);

                if (1)
                {
                    if (FLASH_SYNC_1Hz)
                    {
                        /*车*/
                        GUI_General_Display(ADAS_Sprite, CN_che_shanshuo, GUI_BLENDMODE_SRC_OVER);
                        /*道*/
                        GUI_General_Display(ADAS_Sprite, CN_Road4_shanshuo, GUI_BLENDMODE_SRC_OVER);
                        GUI_General_Display(ADAS_Sprite, CN_Road3_shanshuo, GUI_BLENDMODE_SRC_OVER);
                        GUI_General_Display(ADAS_Sprite, CN_Road2_shanshuo, GUI_BLENDMODE_SRC_OVER);
                        GUI_General_Display(ADAS_Sprite, CN_Road1_shanshuo, GUI_BLENDMODE_SRC_OVER);
                    }
                    else
                    {
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else  if (0)
                {
                    /*车*/
                    GUI_General_Display(ADAS_Sprite, CN_che, GUI_BLENDMODE_SRC_OVER);

                    /*道*/
                    ADAS_Value = 2u;
                    switch (ADAS_Value)
                    {
                    case 4u: GUI_General_Display(ADAS_Sprite, CN_Road4, GUI_BLENDMODE_SRC_OVER);
                    case 3u: GUI_General_Display(ADAS_Sprite, CN_Road3, GUI_BLENDMODE_SRC_OVER);
                    case 2u: GUI_General_Display(ADAS_Sprite, CN_Road2, GUI_BLENDMODE_SRC_OVER);
                    case 1u: GUI_General_Display(ADAS_Sprite, CN_Road1, GUI_BLENDMODE_SRC_OVER);
                        break;
                    default :
                        break;
                    }
                }
                else
                {

                }
            }
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

        /*左车道线*/
        if (FLASH_SYNC_1Hz == 0)
        {
            GUI_General_Display(ADAS_Sprite, CN_LeftRoad, GUI_BLENDMODE_SRC_OVER);/*绿*/
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, CN_LeftRoad_shanshuo, GUI_BLENDMODE_SRC_OVER);/*虚*/
        }

        /*右车道线*/
        if (FLASH_SYNC_1Hz == 0)
        {
            GUI_General_Display(ADAS_Sprite, CN_RightRoad, GUI_BLENDMODE_SRC_OVER);/*绿*/
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, CN_RightRoad_shanshuo, GUI_BLENDMODE_SRC_OVER);/*虚*/
        }

        /*左叹号*/
        if (FLASH_SYNC_1Hz)
        {
            GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 125u, 257u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
        /*右叹号*/
        if (FLASH_SYNC_1Hz)
        {
            GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 339u, 257u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_DrivingSupport_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_DrivingSupport_Display(uint8_t Mode)
{
    uint8_t Veh_Seep_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*定速巡航图标*/
        GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);

        //显示km/h，显示设定车速:
        GUI_General_Digit_Display(Cruise_Sprite, Veh_Seep_Value, Nb_21_0, 3u, 2u, GUI_DISP_DrivingSupport, 104u, GUI_BLENDMODE_SRC_OVER);/*显示 定速巡航设定车速 的数值*/
        GUI_General_Display(Cruise_Sprite, CN_dingsuxunhangdanwei, GUI_BLENDMODE_SRC_OVER); //显示文字 “ km/h ”
    }
    else
    {
        GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_Gear_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_Gear_Display(uint8_t Mode)
{
    uint8_t Gear_Value = 0u;
    uint8_t Manouvering_Mode = 0u;
    uint8_t Transmission_Sift_Mode = 0u;
    uint8_t Current_Gear = 0u;
    uint8_t Temp = 0u;
    uint8_t Automatic_or_Manual_Mode = 0u;
    uint8_t CanStatus1 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*G1 自动挡 EOL设定为ZF变速器*/
        if (K_Line_Set.K_Line_LID41 == 0x13u)
        {
            Manouvering_Mode = Get_ID_18FF8503_Sig_Manouvering_mode();
            Transmission_Sift_Mode = Get_ID_18FE4A03_Sig_TransmissionSiftMode1_Indicator();
            Current_Gear = Get_ID_18F00503_Sig_Current_Gear();

            Temp = Current_Gear - 0x7Eu;
            if ((Current_Gear >= 0x7Eu) && (Current_Gear <= 0x89u))
            {
                if ((Current_Gear == 0x7Eu) && (Manouvering_Mode == 0x01u))
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_DM, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, GUIGear[Temp], GUI_BLENDMODE_SRC_OVER);/*1-12*/
                }
            }
            else if (Current_Gear == 0x7Bu)
            {
                GUI_General_Display(Gear_Sprite, CN_dangwei_R2, GUI_BLENDMODE_SRC_OVER);/*R2*/
            }
            else if (Current_Gear == 0x7Cu)
            {
                if (Manouvering_Mode == 0x01u)
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_RM, GUI_BLENDMODE_SRC_OVER);/*RM*/
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_R1, GUI_BLENDMODE_SRC_OVER);/*R1*/
                }
            }
            else if (Current_Gear == 0x7Du)
            {
                if (Transmission_Sift_Mode == 0x01u)
                {
                    if (FLASH_SYNC_1Hz)
                    {
                        GUI_General_Display(Gear_Sprite, CN_dangwei_E, GUI_BLENDMODE_SRC_OVER);/*E*/
                    }
                    else
                    {
                        GUI_General_Display(Gear_Sprite, CN_dangwei_NE, GUI_BLENDMODE_SRC_OVER);/*NE*/
                    }
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_N, GUI_BLENDMODE_SRC_OVER);/*N*/
                }
            }
            else
            {
                GUI_General_Display(Gear_Sprite, CN_dangwei_buming, GUI_BLENDMODE_SRC_OVER);/*-*/
            }
        }
        else
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER); /*K未配*/
        }

        /*G2*/
        Automatic_or_Manual_Mode = Get_ID_18FF8503_Sig_Automatic_or_Manual_Mode();

        CanStatus1 = CAN_MSG_Status(ID_CanMsg18FF8503_Msg_Count);
        if (CanStatus1 == CAN_SIG_LOST)
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
        else if (Automatic_or_Manual_Mode == 0x00u)
        {
            GUI_General_Display(Gear_Sprite, CN_MANUAL, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AVG_FuelSpeed_Display
 * Description    : 平均车速，平局油耗
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {

    }
    else  if (Mode == GUI_DISP_MODE_BLANK)
    {
        switch (0u)
        {
        case 0 :
            GUI_Translate_Display(MultiPurpose_Sprite   , CN_TRIP,   400u, 217u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite   , CN_TRIP_A, 475u, 223u, GUI_BLENDMODE_SRC_OVER);
            break;
        case 1 :
            GUI_Translate_Display(MultiPurpose_Sprite   , CN_TRIP,   400u, 217u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite   , CN_TRIP_B, 475u, 223u, GUI_BLENDMODE_SRC_OVER);
            break;
        default    :
            break;
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Drive_Info_Avg_Speed_Display
 * Description    : 平均车速
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Drive_Info_Avg_Speed_Display(uint8_t Valid, uint16_t Speed)
{
    uint8_t CanStatus1 = 0u;

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count) ;

    if (CanStatus1 == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
#if 0
        /*单位切换*/
        if (User_App.User_Company == 1)
            TFT_LCD_Display_Sprite(LAYER_Trip5, SN_D_05_X386_Y188_png,  386, 188, 64); /*km/H*/
        else
        {
            if (Speed == TRAPB)    /*Trip B*/
                TFT_LCD_Display_Sprite(LAYER_Trip5, SN_D_06_X386_Y188_png,  386, 188, 64); /*MPH*/
            else                   /*Trip A ODO*/
                TFT_LCD_Display_Sprite(LAYER_Trip5, SN_D_06_X386_Y188_png,  386, 188, 64); /*MPH*/
        }

        /*是否有效*/
        if (User_App.User_Company == 1)
        {
            if (Speed == TRAPB)    /*Trip B*/
            {
                if (User_ECU.TripB_Average_Speed < 1000 )
                {
                    GUI_General_Digit_Display(User_ECU.TripB_Average_Speed / 10, DIGIT_FIVE_WHITE, 4, 3, LAYER_NUMT_1, GUIBGAVGSpeedPosX, 180, 64);
                }
                else
                {
                    TFT_LCD_Display_Sprite(LAYER_NUMT_1, SN_Number_05_white_Line_png,  343, 180, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMT_2, SN_Number_05_white_Line_png,  363, 180, 64);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_3);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_4);
                }
            }
            else
            {
                if (User_ECU.TripA_Average_Speed < 1000)
                {
                    GUI_General_Digit_Display(User_ECU.TripA_Average_Speed / 10, DIGIT_FIVE_WHITE, 4, 3, LAYER_NUMT_1, GUIBGAVGSpeedPosX, 180, 64);
                }
                else
                {
                    TFT_LCD_Display_Sprite(LAYER_NUMT_1, SN_Number_05_white_Line_png,  343, 180, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMT_2, SN_Number_05_white_Line_png,  363, 180, 64);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_3);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_4);
                }
            }
        }
        else
        {
            if (Speed == TRAPB)    /*Trip B*/
            {
                if (User_ECU.TripB_Average_Speed < 1000)
                {
                    GUI_General_Digit_Display(User_ECU.TripB_Average_Speed / 10, DIGIT_FIVE_WHITE, 4, 3, LAYER_NUMT_1, GUIBGAVGSpeedPosX, 180, 64);
                }
                else
                {
                    TFT_LCD_Display_Sprite(LAYER_NUMT_1, SN_Number_05_white_Line_png,  343, 180, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMT_2, SN_Number_05_white_Line_png,  363, 180, 64);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_3);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_4);
                }
            }
            else
            {
                if (User_ECU.TripA_Average_Speed < 1000)
                {
                    GUI_General_Digit_Display(User_ECU.TripA_Average_Speed / 10, DIGIT_FIVE_WHITE, 4, 3, LAYER_NUMT_1, GUIBGAVGSpeedPosX, 180, 64);
                }
                else
                {
                    TFT_LCD_Display_Sprite(LAYER_NUMT_1, SN_Number_05_white_Line_png,  343, 180, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMT_2, SN_Number_05_white_Line_png,  363, 180, 64);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_3);
                    TFT_LCD_Clear_Layer(LAYER_NUMT_4);
                }
            }
        }
#endif
    }
}
/*--------------------------------------------------------------------------
 * Function Name  : GUI_Drive_Info_Avg_Fuel_Display
 * Description    : 平均油耗
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Drive_Info_Avg_Fuel_Display(uint8_t Valid, uint16_t Fuel)
{
    uint8_t CanStatus1 = 0u;

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count) ;

    if (CanStatus1 == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
#if 0
        /*单位切换*/
        if (User_App.User_Company == 1)
            TFT_LCD_Display_Sprite(LAYER_Trip3, SN_D_04_X386_Y152_png, 386, 152, 64);   //L/km
        else
        {
            if (Fuel == TRAPB)    //Trip B
                TFT_LCD_Display_Sprite(LAYER_Trip3, SN_D_07_X386_Y152_png, 386, 156, 64);   //MPG
            else                  //Trip A ODO
                TFT_LCD_Display_Sprite(LAYER_Trip3, SN_D_07_X386_Y152_png, 386, 156, 64);   //L/m
        }

        TFT_LCD_Display_Sprite(LAYER_NUMO_5, SN_Number_05_white_Point_png, 354, 140, 64); //top

        if (User_App.User_Company == 1)
        {
            if (Fuel == TRAPB)   //Trip B
            {
                if (User_ECU.TripB_Fuel > 1000)
                {
                    GUI_General_Digit_Display((1000000 / User_ECU.TripB_Fuel), DIGIT_FIVE_WHITE, 4, 2, LAYER_NUMO_1, GUIBGAVGFuelPosX, 140, 64); //L/100km
                }
                else
                {
                    TFT_LCD_Clear_Layer(LAYER_NUMO_4);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_3, SN_Number_05_white_Line_png,  314, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_2, SN_Number_05_white_Line_png,  334, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_1, SN_Number_05_white_Line_png,  363, 140, 64);
                }
            }
            else
            {
                if (User_ECU.TripA_Fuel > 1000)
                {
                    GUI_General_Digit_Display((1000000 / User_ECU.TripA_Fuel), DIGIT_FIVE_WHITE, 4, 2, LAYER_NUMO_1, GUIBGAVGFuelPosX, 140, 64); //L/100km
                }
                else
                {
                    TFT_LCD_Clear_Layer(LAYER_NUMO_4);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_3, SN_Number_05_white_Line_png,  314, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_2, SN_Number_05_white_Line_png,  334, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_1, SN_Number_05_white_Line_png,  363, 140, 64);
                }
            }
        }
        else
        {
            if (Fuel == TRAPB)   //Trip B           //ÏµÊý1.069
            {
                if (User_ECU.TripB_Fuel > 1000)
                {
                    GUI_General_Digit_Display(((1000000 / User_ECU.TripB_Fuel) * 1069 / 1000), DIGIT_FIVE_WHITE, 4, 2, LAYER_NUMO_1, GUIBGAVGFuelPosX, 140, 64); //MPG
                }
                else
                {
                    TFT_LCD_Clear_Layer(LAYER_NUMO_4);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_3, SN_Number_05_white_Line_png,  314, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_2, SN_Number_05_white_Line_png,  334, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_1, SN_Number_05_white_Line_png,  363, 140, 64);
                }
            }
            else                //Trip A ODO
            {
                if (User_ECU.TripB_Fuel > 1000)
                {
                    GUI_General_Digit_Display((10 / User_ECU.TripA_Fuel), DIGIT_FIVE_WHITE, 4, 2, LAYER_NUMO_1, GUIBGAVGFuelPosX, 140, 64);     //L/m
                }
                else
                {
                    TFT_LCD_Clear_Layer(LAYER_NUMO_4);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_3, SN_Number_05_white_Line_png,  314, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_2, SN_Number_05_white_Line_png,  334, 140, 64);
                    TFT_LCD_Display_Sprite(LAYER_NUMO_1, SN_Number_05_white_Line_png,  363, 140, 64);
                }
            }
        }
#endif
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Battery_Display_Display
 * Description    : 电池电量
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Battery_Display_Display(uint8_t Mode)
{
    uint8_t current_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_tubiao, GUI_BLENDMODE_SRC_OVER); /*电池*/
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_kedu, GUI_BLENDMODE_SRC_OVER);/*标尺*/
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_L, GUI_BLENDMODE_SRC_OVER);/*L*/
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_H, GUI_BLENDMODE_SRC_OVER);/*H*/

        current_value = HYQ_TEST;
        switch (current_value)
        {
        case  0x0Du :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x0Cu), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x0Cu :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x0Bu), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x0Bu :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x0Au), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x0Au :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x09u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x09u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x08u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x08u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x07u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x07u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x06u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x06u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x05u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x05u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x04u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x04u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x03u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x03u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x02u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x02u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x01u), 276u, GUI_BLENDMODE_CUSTOM);
        case  0x01u :
            GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge1, (536 + 17u * 0x00u), 276u, GUI_BLENDMODE_CUSTOM);
            break;
        default :
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            break;
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}


/*--------------------------------------------------------------------------
 * Function Name  : GUI_DPD_Display_Display
 * Description    : DPD
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_DPD_Display_Display(uint8_t Mode)
{
    uint16_t value = 0u;
    //value = AUXIO_DPF_Status * 20 / 5;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if ((K_Line_Set.K_Line_LID33 == 0x00u) || (K_Line_Set.K_Line_LID33 == 0x01u))
        {
            value = HYQ_TEST;

            if (1)
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_duijiliang, GUI_BLENDMODE_SRC_OVER); /*DPD堆积绿*/
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zaishengjindu, GUI_BLENDMODE_SRC_OVER); /*DPD再生黄*/
            }

            GUI_General_Display(MultiPurpose_Sprite, CN_DPD_L, GUI_BLENDMODE_SRC_OVER); /*L*/
            GUI_General_Display(MultiPurpose_Sprite, CN_DPD_H, GUI_BLENDMODE_SRC_OVER); /*H*/

            if ((value >= 0u) && (value <= 100u))
            {
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value > 100u) && (value <= 200u))
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value > 200u) && (value <= 300u))
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value > 300u) && (value <= 450u))
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value > 450u) && (value <= 600u))
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge4, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value > 600u) && (value <= 1000u))
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge4, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge5, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Time_OilTemp_Display
 * Description    : 发动机转速时间-油温
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Time_OilTemp_Display(uint8_t Mode)
{
    uint32_t Temp = 0;
    uint8_t CanStatus1 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Temp = Get_ID_18FEE518_Sig_Total_Engine_Hours() ;
        CanStatus1 = CAN_MSG_Status(ID_CanMsg18FEE518_Msg_Count);

        /*时间*/
        GUI_General_Display(MultiPurpose_Sprite, CN_Time_wenzi, GUI_BLENDMODE_SRC_OVER);/*时间*/
        GUI_General_Display(MultiPurpose_Sprite, CN_Time_danwei, GUI_BLENDMODE_SRC_OVER);/*H*/

        if (CanStatus1 == CAN_SIG_LOST)
        {
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
        else  if (Temp <= 0xFAFFFFFFu)
        {
            Temp = Temp / 20u;

            if (Temp >= 9999999u)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, 9999999u, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER);/*显示ODO的数值*/
            }
            else
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, Temp, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER);/*显示ODO的数值*/
            }

            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM);/*点*/
        }
        else
        {
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 592u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 613u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 634u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 655u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 676u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 697u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 729u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM);/*点*/
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Time_OilTemp_OFF_Display
 * Description    : OFF-发动机转速时间显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {

    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Year_Month_Data_Display
 * Description    : 年月日显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Year_Month_Data_Display(uint8_t Mode)
{
    uint8_t Time_Hours   = 0u;
    uint8_t Time_Minutes = 0u;
    uint8_t Month = 0u;/*月*/
    uint8_t Date  = 0u;/*日*/
    uint8_t Week   = 0u;/*星期*/
    uint16_t Year  = 0u;/*年*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Year  = 2000 + Get_RTC_YEAR();
        Month = Get_RTC_MONTH();
        Date  = Get_RTC_DATE();
        /*年月日*/
        if (1)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian  , GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue   , GUI_BLENDMODE_SRC_OVER); /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri    , GUI_BLENDMODE_SRC_OVER); /*日*/

            GUI_General_Digit_Display(MultiPurpose_Sprite, Year , Nb_17_0, 4u, 0u, GUI_DISP_MENUYear  , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date , Nb_17_0, 2u, 1u, GUI_DISP_MENUDate  , 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*月日年*/
        else if (0)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian  , GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue   , GUI_BLENDMODE_SRC_OVER); /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri    , GUI_BLENDMODE_SRC_OVER); /*日*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Year , Nb_17_0, 4u, 1u, GUI_DISP_MENUYear1  , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth1 , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date , Nb_17_0, 2u, 1u, GUI_DISP_MENUDate1  , 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*日月年*/
        else
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian  , GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue   , GUI_BLENDMODE_SRC_OVER); /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri    , GUI_BLENDMODE_SRC_OVER); /*日*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Year , Nb_17_0, 4u, 1u, GUI_DISP_MENUYear1  , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUDate1  , 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date , Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth1 , 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*星期 */
        Week  = Get_RTC_WEEK();
        GUI_General_Display(MultiPurpose_Sprite, CN_kuohao, GUI_BLENDMODE_SRC_OVER); /*括号*/
        GUI_General_Display(MultiPurpose_Sprite, GUIMenuWedk[Week - 1u], GUI_BLENDMODE_CUSTOM);

        Time_Hours = Get_RTC_HOUR();
        /*时间*/
        if (1)
        {
            if (Time_Hours < 12 )
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_AM, GUI_BLENDMODE_SRC_OVER);   /*AM*/
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PM, GUI_BLENDMODE_SRC_OVER);   /*PM*/
            }

            if (Time_Hours == 0)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, (Time_Hours + 12u) , Nb_17_0, 2u, 1u, GUI_DISP_MENUHours  , 279u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (Time_Hours > 12)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, (Time_Hours - 12u) , Nb_17_0, 2u, 1u, GUI_DISP_MENUHours  , 279u, GUI_BLENDMODE_SRC_OVER); /*PM*/
            }
            else
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Hours , Nb_17_0, 2u, 1u, GUI_DISP_MENUHours  , 279u, GUI_BLENDMODE_SRC_OVER);     /*AM*/
            }
        }
        else
        {
            GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Hours , Nb_17_0, 2u, 1u, GUI_DISP_MENUHours  , 279u, GUI_BLENDMODE_SRC_OVER);
        }

        Time_Minutes = Get_RTC_MINUTE();
        GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Minutes, Nb_17_0, 2u, 0u, GUI_DISP_MENUMinutes, 279u, GUI_BLENDMODE_SRC_OVER);/*分钟*/

        GUI_Translate_Display(MultiPurpose_Sprite, Nb_17_maohao, 592u, 282u, GUI_BLENDMODE_CUSTOM);/*冒号*/
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_block_NULL_Display
 * Description    : 年月日显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_block_NULL_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MultiPurpose_Sprite, Nb_12_dian, 801u, 481u, GUI_BLENDMODE_CUSTOM);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu_Display
 * Description    : 年月日显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu_Display(uint8_t Mode)
{
    /*显示*/
    GUI_General_Display(MENU_Sprite, CN_User_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
    GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER); /*line*/
    GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER); /*长度条*/
#if 0
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER); /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER); /*长度条*/

        if ((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2MENU_5))
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_1 )
            {
                if (1) /*有故障码*/
                {
                    GUI_General_Display(MultiPurpose_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(MultiPurpose_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);
                }
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_2)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_5,  SN_Set_Menu1_02_Word0_01Black_png + State_Flag.Sig.FState_WXTZ, 126,  73, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_3)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_6,  SN_Set_Menu1_03_Word0_01Black_png + State_Flag.Sig.FState_WXSD, 126, 101, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_4)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_7,  SN_Set_Menu1_04_Word0_01Black_png + State_Flag.Sig.FState_YHSD, 126, 129, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_7)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_8,  SN_Set_Menu1_18_Word0_01Black_png + State_Flag.Sig.FState_TPMS, 126, 157, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_5)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_9,  SN_Set_Menu1_05_Word0_01Black_png + State_Flag.Sig.FState_ECO,  126, 185, 64);
        }
        else
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_2)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_4,  SN_Set_Menu1_02_Word0_01Black_png + State_Flag.Sig.FState_WXTZ, 126, 45, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_3)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_5,  SN_Set_Menu1_03_Word0_01Black_png + State_Flag.Sig.FState_WXSD, 126, 73, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_4)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_6,  SN_Set_Menu1_04_Word0_01Black_png + State_Flag.Sig.FState_YHSD, 126, 101, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_7)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_7,  SN_Set_Menu1_18_Word0_01Black_png + State_Flag.Sig.FState_TPMS, 126, 129, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_5)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_8,  SN_Set_Menu1_05_Word0_01Black_png + State_Flag.Sig.FState_ECO,  126, 157, 64);
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_6)
                TFT_LCD_Display_Sprite(LAYER_G3_D2_9,  SN_Set_Menu1_06_Word0_01Black_png + State_Flag.Sig.FState_SYSYS, 126, 185, 64);
        }
    }
    else
    {
        TFT_LCD_Clear_Multi_Layer(LAYER_G3_D1, LAYER_G3_D2_2);
    }
#endif
}






void GUI_Test_Dispaly (uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {

    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        //GUI_General_Digit_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}