﻿
#ifndef GUI_H_
#define GUI_H_

#include "loc_graphics.h"
#include "images.h"
#include "TYW_stdint.h"

static const uint32_t GUIWedk[7u] = {CN_xingqiyi, CN_xingqier, CN_xingqisan, CN_xingqisi, CN_xingqiwu, CN_xingqiliu, CN_xingqiri};
static const uint32_t GUIGear[12u] = {CN_dangwei_01, CN_dangwei_02, CN_dangwei_03, CN_dangwei_04, CN_dangwei_05, CN_dangwei_06,
                                      CN_dangwei_07, CN_dangwei_08, CN_dangwei_09, CN_dangwei_10, CN_dangwei_11, CN_dangwei_12
                                     };
static const uint32_t GUIMenuWedk[7u] = {CN_Mon, CN_Tue, CN_Wed, CN_Thu, CN_Fri, CN_Sat, CN_ri};

static const uint16_t GUI_DISP_AC_TEMP[2]           = {229u, 216u}; /*室外温度数字显示*/
static const uint16_t GUI_DISP_Hours[2]             = {370u, 349u};
static const uint16_t GUI_DISP_Minutes[2]           = {428u, 406u};
static const uint16_t GUI_DISP_Year[4]              = {568u, 552u, 538u, 522u};
static const uint16_t GUI_DISP_Month[2]             = {617u, 604u};
static const uint16_t GUI_DISP_Date[2]              = {669u, 653u};
static const uint16_t GUI_DISP_TRIPA[5]             = {676u, 648u, 629u, 610u, 591u};             /*TRIP*/
static const uint16_t GUI_DISP_ODO[7]               = {676u, 657u, 638u, 619u, 600u, 581u, 562u};     /*ODO*/
static const uint16_t GUI_DISP_DrivingSupport[3]    = {481u, 459u, 436u};                        /*定速巡航*/
static const uint16_t GUI_DISP_OILTEMP[7]           = {729u, 697u, 676u, 655u, 634u, 613u, 592u}; /*油温时间*/
static const uint16_t GUI_DISP_MENUHours[2]         = {578u, 560u};
static const uint16_t GUI_DISP_MENUMinutes[2]       = {623u, 605u};
static const uint16_t GUI_DISP_MENUYear[4]          = {495u, 477u, 459u, 441u};     /*年月日*/
static const uint16_t GUI_DISP_MENUMonth[2]         = {572u, 554u};
static const uint16_t GUI_DISP_MENUDate[2]          = {648u, 630u};
static const uint16_t GUI_DISP_MENUYear1[4]         = {568u, 552u, 538u, 522u};    /*月日年*/
static const uint16_t GUI_DISP_MENUMonth1[2]        = {617u, 604u};
static const uint16_t GUI_DISP_MENUDate1[2]         = {669u, 653u};

extern void GUI_Display_KL15_ON_Init(void);
extern void GUI_Display_KL15_OFF_Init(void);
extern void GUI_Display_background(void); /*刷底图*/
extern void GUI_OftenShow_Display(void);  /*常显界面*/
extern void GUI_Dynamic_DIsplay(void);

void GUI_AC_Temp_Dispaly(uint8_t Mode);                               /*室外温度显示*/
void GUI_Time_Dispaly(uint8_t Mode);                                  /*时间显示*/
void GUI_Data_Dispaly(uint8_t Mode);                                  /*日历显示*/
void GUI_TFTTelltales_Display(uint8_t Mode);                          /*TFT指示灯*/
void GUI_WetGas_Dispaly(uint8_t Mode);                                /*wet气压*/
void GUI_AdBlue_Dispaly(uint8_t Mode);                                /**/
void Gui_TRIPA_Display(uint8_t Mode);                                 /*TRIPA*/
void Gui_TRIPB_Display(uint8_t Mode);                                 /*TRIPB*/
void Gui_ODO_Display(uint8_t Mode);                                   /*ODO*/
void Gui_ADAS_Display(uint8_t Mode);                                  /*ADAS*/
void Gui_DrivingSupport_Display(uint8_t Mode);                        /*定速巡航*/
void Gui_Gear_Display(uint8_t Mode);                                  /*挡位*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode);                         /*平均车速，平均油耗*/
void GUI_Drive_Info_Avg_Speed_Display(uint8_t Valid, uint16_t Speed); /*平均车速*/
void GUI_Drive_Info_Avg_Fuel_Display(uint8_t Valid, uint16_t Fuel);   /*平均油耗*/
void GUI_Battery_Display_Display(uint8_t Mode);                       /*电池电量*/
void GUI_DPD_Display_Display(uint8_t Mode);                           /*DPD*/
void GUI_Time_OilTemp_Display(uint8_t Mode);                          /*转速时间-油温*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode);                      /*OFF 转速时间-油温*/
void GUI_Year_Month_Data_Display(uint8_t Mode);                       /*年月日*/
void GUI_block_NULL_Display(uint8_t Mode);/**/
void GUI_BG_Menu_Display(uint8_t Mode);/*菜单项*/

void GUI_Test_Dispaly(uint8_t Mode);

#endif
