


#ifndef _POPUP_SCHEDULER_H_
#define _POPUP_SCHEDULER_H_

#include "TYW_stdint.h"

/******************************************************************************
����״̬����
******************************************************************************/
#define   POPUP_STATUS_OFF                      0x00u
#define   POPUP_STATUS_NEW                      0x01u
#define   POPUP_STATUS_FIRST                    0x02u
#define   POPUP_STATUS_LOOP                     0x03u
#define   POPUP_STATUS_MASKED                   0x04u
#define   POPUP_STATUS_DELETE                   0x05u
#define   POPUP_STATUS_CLEAR                    0x06u

/******************************************************************************
�����л��ȼ�
******************************************************************************/
#define   POPUP_CUT_NOT                         0x00u
#define   POPUP_CUT_IMMEDIATELY                 0x01u
#define   POPUP_CUT_WAIT_TIME_MIN               0x02u
#define   POPUP_CUT_WAIT_TIME_NORMAL            0x03u

/******************************************************************************
������������
******************************************************************************/
#define   POPUP_DEFINE_FIRST_DISPLAY            0u    /*�״���ʾ��POPUP_CUT_WAIT_TIME_MIN��POPUP_CUT_WAIT_TIME_NORMAL�л���Ҫ�ȴ������������л�*/
#define   POPUP_SAME_CLASS_CUT_IMMEDIATELY      1u     /*ͬ���͵���Ϣ����������ϣ���Ҫ������*/
#define   POPUP_HIGH_CUT_LOW_TYPE_IMMEDIATELY   1u      /*���͸�����������͵ͣ�=1ʹ�ܣ�=0��ʹ��*/
#define   POPUP_HINT_CUT_HINT_IMMEDIATELY       0u      /*��ʾ����Ϣ���������ʾ����Ϣ��=1ʹ�ܣ�=0��ʹ��*/
#define   POPUP_WARNING_CUT_HINT_MIN            0u      /*��������Դ����ʾ�࣬����Ҫ�ȴ���Сʱ�䣺=1ʹ�ܣ�=0��ʹ��*/
#define   POPUP_CUT_RECOVER                     1u      /*����ϵ���Ϣ���ָ���ʾʱ�������Ӵ˿�ʼ��ʾ*/
#define   POPUP_DISP_TIME_NORMAL                3u*10u  /*unit = 100ms*/
#define   POPUP_DISP_TIME_MIN                   8u  /*unit = 100ms*/

/******************************************************************************
��ѯģʽ����
******************************************************************************/
#define   POPUP_POLLING_FORWARD                 0x00u
#define   POPUP_POLLING_REVERSE                 0x01u

/******************************************************************************
������ȼ���
******************************************************************************/
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_FATAL

/******************************************************************************
������Ϣ���Ƚṹ
******************************************************************************/
typedef struct
{
    uint8_t   Timer;
    uint16_t   NewPopupID;
    uint16_t   PollPopupID;
    uint8_t   CutGrade;
    uint16_t   CurPopupID;
    uint8_t   CurStatus;
    uint8_t   SndReqCode;
    uint16_t   CurMaskedID;
    uint8_t   WarningExist;
} PopupSchedulingStruct;

/******************************************************************************
��������
******************************************************************************/

/**********************************************************************************************************
 *@Function:    Popup_Scheduler_Init
 *@Description: ��ʼ��������Ϣ������
 *@Input:             MY_MemInit / CommMemInit
 *@Output:          none.
 *@Calls:           none.
 *@Return:          none.
 *@Note:            �����ڴ����������Ҫ�������Ӳ����ʼ��֮ǰ�����г�ʼ������
 **********************************************************************************************************/
void Popup_Scheduler_Init ( void );

/**********************************************************************************************************
 *@Function:        Popup_Scheduler_OFF
 *@Description:     ���ٴ��ڵ��������ָ�Ϊ��ʼ��״̬
 *@Input:           MY_MemInit / CommMemInit
 *@Output:          none.
 *@Calls:           none.
 *@Return:          none.
 *@Note:            none.
 **********************************************************************************************************/
void Popup_Scheduler_OFF ( void );

/**********************************************************************************************************
 *@Function:        Popup_Scheduling_Service
 *@Description:   ���ȵ�����Ϣ�����µ�ǰ��ʾ����Ϣ����,�ӿں���
 *                        ���ܷ����л���������
 *                        1����ǰ��ʾ��Ϣ��ɾ��/����
 *                        2���������ȼ��ߵ�����Ϣ
 *                        3����ʾʱ�䵽
 *@Input:               CommMemInit
 *@Output:            none.
 *@Calls:             none
 *@Return:            none
 *@Note:              �÷���������ÿ100ms������һ��
 **********************************************************************************************************/
void Popup_Scheduling_Service ( void );

/**********************************************************************************************************
 *@Function:        Popup_Request
 *@Description:   ��Ϣ�������󣬰���ȫ�����ͣ��ӿں���
 *@Input:               uint8_t PopupID -- ������Ϣ��ID.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
void Popup_Request ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:        Popup_Mask_Request
 *@Description:   ���ε����ࣨ�����ࣩ��Ϣ��ֻ����ʾ���Ĳſ��Ա�����
 *                ***********����ȫ����ʾ����***************
 *@Input:               none.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
void Popup_Mask_Request ( void );

/**********************************************************************************************************
 *@Function:    Popup_Del_Masked_Request
 *@Description: ��IGN_OFFʱ����Ҫ�����ι��ı�����Ϣ��ʾ���������������ٴ���ʾ��������
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        Ŀǰ��������Ϣ��״̬�л�Ϊѭ����ʾ״̬.
 **********************************************************************************************************/
void Popup_Del_Masked_Request ( void );

/**********************************************************************************************************
 *@Function:        Popup_Get_Status
 *@Description:   ��ȡ��ѯ��Ϣ��״̬
 *@Input:               uint8_t PopupID -- ������Ϣ��ID
 *@Output:            none.
 *@Calls:             PopupList_Select
 *@Return:            POPUP_STATUS_OFF -- ����Ϣ������Ҫ��ʾ
 *                POPUP_STATUS_FIRST -- ����Ϣ��һ����ʾ
 *                POPUP_STATUS_LOOP -- ����Ϣ������ѯ��ʾ��
 *                POPUP_STATUS_MASKED -- ����Ϣ������
 *                POPUP_STATUS_DELETE -- ����Ϣ�ȴ���ɾ��
 *                POPUP_STATUS_CLEAR -- ����Ϣ���ϱ�ɾ��
 *@Note:              none.
 **********************************************************************************************************/
uint8_t Popup_Get_Status ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:        Popup_Get_Current_Message
 *@Description:   ��ȡ��ǰ��Ϣ�����ֱ��
 *@Input:               none.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
uint16_t Popup_Get_Current_Message ( void );

/**********************************************************************************************************
 *@Function:        Popup_Get_Current_Sound
 *@Description:   ��ȡ��ǰ��Ϣ���������
 *@Input:               none.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              ����������Ӱ�������ĳ����Լ��Ƿ���
 **********************************************************************************************************/
uint8_t Popup_Get_Current_Sound ( void );

/**********************************************************************************************************
 *@Function:        Popup_Get_Current_Sound_Req_Code
 *@Description:   ��ȡ��ǰ��Ϣ������������
 *@Input:               none.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              ����������Ӱ�������ĳ����Լ��Ƿ���
 **********************************************************************************************************/
uint8_t Popup_Get_Current_Sound_Req_Code ( void );

/**********************************************************************************************************
 *@Function:        Popup_Delete
 *@Description:   �����ǰ��ʾ��Ϣ������ǵ�һ����ʾ��Ҫ�ȴ�Tmin���ڶ�����Ϣ����ʾ�ࣩ���⣩
 *@Input:               uint8_t PopupID -- ������Ϣ��ID
 *@Output:            FatalListHead/HintListHead/WarningListHead/ExceptionListHead -- ������
 *@Calls:             PopupList_Select / PopupList_Delete
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
void Popup_Delete ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:        Popup_Clear
 *@Description:   �����ǰ��ʾ��Ϣ������Ҫ�ȴ�Tmin
 *@Input:               uint8_t PopupID -- ������Ϣ��ID
 *@Output:            FatalListHead/HintListHead/WarningListHead/ExceptionListHead -- ������
 *@Calls:             PopupList_Select / PopupList_Delete
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
void Popup_Clear ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:        Popup_Get_Warning_Status
 *@Description:   ��ѯ�Ƿ���ڱ�������Ϣ/�����ǻ�ȡ��ʾ������Ϣ�£��Ƿ���ڱ�������Ϣ
 *@Input:               none
 *@Output:            none
 *@Calls:             none
 *@Return:            TRUE --���ڱ�������Ϣ
 *                FALSE -- �����ڱ�������Ϣ
 *@Note:              none.
 **********************************************************************************************************/
uint8_t Popup_Get_Warning_Status ( void );

/**********************************************************************************************************
 *@Function:        Popup_Get_Masked_Warning_Msg
 *@Description:   ��ȡ��ǰ��ʾ��������Ϣ������/ͼƬ���
 *@Input:               none
 *@Output:            none
 *@Calls:             none
 *@Return:            ����/ͼƬ���
 *@Note:              none.
 **********************************************************************************************************/
uint16_t Popup_Get_Masked_Warning_Msg ( void );

/**********************************************************************************************************
 *@Function:        Popup_Masked_Warning_Polling_Reset
 *@Description:   ��λ������Ϣ��ǰ��ʾ��ָ�룬��ǰ����ָ�����һ���������ָ���һ��
 *@Input:               none.
 *@Output:            none.
 *@Calls:             none.
 *@Return:            none.
 *@Note:              none.
 **********************************************************************************************************/
void Popup_Masked_Warning_Polling_Reset ( uint8_t Mode );

/**********************************************************************************************************
��������Popup_Masked_Warning_Polling
��  �ܣ���ѯ�����εı���

        ÿ����һ�δ˺���,�����α���ָ��ᰴָ�������ƶ�һλ,��ָ������ָ������
        �ϵ����һ��������Ϣʱ,�ٴ���ͬһ�����ѯ,��ǰ�������α�����Ϣ���Ϊ
        POPUP_NONE ��ʾ������ѯ�ѽ���

        ����:��ǰ�������α��� A��B��C��D,����Popup_Masked_Warning_Polling_Reset
        ����,�趨����Ϊ POPUP_POLLING_FORWARD ʱ,�����α���ָ���ָ�򱨾�A,����,
        ���øú����趨����Ϊ POPUP_POLLING_FORWARD ʱ�����α���ָ�뼴ָ�򱨾�B.
        �ظ����ô˺����ҷ��򲻱��������α���ָ��ָ�򱨾�D��,������ͬ������ô˺�
        ���򷵻� POPUP_NONE,��ʾ��ѯ�ѽ���

        ͨ������Popup_Get_Masked_Warning�ɶ�����ǰ�����α���ָ��ָ��ı���

��  ����Mode����ѯģʽ POPUP_POLLING_FORWARD - �������ģʽ
                       POPUP_POLLING_REVERSE - �������ģʽ
����ֵ����
 **********************************************************************************************************/
void Popup_Masked_Warning_Polling ( uint8_t Mode );
void Popup_Hint_Mask_Request ( uint16_t PopupID );
uint16_t Popup_Get_First_Masked_Warning ( void );
uint8_t Popup_WarningRequested ( void );
#endif
