#ifndef POWER_MANAGEMENT_H_
#define POWER_MANAGEMENT_H_



#include "TYW_stdint.h"

#define PowerExcuteWakeUpFlag 0x55u


typedef enum
{
    /*0*/m_IGN_OFF_Init,
    /*1*/m_IGN_OFF,
    /*2*/m_IGN_Sleep_Init,
    /*3*/m_IGN_Sleep,
    /*4*/m_IGN_Wakeup,
    /*5*/m_IGN_ON_Init,
    /*6*/m_IGN_ON,
    /*7*/m_IGN_LVP,
    /*8*/m_IGN_OVP,
    /*9*/m_IGN_LIMIT,
} Power_Status_t;

void Power_Management_Init ( uint8_t u8InitFlag );
void Power_Management_Service ( void );
void ClearNoInitArea(void);

Power_Status_t Power_KL30_Init ( void );
Power_Status_t Power_Wakeup_Init ( void );

void Power_IG_OFF_Init(void);
void Power_IG_ON_Init(void);
void Power_Sleep_Init(void);

Power_Status_t Power_Stay_ON(void);
Power_Status_t Power_Stay_OFF(void);
Power_Status_t Power_Stay_Protect(void);
Power_Status_t Power_Stay_Sleep( void );



#endif