/******************************************************************************
文 件 名：Buzzer.c
功能描述：蜂鸣器驱动库头文件
作    者：张暄
版    本：V1.0
日    期：2016.5.18
******************************************************************************/
#ifndef _BUZZER_H_
#define _BUZZER_H_

#include "GPIO.h"
#include "r_typedefs.h"

#define LINE_BUZZER BUZZER_ACC_OUT_EN

#ifndef BUZZER_CTRL
#define BUZZER_CTRL LINE_BUZZER
#endif

#define BUZZER_MODE_IDLE 0
#define BUZZER_MODE_SINGLE 1
#define BUZZER_MODE_LOOP 2

typedef struct
{
    uint8_t Mode;
    uint8_t Track;
    uint8_t Note;
    uint16_t Timer;
    uint16_t Fade;
} BuzzerPlayCtrlStruct;

/******************************************************************************
函数声明
******************************************************************************/
void Buzzer_Start_Up(void);
void Buzzer_Shutdown(void);
void Buzzer_Play_Track(uint8_t TrackID);
void Buzzer_Repeat_Play_Track(uint8_t TrackID);
void Buzzer_Stop_Play(void);
void Buzzer_Play_ISR(void);
#endif
