

#ifndef _KWP2000_TP_H
#define _KWP2000_TP_H

/*
*********************************************************************
* Defined for ComStatus
*********************************************************************
*/
#define KWP2000_BUFFLEN_MAX		   255
#define KWP2000_RX_BUFFER_SIZE     260
#define KWP2000_TX_BUFFER_SIZE	   260

/*
*********************************************************************
* Defined for ComStatus
*********************************************************************
*/
#define INIT					0x00u	/* Initialisation modes in 0x0y*/
#define COM_INIT				0x01u
#define KWP2000					0x20u	/* KWP2000 modes in 0x2y */
#define KWP2000_FAST_INIT		0x21u
#define KWP2000_WAIT_RECEPTION	0x22u
#define KWP2000_WAIT_HEADER		0x23u
#define KWP2000_WAIT_DATAS		0x24u
#define KWP2000_COMMUNICATION	0x25u
#define KWP2000_BUILD_RESPONSE	0x26u
#define KWP2000_SEND_RESPONSE	0x27u
#define KWP2000_MODIFY_CONFIG	0x28u
#define KWP2000_END				0x29u
#define KWP2000_IDLE			0x2Au
#define PROTOCOL				0xF0u	/* Protocol modes defined by 0xy0 */



#define KWP2000_MODIFY_NULL		    0
#define KWP2000_MODIFY_BAUDRATE	    1
#define KWP2000_MODIFY_RESET	    2
#define KWP2000_MODIFY_END		    3



/*
*********************************************************************
* structure
*********************************************************************
*/
typedef struct
{
    unsigned char  Format;
    unsigned char  headerSize;
    unsigned char  SId;
    unsigned char  TgtAddr;
    unsigned char  SrcAddr;
    unsigned short Rx_len;
    unsigned short Tx_len;
    unsigned char  RxBuffer[KWP2000_RX_BUFFER_SIZE];
    unsigned char  TxBuffer[KWP2000_TX_BUFFER_SIZE];
    unsigned char  *Request_Datas;
    unsigned char  *Response_Datas;
    unsigned short kwp2000_Len;
    unsigned char  kwp2000_Checksum;
    unsigned long  tiCom_u32;
    unsigned char  ResponsePending;
} Kwp2000_ComState_t;

typedef struct
{
    unsigned char  typeOfModif;
    unsigned long  newBaudRate;
    unsigned short resetType;
} Kwp2000_Modify_t;


/*
*********************************************************************
* variable
*********************************************************************
*/

extern  Kwp2000_ComState_t   Kwp2000_ComState;
extern  Kwp2000_Modify_t     Kwp2000_Modify;
extern  unsigned long        Kwp2000_ComMode;

/*
*********************************************************************
* function
*********************************************************************
*/

extern void Kwp2000_Timeout(void);
extern void Kwp2000_CommuniationDown(void);
extern void Kwp2000_Init(void);

extern void Kwp2000_AscRxInterrupt( void );
extern void Kwp2000_ComInit_Handle( void );
extern unsigned char Kwp2000_FormatAnalyse(void);
extern void          Kwp2000_HeaderAnalyse(void);
extern unsigned char Kwp2000_PrepareHeader(unsigned char dataSize);
extern unsigned char Kwp2000_ChecksumCalculate(unsigned char *dataBuffer, unsigned short numberOfBytes);
extern unsigned char kwp2000_AddressTest(void);
extern unsigned char Kwp2000_VerifyChecksum(void);
extern void Kwp2000_ProtocolInit( void );

#endif
